/*
 * Decompiled with CFR 0.152.
 */
package editor.dialogs;

import editor.DoocsTreeView;
import editor.IAddrEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class DoocsAddrEditor
extends JDialog
implements IAddrEditor {
    private JButton jButtonOK;
    private JButton jButtonCancel;
    private DoocsTreeView treeView;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelSouth;
    private JCheckBox fac;
    private JCheckBox dev;
    private JCheckBox loc;
    private JCheckBox prop;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;

    public DoocsAddrEditor() {
        this.initComponents();
        this.setTitle("Doocs Address Chooser");
    }

    @Override
    public String getTextFieldAddr() {
        return this.jTextField1.getText();
    }

    @Override
    public String getAddr() {
        if (this.treeView.getDoocsAddr() == null) {
            return null;
        }
        String[] temp = this.treeView.getDoocsAddr().split("/");
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < 4; ++i) {
            if (i == 0 && temp.length > 0 && this.fac.isSelected()) {
                buf.append(temp[i]);
            }
            if (i == 1 && temp.length > 1 && this.dev.isSelected()) {
                buf.append(temp[i]);
            }
            if (i == 2 && temp.length > 2 && this.loc.isSelected()) {
                buf.append(temp[i]);
            }
            if (i == 3 && temp.length > 3 && this.prop.isSelected()) {
                buf.append(temp[i]);
            }
            if (i >= 3) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    @Override
    public void setAddr(String addr) {
        this.treeView.setDoocsAddr(addr);
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        this.treeView.addMouseListener(ml);
    }

    @Override
    public void addActionListener(ActionListener al) {
        this.jButtonCancel.addActionListener(al);
        this.jButtonOK.addActionListener(al);
    }

    public void setCheckBoxSelection(boolean f, boolean d, boolean l, boolean p) {
        this.fac.setSelected(f);
        this.dev.setSelected(d);
        this.loc.setSelected(l);
        this.prop.setSelected(p);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setPreferredSize(new Dimension(400, 600));
        this.treeView = new DoocsTreeView();
        this.treeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent arg0) {
                DoocsAddrEditor.this.jTextField1.setText(DoocsAddrEditor.this.getAddr());
            }
        });
        this.jScrollPane1.setViewportView(this.treeView);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jPanel1 = new JPanel();
        this.fac = new JCheckBox("facility", true);
        this.fac.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DoocsAddrEditor.this.jTextField1.setText(DoocsAddrEditor.this.getAddr());
            }
        });
        this.dev = new JCheckBox("device", true);
        this.dev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DoocsAddrEditor.this.jTextField1.setText(DoocsAddrEditor.this.getAddr());
            }
        });
        this.loc = new JCheckBox("location", true);
        this.loc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DoocsAddrEditor.this.jTextField1.setText(DoocsAddrEditor.this.getAddr());
            }
        });
        this.prop = new JCheckBox("property", true);
        this.prop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DoocsAddrEditor.this.jTextField1.setText(DoocsAddrEditor.this.getAddr());
            }
        });
        this.jPanel1.add(this.fac);
        this.jPanel1.add(this.dev);
        this.jPanel1.add(this.loc);
        this.jPanel1.add(this.prop);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel2 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jTextField1.setSize(380, 25);
        this.jTextField1.setPreferredSize(new Dimension(380, 25));
        this.jPanel2.add(this.jTextField1);
        this.jPanel3 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK.setText("OK");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jPanel3.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jPanel3.add(this.jButtonCancel);
        this.jPanelSouth = new JPanel();
        this.jPanelSouth.setLayout(new GridLayout(3, 1));
        this.jPanelSouth.add(this.jPanel1);
        this.jPanelSouth.add(this.jPanel2);
        this.jPanelSouth.add(this.jPanel3);
        this.getContentPane().add((Component)this.jPanelSouth, "South");
        this.pack();
    }
}

