/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import editor.EditorPanel;
import editor.events.DOOCSUpdateEditorEvent;
import editor.events.DOOCSUpdateTreeEvent;
import editor.events.UNDOPropertyChangeEvent;
import editor.undo.SetProperty;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PropsTableModel
extends AbstractTableModel {
    public Vector<DOOCSUpdateEditorEvent> updateEditorListener;
    public Vector<DOOCSUpdateTreeEvent> updateListener;
    public Vector<UNDOPropertyChangeEvent> undoListener;
    private String[] columnNames = new String[]{"Property", "Value", "", "Level"};
    protected Vector<DOOCSComponent> m_Components;
    Vector<String[]> props;
    private DOOCSParameter.Levels propsLevel;

    public PropsTableModel() {
        this.updateEditorListener = new Vector();
        this.updateListener = new Vector();
        this.undoListener = new Vector();
        this.m_Components = new Vector();
        this.props = new Vector();
    }

    public void fillProps(DOOCSComponent[] dcomp, DOOCSParameter.Levels level) {
        this.propsLevel = level;
        this.m_Components.clear();
        if (dcomp != null) {
            for (int i = 0; i < dcomp.length; ++i) {
                this.m_Components.add(dcomp[i]);
            }
        }
        this.updateProps();
    }

    private void updateProps() {
        this.props.removeAllElements();
        if (!this.m_Components.isEmpty()) {
            DOOCSParameter[] paramList = this.m_Components.get(0).getDOOCSParameterList();
            for (int i = 0; i < paramList.length; ++i) {
                if (paramList[i].level != this.propsLevel) continue;
                String[] y = new String[]{paramList[i].parameter, null, paramList[i].type.toString(), paramList[i].level.toString(), paramList[i].tooltip};
                this.props.addElement(y);
            }
            for (int comp_count = 1; comp_count < this.m_Components.size(); ++comp_count) {
                DOOCSParameter[] actList = this.m_Components.get(comp_count).getDOOCSParameterList();
                Vector<String[]> tempProps = new Vector<String[]>();
                block2: for (int prop_count = 0; prop_count < this.props.size(); ++prop_count) {
                    for (int item_count = 0; item_count < actList.length; ++item_count) {
                        if (!this.props.get(prop_count)[0].equalsIgnoreCase(actList[item_count].parameter) || !this.props.get(prop_count)[2].equalsIgnoreCase(actList[item_count].type.toString())) continue;
                        if (actList[item_count].parameter.equalsIgnoreCase("name") || actList[item_count].parameter.equalsIgnoreCase("bounds")) continue block2;
                        tempProps.add(this.props.get(prop_count));
                        continue block2;
                    }
                }
                if (this.propsLevel == DOOCSParameter.Levels.SCALE) {
                    String[] y = new String[]{"size", null, "SIZE", "SCALE", null};
                    tempProps.add(y);
                }
                this.props = tempProps;
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.props.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            Vector<String> ret_val = new Vector<String>();
            ret_val.add(this.props.get(row)[0]);
            ret_val.add(this.props.get(row)[4]);
            return ret_val;
        }
        if (col == 1 || col == 4) {
            String ret_val = null;
            if (this.m_Components.get(0).getDOOCSParameter(this.props.get(row)[0]) == null) {
                return null;
            }
            ret_val = this.m_Components.get(0).getDOOCSParameter(this.props.get(row)[0]).toString();
            for (int i = 1; i < this.m_Components.size(); ++i) {
                if (ret_val != null && this.m_Components.get(i).getDOOCSParameter(this.props.get(row)[0]) != null && ret_val.equals(this.m_Components.get(i).getDOOCSParameter(this.props.get(row)[0]).toString())) continue;
                ret_val = null;
            }
            return ret_val;
        }
        return this.props.get(row)[col];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value != null) {
            int i;
            Vector<SetProperty> change = new Vector<SetProperty>();
            for (i = 0; i < this.m_Components.size(); ++i) {
                Container dcomp;
                if (this.props.get(row)[0].equals("bounds") && !(this.m_Components.get(i) instanceof EditorPanel)) {
                    Rectangle rect = DOOCSParameter.convertToBounds(value.toString());
                    Container parent = this.m_Components.get(i).getParent();
                    int parentWidth = parent.getWidth();
                    int parentHeight = parent.getHeight();
                    if (rect.x < 0) {
                        rect.x = 0;
                    }
                    if (rect.y < 0) {
                        rect.y = 0;
                    }
                    if (rect.x + rect.width > parentWidth) {
                        rect.width = parentWidth - rect.x;
                    }
                    if (rect.y + rect.height > parentHeight) {
                        rect.height = parentHeight - rect.y;
                    }
                    this.m_Components.get(i).setInitialBounds(rect);
                    value = DOOCSParameter.getDoocsBounds(rect);
                }
                if (this.props.get(row)[0].equals("size") && !(this.m_Components.get(i) instanceof EditorPanel)) {
                    Dimension dim = DOOCSParameter.convertToSize(value.toString());
                    int x = this.m_Components.get(i).getX();
                    int y = this.m_Components.get(i).getY();
                    Rectangle rect = new Rectangle(x, y, dim.width, dim.height);
                    Container parent = this.m_Components.get(i).getParent();
                    int parentWidth = parent.getWidth();
                    int parentHeight = parent.getHeight();
                    if (rect.x + rect.width > parentWidth) {
                        rect.width = parentWidth - rect.x;
                    }
                    if (rect.y + rect.height > parentHeight) {
                        rect.height = parentHeight - rect.y;
                    }
                    this.m_Components.get(i).setInitialBounds(rect);
                    value = rect.width + "," + rect.height;
                }
                if (this.props.get(row)[0].equals("grid") && this.m_Components.get(i) instanceof DOOCSLayeredPane) {
                    ((DOOCSLayeredPane)this.m_Components.get(i)).setInitialGrid();
                }
                String oldValue = null;
                if (this.m_Components.get(i).getDOOCSParameter(this.props.get(row)[0]) != null) {
                    oldValue = this.m_Components.get(i).getDOOCSParameter(this.props.get(row)[0]).toString();
                }
                change.add(new SetProperty(this.m_Components.get(i), this.props.get(row)[0], oldValue, value.toString()));
                this.m_Components.get(i).setDOOCSParameter(this.props.get(row)[0], value.toString());
                if (!this.props.get(row)[0].startsWith("adr") && !this.props.get(row)[0].contains("Adr") && !this.props.get(row)[0].startsWith("value") && !this.props.get(row)[0].equalsIgnoreCase("xmlFile") && !this.props.get(row)[0].equalsIgnoreCase("toolTipText") && !this.props.get(row)[0].equalsIgnoreCase("file")) continue;
                for (dcomp = (Container)((Object)this.m_Components.get(i)); dcomp != null && !(dcomp instanceof EditorPanel); dcomp = dcomp.getParent()) {
                }
                if (dcomp == null) continue;
                boolean show = ((EditorPanel)dcomp).showToolTip;
                ((EditorPanel)dcomp).switchToolTipText(this.m_Components.get(i), show);
            }
            for (int j = 0; j < this.undoListener.size(); ++j) {
                this.undoListener.get(j).DOOCSPropertyChanged(change);
            }
            this.fireTableCellUpdated(row, 1);
            for (i = 0; i < this.updateEditorListener.size(); ++i) {
                this.updateEditorListener.get(i).DOOCSComponentPropertiesChanged();
            }
            if (this.props.get(row)[0].equals("name") || this.props.get(row)[0].equals("compareValue") || this.props.get(row)[0].equals("comparator") || this.props.get(row)[0].contains("Case") || this.props.get(row)[0].contains("Comparator")) {
                for (i = 0; i < this.updateListener.size(); ++i) {
                    this.updateListener.get(i).DOOCSPanelStructureChanged();
                }
            }
            if (this.props.get(row)[0].equals("function") || this.props.get(row)[0].equals("borderType") || this.props.get(row)[0].equals("representation") || this.props.get(row)[0].equals("colorMap") || this.props.get(row)[0].equals("gradient") || this.props.get(row)[0].equals("file") || this.props.get(row)[0].startsWith("property") && !this.props.get(row)[0].startsWith("propertyValue") || this.props.get(row)[0].contains("component") || this.props.get(row)[0].contains("adr")) {
                this.updateProps();
            }
        }
    }

    public Object[] getOptionList(int row) {
        DOOCSComponent actComp = this.m_Components.get(0);
        if (actComp != null) {
            return actComp.getDOOCSPropertyAllowedValues(this.props.get(row)[0]);
        }
        return new String[]{"ERROR!"};
    }

    public void addDOOCSUpdateTreeListener(DOOCSUpdateTreeEvent due) {
        this.updateListener.add(due);
    }

    public void addDOOCSUpdateEditorListener(DOOCSUpdateEditorEvent due) {
        this.updateEditorListener.add(due);
    }

    public void addDOOCSUndoPropertyChangeListener(UNDOPropertyChangeEvent due) {
        this.undoListener.add(due);
    }
}

