/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.ShowException;
import editor.StartParameters;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;

    public static void printComponent(Component c) {
        new PrintUtilities(c).print();
    }

    public PrintUtilities(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pf = printJob.defaultPage();
        PrintService[] factories = PrinterJob.lookupPrintServices();
        if (factories.length > 0 && factories.length == 1 && factories[0].getName().equals("lp")) {
            new ShowException(null, "Printers not detected", "Not enough memory to print, close some applications and restart the jddd!");
            return;
        }
        printJob.setPrintable(this, pf);
        printJob.setJobName("jddd Screenshot");
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(MediaSizeName.ISO_A4);
        aset.add(OrientationRequested.LANDSCAPE);
        String lastPrinter = StartParameters.getInstance().getLastPrinter();
        try {
            PrintService[] services = PrinterJob.lookupPrintServices();
            for (int i = 0; i < services.length; ++i) {
                PrintService ps = services[i];
                if (!ps.getName().equalsIgnoreCase(lastPrinter)) continue;
                printJob.setPrintService(ps);
                break;
            }
        }
        catch (PrinterException pe) {
            new ShowException(null, "PrinterException", pe);
        }
        if (printJob.printDialog(aset)) {
            try {
                printJob.print(aset);
            }
            catch (PrinterException pe) {
                new ShowException(null, "PrinterException", pe);
            }
        }
        StartParameters.getInstance().setLastPrinter(printJob.getPrintService().getName());
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX() + 2.0, pageFormat.getImageableY() + 2.0);
        try {
            Robot r = new Robot(this.componentToBePrinted.getGraphicsConfiguration().getDevice());
            Point p = this.componentToBePrinted.getLocationOnScreen();
            Rectangle rect = new Rectangle(p.x, p.y, this.componentToBePrinted.getWidth(), this.componentToBePrinted.getHeight());
            BufferedImage image = r.createScreenCapture(rect);
            double factor = 1.0;
            double xfactor = pageFormat.getImageableWidth() / (double)this.componentToBePrinted.getWidth();
            double yfactor = pageFormat.getImageableHeight() / (double)this.componentToBePrinted.getHeight();
            factor = xfactor < yfactor ? xfactor : yfactor;
            g2d.scale(factor, factor);
            PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
            g2d.drawImage(image, null, null);
            PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        }
        catch (AWTException awe) {
            new ShowException(null, "Printer robot excepton occurred", awe);
        }
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

