/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.DOOCSParameter;
import DOOCSPlot.DOOCSPlot;

public class DOOCSPlotLocation
extends DOOCSPlot {
    public DOOCSPlotLocation() {
        super(DOOCSPlot.PlotType.PLOTLOCATION);
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameter1 = super.getDOOCSParameterList();
        DOOCSParameter[] parameter1a = this.doocsAdrList.getDOOCSParameterList();
        DOOCSParameter[] parameter2 = this.doocsPlotAxisX.getDOOCSParameterList();
        DOOCSParameter[] parameter3 = this.doocsPlotAxisY.getDOOCSParameterList();
        DOOCSParameter[] parameters = new DOOCSParameter[parameter1.length + parameter1a.length + parameter2.length + parameter3.length];
        System.arraycopy(parameter1, 0, parameters, 0, parameter1.length);
        System.arraycopy(parameter1a, 0, parameters, parameter1.length, parameter1a.length);
        System.arraycopy(parameter2, 0, parameters, parameter1.length + parameter1a.length, parameter2.length);
        System.arraycopy(parameter3, 0, parameters, parameter1.length + parameter1a.length + parameter2.length, parameter3.length);
        return parameters;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSPlotLocation ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">\n");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">\n");
        }
        xmlStructure.append("</DOOCSPlotLocation>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        super.setDOOCSParameter(parameter, value);
        this.doocsPlotAxisX.setDOOCSParameter(parameter, value);
        this.doocsAdrList.setDOOCSParameter(parameter, value);
        this.doocsPlotAxisY.setDOOCSParameter(parameter, value);
        this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        Object ret = super.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsAdrList.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsPlotAxisX.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsPlotAxisY.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    @Override
    public boolean autoScaleX() {
        boolean flag = this.doocsAdrList.autoScaleX(this.doocsPlotAxisX, this.doocsPlotAxisY);
        this.doocsPlotAxisX.limitMax = this.doocsPlotAxisX.actMax + 1.0;
        this.doocsPlotAxisX.defaultMax = this.doocsPlotAxisX.actMax + 1.0;
        this.doocsPlotAxisX.limitMin = -1.0;
        this.doocsPlotAxisX.defaultMin = 0.0;
        return flag;
    }
}

