/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.DOOCSParameter;
import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSChannelList;
import DOOCSPlot.DOOCSPlot;
import java.util.Locale;
import java.util.Scanner;
import jsvnbrowser.JSVNBrowser;
import jsvnbrowser.JSVNFileInfo;
import ttf.doocs.clnt.EqAdr;

public class DOOCSPlotHist
extends DOOCSPlot {
    public String[] bitNames;
    public String[] preDefBits = new String[]{"# 0", "# 1", "# 2", "# 3", "# 4", "# 5", "# 6", "# 7", "# 8", "# 9", "# 10", "# 11", "# 12", "# 13", "# 14", "# 15", "# 16", "# 17", "# 18", "# 19", "# 20", "# 21", "# 22", "# 23"};

    public DOOCSPlotHist() {
        super(DOOCSPlot.PlotType.PLOTHIST);
        this.doocsPlotAxisX.limitMax = System.currentTimeMillis() / 1000L + 31536000L;
        this.doocsPlotAxisX.defaultMax = System.currentTimeMillis() / 1000L + 36000L;
        this.doocsPlotAxisX.defaultMin = System.currentTimeMillis() / 1000L - 86400L;
        this.doocsPlotAxisX.actMax = System.currentTimeMillis() / 1000L + 3600L;
        this.doocsPlotAxisX.actDuration = 43200.0;
        this.doocsPlotAxisX.actMin = this.doocsPlotAxisX.actMax - this.doocsPlotAxisX.actDuration;
    }

    @Override
    public void init() {
        super.init();
        if (this.isLogicPlot) {
            DOOCSChannel c;
            DOOCSChannelList cL = this.doocsAdrList.list.get(0);
            if (cL != null && (c = cL.channels.get(0)) != null) {
                this.readBitNames(c.doocsAdr);
            }
            if (this.doocsPlotAxisY.limitMax > 23.0) {
                this.doocsPlotAxisY.limitMax = 23.0;
            }
            if (this.doocsPlotAxisY.limitMin < 0.0) {
                this.doocsPlotAxisY.limitMin = 0.0;
            }
        }
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameterOwn = new DOOCSParameter[]{new DOOCSParameter("isLogicPlot", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL)};
        DOOCSParameter[] parameter1 = super.getDOOCSParameterList();
        DOOCSParameter[] parameter1a = this.doocsAdrList.getDOOCSParameterList();
        DOOCSParameter[] parameter2 = this.doocsPlotAxisX.getDOOCSParameterList();
        DOOCSParameter[] parameter3 = this.doocsPlotAxisY.getDOOCSParameterList();
        DOOCSParameter[] parameters = new DOOCSParameter[parameter1.length + parameterOwn.length + parameter1a.length + parameter2.length + parameter3.length];
        System.arraycopy(parameter1, 0, parameters, 0, parameter1.length);
        System.arraycopy(parameterOwn, 0, parameters, parameter1.length, parameterOwn.length);
        System.arraycopy(parameter1a, 0, parameters, parameter1.length + parameterOwn.length, parameter1a.length);
        System.arraycopy(parameter2, 0, parameters, parameter1.length + parameterOwn.length + parameter1a.length, parameter2.length);
        System.arraycopy(parameter3, 0, parameters, parameter1.length + parameterOwn.length + parameter1a.length + parameter2.length, parameter3.length);
        return parameters;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSPlotHist ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">\n");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">\n");
        }
        xmlStructure.append("</DOOCSPlotHist>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        super.setDOOCSParameter(parameter, value);
        if (parameter.equalsIgnoreCase("isLogicPlot")) {
            this.setIsLogicPlot(Boolean.parseBoolean(value));
        }
        this.doocsPlotAxisX.setDOOCSParameter(parameter, value);
        this.doocsAdrList.setDOOCSParameter(parameter, value);
        this.doocsPlotAxisY.setDOOCSParameter(parameter, value);
        this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        Object ret = super.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsAdrList.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsPlotAxisX.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsPlotAxisY.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        if (parameter.equalsIgnoreCase("isLogicPlot")) {
            return this.getIsLogicPlot();
        }
        return null;
    }

    public void setIsLogicPlot(boolean isLogic) {
        this.isLogicPlot = isLogic;
    }

    public boolean getIsLogicPlot() {
        return this.isLogicPlot;
    }

    public void readBitNames(String adrStr) {
        String filePath = "global/bitNames";
        String ext = "plog";
        String fileName = null;
        boolean flag = false;
        JSVNBrowser browser = new JSVNBrowser();
        JSVNFileInfo fInfo = null;
        EqAdr adr = new EqAdr(adrStr);
        for (int i = 0; i < 6; ++i) {
            switch (i) {
                case 0: {
                    fileName = String.format("%s/%s#%s#%s#%s.%s", filePath, adr.facility(), adr.device(), adr.location(), adr.property(), ext);
                    break;
                }
                case 1: {
                    fileName = String.format("%s/%s#%s##%s.%s", filePath, adr.facility(), adr.device(), adr.property(), ext);
                    break;
                }
                case 2: {
                    fileName = String.format("%s/%s#%s.%s", filePath, adr.facility(), adr.device(), ext);
                    break;
                }
                case 3: {
                    fileName = String.format("%s/%s.%s", filePath, adr.facility(), ext);
                    break;
                }
                case 4: {
                    fileName = String.format("%s/%s.%s", filePath, adr.property(), ext);
                    break;
                }
                case 5: {
                    fileName = String.format("%s/GENERAL.%s", filePath, ext);
                    break;
                }
                default: {
                    fileName = "";
                }
            }
            fInfo = browser.openFile(fileName);
            if (fInfo != null && fInfo.buf != null) {
                flag = true;
            }
            if (flag) break;
        }
        if (flag) {
            String text = new String(fInfo.buf);
            Scanner dataScan = new Scanner(text);
            dataScan.useDelimiter("[\\n]+");
            dataScan.useLocale(Locale.ENGLISH);
            int cnt = 0;
            try {
                this.bitNames = new String[24];
                while (dataScan.hasNext()) {
                    String tmp = dataScan.next().trim();
                    if (tmp.startsWith("#")) continue;
                    this.bitNames[cnt] = new String(tmp);
                    int l = tmp.length();
                    if (this.doocsPlotAxisY.tickStringLength < l) {
                        this.doocsPlotAxisY.tickStringLength = l;
                    }
                    if (l <= 0) continue;
                    ++cnt;
                }
            }
            catch (Exception e) {
                System.out.println("Exception in reading " + fileName + " = " + e.toString());
            }
            if (cnt < 1) {
                cnt = 16;
            }
            this.doocsPlotAxisY.setActMinMax(0.0, cnt);
            this.doocsPlotAxisY.setDefaultMin(0.0);
            this.doocsPlotAxisY.setDefaultMax(cnt);
        }
        if (this.bitNames == null) {
            this.bitNames = this.preDefBits;
        }
    }
}

