/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;

public class DOOCSPlotCanvas {
    private MemoryImageSource imgSource;
    private Image img;
    private int imgWidth;
    private int imgHeight;
    private boolean modeOverwrite;
    private int[] pix;
    private Color bgColor;
    private JComponent srcComponent;
    private int regionX0;
    private int regionX1;
    private int regionY0;
    private int regionY1;

    public DOOCSPlotCanvas(int width, int height, Color bgCol, boolean modeOvr, JComponent comp) {
        this.modeOverwrite = modeOvr;
        this.srcComponent = comp;
        this.bgColor = bgCol;
        this.setBounds(0, 0, width, height);
    }

    public void setBounds(int x0, int y0, int w, int h) {
        if (this.imgWidth != w || this.imgHeight != h) {
            this.imgWidth = w;
            this.imgHeight = h;
            this.pix = new int[this.imgWidth * this.imgHeight];
            this.imgSource = new MemoryImageSource(this.imgWidth, this.imgHeight, this.pix, 0, this.imgWidth);
            this.imgSource.setAnimated(true);
            this.img = this.srcComponent.createImage(this.imgSource);
            this.clearBuffer(this.pix);
        }
    }

    public boolean needsUpdate() {
        return this.regionX1 + this.regionX0 != 0 || this.regionY1 + this.regionY0 != 0;
    }

    Color getBgColor() {
        return this.bgColor;
    }

    void setBgColor(Color bg) {
        this.bgColor = bg;
    }

    void clearBuffer(int[] pix) {
        int intColorBg = 0xFF000000 | this.bgColor.getRed() << 16 | this.bgColor.getGreen() << 8 | this.bgColor.getBlue();
        for (int i = 0; i < this.imgWidth * this.imgHeight; ++i) {
            pix[i] = intColorBg;
        }
        this.regionX0 = 0;
        this.regionX1 = this.imgWidth;
        this.regionY0 = 0;
        this.regionY1 = this.imgHeight;
    }

    public void drawCanvas(Graphics g, int x, int y, JComponent c) {
        g.translate(x, y);
        g.drawImage(this.img, 0, 0, c);
        g.translate(-x, -y);
        if (this.regionX1 + this.regionX0 != 0 || this.regionY1 + this.regionY0 != 0) {
            this.imgSource.newPixels(this.regionX0, this.regionY0, this.regionX1 - this.regionX0, this.regionY1 - this.regionY0);
            this.regionX0 = 0;
            this.regionX1 = 0;
            this.regionY0 = 0;
            this.regionY1 = 0;
            this.img.flush();
        }
    }

    void drawLine(int x0, int y0, int x1, int y1, int col) {
        int stepx;
        int stepy;
        if (x0 > this.regionX0) {
            this.regionX0 = x0;
        }
        if (x1 > this.regionX1) {
            this.regionX1 = x1;
        }
        if (y0 > this.regionY0) {
            this.regionY0 = y0;
        }
        if (y1 > this.regionY1) {
            this.regionY1 = y1;
        }
        int dy = y1 - y0;
        int dx = x1 - x0;
        int max = this.imgWidth * this.imgHeight;
        if (dy < 0) {
            dy = -dy;
            stepy = -this.imgWidth;
        } else {
            stepy = this.imgWidth;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        dy <<= 1;
        dx <<= 1;
        y1 *= this.imgWidth;
        int i = x0 + (y0 *= this.imgWidth);
        if (i < max && i >= 0) {
            this.pix[i] = col;
        }
        if (dx > dy) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                i = (x0 += stepx) + y0;
                if (i >= max || i < 0) continue;
                this.pix[i] = col;
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                i = x0 + (y0 += stepy);
                if (i >= max || i < 0) continue;
                this.pix[i] = col;
            }
        }
    }
}

