/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.ShowException;
import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import ttf.doocs.clnt.EqData;

public class DOOCSDataContainerSpectFile
extends DOOCSDataContainer {
    protected File file;
    protected long lastModified;
    protected Formatter formatter;
    protected BasicStroke lineWidth;
    public float xStart;
    public float xInc;

    public DOOCSDataContainerSpectFile(DOOCSChannel ch, File f) {
        super(ch);
        this.file = f;
        this.lastModified = 0L;
        this.formatter = new Formatter();
        this.descriptionMsg = this.file.getName();
        this.lineWidth = new BasicStroke(1.0f);
        this.data = new EqData();
    }

    @Override
    public float[] getSelectedData() {
        if (this.data.error() == 0) {
            return this.data.get_float_array();
        }
        return null;
    }

    @Override
    public int getDataLength() {
        return this.data.array_length();
    }

    @Override
    public double getDataInc() {
        return this.xInc;
    }

    @Override
    public double getYData(int idx) {
        return this.data.get_float(idx);
    }

    @Override
    public double getXData(int idx) {
        return (float)idx * this.xInc + this.xStart;
    }

    @Override
    public boolean hasValidData() {
        return this.data.error() == 0 && this.data.array_length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        boolean i = false;
        Object line = null;
        BufferedReader inputStream = null;
        try {
            long lm = this.file.lastModified() / 1000L;
            if (lm > this.lastModified) {
                this.data.set_type(19);
                this.data.set_from_file(this.file.getAbsolutePath());
                if (this.data.error() == 0) {
                    this.xStart = this.data.get_start();
                    this.xInc = this.data.get_increment();
                    this.errorMsg = "";
                } else {
                    this.errorMsg = this.data.get_string_arg();
                }
                String cmt = this.data.get_spec_comm();
                if (cmt != null && cmt.length() > 1) {
                    this.descriptionMsg = cmt;
                }
                this.hasNewData = true;
                this.hasData = true;
                this.lastModified = System.currentTimeMillis() / 1000L;
            } else {
                this.hasNewData = false;
            }
        }
        catch (Exception e) {
            this.errorMsg = String.format("File Read ERROR! : %s", this.file.getAbsolutePath());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                new ShowException(null, "IOException", e);
            }
        }
        return this.hasNewData;
    }

    private void drawResult(Graphics2D g2d, String tmp, int x, int y) {
        g2d.setColor(this.color);
        g2d.drawString(tmp, x, y);
    }

    void drawData(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis, Color col) {
        int x2 = 0;
        int y2 = 0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        Graphics2D g2d = (Graphics2D)g;
        Rectangle clip = g2d.getClipBounds();
        Point2D.Double po = new Point2D.Double();
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
        int l = this.getDataLength();
        if (l != 0) {
            double x = this.getXData(0);
            double y = yaxis.isLog ? Math.log10(yaxis.actMin) : 0.0;
            ((Point2D)po).setLocation(x, y);
            tr.transform(po, this.pt);
            int y0 = (int)this.pt.getY();
            y = this.getYData(0);
            if (xaxis.isLog) {
                x = x <= 0.0 ? -20.0 : Math.log10(x);
            }
            if (yaxis.isLog) {
                y = y <= 0.0 ? -20.0 : Math.log10(y);
            }
            ((Point2D)po).setLocation(x, y);
            tr.transform(po, this.pt);
            int x1 = (int)this.pt.getX();
            int y1 = (int)this.pt.getY();
            for (int i = 1; i < l; ++i) {
                y = this.getYData(i);
                x = this.getXData(i);
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                x2 = (int)this.pt.getX();
                y2 = (int)this.pt.getY();
                this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false, false);
                x1 = x2;
                y1 = y2;
            }
            if (clip.intersectsLine(x1, y1, x2, y2)) {
                this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, true, false);
            }
        }
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        Rectangle clip = g2d.getClipBounds();
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        long t21 = System.nanoTime();
        boolean x1 = false;
        boolean y1 = false;
        int n = 10000;
        long t22 = System.nanoTime();
        long t11 = System.nanoTime();
        Container tcomp = this.channel.plot.getParent();
        Color col = this.channel.lineColor;
        int intColorFg = 0xFF000000 | col.getRed() << 16 | col.getGreen() << 8 | col.getBlue();
        boolean flag = false;
        DOOCSPlotCanvas canvas = this.channel.plot.getCanvas();
        flag = canvas != null ? canvas.needsUpdate() : true;
        if (flag || this.hasNewData) {
            this.drawData(g, xaxis, yaxis, this.channel.lineColor);
        }
        long t12 = System.nanoTime();
    }
}

