/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.ShowException;
import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;

public class DOOCSDataContainerLocation
extends DOOCSDataContainer {
    protected EqAdr ea;
    protected EqAdr refAdr;
    protected EqData ed;
    protected EqData dataLocStrings;
    protected boolean hasLocStrings = false;
    float[] dataArray;
    int dataLength;
    protected Color bgColor;
    private long lastReadT = 0L;
    private boolean tryUSTR = true;

    public DOOCSDataContainerLocation(DOOCSChannel ch) {
        super(ch);
        this.channel = ch;
        this.color = new Color(0, 0, 0);
        this.bgColor = new Color(128, 128, 128, 60);
        this.pt = new Point();
        this.ea = new EqAdr(ch.doocsAdr);
        this.ed = new EqData();
        this.data = new EqData();
        this.dataLocStrings = new EqData();
        this.eq = new EqCall();
        this.descriptionMsg = this.facDev2Desc(this.channel.doocsAdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readEGU(EqAdr eaa) {
        String line = null;
        BufferedReader inputStream = null;
        int idx = 0;
        if (this.channel.plot.doocsRefAdr.length() > 6) {
            this.refAdr = new EqAdr(this.channel.plot.doocsRefAdr);
            this.descriptionMsg = this.channel.plot.doocsRefAdr.substring(this.channel.plot.doocsRefAdr.indexOf("/", 1));
        } else {
            this.refAdr = new EqAdr(this.channel.doocsAdr);
            this.descriptionMsg = this.facDev2Desc(this.channel.doocsAdr);
        }
        if (this.channel.plot.doocsRefAdr.startsWith("file:")) {
            try {
                File file = new File(this.channel.plot.doocsRefAdr.substring(5));
                if (!file.canRead()) return;
                inputStream = new BufferedReader(new FileReader(file));
                this.dataLocStrings.init();
                this.dataLocStrings.set_type(103);
                while ((line = inputStream.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    this.dataLocStrings.set(st.nextToken());
                    ++idx;
                }
                this.errorMsg = "";
                this.hasLocStrings = true;
                return;
            }
            catch (Exception e) {
                this.errorMsg = String.format("File Read ERROR! Line=%d : %s", idx, line);
                return;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    new ShowException(null, "IOException", e);
                }
            }
        }
        try {
            this.dataLocStrings.init();
            int sysMask = this.channel.plot.sysMask;
            if (sysMask != 0) {
                this.ed.set(sysMask);
            }
            this.eq.get(this.refAdr, this.ed, this.dataLocStrings);
            if (this.dataLocStrings.error() == 0) {
                this.hasLocStrings = true;
                if (!this.channel.doocsReadEGU) return;
                eaa = new EqAdr(this.channel.doocsAdr);
                eaa.set_location(this.dataLocStrings.get_string_arg(0));
                eaa.merge("///.EGU");
                super.readEGU(eaa);
                return;
            } else {
                this.hasLocStrings = false;
            }
            return;
        }
        catch (Exception e) {
            this.hasLocStrings = false;
        }
    }

    @Override
    public boolean update() {
        if (this.channel == null) {
            this.errorMsg = "Internal ERROR! No channel defined";
            return false;
        }
        if (this.firstRead) {
            EqAdr eaa = new EqAdr(this.channel.doocsAdr);
            this.readEGU(eaa);
            this.firstRead = false;
        }
        try {
            int sysMask;
            this.data.init();
            if (this.tryUSTR) {
                this.data.set_type(103);
            }
            if ((sysMask = this.channel.plot.sysMask) != 0) {
                this.ed.set(sysMask);
            }
            this.eq.get(this.ea, this.ed, this.data);
            int i = this.data.error();
            if (i == 0) {
                this.dataLength = this.data.array_length();
                if (this.dataLength == 0) {
                    if (this.dataArray == null) {
                        this.dataArray = new float[1];
                    }
                    this.dataArray[0] = this.data.get_float();
                    this.dataLength = 1;
                } else {
                    this.dataArray = this.data.get_float_array();
                }
                if (this.dataArray != null) {
                    this.hasData = true;
                    this.lastReadT = System.currentTimeMillis();
                } else {
                    this.hasData = false;
                }
            } else if (i == 101) {
                long t = System.currentTimeMillis();
                if (this.lastReadT + 30000L < t) {
                    this.dataLength = 0;
                    this.hasData = false;
                    this.errorMsg = "Timeout";
                }
            } else {
                if (i == 73) {
                    this.tryUSTR = false;
                    this.ea.adr(this.channel.doocsAdr);
                }
                this.dataLength = 0;
                this.hasData = false;
                this.errorMsg = this.data.get_string();
            }
            this.errorMsg = "";
        }
        catch (Exception e) {
            this.errorMsg = "Read ERROR!" + e.toString();
            this.hasData = false;
        }
        this.hasNewData = this.hasData;
        if (this.hasData) {
            this.channel.plot.repaint();
        }
        return this.hasData;
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int i = 1;
        if (this.hasData) {
            i = this.dataLength;
        }
        if ((double)i > xaxis.actMax) {
            xaxis.actMax = i;
        }
        xaxis.actMin = 0.0;
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xMin = xaxis.actMin;
        double xMax = xaxis.actMax;
        if (this.hasData && this.data.error() == 0 && this.dataLength > 0) {
            for (int i = 0; i < this.dataLength; ++i) {
                double x = i;
                if (x < xMin || x > xMax || yaxis.isLog && (double)this.dataArray[i] <= 0.0) continue;
                if ((double)this.dataArray[i] > yaxis.actMax) {
                    yaxis.actMax = this.dataArray[i];
                }
                if (!((double)this.dataArray[i] < yaxis.actMin)) continue;
                yaxis.actMin = this.dataArray[i];
            }
        }
    }

    @Override
    public float[] getSelectedData() {
        return this.dataArray;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public double getDataInc() {
        return 1.0;
    }

    @Override
    public double getYData(int idx) {
        return this.dataArray[idx];
    }

    @Override
    public double getXData(int idx) {
        return idx;
    }

    @Override
    public String getXString(int idx) {
        if (idx >= 0 && idx < this.dataLength) {
            if (this.hasLocStrings) {
                if (idx < this.dataLocStrings.length()) {
                    return this.dataLocStrings.get_string_arg(idx);
                }
                return "";
            }
            if (this.data.type() == 103) {
                return this.data.get_string_arg(idx);
            }
            return String.format("%d", idx);
        }
        if (this.dataLength == 0) {
            return String.format("%d", idx);
        }
        return "";
    }

    @Override
    public String getStatusMsg(int idx) {
        if (this.errorMsg.length() > 0) {
            return this.errorMsg;
        }
        return this.getXString(idx) + " " + this.eguText;
    }

    @Override
    public String getToolTipText(double dataX, double dataY, String adrString) {
        double y = this.channel.plot.doocsPlotAxisY.isLog ? Math.pow(10.0, dataY) : dataY;
        return String.format("X=%s, Y=%g : %s", adrString, y, this.descriptionMsg);
    }

    @Override
    public boolean hasValidData() {
        return this.hasData && this.data.error() == 0;
    }

    private void drawResult(Graphics2D g2d, String tmp, int x, int y) {
        g2d.setColor(this.color);
        g2d.drawString(tmp, x, y);
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int idMax;
        int iDelta;
        int x2 = 0;
        int y2 = 0;
        int x0 = 0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        int idMin = (int)Math.round(xmin);
        if (idMin < 0) {
            idMin = 0;
        }
        if ((iDelta = (idMax = (int)Math.round(xmax)) - idMin) + idMin > this.dataLength) {
            iDelta = this.dataLength - idMin;
        }
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        Rectangle clip = g.getClipBounds();
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        Color col = this.channel.lineColor;
        int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
        if (this.hasData && this.data.error() == 0 && this.dataLength > 0) {
            double x = idMin;
            double y = yaxis.isLog ? Math.log10(yaxis.actMin) : 0.0;
            ((Point2D)po).setLocation(x, y);
            tr.transform(po, this.pt);
            int y0 = (int)this.pt.getY();
            if (xaxis.isLog) {
                x = x <= 0.0 ? -20.0 : Math.log10(x);
            }
            y = this.dataArray[0];
            if (yaxis.isLog) {
                y = y <= 0.0 ? -20.0 : Math.log10(y);
            }
            this.pt_s = new Point2D.Double();
            this.pt_s.setLocation(x, y);
            tr.transform(this.pt_s, this.pt);
            int x1 = x2 = (int)this.pt.getX();
            int y1 = y2 = (int)this.pt.getY();
            if (this.dataLength == 1) {
                x = xaxis.actMax;
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                y2 = (int)this.pt.getY();
                x2 = (int)this.pt.getX();
                this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false, false);
            } else {
                for (int i = idMin + 1; i < idMin + iDelta; ++i) {
                    x = i;
                    if (xaxis.isLog) {
                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                    }
                    y = this.dataArray[i];
                    if (yaxis.isLog) {
                        y = y <= 0.0 ? -20.0 : Math.log10(y);
                    }
                    this.pt_s.setLocation(x, y);
                    tr.transform(this.pt_s, this.pt);
                    x2 = (int)this.pt.getX();
                    y2 = (int)this.pt.getY();
                    if (!(x1 < clip.x && x2 < clip.x || x1 > clip.x + clip.width && x2 > clip.x + clip.width)) {
                        this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false, false);
                    }
                    x0 = x2 - x1;
                    x1 = x2;
                    y1 = y2;
                }
                this.drawDataPoint(g2d, x2, y1, x2 + x0, y2, y0, intColorFg, true, false);
            }
        }
    }
}

