/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSChannelList;
import DOOCSPlot.DOOCSDataContainerHist;
import DOOCSPlot.DOOCSFindDataPoint;
import DOOCSPlot.DOOCSHistBlock;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotXY;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import ttf.doocs.clnt.EqData;

public class DOOCSDataContainerHistXY
extends DOOCSDataContainerHist {
    private double tMinSelection;
    private double tMaxSelection;
    private DOOCSChannelList refContainers;
    private DOOCSDataContainerHist refContainer;
    private List<Point2D> dataPoints = null;
    private int nBlocks;
    private int nInActualBuffer;

    public DOOCSDataContainerHistXY(DOOCSChannel ch) {
        super(ch);
        this.refContainers = ch.plot.doocsRefChannels;
        this.nBlocks = 0;
        this.nInActualBuffer = 0;
        this.dataPoints = new ArrayList<Point2D>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean update() {
        boolean modFlag = false;
        long tSec = 0L;
        if (this.channel == null) {
            this.errorMsg = "Internal ERROR! No channel defined";
            return false;
        }
        if (this.refContainers != null) {
            this.refContainer = this.refContainers.channels.get(0) != null ? (DOOCSDataContainerHist)this.refContainers.channels.get((int)0).dataContainer : null;
        }
        double t1 = this.tMinSelection;
        double t2 = this.tMaxSelection;
        if (this.channel.plot.useGlobalTimeRange && this.channel.plot.doocsPlotSelection.isGlobalTimeRangeDefined()) {
            this.tMinSelection = this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMin();
            this.tMaxSelection = this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMax();
        } else {
            this.tMinSelection = ((DOOCSPlotXY)this.channel.plot).getTimeRangeFrom();
            this.tMaxSelection = ((DOOCSPlotXY)this.channel.plot).getTimeRangeTo();
        }
        tSec = System.currentTimeMillis() / 1000L;
        if (this.firstRead) {
            this.init();
            this.check(tSec);
            return modFlag;
        } else {
            if (!this.channel.isRefChannel) {
                int l;
                if (t1 != this.tMinSelection || t2 != this.tMaxSelection) {
                    this.clear();
                    this.nBlocks = 1;
                    this.nInActualBuffer = 0;
                }
                if (this.nBlocks != this.dataBlock.size() + this.refContainer.dataBlock.size()) {
                    this.nBlocks = this.dataBlock.size() + this.refContainer.dataBlock.size();
                    if (this.dataBlock.size() >= 2 && this.refContainer.dataBlock.size() >= 2) {
                        modFlag = true;
                    }
                    if (this.clearTime + 2L < tSec) {
                        modFlag = true;
                    }
                }
                if (this.dataBlock.size() > 1 && this.refContainer.dataBlock.size() > 1 && (l = ((DOOCSHistBlock)this.dataBlock.get((int)1)).data.array_length() + this.refContainer.dataBlock.get((int)1).data.array_length()) != this.nInActualBuffer) {
                    modFlag = true;
                    this.nInActualBuffer = l;
                }
                if (modFlag) {
                    l = this.dataBlock.size() * 2000;
                    this.dataPoints = new ArrayList<Point2D>(l);
                    this.fillDataPoints();
                    this.channel.plot.repaint();
                }
            }
            if (this.pendingCall) {
                if (this.callTimer == 0L || this.callTimer + 10L >= tSec) return false;
                this.eq.clear_monitor(this.adrHist);
                this.callTimer = 0L;
                this.pendingCall = false;
                return modFlag;
            } else {
                this.check(tSec);
            }
        }
        return modFlag;
    }

    @Override
    protected void check(long tSec) {
        if (this.pendingCall) {
            return;
        }
        if (this.isTine) {
            if (this.tMinSelection != this.actMinOld || this.channel.plot.doocsPlotAxisX.actMax != this.actMaxOld) {
                this.actMinOld = this.tMinSelection;
                this.actMaxOld = this.tMaxSelection;
                int t = (int)(System.currentTimeMillis() / 1000L);
                if ((double)t > this.channel.plot.doocsPlotAxisX.actMin && (double)t < this.channel.plot.doocsPlotAxisX.actMax) {
                    this.readHistBlock((int)this.channel.plot.doocsPlotAxisX.actMin, t, 1, this.refreshData);
                } else {
                    this.readHistBlock((int)this.channel.plot.doocsPlotAxisX.actMin, (int)this.channel.plot.doocsPlotAxisX.actMax, 1, this.refreshData);
                }
            }
        } else if (this.dataBlock.size() == 1) {
            this.readHistBlock((int)this.tMinSelection, (int)this.tMaxSelection, 0, this.firstData);
        } else {
            if (this.tMinSelection < (double)this.oldestDataRead && this.oldestDataRead > this.oldestDataAvailable) {
                this.readHistBlock((int)this.tMinSelection, this.oldestDataRead, this.lastBlock, this.oldData);
                return;
            }
            DOOCSHistBlock block = (DOOCSHistBlock)this.dataBlock.get(1);
            if (this.tMaxSelection > (double)block.tTo && block.tTo + 30L < tSec) {
                if ((float)block.data.array_length() > 2000.0f - this.channel.plot.doocsUpdateTime * 10.0f) {
                    this.readHistBlock(block.tTo, (int)tSec + 100, 1, this.freshData);
                    return;
                }
                this.readHistBlock(block.tFrom, (int)tSec + 100, 1, this.refreshData);
                return;
            }
        }
    }

    private void fillDataPoints() {
        double xd = 0.0;
        double tmpY = 0.0;
        double tmpYref = 0.0;
        double xFirst = 0.0;
        if (this.refContainer == null) {
            return;
        }
        if (this.channel.isRefChannel) {
            return;
        }
        int blocks = this.dataBlock.size();
        boolean l = false;
        for (int block = 0; block < blocks; ++block) {
            EqData dat = ((DOOCSHistBlock)this.dataBlock.get((int)block)).data;
            for (int i = 0; i < dat.length(); ++i) {
                if (block == 0) {
                    xd = (double)dat.get_time() / 1000.0;
                    tmpY = dat.get_float();
                    EqData refDat = this.refContainer.dataBlock.get((int)0).data;
                    tmpYref = refDat.get_float();
                } else {
                    xd = (double)dat.get_time(i) / 1000.0;
                    if (xd >= this.tMinSelection && xd <= this.tMaxSelection) {
                        tmpY = dat.get_float(i);
                        tmpYref = this.getLocalYofX(xd);
                    }
                }
                if (!(xd >= this.tMinSelection) || !(xd <= this.tMaxSelection)) continue;
                Point2D.Double po = new Point2D.Double();
                ((Point2D)po).setLocation(tmpYref, tmpY);
                this.dataPoints.add(po);
            }
        }
    }

    public double getLocalYofX(double x) {
        double xd;
        EqData dat;
        double tmpY = 0.0;
        double tmpY2 = 0.0;
        double xFirst = 0.0;
        double x2 = 0.0;
        DOOCSPlotAxis axis = this.channel.plot.doocsPlotAxisX;
        if (this.refContainer == null) {
            return 0.0;
        }
        int blocks = this.refContainer.dataBlock.size();
        int l = 0;
        int block = 0;
        if (blocks > 1) {
            dat = this.refContainer.dataBlock.get((int)block).data;
            double t1 = xFirst = (xd = (double)dat.get_time() / 1000.0);
            double x1 = xFirst;
            tmpY2 = tmpY = (double)dat.get_float();
            for (int j = 1; j < blocks; ++j) {
                double t2;
                dat = this.refContainer.dataBlock.get((int)j).data;
                l = dat.array_length() - 1;
                t1 = (double)dat.get_time(0) / 1000.0;
                if (t1 <= x1) {
                    x1 = t1;
                    tmpY2 = dat.get_float(0);
                }
                if ((t2 = (double)dat.get_time(l) / 1000.0) > x2) {
                    x2 = t2;
                }
                if (!(x >= t1) || !(x <= t2)) continue;
                block = j;
            }
            if (block == 0) {
                if (x > x2) {
                    return tmpY;
                }
                if (x < x1) {
                    return tmpY2;
                }
                return 0.0;
            }
        }
        dat = this.refContainer.dataBlock.get((int)block).data;
        l = dat.array_length() - 1;
        for (int i = 0; i <= l; ++i) {
            xd = (double)dat.get_time(l - i) / 1000.0;
            tmpY2 = dat.get_float(l - i);
            if (xFirst != 0.0 && x <= xFirst && x >= xd) {
                if (x == xFirst) {
                    return tmpY;
                }
                return tmpY2;
            }
            tmpY = tmpY2;
            xFirst = xd;
        }
        return tmpY;
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        for (int i = 0; i < this.dataPoints.size(); ++i) {
            double x = this.dataPoints.get(i).getX();
            if (x > xaxis.actMax) {
                xaxis.actMax = x;
            }
            if (!(x < xaxis.actMin)) continue;
            xaxis.actMin = x;
        }
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        for (int i = 0; i < this.dataPoints.size(); ++i) {
            double y = this.dataPoints.get(i).getY();
            if (y > yaxis.actMax) {
                yaxis.actMax = y;
            }
            if (!(y < yaxis.actMin)) continue;
            yaxis.actMin = y;
        }
    }

    @Override
    public double getYofX(double x) {
        double tmpY = 0.0;
        double tmpY2 = 0.0;
        double xFirst = 0.0;
        if (this.refContainer == null) {
            return 0.0;
        }
        int blocks = this.refContainer.dataBlock.size();
        boolean l = false;
        for (int block = 0; block < blocks; ++block) {
            EqData dat = this.refContainer.dataBlock.get((int)block).data;
            for (int i = 0; i < dat.length(); ++i) {
                double xd;
                if (block == 0) {
                    xd = (double)dat.get_time() / 1000.0;
                    tmpY = dat.get_float();
                    continue;
                }
                xd = (double)dat.get_time(i) / 1000.0;
                tmpY2 = dat.get_float(i);
                if (xFirst != 0.0 && x >= xFirst && x <= xd) {
                    if (this.channel.plot.debug == 1) {
                        System.out.format("Tin=%9.9g,T=%9.9g, Ypre=%.4g,Y=%.4g", x, xd, tmpY, tmpY2);
                    }
                    if (x == xd) {
                        return tmpY2;
                    }
                    return tmpY;
                }
                tmpY = tmpY2;
                xFirst = xd;
            }
        }
        return tmpY;
    }

    @Override
    public double getXData(int idx) {
        if (idx < this.dataPoints.size()) {
            return this.dataPoints.get(idx).getX();
        }
        return 0.0;
    }

    @Override
    public String getToolTipText(double dataX, double dataY, String adrString) {
        double x = this.channel.plot.doocsPlotAxisX.isLog ? Math.pow(10.0, dataX) : dataX;
        double y = this.channel.plot.doocsPlotAxisY.isLog ? Math.pow(10.0, dataY) : dataY;
        return String.format("X=%g, Y=%g : %s", x, y, adrString);
    }

    @Override
    public void findClosestDataPoint(DOOCSFindDataPoint dp, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        double ymin = yaxis.actMin;
        double ymax = yaxis.actMax;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        if (this.hasData) {
            if (xaxis.isLog) {
                xmin = Math.log10(xmin);
                xmax = Math.log10(xmax);
            }
            if (yaxis.isLog) {
                ymin = Math.log10(ymin);
                ymax = Math.log10(ymax);
            }
            for (int i = 0; i < this.dataPoints.size(); ++i) {
                double x = this.dataPoints.get(i).getX();
                double y = this.dataPoints.get(i).getY();
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                this.pt_s.setLocation(x, y);
                tr.transform(this.pt_s, this.pt);
                int x2 = (int)this.pt.getX();
                int y2 = (int)this.pt.getY();
                if (!(x >= xmin) || !(x <= xmax) || !(y >= ymin) || !(y <= ymax)) continue;
                dp.find(x2, y2, x, y, this.getLocationAdr(0), this.getStatusMsg(i), this.channel);
            }
        }
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (!this.channel.isRefChannel) {
            boolean doAll;
            boolean x2 = false;
            boolean y2 = false;
            double xmin = xaxis.actMin;
            double xmax = xaxis.actMax;
            boolean isTDS = false;
            double xi = 1000.0;
            double xx = 0.0;
            Point2D.Double po = new Point2D.Double();
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
            g2d.setColor(this.channel.lineColor);
            g2d.setStroke(this.channel.strokeSize);
            Color col = this.channel.lineColor;
            Rectangle clip = g2d.getClipBounds();
            boolean bl = doAll = !this.singleUpdate;
            if (clip.x == this.channel.plot.dataAreaX0 && clip.width == this.channel.plot.dataAreaX1 - this.channel.plot.dataAreaX0) {
                doAll = true;
            }
            if (this.channel.plot.doAll) {
                doAll = true;
            }
            this.singleUpdate = false;
            int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
            double x = xaxis.actMin;
            double y = yaxis.actMin;
            if (yaxis.isLog) {
                y = Math.log10(y);
            }
            ((Point2D)po).setLocation(x, y);
            tr.transform(po, this.pt);
            int y0 = (int)this.pt.getY();
            for (int i = 0; i < this.dataPoints.size(); ++i) {
                x = this.dataPoints.get(i).getX();
                y = this.dataPoints.get(i).getY();
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                this.pt_s.setLocation(x, y);
                tr.transform(this.pt_s, this.pt);
                int x1 = (int)this.pt.getX();
                int y1 = (int)this.pt.getY();
                int d = 3;
                if (x1 >= clip.x && x1 <= clip.x + clip.width) {
                    this.actValueX = x1 - d;
                    this.actValueX = 0;
                    this.drawDataPoint(g2d, x1 - d, y1, x1 + d, y1, y0, intColorFg, false, false);
                    continue;
                }
                this.actValueX = 0;
            }
        }
    }

    @Override
    public void print(String fileName) {
        double x;
        int i;
        EqData dat;
        int j;
        double xmin = this.channel.plot.doocsPlotAxisX.getMin();
        double xmax = this.channel.plot.doocsPlotAxisX.getMax();
        System.out.println("Data of " + this.channel.doocsAdr + "; Description=" + this.getStatusMsg(0));
        if (this.mathResult != null && this.mathResult.length() > 2) {
            System.out.println("Math result = " + this.mathResult);
        }
        for (j = 0; j < this.dataBlock.size(); ++j) {
            if (!this.hasData || ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.error() != 0) continue;
            dat = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data;
            for (i = 0; i < dat.array_length(); ++i) {
                x = dat.get_time(i) / 1000L;
                if (!(x >= this.tMinSelection) || !(x <= this.tMaxSelection)) continue;
                System.out.println(dat.get_string(i));
            }
        }
        if (this.refContainer != null) {
            System.out.println("Ref Data of " + this.refContainer.adrActual + "; Description=" + this.refContainer.getStatusMsg(0));
            for (j = 0; j < this.refContainer.dataBlock.size(); ++j) {
                if (!this.refContainer.hasData || this.refContainer.dataBlock.get((int)j).data.error() != 0) continue;
                dat = this.refContainer.dataBlock.get((int)j).data;
                for (i = 0; i < dat.array_length(); ++i) {
                    x = dat.get_time(i) / 1000L;
                    if (!(x >= this.tMinSelection) || !(x <= this.tMaxSelection)) continue;
                    System.out.println(dat.get_string(i));
                }
            }
        }
        for (int i2 = 0; i2 < this.dataPoints.size(); ++i2) {
            double x2 = this.dataPoints.get(i2).getX();
            double y = this.dataPoints.get(i2).getY();
            System.out.println("X=" + x2 + " Y=" + y);
        }
    }
}

