/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSChannelList;
import DOOCSPlot.DOOCSFindDataPoint;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotMath;
import DOOCSPlot.DOOCSPlotSelection;
import DOOCSPlot.utils.PlotDataTable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import ttf.doocs.clnt.EqAdr;
import xmlparser.IntegerParser;

public class DOOCSAdrList {
    public List<DOOCSChannelList> list = new ArrayList<DOOCSChannelList>();
    public int nChannels;
    public int countChannels;
    public String doocsAddress;
    public String fullDoocsAddress;
    private DOOCSPlot plot;
    public AffineTransform transformer;

    public DOOCSAdrList(DOOCSPlot p, String adr) {
        this.doocsAddress = adr;
        this.plot = p;
        this.transformer = new AffineTransform();
    }

    void init() {
        for (DOOCSChannelList li : this.list) {
            li.init(null);
        }
        this.setLegend();
    }

    static DOOCSAdrList clone(DOOCSPlot plotSrc, DOOCSPlot p, DOOCSPlot.PlotType plotT) {
        DOOCSAdrList al = new DOOCSAdrList(plotSrc, p.doocsAdrList.doocsAddress);
        for (DOOCSChannelList li : p.doocsAdrList.list) {
            DOOCSChannelList l = DOOCSChannelList.clone(plotSrc, p, li, plotT);
            al.list.add(l);
        }
        return al;
    }

    public int size() {
        return this.list.size();
    }

    public void addAdr(String str) {
        if (EqAdr.isValidAdr((String)str)) {
            if (!this.findAddr(str)) {
                DOOCSChannelList cl = new DOOCSChannelList(this.plot, str, true);
                this.list.add(cl);
                this.setLegend();
                this.doocsAddress = str;
            } else {
                new ShowException(null, "Address Error", "The Address " + str + " is already booked");
            }
        }
    }

    public void addFullAdr(String str) {
        if (EqAdr.isValidAdr((String)str)) {
            if (!this.findAddr(str)) {
                DOOCSChannelList cl = new DOOCSChannelList(this.plot, str, true);
                this.list.add(cl);
                cl.init(str);
                this.setLegend();
                this.doocsAddress = str;
            } else {
                new ShowException(null, "Address Error", "The Address " + str + " is already booked");
            }
        }
    }

    public void mergeBaseDoocsAddress(String address) {
        for (DOOCSChannelList li : this.list) {
            li.mergeBaseAdr(address);
        }
        this.setLegend();
    }

    public void setFullDoocsAddress(String address) {
        if (this.fullDoocsAddress == null || address != null && address.compareTo(this.fullDoocsAddress) != 0) {
            this.fullDoocsAddress = address;
            this.mergeBaseDoocsAddress(address);
        }
    }

    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = this.plot.plotType == DOOCSPlot.PlotType.PLOTLOCATION || this.plot.plotType == DOOCSPlot.PlotType.PLOTXY ? new DOOCSParameter[this.list.size() * 5 + 5 + 1] : new DOOCSParameter[this.list.size() * 5 + 5];
        int i = 0;
        int j = 0;
        if (this.plot.plotType == DOOCSPlot.PlotType.PLOTLOCATION || this.plot.plotType == DOOCSPlot.PlotType.PLOTXY) {
            parameters[i++] = new DOOCSParameter("refAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.CHANNEL, "<html>The reference channel of the X axis</html>");
        }
        for (DOOCSChannelList li : this.list) {
            parameters[i++] = new DOOCSParameter(String.format("adr%d", j), DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.CHANNEL, "<html>The DOOCS address</html>");
            parameters[i++] = new DOOCSParameter(String.format("lineColor%d", j), DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.CHANNEL, "<html>The color of this channel</html>");
            parameters[i++] = new DOOCSParameter(String.format("lineStyle%d", j), DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.CHANNEL, "<html>The line style of this channel</html>");
            parameters[i++] = new DOOCSParameter(String.format("lineWidth%d", j), DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.CHANNEL, "<html>The line width of this channel</html>");
            parameters[i++] = new DOOCSParameter(String.format("lineMark%d", j), DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.CHANNEL, "<html>The marker of data points of this channel</html>");
            ++j;
        }
        parameters[i++] = new DOOCSParameter(String.format("adr%d", j), DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.CHANNEL, "<html>The DOOCS address</html>");
        parameters[i++] = new DOOCSParameter(String.format("lineColor%d", j), DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.CHANNEL, "<html>The color of this channel</html>");
        parameters[i++] = new DOOCSParameter(String.format("lineStyle%d", j), DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.CHANNEL, "<html>The line style of this channel</html>");
        parameters[i++] = new DOOCSParameter(String.format("lineWidth%d", j), DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.CHANNEL, "<html>The line width of this channel</html>");
        parameters[i++] = new DOOCSParameter(String.format("lineMark%d", j), DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.CHANNEL, "<html>The marker of data points of this channel</html>");
        return parameters;
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter == null || value == null) {
            return;
        }
        try {
            boolean flag = false;
            if (parameter.startsWith("adr")) {
                flag = true;
                String num = parameter.substring(3);
                int i = -1;
                if (num != null && num.length() > 0 && num.length() < 2) {
                    i = IntegerParser.parseInt(num);
                }
                if (i >= 0) {
                    if (i >= this.list.size()) {
                        this.addAdr(value);
                    } else {
                        this.list.get(i).setOrigAddress(value);
                    }
                }
            } else if (parameter.startsWith("lineColor")) {
                flag = true;
                String num = parameter.substring(9);
                int i = -1;
                if (num != null && num.length() > 0 && (i = IntegerParser.parseInt(num)) < this.list.size()) {
                    this.list.get((int)i).channels.get(0).setLineColor(DOOCSParameter.convertToColor(value));
                }
            } else if (parameter.startsWith("lineStyle")) {
                flag = true;
                String num = parameter.substring(9);
                int i = -1;
                if (num != null && num.length() > 0 && (i = IntegerParser.parseInt(num)) < this.list.size()) {
                    this.list.get(i).setDOOCSParameter(parameter, value);
                }
            } else if (parameter.startsWith("lineWidth")) {
                String num = parameter.substring(9);
                int i = -1;
                if (num != null && num.length() > 0 && (i = IntegerParser.parseInt(num)) < this.list.size()) {
                    this.list.get(i).setDOOCSParameter(parameter, value);
                }
            } else if (parameter.startsWith("lineMark")) {
                flag = true;
                String num = parameter.substring(8);
                int i = -1;
                if (num != null && num.length() > 0 && (i = IntegerParser.parseInt(num)) < this.list.size()) {
                    this.list.get(i).setDOOCSParameter(parameter, value);
                }
            }
            if (flag) {
                this.setLegend();
            }
        }
        catch (Exception e) {
            System.out.println("Can't decode " + value + " for " + parameter);
        }
    }

    public Object getDOOCSParameter(String parameter) {
        try {
            if (parameter.startsWith("adr")) {
                String num = parameter.substring(3);
                int i = -1;
                if (num != null && num.length() > 0) {
                    i = IntegerParser.parseInt(num);
                }
                if (i == this.list.size()) {
                    return null;
                }
                if (i >= 0 && i < this.list.size()) {
                    return this.list.get((int)i).doocsOrigAddress;
                }
            } else if (parameter.startsWith("lineColor")) {
                String num = parameter.substring(9);
                int i = -1;
                if (num != null && num.length() > 0) {
                    i = IntegerParser.parseInt(num);
                }
                if (i == this.list.size()) {
                    return DOOCSParameter.getDoocsColor(Color.BLUE);
                }
                if (i >= 0 && i < this.list.size()) {
                    return DOOCSParameter.getDoocsColor(this.list.get((int)i).channels.get((int)0).lineColor);
                }
            } else if (parameter.startsWith("lineStyle")) {
                String num = parameter.substring(9);
                int i = -1;
                if (num != null && num.length() > 0) {
                    i = IntegerParser.parseInt(num);
                }
                if (i == this.list.size()) {
                    return DOOCSChannel.LineStyle.Line;
                }
                if (i >= 0 && i < this.list.size()) {
                    return this.list.get((int)i).lineStyle;
                }
            } else if (parameter.startsWith("lineMark")) {
                String num = parameter.substring(8);
                int i = -1;
                if (num != null && num.length() > 0) {
                    i = IntegerParser.parseInt(num);
                }
                if (i == this.list.size()) {
                    return DOOCSChannel.Marks.None;
                }
                if (i >= 0 && i < this.list.size()) {
                    return this.list.get((int)i).marks;
                }
            } else if (parameter.startsWith("lineWidth")) {
                String num = parameter.substring(9);
                int i = -1;
                if (num != null && num.length() > 0) {
                    i = IntegerParser.parseInt(num);
                }
                if (i == this.list.size()) {
                    return 1;
                }
                if (i >= 0 && i < this.list.size()) {
                    return this.list.get((int)i).strokeSize;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Can't decode " + parameter);
        }
        return null;
    }

    public void findClosestDataPoint(DOOCSFindDataPoint dp, Graphics2D g2d) {
        AffineTransform saveTransform = g2d.getTransform();
        this.transformer.setToIdentity();
        this.transformer.translate(this.plot.dataAreaX0, this.plot.dataAreaY1);
        this.transformer.scale(this.plot.doocsPlotAxisX.transformScale, -this.plot.doocsPlotAxisY.transformScale);
        double xmin = this.plot.doocsPlotAxisX.actMin;
        double ymin = this.plot.doocsPlotAxisY.actMin;
        if (this.plot.doocsPlotAxisX.isLog) {
            xmin = Math.log10(xmin);
        }
        if (this.plot.doocsPlotAxisY.isLog) {
            ymin = Math.log10(ymin);
        }
        this.transformer.translate(-xmin, -ymin);
        for (DOOCSChannelList li : this.list) {
            li.findClosestDataPoint(dp, this.plot.doocsPlotAxisX, this.plot.doocsPlotAxisY);
        }
        g2d.setTransform(saveTransform);
    }

    public boolean findAddr(String adr) {
        for (DOOCSChannelList li : this.list) {
            if (adr.compareTo(li.doocsAddress) != 0) continue;
            return true;
        }
        return false;
    }

    public int isOnDataTip(int x, int y) {
        for (DOOCSChannelList li : this.list) {
            int rtn = li.isOnDataTip(x, y);
            if (rtn < 0) continue;
            return rtn;
        }
        return -1;
    }

    public String getDataTipText(int idx) {
        for (DOOCSChannelList li : this.list) {
            String rtn = li.getDataTipText(idx);
            if (rtn == null) continue;
            return rtn;
        }
        return "no text available";
    }

    public Point getDataTipPosition(int idx) {
        for (DOOCSChannelList li : this.list) {
            Point rtn = li.getDataTipPosition(idx);
            if (rtn == null) continue;
            return rtn;
        }
        return null;
    }

    public void setLegend() {
        ArrayList<DOOCSChannel> listChan = new ArrayList<DOOCSChannel>();
        for (DOOCSChannelList li : this.list) {
            li.setLegend(listChan);
        }
        this.plot.doocsPlotLegend.setLegend(listChan);
    }

    public void setDataTable(PlotDataTable table) {
        for (DOOCSChannelList li : this.list) {
            li.setDataTable(table);
        }
    }

    public void setDataParameter(int index, String parameter, Object obj) {
        for (DOOCSChannelList li : this.list) {
            li.setDataParameter(index, parameter, obj);
        }
    }

    public void cancel() {
        for (DOOCSChannelList li : this.list) {
            li.cancel();
        }
    }

    public void startMonitoring() {
        for (DOOCSChannelList li : this.list) {
            li.startMonitoring();
        }
    }

    boolean update() {
        this.countChannels = 0;
        boolean flag = false;
        for (DOOCSChannelList li : this.list) {
            flag |= li.update();
        }
        this.nChannels = this.countChannels;
        return flag;
    }

    public boolean autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double old1 = xaxis.actMin;
        double old2 = xaxis.actMax;
        if (!xaxis.isTimeScale) {
            xaxis.actMin = 1.0E21;
            xaxis.actMax = -1.0E21;
        }
        for (DOOCSChannelList li : this.list) {
            li.autoScaleX(xaxis, yaxis);
        }
        if (xaxis.actMin >= 1.0E21) {
            xaxis.actMin = xaxis.defaultMin;
        }
        if (xaxis.actMax <= -1.0E21) {
            xaxis.actMax = xaxis.defaultMax;
        }
        if (this.plot.plotType == DOOCSPlot.PlotType.PLOTLOCATION) {
            if (xaxis.actMin < 0.5) {
                xaxis.actMin = -1.0;
            }
        } else {
            if (xaxis.actMin < xaxis.limitMin) {
                xaxis.actMin = xaxis.limitMin;
            }
            if (this.plot.plotType == DOOCSPlot.PlotType.PLOTHIST) {
                double t = (double)System.currentTimeMillis() / 1000.0 + 100000.0;
                if (xaxis.actMax > t) {
                    xaxis.actMax = t;
                }
            } else if (xaxis.actMax > xaxis.limitMax) {
                xaxis.actMax = xaxis.limitMax;
            }
        }
        xaxis.roundUp(xaxis.actMin, xaxis.actMax);
        return old1 != xaxis.actMin || old2 != xaxis.actMax;
    }

    public boolean autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double old1 = yaxis.actMin;
        double old2 = yaxis.actMax;
        yaxis.actMin = 1.0E21;
        yaxis.actMax = -1.0E21;
        for (DOOCSChannelList li : this.list) {
            li.autoScaleY(xaxis, yaxis);
        }
        if (yaxis.actMin >= 1.0E21) {
            yaxis.actMin = yaxis.defaultMin;
        }
        if (yaxis.actMax <= -1.0E21) {
            yaxis.actMax = yaxis.defaultMax;
        }
        if (yaxis.actMin < yaxis.limitMin) {
            yaxis.actMin = yaxis.limitMin;
        }
        if (yaxis.actMax > yaxis.limitMax) {
            yaxis.actMax = yaxis.limitMax;
        }
        if (yaxis.actMin == 0.0 && yaxis.actMax == 0.0) {
            yaxis.actMax = 0.1;
            yaxis.actMin = -0.1;
        }
        yaxis.roundUp(yaxis.actMin, yaxis.actMax);
        return old1 != yaxis.actMin || old2 != yaxis.actMax;
    }

    public void createMathFct(DOOCSPlotMath fct, DOOCSPlotSelection sel) {
        for (DOOCSChannelList li : this.list) {
            li.createMathFct(fct, sel);
        }
    }

    public void paintMathFct(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle savedClip = g2d.getClipBounds();
        g2d.setClip(this.plot.dataAreaX0, this.plot.dataAreaY0, Math.abs(this.plot.dataAreaX1 - this.plot.dataAreaX0), Math.abs(this.plot.dataAreaY0 - this.plot.dataAreaY1));
        for (DOOCSChannelList li : this.list) {
            li.paintMathFct(g, xaxis, yaxis);
        }
        g2d.setClip(savedClip);
    }

    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int h;
        int w;
        Graphics2D g2d = (Graphics2D)g;
        Rectangle savedClip = g2d.getClipBounds();
        AffineTransform saveTransform = g2d.getTransform();
        this.transformer.setToIdentity();
        this.transformer.translate(this.plot.dataAreaX0, this.plot.dataAreaY1);
        this.transformer.scale(this.plot.doocsPlotAxisX.transformScale, -this.plot.doocsPlotAxisY.transformScale);
        double xmin = this.plot.doocsPlotAxisX.actMin;
        double ymin = this.plot.doocsPlotAxisY.actMin;
        if (this.plot.doocsPlotAxisX.isLog) {
            xmin = this.plot.plotType == DOOCSPlot.PlotType.PLOTHIST ? 0.0 : Math.log10(xmin);
        }
        if (this.plot.doocsPlotAxisY.isLog) {
            ymin = Math.log10(ymin);
        }
        this.transformer.translate(-xmin, -ymin);
        try {
            w = (int)g2d.getClipBounds().getWidth();
            if (this.plot.doocsPlotAxisX.pixelLength < w) {
                w = this.plot.doocsPlotAxisX.pixelLength;
            }
        }
        catch (Exception e) {
            w = this.plot.doocsPlotAxisX.pixelLength;
        }
        try {
            h = (int)g2d.getClipBounds().getHeight();
            if (this.plot.doocsPlotAxisY.pixelLength < h) {
                h = this.plot.doocsPlotAxisY.pixelLength;
            }
        }
        catch (Exception e) {
            h = this.plot.doocsPlotAxisY.pixelLength;
        }
        int cX2 = savedClip.x + savedClip.width;
        int pX2 = this.plot.dataAreaX0 + this.plot.doocsPlotAxisX.pixelLength;
        int cY2 = savedClip.y + savedClip.height;
        int pY2 = this.plot.dataAreaY0 + this.plot.doocsPlotAxisY.pixelLength;
        int areaX = savedClip.x > this.plot.dataAreaX0 ? savedClip.x : this.plot.dataAreaX0;
        int areaW = cX2 < pX2 ? cX2 - areaX : pX2 - areaX;
        int areaY = savedClip.y > this.plot.dataAreaY0 ? savedClip.y : this.plot.dataAreaY0;
        int areaH = cY2 < pY2 ? cY2 - areaY : pY2 - areaY;
        g2d.setClip(areaX, areaY, areaW, areaH);
        for (DOOCSChannelList li : this.list) {
            li.paintComponent(g, xaxis, yaxis);
        }
        g2d.setTransform(saveTransform);
        g2d.setClip(savedClip);
    }

    void paintLegend(Graphics g, int x0, int y0, int width, int height) {
        try {
            if (this.list.size() > 0 && this.list.get(0) != null) {
                this.list.get(0).paintLegendLabels(g, x0, y0, width, height);
            } else {
                Graphics2D g2d = (Graphics2D)g;
                int ioff = (int)g2d.getFontMetrics().getStringBounds(this.doocsAddress, g).getWidth();
                g2d.drawString(this.doocsAddress, x0 + width - ioff - 2, y0);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    int paintEGU(Graphics g, int x0, int y0, int width, int height) {
        if (this.list.size() > 0 && this.list.get(0) != null) {
            return this.list.get(0).paintEGULabels(g, x0, y0, width, height);
        }
        return 0;
    }
}

