/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class DOOCSTabbedPaneUI
extends BasicTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new DOOCSTabbedPaneUI();
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform tt = g2d.getTransform();
        if (tabPlacement == 4) {
            AffineTransform rotate = AffineTransform.getRotateInstance(Math.PI, (double)metrics.getHeight() / 2.0, 0.0);
            g2d.setFont(font.deriveFont(rotate));
        } else {
            g2d.setFont(font);
        }
        g2d.rotate(-1.5707963267948966);
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            g2d.setColor(this.tabPane.getForegroundAt(tabIndex));
            if (tabPlacement == 2 && title != null) {
                g.drawString(title, -(textRect.y + textRect.height) + 10, textRect.x + metrics.getAscent() + 4);
            }
            if (tabPlacement == 4 && title != null) {
                g.drawString(title, -(textRect.y + textRect.height / 2) + 4, textRect.x + metrics.getAscent() - 4);
            }
        } else {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
            g.drawString(title, -(textRect.y + SwingUtilities.computeStringWidth(metrics, title)) + textRect.height, textRect.x + metrics.getAscent());
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
            g.drawString(title, -(textRect.y + SwingUtilities.computeStringWidth(metrics, title) - 1) + textRect.height, textRect.x + metrics.getAscent() - 1);
        }
        g2d.setTransform(tt);
    }

    @Override
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        Icon icon = this.getIconForTab(tabIndex);
        FontMetrics metrics = this.getFontMetrics();
        Insets tInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = 0;
        if (icon != null) {
            width += icon.getIconHeight() + this.textIconGap;
        }
        String title = this.tabPane.getTitleAt(tabIndex);
        int height = (width += SwingUtilities.computeStringWidth(metrics, title)) + 20;
        return height += tInsets.top + tInsets.bottom;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int height = 0;
        height += metrics.getHeight();
        Icon icon = this.getIconForTab(tabIndex);
        Insets tInsets = this.getTabInsets(tabPlacement, tabIndex);
        if (icon != null) {
            height = Math.max(height, icon.getIconWidth());
        }
        float ratio = 0.2f;
        int width = (int)(ratio * (float)height);
        return width += tInsets.left + tInsets.right;
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.setBounds(tabRect);
        textRect.x += xNudge;
        textRect.y += yNudge;
    }
}

