/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import editor.undo.SetProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class DOOCSRect
extends JComponent
implements DOOCSComponent {
    private Color doocsLineColor = Color.BLACK;
    private int doocsStrokeSize = 1;
    private Color doocsFillColor = Color.WHITE;
    private Color doocsEndColor = Color.WHITE;
    private boolean doocsLineTransparent = false;
    private boolean doocsFillTransparent = false;
    private boolean doocsGradient = false;
    private String doocsRotate = "0";
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;

    public DOOCSRect() {
        this.setEnabled(this.doocsRunMode);
        this.setPreferredSize(new Dimension(50, 50));
        this.setSize(new Dimension(50, 50));
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsLineColor(Color lineColor) {
        this.doocsLineColor = lineColor;
    }

    public Color getDoocsLineColor() {
        return this.doocsLineColor;
    }

    public void setDoocsLineTransparent(Boolean lineTransparent) {
        this.doocsLineTransparent = lineTransparent;
    }

    public Boolean getDoocsLineTransparent() {
        return this.doocsLineTransparent;
    }

    public void setDoocsStrokeSize(int strokeSize) {
        this.doocsStrokeSize = strokeSize;
    }

    public int getDoocsStrokeSize() {
        return this.doocsStrokeSize;
    }

    public void setDoocsFillColor(Color fillColor) {
        this.doocsFillColor = fillColor;
    }

    public Color getDoocsFillColor() {
        return this.doocsFillColor;
    }

    public void setDoocsEndColor(Color endColor) {
        this.doocsEndColor = endColor;
    }

    public Color getDoocsEndColor() {
        return this.doocsEndColor;
    }

    public void setDoocsFillTransparent(Boolean fillTransparent) {
        this.doocsFillTransparent = fillTransparent;
    }

    public Boolean getDoocsFillTransparent() {
        return this.doocsFillTransparent;
    }

    public void setDoocsGradient(Boolean gradient) {
        this.doocsGradient = gradient;
    }

    public Boolean getDoocsGradient() {
        return this.doocsGradient;
    }

    public void setDoocsRotate(String rotate) {
        this.doocsRotate = rotate;
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public void setFullDoocsAddress(String address) {
    }

    @Override
    public String getFullDoocsAddress() {
        return null;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        if (this.doocsGradient) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("strokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("gradient", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("endColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("strokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("gradient", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSRect ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSRect>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("lineColor")) {
            this.setDoocsLineColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("lineTransparent")) {
            this.setDoocsLineTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("strokeSize")) {
            this.setDoocsStrokeSize(Math.round(Float.parseFloat(value)));
        } else if (parameter.equalsIgnoreCase("fillColor")) {
            this.setDoocsFillColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("endColor")) {
            this.setDoocsEndColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("fillTransparent")) {
            this.setDoocsFillTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("gradient")) {
            this.setDoocsGradient(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSRect.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("lineColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsLineColor());
        }
        if (parameter.equalsIgnoreCase("lineTransparent")) {
            return this.getDoocsLineTransparent();
        }
        if (parameter.equalsIgnoreCase("strokeSize")) {
            return this.getDoocsStrokeSize();
        }
        if (parameter.equalsIgnoreCase("fillColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsFillColor());
        }
        if (parameter.equalsIgnoreCase("endColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsEndColor());
        }
        if (parameter.equalsIgnoreCase("fillTransparent")) {
            return this.getDoocsFillTransparent();
        }
        if (parameter.equalsIgnoreCase("gradient")) {
            return this.getDoocsGradient();
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSRect.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public boolean isSelected(int x, int y) {
        if (this.doocsFillTransparent) {
            if (x < this.doocsStrokeSize + 2 || x > this.getSize().width - this.doocsStrokeSize - 2) {
                return true;
            }
            return y < this.doocsStrokeSize + 2 || y > this.getSize().height - this.doocsStrokeSize - 2;
        }
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x = 0;
        int y = 0;
        int width = this.getSize().width - 1;
        int height = this.getSize().height - 1;
        if (!this.doocsGradient) {
            g2d.setColor(this.doocsFillColor);
            if (!this.doocsFillTransparent) {
                g2d.fillRect(x, y, width, height);
            }
        } else {
            GradientPaint pat = this.doocsRotate.equalsIgnoreCase("180") ? new GradientPaint(width / 2, 0.0f, this.doocsEndColor, width / 2, height, this.doocsFillColor) : (this.doocsRotate.equalsIgnoreCase("90") ? new GradientPaint(0.0f, height / 2, this.doocsEndColor, width, height / 2, this.doocsFillColor) : (this.doocsRotate.equalsIgnoreCase("0") ? new GradientPaint(width / 2, 0.0f, this.doocsFillColor, width / 2, height, this.doocsEndColor) : new GradientPaint(0.0f, height / 2, this.doocsFillColor, width, height / 2, this.doocsEndColor)));
            g2d.setPaint(pat);
            Rectangle2D.Float rect1 = new Rectangle2D.Float(x, y, width, height);
            g2d.fill(rect1);
        }
        BasicStroke myStroke = new BasicStroke(this.doocsStrokeSize);
        g2d.setStroke(myStroke);
        g2d.setColor(this.doocsLineColor);
        if (!this.doocsLineTransparent) {
            g2d.drawRect(x, y, width, height);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("0");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }
}

