/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSPropertiesTableCellEditor;
import DOOCSComponents.StringTransferHandler;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.DOOCSParser;

public class DOOCSPropertiesTable
extends JScrollPane
implements Runnable,
DOOCSComponent {
    private transient Thread th;
    private boolean stop = false;
    private MouseMotionAdapter listenerDrag;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsToolTipText = null;
    private float doocsUpdateTime = 60.0f;
    private DefaultTableModel myModel = new DefaultTableModel();
    public JTable propertiesTable;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String m_path = null;
    private DOOCSPropertiesTableCellEditor myCellEditor;

    public DOOCSPropertiesTable() {
        this.myModel.addColumn("Path");
        this.myModel.addColumn("Value");
        this.propertiesTable = new JTable(this.myModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText((String)this.getValueAt(rowIndex, vColIndex));
                }
                return c;
            }
        };
        this.myCellEditor = new DOOCSPropertiesTableCellEditor();
        this.propertiesTable.getColumnModel().getColumn(1).setCellEditor(this.myCellEditor);
        this.propertiesTable.setColumnSelectionAllowed(true);
        this.propertiesTable.setRowSelectionAllowed(true);
        this.propertiesTable.setSelectionMode(0);
        this.propertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DOOCSPropertiesTable.this.selectionChanged();
            }
        });
        this.setViewportView(this.propertiesTable);
        this.setPreferredSize(new Dimension(250, 150));
        this.setSize(new Dimension(250, 150));
        this.setEnabled(this.doocsRunMode);
        this.setTransferHandler(new StringTransferHandler());
        this.listenerDrag = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DOOCSPropertiesTable.this.setDragString(e);
            }
        };
    }

    private void selectionChanged() {
        int x = this.propertiesTable.getSelectedRow();
        int y = this.propertiesTable.getSelectedColumn();
        if (y == 1 && x >= 0) {
            this.propertiesTable.editCellAt(x, y);
            ((DOOCSPropertiesTableCellEditor)this.propertiesTable.getCellEditor((int)x, (int)y)).component.requestFocus();
        }
    }

    private void setDragString(MouseEvent e) {
        TransferHandler tr = this.getTransferHandler();
        tr.exportAsDrag(this, e, 1);
    }

    public void stopThreads() {
        this.stop = true;
        this.propertiesTable.removeMouseMotionListener(this.listenerDrag);
    }

    public void startThreads() {
        this.stop = false;
        this.propertiesTable.addMouseMotionListener(this.listenerDrag);
        this.th = new Thread(this);
        this.th.start();
    }

    @Override
    public void setDnDText(String str) {
        EqAdr ea = new EqAdr(str);
        if (EqAdr.isValidAdr((String)str)) {
            this.doocsAddress = str;
            this.setRunMode(false);
            DOOCSParser.inherit(DOOCSParameter.getParentLayeredPane(this));
            this.setRunMode(true);
        }
    }

    @Override
    public String getDnDText() {
        int selRow = this.propertiesTable.getSelectedRow();
        return this.m_path + this.myModel.getValueAt(selRow, 0);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
        if (this.isRunMode()) {
            this.setRunMode(false);
            this.setRunMode(true);
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            if (this.fullDoocsAddress != null) {
                EqAdr check = new EqAdr(this.fullDoocsAddress);
                if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                    return;
                }
                if (check.facility() == null || check.device() == null || check.location() == null) {
                    return;
                }
                int slash1 = this.fullDoocsAddress.indexOf("/");
                int slash2 = this.fullDoocsAddress.indexOf("/", slash1 + 1);
                int slash3 = this.fullDoocsAddress.indexOf("/", slash2 + 1);
                this.m_path = this.fullDoocsAddress.substring(0, slash3 + 1);
                String endsWith = this.fullDoocsAddress.substring(slash3 + 1);
                if (endsWith.length() > 0 && endsWith.substring(endsWith.length() - 1).equalsIgnoreCase("*")) {
                    endsWith = endsWith.substring(0, endsWith.length() - 1);
                }
                this.propertiesTable.getColumnModel().getColumn(0).setHeaderValue(this.m_path + "*");
                this.myCellEditor.setPath(this.m_path);
                EqCall ec = new EqCall();
                EqData ed = new EqData();
                EqData valueData = new EqData();
                EqData data = ec.names(new EqAdr(this.m_path + "*"));
                EqAdr ea = null;
                int counter = 0;
                if (data.error() == 0) {
                    this.myModel.setRowCount(data.array_length());
                    for (int i = 0; i < data.array_length(); ++i) {
                        String property = data.get_string_arg(i).trim();
                        if (property.contains(" ")) {
                            property = property.substring(0, property.indexOf(" "));
                        }
                        if (endsWith.length() != 0 && (endsWith.length() <= 0 || !property.startsWith(endsWith))) continue;
                        this.propertiesTable.setValueAt(property, counter, 0);
                        ea = new EqAdr(this.m_path + property);
                        ec.get(ea, ed, valueData);
                        if (valueData.error() == 0) {
                            this.propertiesTable.setValueAt(valueData.get_string(), counter, 1);
                        }
                        ++counter;
                    }
                } else {
                    counter = 0;
                    this.myModel.setRowCount(1);
                    this.propertiesTable.setValueAt("ERROR:", counter, 0);
                    this.propertiesTable.setValueAt(data.get_string(), counter, 1);
                    this.propertiesTable.setBackground(new Color(255, 0, 0));
                }
                this.propertiesTable.getTableHeader().setToolTipText(this.fullDoocsAddress);
            }
            this.startThreads();
        } else {
            this.stopThreads();
            this.myModel.setRowCount(0);
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("headerTextColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("headerBgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSPropertiesTable ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSPropertiesTable>\n");
        return xmlStructure;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.propertiesTable.addMouseListener(ml);
        this.propertiesTable.addMouseMotionListener(ml);
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.propertiesTable.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("headerTextColor")) {
            this.propertiesTable.getTableHeader().setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("headerBgColor")) {
            this.propertiesTable.getTableHeader().setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.propertiesTable.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.propertiesTable.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSPropertiesTable.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.propertiesTable.getFont());
        }
        if (parameter.equalsIgnoreCase("headerTextColor")) {
            return DOOCSParameter.getDoocsColor(this.propertiesTable.getTableHeader().getForeground());
        }
        if (parameter.equalsIgnoreCase("headerBgColor")) {
            return DOOCSParameter.getDoocsColor(this.propertiesTable.getTableHeader().getBackground());
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.propertiesTable.getForeground());
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.propertiesTable.getBackground());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSPropertiesTable.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void run() {
        EqCall ec = new EqCall();
        EqData ed = new EqData();
        EqData valueData = new EqData();
        EqData data = ec.names(new EqAdr(this.m_path + "*"));
        EqAdr ea = null;
        while (!this.stop) {
            if (this.doocsRunMode && this.m_path != null) {
                for (int i = 0; i < data.length(); ++i) {
                    String property = data.get_string_arg(i).trim();
                    if (property.contains(" ")) {
                        property = property.substring(0, property.indexOf(" "));
                    }
                    for (int k = 0; k < this.myModel.getRowCount(); ++k) {
                        if (property == null || this.propertiesTable.getValueAt(k, 0) == null || !property.equalsIgnoreCase(this.propertiesTable.getValueAt(k, 0).toString())) continue;
                        ea = new EqAdr(this.m_path + property);
                        ec.get(ea, ed, valueData);
                        if (valueData.error() != 0) continue;
                        String value = valueData.get_string_arg();
                        if (this.myModel.getRowCount() <= 0 || this.propertiesTable.getValueAt(k, 1).toString().equalsIgnoreCase(value)) continue;
                        this.propertiesTable.setValueAt(value, k, 1);
                    }
                }
            }
            try {
                if ((double)this.doocsUpdateTime == 0.0) {
                    Thread.sleep(10000L);
                    continue;
                }
                if ((double)this.doocsUpdateTime < 0.1) {
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep((long)(this.doocsUpdateTime * 1000.0f));
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

