/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSProgressBar;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class DOOCSProgressBarUI
extends BasicProgressBarUI {
    protected DOOCSProgressBar pBar;

    public DOOCSProgressBarUI(DOOCSProgressBar bar) {
        this.pBar = bar;
    }

    @Override
    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        if (this.pBar.getOrientation() == 0) {
            if (this.pBar.getComponentOrientation().isLeftToRight()) {
                if (this.pBar.isIndeterminate()) {
                    this.boxRect = this.getBox(this.boxRect);
                    this.paintString(g, x, y, width, height, this.boxRect.x, this.boxRect.width, b);
                } else {
                    this.paintString(g, x, y, width, height, x, amountFull, b);
                }
            } else {
                this.paintString(g, x, y, width, height, x + width - amountFull, amountFull, b);
            }
        } else if (this.pBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            this.paintString(g, x, y, width, height, this.boxRect.y, this.boxRect.height, b);
        } else {
            this.paintString(g, x, y, width, height, y + height - amountFull, amountFull, b);
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.pBar.getString();
        g2.setFont(this.pBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.pBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, height);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            FontMetrics fm = this.pBar.getFontMetrics(this.pBar.getFont());
            AffineTransform rotate = this.pBar.getDoocsRotate().equalsIgnoreCase("90") ? AffineTransform.getRotateInstance(1.5707963267948966) : AffineTransform.getRotateInstance(-1.5707963267948966, (double)fm.getHeight() / 2.0, 0.0);
            g2.setFont(this.pBar.getFont().deriveFont(rotate));
            renderLocation = this.pBar.getDoocsRotate().equalsIgnoreCase("90") ? this.getStringPlacement(g2, progressString, x, y, width, height) : this.getStringPlacement(g2, progressString, x, y + fm.stringWidth(progressString) - fm.getAscent() / 2, width, height);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, width, amountFull);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }
}

