/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import editor.undo.SetProperty;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.metal.MetalComboBoxButton;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.DOOCSParser;

public class DOOCSLocationChooser
extends JComponent
implements DOOCSComponent,
ActionListener {
    private JComboBox facBox = new JComboBox();
    private JComboBox devBox = new JComboBox();
    private JComboBox locBox = new JComboBox();
    private JComboBox propBox = new JComboBox();
    private boolean doocsFacility = false;
    private boolean doocsDevice = false;
    private boolean doocsLocation = true;
    private boolean doocsProperty = false;
    private boolean doocsHeadline = false;
    private String doocsFacilityFilter = null;
    private String doocsDeviceFilter = null;
    private String doocsLocationFilter = null;
    private String doocsPropertyFilter = null;
    private String doocsFacilityRegexFilter = null;
    private String doocsDeviceRegexFilter = null;
    private String doocsLocationRegexFilter = null;
    private String doocsPropertyRegexFilter = null;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String fullDoocsAddress = null;
    private boolean startup = false;
    private MouseListener buttonMouseListenerFac;
    private MouseListener buttonMouseListenerDev;
    private MouseListener buttonMouseListenerLoc;
    private MouseListener buttonMouseListenerProp;

    public DOOCSLocationChooser() {
        this.facBox.setName("facBox");
        this.devBox.setName("devBox");
        this.locBox.setName("locBox");
        this.propBox.setName("propBox");
        this.facBox.addActionListener(this);
        this.devBox.addActionListener(this);
        this.locBox.addActionListener(this);
        this.propBox.addActionListener(this);
        this.facBox.setEnabled(this.doocsRunMode);
        this.devBox.setEnabled(this.doocsRunMode);
        this.locBox.setEnabled(this.doocsRunMode);
        this.propBox.setEnabled(this.doocsRunMode);
        this.composeLocationChooser();
        this.setPreferredSize(new Dimension(100, 20));
        this.setEnabled(this.doocsRunMode);
        this.buttonMouseListenerFac = ((MetalComboBoxButton)this.facBox.getComponent(0)).getMouseListeners()[0];
        ((MetalComboBoxButton)this.facBox.getComponent(0)).removeMouseListener(this.buttonMouseListenerFac);
        this.buttonMouseListenerDev = ((MetalComboBoxButton)this.devBox.getComponent(0)).getMouseListeners()[0];
        ((MetalComboBoxButton)this.devBox.getComponent(0)).removeMouseListener(this.buttonMouseListenerDev);
        this.buttonMouseListenerLoc = ((MetalComboBoxButton)this.locBox.getComponent(0)).getMouseListeners()[0];
        ((MetalComboBoxButton)this.locBox.getComponent(0)).removeMouseListener(this.buttonMouseListenerLoc);
        this.buttonMouseListenerProp = ((MetalComboBoxButton)this.propBox.getComponent(0)).getMouseListeners()[0];
        ((MetalComboBoxButton)this.propBox.getComponent(0)).removeMouseListener(this.buttonMouseListenerProp);
    }

    private void composeLocationChooser() {
        int rows = 1;
        int columns = 0;
        this.removeAll();
        if (this.doocsHeadline) {
            rows = 2;
        }
        if (this.doocsFacility) {
            ++columns;
        }
        if (this.doocsDevice) {
            ++columns;
        }
        if (this.doocsLocation) {
            ++columns;
        }
        if (this.doocsProperty) {
            ++columns;
        }
        this.setLayout(new GridLayout(rows, columns));
        if (this.doocsHeadline) {
            if (this.doocsFacility) {
                this.add(new JLabel("facility"));
            }
            if (this.doocsDevice) {
                this.add(new JLabel("device"));
            }
            if (this.doocsLocation) {
                this.add(new JLabel("location"));
            }
            if (this.doocsProperty) {
                this.add(new JLabel("property"));
            }
        }
        if (this.doocsFacility) {
            this.add(this.facBox);
        }
        if (this.doocsDevice) {
            this.add(this.devBox);
        }
        if (this.doocsLocation) {
            this.add(this.locBox);
        }
        if (this.doocsProperty) {
            this.add(this.propBox);
        }
        this.validate();
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsHeadline(boolean set) {
        this.doocsHeadline = set;
        this.composeLocationChooser();
    }

    public boolean getDoocsHeadline() {
        return this.doocsHeadline;
    }

    public void setDoocsFacility(boolean set) {
        this.doocsFacility = set;
        this.composeLocationChooser();
    }

    public boolean getDoocsFacility() {
        return this.doocsFacility;
    }

    public void setDoocsDevice(boolean set) {
        this.doocsDevice = set;
        this.composeLocationChooser();
    }

    public boolean getDoocsDevice() {
        return this.doocsDevice;
    }

    public void setDoocsLocation(boolean set) {
        this.doocsLocation = set;
        this.composeLocationChooser();
    }

    public boolean getDoocsLocation() {
        return this.doocsLocation;
    }

    public void setDoocsProperty(boolean set) {
        this.doocsProperty = set;
        this.composeLocationChooser();
    }

    public boolean getDoocsProperty() {
        return this.doocsProperty;
    }

    public void setDoocsFacilityFilter(String filter) {
        this.doocsFacilityFilter = filter;
    }

    public String getDoocsFacilityFilter() {
        return this.doocsFacilityFilter;
    }

    public void setDoocsDeviceFilter(String filter) {
        this.doocsDeviceFilter = filter;
    }

    public String getDoocsDeviceFilter() {
        return this.doocsDeviceFilter;
    }

    public void setDoocsLocationFilter(String filter) {
        this.doocsLocationFilter = filter;
    }

    public String getDoocsLocationFilter() {
        return this.doocsLocationFilter;
    }

    public void setDoocsPropertyFilter(String filter) {
        this.doocsPropertyFilter = filter;
    }

    public String getDoocsPropertyFilter() {
        return this.doocsPropertyFilter;
    }

    public void setDoocsFacilityRegexFilter(String filter) {
        this.doocsFacilityRegexFilter = filter;
    }

    public String getDoocsFacilityRegexFilter() {
        return this.doocsFacilityRegexFilter;
    }

    public void setDoocsDeviceRegexFilter(String filter) {
        this.doocsDeviceRegexFilter = filter;
    }

    public String getDoocsDeviceRegexFilter() {
        return this.doocsDeviceRegexFilter;
    }

    public void setDoocsLocationRegexFilter(String filter) {
        this.doocsLocationRegexFilter = filter;
    }

    public String getDoocsLocationRegexFilter() {
        return this.doocsLocationRegexFilter;
    }

    public void setDoocsPropertyRegexFilter(String filter) {
        this.doocsPropertyRegexFilter = filter;
    }

    public String getDoocsPropertyRegexFilter() {
        return this.doocsPropertyRegexFilter;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.facBox.setEnabled(bRun);
        this.devBox.setEnabled(bRun);
        this.locBox.setEnabled(bRun);
        this.propBox.setEnabled(bRun);
        if (bRun) {
            ((MetalComboBoxButton)this.facBox.getComponent(0)).addMouseListener(this.buttonMouseListenerFac);
            ((MetalComboBoxButton)this.devBox.getComponent(0)).addMouseListener(this.buttonMouseListenerDev);
            ((MetalComboBoxButton)this.locBox.getComponent(0)).addMouseListener(this.buttonMouseListenerLoc);
            ((MetalComboBoxButton)this.propBox.getComponent(0)).addMouseListener(this.buttonMouseListenerProp);
            if (this.fullDoocsAddress != null) {
                this.startup = true;
                String facility = null;
                String device = null;
                String location = null;
                String property = null;
                EqAdr ea = new EqAdr(this.fullDoocsAddress);
                if (EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                    String path;
                    facility = ea.facility();
                    device = ea.device();
                    location = ea.location();
                    property = ea.property();
                    if (this.doocsFacility) {
                        this.facBox.removeAllItems();
                        try {
                            if (this.doocsFacilityFilter != null && this.doocsFacilityFilter.endsWith("*")) {
                                this.doocsFacilityFilter = this.doocsFacilityFilter.substring(0, this.doocsFacilityFilter.length() - 1);
                            }
                            path = "*///";
                            EqCall ec = new EqCall();
                            EqData data = ec.names(new EqAdr(path));
                            for (int i = 0; i < data.length(); ++i) {
                                String item = data.get_string_arg(i).trim();
                                if (this.doocsFacilityFilter == null && this.doocsFacilityRegexFilter == null) {
                                    this.facBox.addItem(item);
                                }
                                if (this.doocsFacilityFilter != null && item.startsWith(this.doocsFacilityFilter)) {
                                    this.facBox.addItem(item);
                                }
                                if (this.doocsFacilityFilter != null || this.doocsFacilityRegexFilter == null || !item.matches(this.doocsFacilityRegexFilter)) continue;
                                this.facBox.addItem(item);
                            }
                            if (facility != null && facility.length() > 2) {
                                this.facBox.setSelectedItem(facility);
                            } else {
                                this.facBox.setSelectedIndex(0);
                                facility = this.facBox.getSelectedItem().toString();
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            System.out.println(pse);
                        }
                    }
                    if (this.doocsDevice) {
                        path = facility + "/*//";
                        this.fillDevBox(path, device);
                        if (device == null || device.length() < 3) {
                            device = this.devBox.getSelectedItem().toString();
                        }
                    }
                    if (this.doocsLocation) {
                        path = facility + "/" + device + "/*/";
                        this.fillLocBox(path, location);
                        if (location == null || location.length() < 3) {
                            location = this.locBox.getSelectedItem().toString();
                        }
                    }
                    if (this.doocsProperty) {
                        path = facility + "/" + device + "/" + location + "/*";
                        this.fillPropBox(path, property);
                        if (property == null || property.length() < 3) {
                            property = this.propBox.getSelectedItem().toString();
                        }
                    }
                    String newAddress = facility + "/" + device + "/" + location + "/" + property;
                    this.updateLayeredPane(newAddress);
                }
                this.startup = false;
            }
        } else {
            ((MetalComboBoxButton)this.facBox.getComponent(0)).removeMouseListener(this.buttonMouseListenerFac);
            ((MetalComboBoxButton)this.devBox.getComponent(0)).removeMouseListener(this.buttonMouseListenerDev);
            ((MetalComboBoxButton)this.locBox.getComponent(0)).removeMouseListener(this.buttonMouseListenerLoc);
            ((MetalComboBoxButton)this.propBox.getComponent(0)).removeMouseListener(this.buttonMouseListenerProp);
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("headline", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("facility", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("device", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("location", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("property", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("facilityFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "to display only facilities starting with this String"), new DOOCSParameter("deviceFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "to display only devices starting with this String"), new DOOCSParameter("locationFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "to display only locations starting with this String"), new DOOCSParameter("propertyFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "to display only properties starting with this String"), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("facilityRegexFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.EXPERT, "to display facilities matching this regex String"), new DOOCSParameter("deviceRegexFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.EXPERT, "to display devices matching this regex String"), new DOOCSParameter("locationRegexFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.EXPERT, "to display locations matching this regex String"), new DOOCSParameter("propertyRegexFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.EXPERT, "to display properties matching this regex String"), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSLocationChooser ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSLocationChooser>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("headline")) {
            this.setDoocsHeadline(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("facility")) {
            this.setDoocsFacility(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("device")) {
            this.setDoocsDevice(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("location")) {
            this.setDoocsLocation(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("property")) {
            this.setDoocsProperty(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("facilityFilter")) {
            this.setDoocsFacilityFilter(value);
        } else if (parameter.equalsIgnoreCase("deviceFilter")) {
            this.setDoocsDeviceFilter(value);
        } else if (parameter.equalsIgnoreCase("locationFilter")) {
            this.setDoocsLocationFilter(value);
        } else if (parameter.equalsIgnoreCase("propertyFilter")) {
            this.setDoocsPropertyFilter(value);
        } else if (parameter.equalsIgnoreCase("facilityRegexFilter")) {
            this.setDoocsFacilityRegexFilter(value);
        } else if (parameter.equalsIgnoreCase("deviceRegexFilter")) {
            this.setDoocsDeviceRegexFilter(value);
        } else if (parameter.equalsIgnoreCase("locationRegexFilter")) {
            this.setDoocsLocationRegexFilter(value);
        } else if (parameter.equalsIgnoreCase("propertyRegexFilter")) {
            this.setDoocsPropertyRegexFilter(value);
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSLocationChooser.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("headline")) {
            return this.getDoocsHeadline();
        }
        if (parameter.equalsIgnoreCase("facility")) {
            return this.getDoocsFacility();
        }
        if (parameter.equalsIgnoreCase("device")) {
            return this.getDoocsDevice();
        }
        if (parameter.equalsIgnoreCase("location")) {
            return this.getDoocsLocation();
        }
        if (parameter.equalsIgnoreCase("property")) {
            return this.getDoocsProperty();
        }
        if (parameter.equalsIgnoreCase("facilityFilter")) {
            return this.getDoocsFacilityFilter();
        }
        if (parameter.equalsIgnoreCase("deviceFilter")) {
            return this.getDoocsDeviceFilter();
        }
        if (parameter.equalsIgnoreCase("locationFilter")) {
            return this.getDoocsLocationFilter();
        }
        if (parameter.equalsIgnoreCase("propertyFilter")) {
            return this.getDoocsPropertyFilter();
        }
        if (parameter.equalsIgnoreCase("facilityRegexFilter")) {
            return this.getDoocsFacilityRegexFilter();
        }
        if (parameter.equalsIgnoreCase("deviceRegexFilter")) {
            return this.getDoocsDeviceRegexFilter();
        }
        if (parameter.equalsIgnoreCase("locationRegexFilter")) {
            return this.getDoocsLocationRegexFilter();
        }
        if (parameter.equalsIgnoreCase("propertyRegexFilter")) {
            return this.getDoocsPropertyRegexFilter();
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.facBox.getFont());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSLocationChooser.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setFont(f);
        }
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.facBox.addMouseListener(ml);
        this.facBox.addMouseMotionListener(ml);
        this.devBox.addMouseListener(ml);
        this.devBox.addMouseMotionListener(ml);
        this.locBox.addMouseListener(ml);
        this.locBox.addMouseMotionListener(ml);
        this.propBox.addMouseListener(ml);
        this.propBox.addMouseMotionListener(ml);
        this.facBox.getComponent(0).addMouseListener(ml);
        this.facBox.getComponent(0).addMouseMotionListener(ml);
        this.devBox.getComponent(0).addMouseListener(ml);
        this.devBox.getComponent(0).addMouseMotionListener(ml);
        this.locBox.getComponent(0).addMouseListener(ml);
        this.locBox.getComponent(0).addMouseMotionListener(ml);
        this.propBox.getComponent(0).addMouseListener(ml);
        this.propBox.getComponent(0).addMouseMotionListener(ml);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.doocsRunMode && !this.startup) {
            String source = ((JComboBox)e.getSource()).getName();
            String facility = null;
            String device = null;
            String location = null;
            String property = null;
            EqAdr ea = new EqAdr(this.fullDoocsAddress);
            if (EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                facility = ea.facility();
                device = ea.device();
                location = ea.location();
                property = ea.property();
            }
            this.startup = true;
            if (facility == null || facility.length() < 3) {
                facility = this.facBox.getSelectedItem().toString();
            }
            if (this.doocsFacility && source.equalsIgnoreCase("facBox")) {
                facility = this.facBox.getSelectedItem().toString();
                this.fillDevBox(facility + "/*//", null);
                device = this.devBox.getSelectedItem().toString();
                this.fillLocBox(facility + "/" + device + "/*/", null);
                location = this.locBox.getSelectedItem().toString();
                this.fillPropBox(facility + "/" + device + "/" + location + "/*", null);
                property = this.propBox.getSelectedItem().toString();
            }
            if (this.doocsDevice && source.equalsIgnoreCase("devBox")) {
                device = this.devBox.getSelectedItem().toString();
                this.fillLocBox(facility + "/" + device + "/*/", null);
                location = this.locBox.getSelectedItem().toString();
                this.fillPropBox(facility + "/" + device + "/" + location + "/*", null);
                property = this.propBox.getSelectedItem().toString();
            }
            if (this.doocsLocation && source.equalsIgnoreCase("locBox")) {
                if (device == null || device.length() < 3) {
                    device = this.devBox.getSelectedItem().toString();
                }
                location = this.locBox.getSelectedItem().toString();
                this.fillPropBox(facility + "/" + device + "/" + location + "/*", null);
                property = this.propBox.getSelectedItem().toString();
            }
            if (this.doocsProperty && source.equalsIgnoreCase("propBox")) {
                if (device == null || device.length() < 3) {
                    device = this.devBox.getSelectedItem().toString();
                }
                if (location == null || location.length() < 3) {
                    location = this.locBox.getSelectedItem().toString();
                }
                property = this.propBox.getSelectedItem().toString();
            }
            String newAddress = facility + "/" + device + "/" + location + "/" + property;
            this.updateLayeredPane(newAddress);
            this.startup = false;
        }
    }

    private void updateLayeredPane(String newAddress) {
        ((DOOCSLayeredPane)this.getParent()).setFullDoocsAddress(newAddress);
        DOOCSParser.inherit((DOOCSComponent)((Object)this.getParent()));
        if (((DOOCSLayeredPane)this.getParent()).showToolTip) {
            ((DOOCSLayeredPane)this.getParent()).switchToolTipText((DOOCSLayeredPane)this.getParent(), true);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    private void fillDevBox(String path, String device) {
        this.devBox.removeAllItems();
        try {
            if (this.doocsDeviceFilter != null && this.doocsDeviceFilter.endsWith("*")) {
                this.doocsDeviceFilter = this.doocsDeviceFilter.substring(0, this.doocsDeviceFilter.length() - 1);
            }
            EqCall ec = new EqCall();
            EqData data = ec.names(new EqAdr(path));
            for (int i = 0; i < data.length(); ++i) {
                String item = data.get_string_arg(i).trim();
                if (this.doocsDeviceFilter == null && this.doocsDeviceRegexFilter == null) {
                    this.devBox.addItem(item);
                }
                if (this.doocsDeviceFilter != null && item.startsWith(this.doocsDeviceFilter)) {
                    this.devBox.addItem(item);
                }
                if (this.doocsDeviceFilter != null || this.doocsDeviceRegexFilter == null || !item.matches(this.doocsDeviceRegexFilter)) continue;
                this.devBox.addItem(item);
            }
            if (device != null && device.length() > 2) {
                this.devBox.setSelectedItem(device);
            } else {
                this.devBox.setSelectedIndex(0);
            }
        }
        catch (PatternSyntaxException pse) {
            System.out.println(pse);
        }
    }

    private void fillLocBox(String path, String location) {
        this.locBox.removeAllItems();
        try {
            if (this.doocsLocationFilter != null && this.doocsLocationFilter.endsWith("*")) {
                this.doocsLocationFilter = this.doocsLocationFilter.substring(0, this.doocsLocationFilter.length() - 1);
            }
            EqCall ec = new EqCall();
            EqData data = ec.names(new EqAdr(path));
            for (int i = 0; i < data.length(); ++i) {
                String item = data.get_string_arg(i).trim();
                if (this.doocsLocationFilter == null && this.doocsLocationRegexFilter == null) {
                    this.locBox.addItem(item);
                }
                if (this.doocsLocationFilter != null && item.startsWith(this.doocsLocationFilter)) {
                    this.locBox.addItem(item);
                }
                if (this.doocsLocationFilter != null || this.doocsLocationRegexFilter == null || !item.matches(this.doocsLocationRegexFilter)) continue;
                this.locBox.addItem(item);
            }
            if (location != null && location.length() > 2) {
                this.locBox.setSelectedItem(location);
            } else {
                this.locBox.setSelectedIndex(0);
            }
        }
        catch (PatternSyntaxException pse) {
            System.out.println(pse);
        }
    }

    private void fillPropBox(String path, String property) {
        this.propBox.removeAllItems();
        try {
            if (this.doocsPropertyFilter != null && this.doocsPropertyFilter.endsWith("*")) {
                this.doocsPropertyFilter = this.doocsPropertyFilter.substring(0, this.doocsPropertyFilter.length() - 1);
            }
            EqCall ec = new EqCall();
            EqData data = ec.names(new EqAdr(path));
            for (int i = 0; i < data.length(); ++i) {
                String item = data.get_string_arg(i).trim();
                if (this.doocsPropertyFilter == null && this.doocsPropertyRegexFilter == null) {
                    this.propBox.addItem(item);
                }
                if (this.doocsPropertyFilter != null && item.startsWith(this.doocsPropertyFilter)) {
                    this.propBox.addItem(item);
                }
                if (this.doocsPropertyFilter != null || this.doocsPropertyRegexFilter == null || !item.matches(this.doocsPropertyRegexFilter)) continue;
                this.propBox.addItem(item);
            }
            if (property != null && property.length() > 2) {
                this.propBox.setSelectedItem(property);
            } else {
                this.propBox.setSelectedIndex(0);
            }
        }
        catch (PatternSyntaxException pse) {
            System.out.println(pse);
        }
    }
}

