/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSAlive;
import DOOCSComponents.DOOCSAudio;
import DOOCSComponents.DOOCSButton;
import DOOCSComponents.DOOCSCameraImage;
import DOOCSComponents.DOOCSCheckBox;
import DOOCSComponents.DOOCSColouredIndicator;
import DOOCSComponents.DOOCSComboBox;
import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSDial;
import DOOCSComponents.DOOCSDynamicList;
import DOOCSComponents.DOOCSGroup;
import DOOCSComponents.DOOCSIcon;
import DOOCSComponents.DOOCSIf;
import DOOCSComponents.DOOCSIfCase;
import DOOCSComponents.DOOCSIncludeComponent;
import DOOCSComponents.DOOCSLabel;
import DOOCSComponents.DOOCSLine;
import DOOCSComponents.DOOCSLogicGroup;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSProgressBar;
import DOOCSComponents.DOOCSPropertiesTable;
import DOOCSComponents.DOOCSSlider;
import DOOCSComponents.DOOCSStatusRegister;
import DOOCSComponents.DOOCSSwitch;
import DOOCSComponents.DOOCSSwitchCase;
import DOOCSComponents.DOOCSTabbedPane;
import DOOCSComponents.DOOCSTextArea;
import DOOCSComponents.DOOCSTextField;
import DOOCSComponents.DOOCSToggleButton;
import DOOCSComponents.DOOCSValue;
import DOOCSComponents.PrintUtilities;
import DOOCSComponents.ShowException;
import DOOCSComponents.StringTransferHandler;
import TangoComponents.ITangoComponent;
import TangoComponents.ITangoDiagnostic;
import TangoComponents.ITangoErrorHistory;
import TangoComponents.TangoOptions;
import editor.EditorPanel;
import editor.ExampleFileFilter;
import editor.ImagePreviewPanel;
import editor.StartParameters;
import editor.about.About;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.MouseInputListener;
import jsvnbrowser.JSVNBrowser;
import jsvnbrowser.JSVNFileInfo;
import layoutmanager.ScaleLayout;
import runtime.jddd_run;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.Monitoring;
import xmlparser.DOOCSParser;

public class DOOCSLayeredPane
extends JLayeredPane
implements DOOCSComponent,
DropTargetListener {
    private MouseMotionAdapter listenerDrag;
    private String doocsAddress = null;
    protected String fullDoocsAddress = null;
    protected String doocsIndirectAddress = null;
    private String doocsToolTipText = null;
    private boolean showGrid = false;
    private String doocsBorderType = "No Border";
    private String doocsBorderTitle = null;
    private String doocsBorderTitleJustification = "Default Justification";
    private String doocsBorderTitlePosition = "Default Position";
    private String doocsTitledBorderType = "Default Titled Border";
    private String doocsGrid = "10,10";
    protected boolean editorPanelType = false;
    private String doocsAuthor = null;
    private String doocsDescription = null;
    private boolean doocsFullScreenMode = false;
    private boolean doocsShowWindowBorder = true;
    public float gridX = 10.0f;
    public float gridY = 10.0f;
    public float m_initialGridX = 10.0f;
    public float m_initialGridY = 10.0f;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    protected boolean doocsRunMode = false;
    protected MouseInputListener m_DOOCSMouse;
    public boolean[] visibleLayer = new boolean[]{true, true, true, true, true};
    private Rectangle m_initialBounds;
    public boolean showToolTip = false;
    private String xmlFilePath = null;
    private String doocsMinSize = "0,0";
    private boolean doocsEditMode = true;
    private ITangoErrorHistory tango_error_handler = null;
    private ITangoDiagnostic tango_diagnostic = null;

    public DOOCSLayeredPane() {
        String pluginPath;
        this.setSize(new Dimension(100, 100));
        this.setLayout(new ScaleLayout(new Dimension(100, 100)));
        this.setOpaque(true);
        this.m_DOOCSMouse = null;
        if ((TangoOptions.TANGO_ONLY || TangoOptions.TANGO_DIAG) && (pluginPath = StartParameters.getInstance().getPluginPath()) != null && pluginPath.length() > 0) {
            String msg;
            URLClassLoader newCL = StartParameters.getInstance().getClassLoader();
            try {
                this.tango_error_handler = (ITangoErrorHistory)newCL.loadClass("tangoatk.jddd.utils.TangoErrorHistory").newInstance();
            }
            catch (ClassNotFoundException ex) {
                msg = "tangoatk.jddd.utils.TangoErrorHistory class not found!";
                Logger.getLogger(DOOCSLayeredPane.class.getName()).log(Level.SEVERE, msg, ex);
            }
            catch (InstantiationException ex) {
                msg = "tangoatk.jddd.utils.TangoErrorHistory cannot instantiate object!";
                Logger.getLogger(DOOCSLayeredPane.class.getName()).log(Level.SEVERE, msg, ex);
            }
            catch (IllegalAccessException ex) {
                msg = "Illegal resource access in the tangoatk.jddd.utils.TangoErrorHistory class!";
                Logger.getLogger(DOOCSLayeredPane.class.getName()).log(Level.SEVERE, msg, ex);
            }
            try {
                this.tango_diagnostic = (ITangoDiagnostic)newCL.loadClass("tangoatk.jddd.utils.TangoDiagnostic").newInstance();
            }
            catch (ClassNotFoundException ex) {
                msg = "tangoatk.jddd.utils.TangoDiagnostic class not found!";
                Logger.getLogger(DOOCSLayeredPane.class.getName()).log(Level.SEVERE, msg, ex);
            }
            catch (InstantiationException ex) {
                msg = "tangoatk.jddd.utils.TangoDiagnostic cannot instantiate object!";
                Logger.getLogger(DOOCSLayeredPane.class.getName()).log(Level.SEVERE, msg, ex);
            }
            catch (IllegalAccessException ex) {
                msg = "Illegal resource access in the tangoatk.jddd.utils.TangoDiagnostic class!";
                Logger.getLogger(DOOCSLayeredPane.class.getName()).log(Level.SEVERE, msg, ex);
            }
        }
        new DropTarget(this, this);
        this.setTransferHandler(new StringTransferHandler());
        this.listenerDrag = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, e, 1);
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 1 && evt.isMetaDown() && DOOCSLayeredPane.this.doocsRunMode) {
                    JMenuItem mi;
                    JPopupMenu popup = new JPopupMenu();
                    JMenu submenu = new JMenu("Visible Layers");
                    JCheckBoxMenuItem cmi = new JCheckBoxMenuItem("VACUUM", DOOCSLayeredPane.this.visibleLayer[1]);
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.visibleLayer[1] = !DOOCSLayeredPane.this.visibleLayer[1];
                            DOOCSLayeredPane.this.updateLayers(null);
                        }
                    });
                    submenu.add(cmi);
                    cmi = new JCheckBoxMenuItem("MAGNETS", DOOCSLayeredPane.this.visibleLayer[2]);
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.visibleLayer[2] = !DOOCSLayeredPane.this.visibleLayer[2];
                            DOOCSLayeredPane.this.updateLayers(null);
                        }
                    });
                    submenu.add(cmi);
                    cmi = new JCheckBoxMenuItem("BEAM_DIAG", DOOCSLayeredPane.this.visibleLayer[3]);
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.visibleLayer[3] = !DOOCSLayeredPane.this.visibleLayer[3];
                            DOOCSLayeredPane.this.updateLayers(null);
                        }
                    });
                    submenu.add(cmi);
                    cmi = new JCheckBoxMenuItem("RF", DOOCSLayeredPane.this.visibleLayer[4]);
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.visibleLayer[4] = !DOOCSLayeredPane.this.visibleLayer[4];
                            DOOCSLayeredPane.this.updateLayers(null);
                        }
                    });
                    submenu.add(cmi);
                    popup.add(submenu);
                    final JCheckBoxMenuItem show = new JCheckBoxMenuItem("Show ToolTips", DOOCSLayeredPane.this.showToolTip);
                    show.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            DOOCSLayeredPane.this.showToolTipText(show.getState());
                        }
                    });
                    popup.add(show);
                    if (TangoOptions.TANGO_ONLY || TangoOptions.TANGO_DIAG) {
                        if (DOOCSLayeredPane.this.tango_error_handler != null) {
                            mi = new JMenuItem("View Tango Errors");
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    DOOCSLayeredPane.this.tango_error_handler.setVisible(true);
                                }
                            });
                            popup.add(mi);
                        }
                        if (DOOCSLayeredPane.this.tango_error_handler != null) {
                            mi = new JMenuItem("View Tango Diagnostics");
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    DOOCSLayeredPane.this.tango_diagnostic.showDiagnostic();
                                }
                            });
                            popup.add(mi);
                        }
                    }
                    mi = new JMenuItem("Open Local File...");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.evt_File_Open_ActionPerformed(e);
                        }
                    });
                    popup.add(mi);
                    mi = new JMenuItem("Open Central File...");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.evt_File_OpenSvn_ActionPerformed(e);
                        }
                    });
                    popup.add(mi);
                    mi = new JMenuItem("Print Panel...");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.printScreenshot(null);
                        }
                    });
                    popup.add(mi);
                    mi = new JMenuItem("Save as png...");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.savePng(null);
                        }
                    });
                    popup.add(mi);
                    mi = new JMenuItem("Print all monitors...");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Monitoring.printAllMonitors();
                        }
                    });
                    popup.add(mi);
                    if (DOOCSLayeredPane.this.getParent().getParent() instanceof DOOCSDynamicList) {
                        mi = new JMenuItem("Print DynamicList...");
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DOOCSLayeredPane.this.printScreenshot("DOOCSDynamicList");
                            }
                        });
                        popup.add(mi);
                        mi = new JMenuItem("Save DynamicList as png...");
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DOOCSLayeredPane.this.savePng("DOOCSDynamicList");
                            }
                        });
                        popup.add(mi);
                    }
                    popup.addSeparator();
                    mi = new JMenuItem("About this panel");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.showAbout();
                        }
                    });
                    popup.add(mi);
                    mi = new JMenuItem("About jddd");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSLayeredPane.this.showJdddAbout();
                        }
                    });
                    popup.add(mi);
                    popup.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
    }

    public void evt_File_Open_ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        ImagePreviewPanel preview = new ImagePreviewPanel();
        chooser.setAccessory(preview);
        chooser.addPropertyChangeListener(preview);
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("xml");
        filter.setDescription("XML files");
        chooser.setFileFilter(filter);
        StartParameters startParams = StartParameters.getInstance();
        if (startParams.getDirectory() != null) {
            chooser.setCurrentDirectory(new File(startParams.getDirectory()));
        }
        int returnVal = chooser.showOpenDialog(this);
        File selFile = chooser.getSelectedFile();
        if (returnVal == 0 && selFile != null) {
            jddd_run.startPanel(selFile.getPath(), null, this, true, false, null);
            startParams.setDirectory(selFile.getParent());
        }
    }

    public void evt_File_OpenSvn_ActionPerformed(ActionEvent evt) {
        JSVNFileInfo fInfo;
        JSVNBrowser browser = new JSVNBrowser();
        StartParameters startParams = StartParameters.getInstance();
        if (startParams.getSvnDirectory() != null) {
            browser.setCurrentDirectory(startParams.getSvnDirectory());
        }
        if ((fInfo = browser.showOpenDialog(DOOCSParameter.getParentFrame(this))) != null) {
            jddd_run.startPanel(fInfo.filepath, null, this, true, false, null);
            startParams.addFile(fInfo.filepath);
        }
    }

    public void showAbout() {
        Container comp = this;
        while (!(comp.getParent() instanceof JViewport)) {
            comp = comp.getParent();
        }
        DOOCSLayeredPane lcomp = comp;
        String aboutText = "<html><h2>About:</h2>";
        if (lcomp.getDoocsXmlFilePath() != null) {
            JSVNBrowser browser;
            JSVNFileInfo fInfo;
            aboutText = aboutText + "<p><FONT COLOR=BLUE>FilePath:</FONT> " + lcomp.getDoocsXmlFilePath();
            if (lcomp.getDoocsXmlFilePath().startsWith("/svn/") && (fInfo = (browser = new JSVNBrowser()).openFile(lcomp.getDoocsXmlFilePath().substring(5))) != null) {
                aboutText = aboutText + "<p><FONT COLOR=BLUE>Date:</FONT> " + fInfo.date;
            }
        }
        if (lcomp.getDoocsAuthor() != null) {
            aboutText = aboutText + "<p><FONT COLOR=BLUE>Author:</FONT> " + lcomp.getDoocsAuthor();
        }
        if (lcomp.getDoocsDescription() != null) {
            aboutText = aboutText + "<p><FONT COLOR=BLUE>Description:</FONT> " + lcomp.getDoocsDescription();
        }
        aboutText = aboutText + "</html>";
        JOptionPane.showMessageDialog(this, aboutText);
    }

    public void showJdddAbout() {
        new About((Frame)DOOCSParameter.getParentFrame(this), true).setVisible(true);
    }

    public void showToolTipText(boolean show) {
        Container pcomp = this;
        if (pcomp.getParent().getParent() instanceof DOOCSDynamicList) {
            pcomp = pcomp.getParent();
        }
        while (!(pcomp instanceof EditorPanel) && pcomp.getParent() != null && !(pcomp.getParent() instanceof JViewport)) {
            if (!((pcomp = pcomp.getParent()).getParent().getParent() instanceof DOOCSDynamicList)) continue;
            pcomp = pcomp.getParent();
        }
        this.switchToolTipText((DOOCSComponent)((Object)pcomp), show);
    }

    public void switchToolTipText(DOOCSComponent comp, boolean show) {
        if (comp instanceof DOOCSLayeredPane) {
            ((DOOCSLayeredPane)comp).showToolTip = show;
        }
        if (show) {
            if (comp.getDoocsToolTipText() == null || comp.getDoocsToolTipText().equals("")) {
                if (!(comp instanceof DOOCSLayeredPane || comp instanceof DOOCSTabbedPane || comp instanceof DOOCSButton || comp instanceof DOOCSToggleButton || comp instanceof DOOCSCheckBox || comp instanceof DOOCSAlive)) {
                    if (comp.getFullDoocsAddress() != null) {
                        comp.setToolTipText(comp.getFullDoocsAddress());
                    } else {
                        if (comp instanceof DOOCSValue) {
                            comp.setToolTipText(((DOOCSValue)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSDial) {
                            comp.setToolTipText(((DOOCSDial)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSTextField) {
                            comp.setToolTipText(((DOOCSTextField)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSComboBox) {
                            comp.setToolTipText(((DOOCSComboBox)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSProgressBar) {
                            comp.setToolTipText(((DOOCSProgressBar)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSSlider) {
                            comp.setToolTipText(((DOOCSSlider)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSStatusRegister) {
                            comp.setToolTipText(((DOOCSStatusRegister)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSColouredIndicator) {
                            comp.setToolTipText(((DOOCSColouredIndicator)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSCameraImage) {
                            comp.setToolTipText(((DOOCSCameraImage)comp).getDoocsAddress());
                        }
                        if (comp instanceof DOOCSPropertiesTable) {
                            comp.setToolTipText(((DOOCSPropertiesTable)comp).getDoocsAddress());
                        }
                    }
                }
                if (comp instanceof DOOCSIncludeComponent && !comp.isRunMode()) {
                    comp.setToolTipText("<html>xmlFile: " + ((DOOCSIncludeComponent)comp).getIncludeDoocsXmlFile() + "<p>adr: " + ((DOOCSIncludeComponent)comp).getDoocsAddress() + "</html>");
                }
                if (comp instanceof DOOCSLogicGroup && !comp.isRunMode()) {
                    comp.setToolTipText("logicAdr: " + ((DOOCSLogicGroup)comp).getDoocsLogicAddress());
                }
                if (comp instanceof DOOCSTextArea) {
                    String ttt = "<html>file: " + ((DOOCSTextArea)comp).getDoocsFile() + "<p>adr: ";
                    ttt = comp.getFullDoocsAddress() != null ? ttt + comp.getFullDoocsAddress() + "</html>" : ttt + ((DOOCSTextArea)comp).getDoocsAddress() + "</html>";
                    comp.setToolTipText(ttt);
                }
                if (comp instanceof DOOCSButton) {
                    comp.setToolTipText(((DOOCSButton)comp).getCorrectDoocsToolTipText());
                }
                if (comp instanceof DOOCSToggleButton) {
                    int value = 1;
                    if (((DOOCSToggleButton)comp).isSelected()) {
                        value = 0;
                    }
                    if (comp.getFullDoocsAddress() != null) {
                        comp.setToolTipText("set " + comp.getFullDoocsAddress() + " = " + value);
                    } else {
                        comp.setToolTipText(((DOOCSToggleButton)comp).getDoocsAddress());
                    }
                }
                if (comp instanceof DOOCSCheckBox) {
                    int value = 1;
                    if (((DOOCSCheckBox)comp).isSelected()) {
                        value = 0;
                    }
                    if (comp.getFullDoocsAddress() != null) {
                        comp.setToolTipText(comp.getFullDoocsAddress() + " = " + value);
                    } else {
                        comp.setToolTipText(((DOOCSCheckBox)comp).getDoocsAddress());
                    }
                }
                if (comp instanceof DOOCSAlive) {
                    String ttt = "<html>xposAdr: ";
                    ttt = ((DOOCSAlive)comp).getFullDoocsXposAdr() != null ? ttt + ((DOOCSAlive)comp).getFullDoocsXposAdr() + "<p>yposAdr: " : ttt + ((DOOCSAlive)comp).getDoocsXposAdr() + "<p>yposAdr: ";
                    ttt = ((DOOCSAlive)comp).getFullDoocsYposAdr() != null ? ttt + ((DOOCSAlive)comp).getFullDoocsYposAdr() + "<p>widthAdr: " : ttt + ((DOOCSAlive)comp).getDoocsYposAdr() + "<p>widthAdr: ";
                    ttt = ((DOOCSAlive)comp).getFullDoocsWidthAdr() != null ? ttt + ((DOOCSAlive)comp).getFullDoocsWidthAdr() + "<p>heightAdr: " : ttt + ((DOOCSAlive)comp).getDoocsWidthAdr() + "<p>heightAdr: ";
                    ttt = ((DOOCSAlive)comp).getFullDoocsHeightAdr() != null ? ttt + ((DOOCSAlive)comp).getFullDoocsHeightAdr() + "</html>" : ttt + ((DOOCSAlive)comp).getDoocsHeightAdr() + "</html>";
                    comp.setToolTipText(ttt);
                }
                if (comp instanceof DOOCSIfCase) {
                    if (((DOOCSComponent)((Object)comp.getParent())).getFullDoocsAddress() != null) {
                        comp.setToolTipText(((DOOCSComponent)((Object)comp.getParent())).getFullDoocsAddress() + ": " + ((DOOCSIfCase)comp).toString());
                    } else {
                        comp.setToolTipText(((DOOCSIf)comp.getParent()).getDoocsAddress() + ": " + ((DOOCSIfCase)comp).toString());
                    }
                }
                if (comp instanceof DOOCSSwitchCase) {
                    if (((DOOCSComponent)((Object)comp.getParent())).getFullDoocsAddress() != null) {
                        comp.setToolTipText(((DOOCSComponent)((Object)comp.getParent())).getFullDoocsAddress() + ": " + ((DOOCSSwitchCase)comp).toString());
                    } else {
                        comp.setToolTipText(((DOOCSSwitch)comp.getParent()).getDoocsAddress() + ": " + ((DOOCSSwitchCase)comp).toString());
                    }
                }
            } else {
                comp.setToolTipText(comp.getDoocsToolTipText());
            }
        } else {
            comp.setToolTipText(null);
        }
        if (comp instanceof DOOCSDynamicList) {
            comp = (DOOCSComponent)((Object)((Container)comp.getComponent(0)).getComponent(0));
            ((DOOCSLayeredPane)comp).showToolTip = show;
            for (int k = 0; k < comp.getComponentCount(); ++k) {
                DOOCSComponent cmp = (DOOCSComponent)((Object)comp.getComponent(k));
                this.switchToolTipText(cmp, show);
            }
        } else {
            for (int i = 0; i < comp.getComponentCount(); ++i) {
                if (!(comp.getComponent(i) instanceof DOOCSComponent)) continue;
                this.switchToolTipText((DOOCSComponent)((Object)comp.getComponent(i)), show);
            }
        }
    }

    public void setDoocsXmlFilePath(String f) {
        this.xmlFilePath = f;
    }

    public String getDoocsXmlFilePath() {
        return this.xmlFilePath;
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        if (comp.getName() == null) {
            DOOCSLayeredPane.setComponentName(comp, this);
        }
        if (DOOCSParameter.getLastLayeredPane(this).isEditMode()) {
            DOOCSLayeredPane.removeOldMouseListeners(comp);
        } else if ((TangoOptions.TANGO_ONLY || TangoOptions.TANGO_DIAG) && this.tango_error_handler != null && comp instanceof ITangoComponent) {
            ((ITangoComponent)((Object)comp)).addTangoErrorListener(this.tango_error_handler);
        }
        ((DOOCSComponent)((Object)comp)).addDOOCSMouseListener(this.m_DOOCSMouse);
    }

    public static void setComponentName(Component comp, Container parent) {
        String name = comp.getClass().toString();
        if ((name = name.substring(name.indexOf(".DOOCS") + 6)).startsWith(" DOOCS")) {
            name = name.substring(6);
        }
        int counter = 1;
        while (DOOCSLayeredPane.nameExists(name, counter, parent)) {
            ++counter;
        }
        comp.setName(name + counter);
    }

    public static boolean nameExists(String name, int counter, Container parent) {
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            boolean nameExistsInGroup;
            String childName = parent.getComponent(i).getName();
            if (childName != null && childName.equalsIgnoreCase(name + counter)) {
                return true;
            }
            if (!(parent.getComponent(i) instanceof DOOCSGroup) || !(nameExistsInGroup = DOOCSLayeredPane.nameExists(name, counter, (Container)parent.getComponent(i)))) continue;
            return true;
        }
        return false;
    }

    public static void removeOldMouseListeners(Component comp) {
        int i;
        MouseListener[] mls = (MouseListener[])comp.getListeners(MouseListener.class);
        for (int i2 = 0; i2 < mls.length; ++i2) {
            if (mls[i2].toString().contains("BasicComboPopup") || mls[i2].toString().contains("BasicSliderUI") || mls[i2].toString().contains("BasicScrollBarUI") || mls[i2].toString().contains("BasicTableUI") || mls[i2].toString().contains("ToolTipManager") || mls[i2].toString().contains("BasicTextUI") || mls[i2].toString().contains("BasicTabbedPaneUI") || mls[i2].toString().contains("Dot") || mls[i2].toString().contains("dot") || mls[i2].toString().contains("BasicTreeUI") || mls[i2].toString().contains("DoocsTreeView") || mls[i2].toString().contains("DialKnob") || mls[i2].toString().contains("Tango") || mls[i2].toString().contains("DOOCSLayeredPane") || mls[i2].toString().contains("DOOCSPlot")) continue;
            comp.removeMouseListener(mls[i2]);
        }
        MouseMotionListener[] mmls = (MouseMotionListener[])comp.getListeners(MouseMotionListener.class);
        for (i = 0; i < mmls.length; ++i) {
            if (mmls[i].toString().contains("BasicSliderUI") || mmls[i].toString().contains("BasicComboPopup") || mmls[i].toString().contains("BasicScrollBarUI") || mmls[i].toString().contains("BasicTableUI") || mmls[i].toString().contains("ToolTipManager") || mmls[i].toString().contains("BasicTextUI") || mmls[i].toString().contains("BasicTabbedPaneUI") || mmls[i].toString().contains("Dot") || mmls[i].toString().contains("dot") || mmls[i].toString().contains("BasicTreeUI") || mmls[i].toString().contains("DialKnob") || mmls[i].toString().contains("Tango") || mmls[i].toString().contains("DOOCSPlot")) continue;
            comp.removeMouseMotionListener(mmls[i]);
        }
        if (comp instanceof Container) {
            for (i = 0; i < ((Container)comp).getComponentCount(); ++i) {
                Component subcomp = ((Container)comp).getComponent(i);
                DOOCSLayeredPane.removeOldMouseListeners(subcomp);
            }
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsBorderType(String borderType) {
        this.doocsBorderType = borderType;
        Border border = borderType.equalsIgnoreCase("Black Line Border") ? BorderFactory.createLineBorder(Color.BLACK) : (borderType.equalsIgnoreCase("Raised Etched Border") ? BorderFactory.createEtchedBorder(0) : (borderType.equalsIgnoreCase("Lowered Etched Border") ? BorderFactory.createEtchedBorder(1) : (borderType.equalsIgnoreCase("Raised Bevel Border") ? BorderFactory.createRaisedBevelBorder() : (borderType.equalsIgnoreCase("Lowered Bevel Border") ? BorderFactory.createLoweredBevelBorder() : (borderType.equalsIgnoreCase("Titled Border") ? BorderFactory.createTitledBorder("") : null)))));
        this.setBorder(border);
    }

    public String getDoocsBorderType() {
        return this.doocsBorderType;
    }

    public void completeDoocsBorderTitle() {
        String text = this.doocsBorderTitle;
        if (text != null && this.fullDoocsAddress != null) {
            EqAdr ea = new EqAdr(this.fullDoocsAddress);
            if (EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                text = text.replace("$f", ea.facility());
                text = text.replace("$d", ea.device());
                text = text.replace("$l", ea.location());
                text = text.replace("$p", ea.property());
            }
            ((TitledBorder)this.getBorder()).setTitle(text);
        }
    }

    public void setDoocsBorderTitle(String text) {
        this.doocsBorderTitle = text;
        ((TitledBorder)this.getBorder()).setTitle(text);
    }

    public String getDoocsBorderTitle() {
        return this.doocsBorderTitle;
    }

    public void setDoocsBorderTitleJustification(String justification) {
        this.doocsBorderTitleJustification = justification;
        int justnumber = justification.equalsIgnoreCase("Left") ? 1 : (justification.equalsIgnoreCase("Center") ? 2 : (justification.equalsIgnoreCase("Right") ? 3 : 0));
        ((TitledBorder)this.getBorder()).setTitleJustification(justnumber);
    }

    public String getDoocsBorderTitleJustification() {
        return this.doocsBorderTitleJustification;
    }

    public void setDoocsBorderTitlePosition(String position) {
        this.doocsBorderTitlePosition = position;
        int posnumber = position.equalsIgnoreCase("Above Top") ? 1 : (position.equalsIgnoreCase("Top") ? 2 : (position.equalsIgnoreCase("Below Top") ? 3 : (position.equalsIgnoreCase("Above Bottom") ? 4 : (position.equalsIgnoreCase("Bottom") ? 5 : (position.equalsIgnoreCase("Below Bottom") ? 6 : 0)))));
        ((TitledBorder)this.getBorder()).setTitlePosition(posnumber);
    }

    public String getDoocsBorderTitlePosition() {
        return this.doocsBorderTitlePosition;
    }

    public void setDoocsTitledBorderType(String type) {
        this.doocsTitledBorderType = type;
        Border border = type.equalsIgnoreCase("Black Line Border") ? BorderFactory.createLineBorder(Color.BLACK) : (type.equalsIgnoreCase("Raised Etched Border") ? BorderFactory.createEtchedBorder(0) : (type.equalsIgnoreCase("Lowered Etched Border") ? BorderFactory.createEtchedBorder(1) : (type.equalsIgnoreCase("Raised Bevel Border") ? BorderFactory.createRaisedBevelBorder() : (type.equalsIgnoreCase("Lowered Bevel Border") ? BorderFactory.createLoweredBevelBorder() : null))));
        ((TitledBorder)this.getBorder()).setBorder(border);
    }

    public String getDoocsTitledBorderType() {
        return this.doocsTitledBorderType;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
        if (this.isRunMode()) {
            DOOCSParser.inherit((DOOCSComponent)((Object)this.getParent()));
            if (this.showToolTip) {
                this.showToolTipText(true);
            }
        }
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
        if (this.doocsIndirectAddress != null && this.doocsIndirectAddress.length() > 3) {
            EqCall eq = new EqCall();
            EqAdr ea = new EqAdr(DOOCSParser.inheritDoocsAddress(this, this.doocsIndirectAddress));
            EqData ed = new EqData();
            EqData data = new EqData();
            eq.get(ea, ed, data);
            if (data.error() == 0) {
                this.fullDoocsAddress = data.get_string_arg();
            } else {
                System.out.println("DOOCSLayeredPane.setFullDoocsAddress: wrong merged indirectAdr " + DOOCSParser.inheritDoocsAddress(this, this.doocsIndirectAddress));
            }
        }
        if (!DOOCSParameter.getLastLayeredPane(this).isEditMode()) {
            this.completeDoocsBorderTitle();
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsIndirectAddress(String address) {
        this.doocsIndirectAddress = address;
    }

    public String getDoocsIndirectAddress() {
        return this.doocsIndirectAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDnDText(String str) {
        if (this.isRunMode()) {
            Container comp = this;
            while (comp.getParent() != null && !(comp.getParent() instanceof JViewport)) {
                if (!((comp = comp.getParent()).getParent().getParent() instanceof DOOCSDynamicList)) continue;
                comp = comp.getParent();
            }
            DOOCSLayeredPane dcomp = comp;
            dcomp.setRunMode(false);
            dcomp.setFullDoocsAddress(str);
            DOOCSParser.inherit(dcomp);
            dcomp.setRunMode(true);
            if (dcomp.showToolTip) {
                dcomp.showToolTipText(true);
            }
        }
    }

    @Override
    public String getDnDText() {
        return null;
    }

    public void setShowGrid(boolean grid) {
        this.showGrid = grid;
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public void updateLayers(Component[] comp) {
        if (comp == null) {
            comp = this.getComponents();
        }
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof DOOCSComponent)) continue;
            DOOCSComponent dcomp = (DOOCSComponent)((Object)comp[i]);
            int z = 0;
            if (dcomp.getDoocsLayer().equalsIgnoreCase("VACUUM")) {
                z = 1;
            }
            if (dcomp.getDoocsLayer().equalsIgnoreCase("MAGNETS")) {
                z = 2;
            }
            if (dcomp.getDoocsLayer().equalsIgnoreCase("BEAM_DIAG")) {
                z = 3;
            }
            if (dcomp.getDoocsLayer().equalsIgnoreCase("RF")) {
                z = 4;
            }
            comp[i].setVisible(this.visibleLayer[z]);
            Container cont = (Container)comp[i];
            if (cont.getComponentCount() <= 0) continue;
            this.updateLayers(cont.getComponents());
        }
    }

    public void printScreenshot(String pane) {
        if (pane == null) {
            PrintUtilities.printComponent(DOOCSParameter.getParentFrame(this));
        } else {
            PrintUtilities.printComponent(this);
        }
    }

    public void savePng(String pane) {
        Container gcomp = pane == null ? DOOCSParameter.getParentFrame(this) : this;
        BufferedImage bufferedImage = new BufferedImage(gcomp.getSize().width, gcomp.getSize().height, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        ((Component)gcomp).paint(g2d);
        JFileChooser chooser = new JFileChooser();
        String title = pane == null ? ((JFrame)gcomp).getTitle() : gcomp.getParent().getParent().getName();
        if (title != null && title.contains(".")) {
            title = title.substring(0, title.indexOf("."));
        }
        Date heute = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.applyPattern("HH:mm:ss");
        String time = dateFormat.format(heute);
        dateFormat.applyPattern("yyyy-MM-dd");
        String date = dateFormat.format(heute);
        chooser.setSelectedFile(new File(System.getProperty("user.home") + File.separatorChar + title + "_" + date + "T" + time + ".png"));
        chooser.showSaveDialog(this);
        File selFile = chooser.getSelectedFile();
        if (selFile != null && !selFile.getName().endsWith("png")) {
            selFile = new File(selFile.getPath() + ".png");
        }
        try {
            if (selFile != null) {
                ImageIO.write((RenderedImage)bufferedImage, "png", selFile);
            }
        }
        catch (IOException e) {
            new ShowException(null, "DOOCSLayeredPane->savePng", e);
        }
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsGrid(String grid) {
        this.doocsGrid = grid;
        int komma = grid.indexOf(",");
        this.gridX = Float.parseFloat(grid.substring(0, komma));
        this.gridY = Float.parseFloat(grid.substring(komma + 1));
    }

    public String getDoocsGrid() {
        return this.doocsGrid;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    public void setEditMode(boolean bEdit) {
        this.doocsEditMode = bEdit;
    }

    public boolean isEditMode() {
        return this.doocsEditMode;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            if (bRun && dcomp.getDoocsLayer().equalsIgnoreCase("EDIT")) {
                subcomp[i].setVisible(false);
            }
            dcomp.setRunMode(bRun);
        }
        if (this.getParent() != null && this.getParent().getParent() != null && !(this.getParent().getParent() instanceof DOOCSDynamicList)) {
            if (this.getLayout() instanceof ScaleLayout) {
                ((ScaleLayout)this.getLayout()).setRunMode(bRun, this);
            }
            if (bRun) {
                this.addMouseMotionListener(this.listenerDrag);
                if (!this.doocsShowWindowBorder) {
                    DOOCSParameter.getParentFrame(this).setUndecorated(true);
                }
                if (this.doocsFullScreenMode) {
                    GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                    if (device.isFullScreenSupported()) {
                        device.setFullScreenWindow(DOOCSParameter.getParentFrame(this));
                    } else {
                        System.out.println("Full screen not supported");
                        int screenWidth = device.getDisplayMode().getWidth();
                        int screenHeight = device.getDisplayMode().getHeight();
                        DOOCSParameter.getParentFrame(this).setLocation(0, 0);
                        DOOCSParameter.getParentFrame(this).setPreferredSize(new Dimension(screenWidth, screenHeight));
                    }
                }
            } else {
                this.removeMouseMotionListener(this.listenerDrag);
            }
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setInitialGrid() {
        this.m_initialGridX = this.gridX;
        this.m_initialGridY = this.gridY;
    }

    public String getInitialGrid() {
        return this.m_initialGridX + "," + this.m_initialGridY;
    }

    public void setDoocsAuthor(String author) {
        this.doocsAuthor = author;
    }

    public String getDoocsAuthor() {
        return this.doocsAuthor;
    }

    public void setDoocsDescription(String description) {
        this.doocsDescription = description;
    }

    public String getDoocsDescription() {
        return this.doocsDescription;
    }

    public void setDoocsFullScreenMode(boolean mode) {
        this.doocsFullScreenMode = mode;
    }

    public boolean getDoocsFullScreenMode() {
        return this.doocsFullScreenMode;
    }

    public void setDoocsShowWindowBorder(boolean border) {
        this.doocsShowWindowBorder = border;
    }

    public boolean getDoocsShowWindowBorder() {
        return this.doocsShowWindowBorder;
    }

    public void setDoocsMinSize(String size) {
        this.doocsMinSize = size;
    }

    public String getDoocsMinSize() {
        return this.doocsMinSize;
    }

    @Override
    public void setLayout(LayoutManager manager) {
        super.setLayout(manager);
        if (manager instanceof ScaleLayout) {
            ((ScaleLayout)manager).setRunMode(this.doocsRunMode, this);
        }
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        if (this.doocsBorderType.equalsIgnoreCase("Titled Border")) {
            if (this.editorPanelType) {
                DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("author", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("description", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fullScreenMode", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("showWindowBorder", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderType", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitle", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitleColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitleFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitleJustification", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitlePosition", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("titledBorderType", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("transparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("grid", DOOCSParameter.ParameterTypes.GRID, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("minSize", DOOCSParameter.ParameterTypes.SIZE, DOOCSParameter.Levels.SCALE), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
                return parameters;
            }
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderType", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitle", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitleColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitleFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitleJustification", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderTitlePosition", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("titledBorderType", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("transparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("grid", DOOCSParameter.ParameterTypes.GRID, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        if (this.editorPanelType) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("author", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("description", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fullScreenMode", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("showWindowBorder", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderType", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("transparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("grid", DOOCSParameter.ParameterTypes.GRID, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("minSize", DOOCSParameter.ParameterTypes.SIZE, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderType", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("transparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("indirectAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "Control system property containing an address string."), new DOOCSParameter("grid", DOOCSParameter.ParameterTypes.GRID, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("borderType")) {
            String[] allowedValues = new String[]{"No Border", "Black Line Border", "Raised Etched Border", "Lowered Etched Border", "Raised Bevel Border", "Lowered Bevel Border", "Titled Border"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("borderTitleJustification")) {
            String[] allowedValues = new String[]{"Default Justification", "Left", "Center", "Right"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("borderTitlePosition")) {
            String[] allowedValues = new String[]{"Default Position", "Above Top", "Top", "Below Top", "Above Bottom", "Bottom", "Below Bottom"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("titledBorderType")) {
            String[] allowedValues = new String[]{"Default Titled Border", "Black Line Border", "Raised Etched Border", "Lowered Etched Border", "Raised Bevel Border", "Lowered Bevel Border"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSLayeredPane ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSLayeredPane>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("borderType")) {
            this.setDoocsBorderType(value);
        } else if (parameter.equalsIgnoreCase("borderTitle")) {
            this.setDoocsBorderTitle(value);
        } else if (parameter.equalsIgnoreCase("borderTitleColor")) {
            ((TitledBorder)this.getBorder()).setTitleColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("borderTitleFont")) {
            ((TitledBorder)this.getBorder()).setTitleFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("borderTitleJustification")) {
            this.setDoocsBorderTitleJustification(value);
        } else if (parameter.equalsIgnoreCase("borderTitlePosition")) {
            this.setDoocsBorderTitlePosition(value);
        } else if (parameter.equalsIgnoreCase("titledBorderType")) {
            this.setDoocsTitledBorderType(value);
        } else if (parameter.equalsIgnoreCase("fillColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("transparent")) {
            this.setOpaque(!Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("indirectAdr")) {
            this.setDoocsIndirectAddress(value);
        } else if (parameter.equalsIgnoreCase("grid")) {
            this.setDoocsGrid(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("minSize")) {
            this.setDoocsMinSize(value);
        } else if (parameter.equalsIgnoreCase("bounds")) {
            Dimension dim = new Dimension(DOOCSParameter.convertToBounds((String)value).width, DOOCSParameter.convertToBounds((String)value).height);
            this.setPreferredSize(dim);
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("author")) {
            this.setDoocsAuthor(value);
        } else if (parameter.equalsIgnoreCase("description")) {
            this.setDoocsDescription(value);
        } else if (parameter.equalsIgnoreCase("fullScreenMode")) {
            this.setDoocsFullScreenMode(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("showWindowBorder")) {
            this.setDoocsShowWindowBorder(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSLayeredPane.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("borderType")) {
            return this.getDoocsBorderType();
        }
        if (parameter.equalsIgnoreCase("borderTitle")) {
            return this.getDoocsBorderTitle();
        }
        if (parameter.equalsIgnoreCase("borderTitleColor")) {
            return DOOCSParameter.getDoocsColor(((TitledBorder)this.getBorder()).getTitleColor());
        }
        if (parameter.equalsIgnoreCase("borderTitleFont")) {
            return DOOCSParameter.getDoocsFont(((TitledBorder)this.getBorder()).getTitleFont());
        }
        if (parameter.equalsIgnoreCase("borderTitleJustification")) {
            return this.getDoocsBorderTitleJustification();
        }
        if (parameter.equalsIgnoreCase("borderTitlePosition")) {
            return this.getDoocsBorderTitlePosition();
        }
        if (parameter.equalsIgnoreCase("titledBorderType")) {
            return this.getDoocsTitledBorderType();
        }
        if (parameter.equalsIgnoreCase("fillColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("transparent")) {
            return !this.isOpaque();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("indirectAdr")) {
            return this.getDoocsIndirectAddress();
        }
        if (parameter.equalsIgnoreCase("grid")) {
            return this.getDoocsGrid();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("minSize")) {
            return this.getDoocsMinSize();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("author")) {
            return this.getDoocsAuthor();
        }
        if (parameter.equalsIgnoreCase("description")) {
            return this.getDoocsDescription();
        }
        if (parameter.equalsIgnoreCase("fullScreenMode")) {
            return this.getDoocsFullScreenMode();
        }
        if (parameter.equalsIgnoreCase("showWindowBorder")) {
            return this.getDoocsShowWindowBorder();
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSLayeredPane.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.m_DOOCSMouse = ml;
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((DOOCSComponent)((Object)this.getComponent(i))).addDOOCSMouseListener(ml);
        }
    }

    public boolean isSelected(int x, int y) {
        if (x < 5 || x > this.getSize().width - 5) {
            return true;
        }
        return y < 5 || y > this.getSize().height - 5;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (DOOCSParameter.getLastLayeredPane(this).isEditMode() && this.doocsBorderType.equalsIgnoreCase("No Border")) {
            Graphics2D g2 = (Graphics2D)g;
            Color col = g2.getColor();
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(col);
        }
        if (this.showGrid) {
            g.setColor(Color.BLACK);
            for (float x = this.gridX; x < (float)this.getWidth(); x += this.gridX) {
                for (float y = this.gridY; y < (float)this.getHeight(); y += this.gridY) {
                    g.drawRect(Math.round(x), Math.round(y), 0, 0);
                }
            }
        }
    }

    public void setNewBounds(int x, int y, int w, int h, boolean controlPressed) {
        if (!controlPressed) {
            double xFactor = (double)w / (double)this.m_initialBounds.width;
            double yFactor = (double)h / (double)this.m_initialBounds.height;
            if (this.getComponentCount() > 0) {
                this.gridX = (float)((double)this.m_initialGridX * xFactor);
                this.gridY = (float)((double)this.m_initialGridY * yFactor);
                this.doocsGrid = this.gridX + "," + this.gridY;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component comp = this.getComponent(i);
                DOOCSComponent dcomp = (DOOCSComponent)((Object)comp);
                Rectangle compBounds = dcomp.getInitialBounds();
                int xnew = (int)Math.round(compBounds.getX() * xFactor);
                int ynew = (int)Math.round(compBounds.getY() * yFactor);
                int wnew = (int)Math.round(compBounds.getWidth() * xFactor);
                int hnew = (int)Math.round(compBounds.getHeight() * yFactor);
                if (comp instanceof DOOCSLayeredPane) {
                    ((DOOCSLayeredPane)comp).setNewBounds(xnew, ynew, wnew, hnew, controlPressed);
                    continue;
                }
                if (comp instanceof DOOCSTabbedPane) {
                    ((DOOCSTabbedPane)comp).setNewBounds(xnew, ynew, wnew, hnew, controlPressed);
                    continue;
                }
                comp.setBounds(xnew, ynew, wnew, hnew);
            }
        }
        this.setBounds(x, y, w, h);
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        if (!this.doocsRunMode) {
            int x = evt.getLocation().x;
            int y = evt.getLocation().y;
            Container bgcomponent = this;
            while (!(bgcomponent instanceof EditorPanel)) {
                bgcomponent = bgcomponent.getParent();
            }
            EditorPanel epanel = (EditorPanel)bgcomponent;
            epanel.addDoocsComponent(x, y, this);
            epanel.setSelection(false, x, y, true, 1);
            epanel.add = false;
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            int newx = this.getWidth() - this.getComponent(i).getX() - this.getComponent(i).getWidth();
            String startBounds = DOOCSParameter.getDoocsBounds(this.getComponent(i).getBounds());
            this.getComponent(i).setLocation(newx, this.getComponent(i).getY());
            String stopBounds = DOOCSParameter.getDoocsBounds(this.getComponent(i).getBounds());
            change.add(new SetProperty((DOOCSComponent)((Object)this.getComponent(i)), "bounds", startBounds, stopBounds));
            ((DOOCSComponent)((Object)this.getComponent(i))).setInitialBounds(this.getComponent(i).getBounds());
            change = ((DOOCSComponent)((Object)this.getComponent(i))).flipHorizontal(change);
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            int newy = this.getHeight() - this.getComponent(i).getY() - this.getComponent(i).getHeight();
            String startBounds = DOOCSParameter.getDoocsBounds(this.getComponent(i).getBounds());
            this.getComponent(i).setLocation(this.getComponent(i).getX(), newy);
            String stopBounds = DOOCSParameter.getDoocsBounds(this.getComponent(i).getBounds());
            change.add(new SetProperty((DOOCSComponent)((Object)this.getComponent(i)), "bounds", startBounds, stopBounds));
            ((DOOCSComponent)((Object)this.getComponent(i))).setInitialBounds(this.getComponent(i).getBounds());
            change = ((DOOCSComponent)((Object)this.getComponent(i))).flipVertical(change);
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            int x = comp.getY();
            int y = this.getHeight() - comp.getWidth() - comp.getX();
            if (comp instanceof DOOCSLayeredPane) {
                ((DOOCSLayeredPane)comp).setNewBounds(x, y, comp.getHeight(), comp.getWidth(), true);
                comp.setPreferredSize(new Dimension(comp.getHeight(), comp.getWidth()));
            } else if (!(comp instanceof DOOCSAudio || comp instanceof DOOCSDial || comp instanceof JComboBox)) {
                if (comp instanceof DOOCSLabel || comp instanceof DOOCSValue || comp instanceof DOOCSProgressBar || comp instanceof DOOCSCheckBox || comp instanceof DOOCSButton || comp instanceof DOOCSSlider || comp instanceof DOOCSIcon || comp instanceof DOOCSToggleButton) {
                    comp.setLocation(x, y);
                } else {
                    if (comp instanceof DOOCSLine) {
                        ((DOOCSLine)comp).adjust = true;
                    }
                    comp.setBounds(x, y, comp.getHeight(), comp.getWidth());
                }
            }
            String startBounds = DOOCSParameter.getDoocsBounds(((DOOCSComponent)((Object)comp)).getInitialBounds());
            String stopBounds = DOOCSParameter.getDoocsBounds(comp.getBounds());
            change.add(new SetProperty((DOOCSComponent)((Object)comp), "bounds", startBounds, stopBounds));
            change = ((DOOCSComponent)((Object)comp)).rotateRight(change);
            ((DOOCSComponent)((Object)comp)).setInitialBounds(comp.getBounds());
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            int x = this.getWidth() - comp.getHeight() - comp.getY();
            int y = comp.getX();
            if (comp instanceof DOOCSLayeredPane) {
                ((DOOCSLayeredPane)comp).setNewBounds(x, y, comp.getHeight(), comp.getWidth(), true);
                comp.setPreferredSize(new Dimension(comp.getHeight(), comp.getWidth()));
            } else if (!(comp instanceof DOOCSAudio || comp instanceof DOOCSDial || comp instanceof JComboBox)) {
                if (comp instanceof DOOCSLabel || comp instanceof DOOCSValue || comp instanceof DOOCSProgressBar || comp instanceof DOOCSCheckBox || comp instanceof DOOCSButton || comp instanceof DOOCSSlider || comp instanceof DOOCSIcon || comp instanceof DOOCSToggleButton) {
                    comp.setLocation(x, y);
                } else {
                    if (comp instanceof DOOCSLine) {
                        ((DOOCSLine)comp).adjust = true;
                    }
                    comp.setBounds(x, y, comp.getHeight(), comp.getWidth());
                }
            }
            String startBounds = DOOCSParameter.getDoocsBounds(((DOOCSComponent)((Object)comp)).getInitialBounds());
            String stopBounds = DOOCSParameter.getDoocsBounds(comp.getBounds());
            change.add(new SetProperty((DOOCSComponent)((Object)comp), "bounds", startBounds, stopBounds));
            change = ((DOOCSComponent)((Object)comp)).rotateRight(change);
            ((DOOCSComponent)((Object)comp)).setInitialBounds(comp.getBounds());
        }
        return change;
    }
}

