/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import editor.EditorPanel;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import jsvnbrowser.JSVNFileInfo;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import xmlparser.DOOCSParser;

public class DOOCSIncludeComponent
extends DOOCSLayeredPane {
    private Animator animator = new Animator(2000);
    private BufferedImage firstImage;
    private float alpha = 0.0f;
    private Rectangle mySize;
    private String name;
    private String originalAddress;
    private String doocsXmlFile;
    private String doocsTransition = "NONE";
    private int m_initialWidth = 0;
    private int m_initialHeight = 0;
    private boolean getFirstImage = false;

    public DOOCSIncludeComponent() {
        this.animator.addTarget((TimingTarget)new PropertySetter((Object)this, "alpha", (Object[])new Float[]{Float.valueOf(1.0f)}));
        this.animator.setAcceleration(0.2f);
        this.animator.setDeceleration(0.4f);
    }

    public void setIncludeDoocsXmlFile(String file) {
        if (!this.animator.isRunning()) {
            Container parent;
            String borderType = this.getDoocsBorderType();
            boolean flagForAnimatedTransition = false;
            boolean flagForRunmode = false;
            if (this.isRunMode()) {
                if (!this.doocsTransition.equalsIgnoreCase("NONE")) {
                    this.getFirstImage = true;
                    this.firstImage = new BufferedImage(this.getSize().width, this.getSize().height, 1);
                    Graphics2D g2d = this.firstImage.createGraphics();
                    this.paint(g2d);
                    this.getFirstImage = false;
                    flagForAnimatedTransition = true;
                }
                flagForRunmode = true;
                this.setRunMode(false);
            }
            this.removeAll();
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            this.mySize = this.getBounds();
            this.originalAddress = this.getDoocsAddress();
            this.name = this.getName();
            this.doocsXmlFile = file;
            JSVNFileInfo fInfo = DOOCSParameter.getDoocsFilePath(this.doocsXmlFile, this);
            if (fInfo != null && fInfo.buf != null) {
                DOOCSParser.parseStringBuffer(this, fInfo.buf);
            }
            this.setName(this.name);
            this.setDoocsBorderType(borderType);
            this.setDoocsAddress(this.originalAddress);
            this.resetInitialBounds(this);
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
            if (this.mySize.width != 100 || this.mySize.height != 100) {
                this.setNewBounds(this.mySize.x, this.mySize.y, this.mySize.width, this.mySize.height, false);
            }
            if ((parent = this.getParent()) != null) {
                int pwidth = parent.getWidth();
                int pheight = parent.getHeight();
                if (this.getX() + this.getWidth() > pwidth) {
                    this.setLocation(pwidth - this.getWidth(), this.getY());
                }
                if (this.getY() + this.getHeight() > pheight) {
                    this.setLocation(this.getX(), pheight - this.getHeight());
                }
            }
            if (flagForRunmode) {
                DOOCSParser.inherit((DOOCSComponent)((Object)this.getParent()));
                if (((DOOCSLayeredPane)this.getParent()).showToolTip) {
                    ((DOOCSLayeredPane)this.getParent()).switchToolTipText((DOOCSLayeredPane)this.getParent(), true);
                }
                this.setRunMode(true);
            }
            if (flagForAnimatedTransition) {
                this.animator.start();
            }
            if (this.showToolTip) {
                this.showToolTipText(true);
            }
        }
    }

    public String getIncludeDoocsXmlFile() {
        return this.doocsXmlFile;
    }

    public void setDoocsTransition(String transition) {
        this.doocsTransition = transition;
    }

    public String getDoocsTransition() {
        return this.doocsTransition;
    }

    public void resetInitialBounds(Component comp) {
        EditorPanel.resetInitialBounds(comp);
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("xmlFile", DOOCSParameter.ParameterTypes.XMLFILE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderType", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("transition", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("borderType")) {
            String[] allowedValues = new String[]{"No Border", "Black Line Border", "Raised Etched Border", "Lowered Etched Border", "Raised Bevel Border", "Lowered Bevel Border"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("transition")) {
            String[] allowedValues = new String[]{"NONE", "Fading"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSIncludeComponent ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSIncludeComponent>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("borderType")) {
            this.setDoocsBorderType(value);
        } else if (parameter.equalsIgnoreCase("fillColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("transparent")) {
            this.setOpaque(!Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("grid")) {
            this.setDoocsGrid(value);
        } else if (parameter.equalsIgnoreCase("xmlFile")) {
            this.setIncludeDoocsXmlFile(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("transition")) {
            this.setDoocsTransition(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else if (!(parameter.equalsIgnoreCase("author") || parameter.equalsIgnoreCase("description") || parameter.equalsIgnoreCase("fullScreenMode") || parameter.equalsIgnoreCase("showWindowBorder") || parameter.equalsIgnoreCase("minSize"))) {
            System.out.println("DOOCSIncludeComponent.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("fillColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("transparent")) {
            return !this.isOpaque();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("grid")) {
            return this.getDoocsGrid();
        }
        if (parameter.equalsIgnoreCase("xmlFile")) {
            return this.getIncludeDoocsXmlFile();
        }
        if (parameter.equalsIgnoreCase("borderType")) {
            return this.getDoocsBorderType();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("transition")) {
            return this.getDoocsTransition();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSIncludeComponent.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        if (this.doocsXmlFile != null) {
            this.setIncludeDoocsXmlFile(this.doocsXmlFile);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.m_initialWidth != 0 && this.m_initialHeight != 0) {
            double xFactor = (double)w / (double)this.m_initialWidth;
            double yFactor = (double)h / (double)this.m_initialHeight;
            this.scaleFonts(xFactor, yFactor, this);
        }
    }

    private void scaleFonts(double xFactor, double yFactor, Container scaleComp) {
        for (int i = 0; i < scaleComp.getComponentCount(); ++i) {
            Component comp = scaleComp.getComponent(i);
            Font f = comp.getFont();
            if (f != null) {
                AffineTransform aft = f.getTransform();
                aft.setToScale(xFactor, yFactor);
                f = f.deriveFont(aft);
                comp.setFont(f);
            }
            if (!(comp instanceof DOOCSComponent) || comp instanceof DOOCSIncludeComponent || ((Container)comp).getComponentCount() <= 0) continue;
            this.scaleFonts(xFactor, yFactor, (Container)comp);
        }
    }

    public void setAlpha(float alpha) {
        if ((double)alpha > 0.9999 && this.firstImage == null) {
            this.alpha = 0.0f;
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void paint(Graphics g) {
        if (this.firstImage != null && !this.getFirstImage) {
            if ((double)this.alpha == 0.0) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(AlphaComposite.SrcOver.derive(this.alpha));
            super.paint(g2);
            g2.setComposite(AlphaComposite.SrcOver.derive(1.0f - this.alpha));
            g2.drawImage((Image)this.firstImage, 0, 0, null);
            if ((double)this.alpha > 0.9999) {
                this.firstImage = null;
            }
        } else {
            super.paint(g);
        }
    }
}

