/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.ColorMap;
import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.StringTransferHandler;
import editor.undo.SetProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputListener;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSColouredIndicator
extends JComponent
implements EqCallback,
DOOCSComponent {
    private MouseAdapter listener;
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    private EqAdr adrData = null;
    private String errorMessage = null;
    private Float value;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsToolTipText = null;
    private int doocsIndex = 0;
    private float doocsUpdateTime = 1.0f;
    private float doocsMinimum = 0.0f;
    private float doocsMaximum = 100.0f;
    private String doocsIndicatorShape = "Rectangle";
    private Color doocsLineColor = Color.BLACK;
    private int doocsStrokeSize = 1;
    private String doocsColorMap = "Standard";
    private boolean doocsLineTransparent = false;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private transient ColorMap myColorMap;
    private Color fillColor = Color.WHITE;

    public DOOCSColouredIndicator() {
        this.setPreferredSize(new Dimension(50, 50));
        this.setSize(new Dimension(50, 50));
        this.setDoocsColorMap("Standard");
        this.setEnabled(this.doocsRunMode);
        this.setTransferHandler(new StringTransferHandler());
        this.listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, e, 1);
            }
        };
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, null);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, null);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return this.fullDoocsAddress;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsIndex(int index) {
        this.doocsIndex = index;
    }

    public int getDoocsIndex() {
        return this.doocsIndex;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsMinimum(float mini) {
        this.doocsMinimum = mini;
    }

    public float getDoocsMinimum() {
        return this.doocsMinimum;
    }

    public void setDoocsMaximum(float maxi) {
        this.doocsMaximum = maxi;
    }

    public float getDoocsMaximum() {
        return this.doocsMaximum;
    }

    public void setDoocsIndicatorShape(String shape) {
        this.doocsIndicatorShape = shape;
    }

    public String getDoocsIndicatorShape() {
        return this.doocsIndicatorShape;
    }

    public void setDoocsLineColor(Color lineColor) {
        this.doocsLineColor = lineColor;
    }

    public Color getDoocsLineColor() {
        return this.doocsLineColor;
    }

    public void setDoocsLineTransparent(Boolean lineTransparent) {
        this.doocsLineTransparent = lineTransparent;
    }

    public Boolean getDoocsLineTransparent() {
        return this.doocsLineTransparent;
    }

    public void setDoocsStrokeSize(int strokeSize) {
        this.doocsStrokeSize = strokeSize;
    }

    public int getDoocsStrokeSize() {
        return this.doocsStrokeSize;
    }

    public void setDoocsColorMap(String map) {
        this.doocsColorMap = map;
        if (map.equalsIgnoreCase("BlackToWhite")) {
            this.myColorMap = new ColorMap("01", 100);
        } else if (map.equalsIgnoreCase("RedGreen")) {
            this.myColorMap = new ColorMap("RedGreen", 2);
        } else if (map.equalsIgnoreCase("GrayGreen")) {
            this.myColorMap = new ColorMap("GrayGreen", 2);
        } else if (map.equalsIgnoreCase("StatusCode")) {
            this.myColorMap = new ColorMap("StatusCode", 8);
            this.doocsMinimum = 0.0f;
            this.doocsMaximum = 7.0f;
        } else {
            this.myColorMap = new ColorMap("bgyr", 101);
        }
    }

    public String getDoocsColorMap() {
        return this.doocsColorMap;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.addMouseListener(this.listener);
            this.startMonitors();
        } else {
            this.removeMouseListener(this.listener);
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        if (this.doocsColorMap.equalsIgnoreCase("StatusCode")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("indicatorShape", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("colorMap", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("strokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("indicatorShape", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("colorMap", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("strokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maximum", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("minimum", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("indicatorShape")) {
            String[] allowedValues = new String[]{"Rectangle", "Oval"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("colorMap")) {
            String[] allowedValues = new String[]{"Standard", "BlackToWhite", "RedGreen", "GrayGreen", "StatusCode"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSColouredIndicator ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSColouredIndicator>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("dataIndex")) {
            this.setDoocsIndex(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("indicatorShape")) {
            this.setDoocsIndicatorShape(value);
        } else if (parameter.equalsIgnoreCase("lineColor")) {
            this.setDoocsLineColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("lineTransparent")) {
            this.setDoocsLineTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("strokeSize")) {
            this.setDoocsStrokeSize(Math.round(Float.parseFloat(value)));
        } else if (parameter.equalsIgnoreCase("colorMap")) {
            this.setDoocsColorMap(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("maximum")) {
            this.setDoocsMaximum(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("minimum")) {
            this.setDoocsMinimum(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSColouredIndicator.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("dataIndex")) {
            return this.getDoocsIndex();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("indicatorShape")) {
            return this.getDoocsIndicatorShape();
        }
        if (parameter.equalsIgnoreCase("lineColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsLineColor());
        }
        if (parameter.equalsIgnoreCase("lineTransparent")) {
            return this.getDoocsLineTransparent();
        }
        if (parameter.equalsIgnoreCase("strokeSize")) {
            return this.getDoocsStrokeSize();
        }
        if (parameter.equalsIgnoreCase("colorMap")) {
            return this.getDoocsColorMap();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("maximum")) {
            return Float.valueOf(this.getDoocsMaximum());
        }
        if (parameter.equalsIgnoreCase("minimum")) {
            return Float.valueOf(this.getDoocsMinimum());
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSColouredIndicator.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((DOOCSComponent)((Object)this.getComponent(i))).addDOOCSMouseListener(ml);
        }
    }

    public void dataCallback(EqData dataOut, Object userData) {
        this.value = Float.valueOf(0.0f);
        if (dataOut.error() == 0) {
            this.errorMessage = null;
            if (dataOut.type() == 2) {
                this.value = Float.valueOf(dataOut.get_float(this.doocsIndex));
            } else if (dataOut.type() == 1) {
                this.value = new Float(dataOut.get_int(this.doocsIndex));
            } else if (dataOut.type() == 103) {
                this.value = new Float(dataOut.get_int(this.doocsIndex));
            } else {
                System.out.println("DOOCSColouredIndicator: " + this.fullDoocsAddress + " wrong data type!");
            }
            int max = this.myColorMap.max_colors - 1;
            int setValue = Math.round((this.value.floatValue() - this.doocsMinimum) * (float)max / (this.doocsMaximum - this.doocsMinimum));
            if (setValue > max) {
                setValue = max;
            }
            if (setValue < 0) {
                setValue = 0;
            }
            this.fillColor = this.myColorMap.table[setValue];
            this.repaint();
        } else if (this.errorMessage == null && this.doocsRunMode) {
            this.errorMessage = dataOut.get_string_arg();
            System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x = 0;
        int y = 0;
        int width = this.getSize().width - 1;
        int height = this.getSize().height - 1;
        g2d.setColor(this.fillColor);
        if (this.doocsIndicatorShape.equalsIgnoreCase("Rectangle")) {
            g2d.fillRect(x, y, width, height);
        } else {
            g2d.fillOval(x, y, width, height);
        }
        BasicStroke myStroke = new BasicStroke(this.doocsStrokeSize);
        g2d.setStroke(myStroke);
        g2d.setColor(this.doocsLineColor);
        if (!this.doocsLineTransparent) {
            if (this.doocsIndicatorShape.equalsIgnoreCase("Rectangle")) {
                g2d.drawRect(x, y, width, height);
            } else {
                g2d.drawOval(x, y, width, height);
            }
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

