/* file: ENS.x

source for:
		ENS.h
		ENS_xdr.c
		ENS_cltn.c
		ENS_svc.c
*/
/* file: ENS.h

RPC/XDR for ENS


last update:
16. Mar. 1995
*/

/*
#ifndef ENS_h
const ENS_h
#include <pvak_types.h>
*/
typedef  long  time_t;   

const SERVER_STRING_LENGTH =128;
const HOST_STRING_LENGTH = 256;
const AUTH_STRING_LENGTH =128;
const FILE_STRING_LENGTH =256;

/* defined protocols : */
const DOOCS = 1;
const TINE  = 2;
const EPICS = 3;
const TANGO = 4;
/*const SHM_DOOCS =5;
const SBAND =6;
const EPICS_TAB =7;
const FNAL_CLASSIC =8;
*/
/* defined server level masks : */
const MASK_FACILITY =1;
const MASK_DEVICE   =2;
const MASK_LOCATION =4;
const MASK_PROPERTY =8;


/* defined auth masks : */
const MASK_GET_CALL  =  1;
const MASK_SET_CALL   = 2;
const MASK_NAMES_CALL  =4;
const MASK_CREATE_CALL =8;

/* defined status masks : */
const MASK_STS_OFFLINE  =  1;

/* ====================== info ======================== */

struct ENSinfo {
	int	error;			/* return code */
	int	server_mask;		/* mask for level of server */

	char	facility<FACILITY_STRING_LENGTH>;
	char	device<DEVICE_STRING_LENGTH>;
	char	location<LOCATION_STRING_LENGTH>;
	char	property<PROPERTY_STRING_LENGTH>;

	char	server_name<SERVER_STRING_LENGTH>;
	char	hostname<HOST_STRING_LENGTH>;
	u_long	protocol;
	u_long	prog_no;
	u_long	prog_vers;
	u_long	options;
	u_long	status;
	char	file_or_ch<STRING_LENGTH>; /* shm file or channel name */
	u_long	auth_mask;	/* requesting client may call */
    	OncRpcClient client_;
};


/* ====================== input ======================== */

struct ens_param {
	EqNameString*	eq_name;
};

struct ens_name_param {
	EqNameString*	eq_name;
	EqDataBlock*	eq_data;
};


/* ====================== results ======================== */

struct ens_results {
	ENSinfo		eq_data;
};

struct ens_name_results {
	EqDataBlock	eq_data;
};


/* ====================== PROGRAM ======================== */

program ENSLIBPROG {
    version ENSLIBVERS {
        ENSinfo			ENS_GET (ens_param)		= 1;
        ens_name_results	ENS_NAMES (ens_name_param)	= 2;
    } = 1;
} = 0x20454e53;		/* 0x20000000 + ENS [hex] */

/*#endif*/
