typedef  unsigned char u_char;   



const	DATA_NULL	= 0;
const	DATA_INT	= 1;
const	DATA_FLOAT	= 2;
const	DATA_STRING	= 3;
const	DATA_BOOL	= 4;
const	DATA_STRING16	= 5;
const	DATA_DOUBLE     = 6;
const	DATA_TEXT       = 7;
const	DATA_SHORT      = 8;

const	DATA_YT		= 10;
const	DATA_XYT	= 11;
const	DATA_TDS	= 12;
const	DATA_XY		= 13;
const	DATA_IIII	= 14;
const	DATA_IFFF	= 15;
const	DATA_USTR	= 16;
const	DATA_FIS	= 17;
const	DATA_TTII	= 18;
const	DATA_SPECTRUM	= 19;
const	DATA_XML	= 20;
const	DATA_XYZS	= 21;
const	DATA_IMAGE      = 22; /*not yet implemented */

const	DATA_A_FLOAT	= 100;
const	DATA_A_TDS	= 101;
const	DATA_A_XY	= 102;
const	DATA_A_USTR	= 103;
const	DATA_A_FIS	= 104;
const	DATA_A_INT	= 105;
const	DATA_A_BYTE	= 106;
const	DATA_A_TDSi	= 107;
const	DATA_A_XYZS	= 108;
const	DATA_MDA_FLOAT  = 109;
const	DATA_A_DOUBLE   = 110;
const	DATA_A_NAME16FI = 111;
const	DATA_A_NAME16II = 112;
const	DATA_A_NAME16   = 113;  //not complete integrated!!
const   DATA_A_FI       = 114;
const   DATA_A_SHORT    = 115;
const   DATA_A_II       = 116;
const	DATA_A_NAME64   = 117;
const	DATA_A_NAME32   = 118;
const	DATA_A_BOOL     = 119;

const	DATA_A_TS_SPECTRUM  = 1013;

const	SHORT_STRING_LENGTH	= 16;

const	FACILITY_STRING_LENGTH	= 64;
const	DEVICE_STRING_LENGTH	= 64;
const	LOCATION_STRING_LENGTH	= 64;
const	PROPERTY_STRING_LENGTH	= 64;
/*C++ definitions:
//#define	FACILITY_STRING_LENGTH  64
//#define	DEVICE_STRING_LENGTH    64
//#define	LOCATION_STRING_LENGTH  64
//#define	PROPERTY_STRING_LENGTH  64
//

#define HOST_STRING_LENGTH     256
#define AUTH_STRING_LENGTH     128
#define SERVER_STRING_LENGTH   128
#define FILE_STRING_LENGTH     256
*/
const	STRING_LENGTH		= 80;
const	RB_LENGTH		= 2000;
const	TDS_LENGTH		= 2000;
const	FLOAT_LENGTH		= 1024;
const	INT_LENGTH		= 1024;
const	IMAGE_LENGTH		= 8388608;	/* 8Mb length */
const	BYTE_ARRAY_LENGTH	= 8388608;	/* 8Mb length */
const	XML_ARRAY_LENGTH	= 4194304;	/* 4Mb length, 64k is max TCP length */

const	XY_LENGTH		= 2048;
const	SPECTRUM_LENGTH		= 8192;
const	FIS_LENGTH		= 128;
const	FI_LENGTH		= 1000;
const	II_LENGTH		= 1000;
const	USTR_LENGTH		= 1000;
const	STRING_ARRAY_LENGTH	= 128;
const	XYZS_LENGTH		= 1000;
const	NAME16_LENGTH		= 1000; // for NAME16FI and NAME16II

const	ERR_ALIAS		= 1008;
const	MDA_LENGTH              = 16384;
const	DIM_MAX                 = 6;
const	TEXT_LENGTH             = 1048576;
const	SPECTRUM_LENGTH_MAX     = 1048576;
const	TS_SPECTRUM_LENGTH      = 128;

typedef long time_t;

struct TDS {
	time_t	tm;
	float	data;
	u_char	status;
};

struct TDSi {
	time_t	tm;
	float	data;
	u_short	status;
	u_short	t_ms;
};

struct XY {
	float	x_data;
	float	y_data;
};

struct SPECTRUM {
	char	comment<STRING_LENGTH>;	
	time_t	tm;
	float	s_start;
	float	s_inc;
	int	status;
	float	d_spect_array<SPECTRUM_LENGTH>;
};

struct TSH {
	u_int   tsec;
	u_short tmsec;
	u_short status;
};

struct TS_SPECTRUM {
	u_int    tsec;
	u_short  tmsec;
	u_short  tstatus;
        SPECTRUM sp;
	/*char	  comment<STRING_LENGTH>;	
	time_t	 tm;
	float	 s_start;
	float	 s_inc;
	u_char	 status;
	float	 d_spect_array<SPECTRUM_LENGTH>;*/
};

struct A_BYTE {
	int	x_dim;
	int	y_dim;
	int	x_offset;
	int	y_offset;
	int	option;
	u_char	d_byte_array<BYTE_ARRAY_LENGTH>;
};

struct XML {
	char	d_xml_array<XML_ARRAY_LENGTH>;
};

struct IIII {
	int	i1_data;
	int	i2_data;
	int	i3_data;
	int	i4_data;
};

struct IFFF {	
	int	i1_data;
	float	f1_data;
	float	f2_data;
	float	f3_data;
};

struct SYT  { float d_y;            time_t tm; };
struct SXYT { float d_x; float d_y; time_t tm; };

union UstrUnion switch (int data_sel) {
		case DATA_YT	: struct SYT  d_syt;
		case DATA_XYT	: struct SXYT d_xyt;
		default	: void;
};

struct	USTR {
	int	i1_data;
	float	f1_data;
	float	f2_data;
	time_t	tm;
	char	str_data<STRING_LENGTH>;
};

struct	NAME16FI {
	char	str_data<16>;
	float	f_data;
	int	i_data;
};

struct	NAME16II {
	char	str_data<16>;
	int	i1_data;
	int	i2_data;
};

struct FIS {
	float	f_data;
	int	i_data;
	u_char	status;
};

struct FI {
	float	f_data;
	int	i_data;
};

struct II {
	int	i1_data;
	int	i2_data;
};

struct TTII {
	time_t	tm1;
	time_t	tm2;
	int	i1_data;
	int	i2_data;
};

struct XYZS {
	int	status;
	float	x;
	float	y;
	float	z;
	char	loc<LOCATION_STRING_LENGTH>;
};

struct MDAF {
	char	comment<STRING_LENGTH>;	
        int     dimn;
	int	dims [DIM_MAX];
	float	d_mdfa<MDA_LENGTH>;
};

struct IMH {
	int     width;
	int     height;
	int     aoi_width;
	int     aoi_height;
	int     x_start;
	int     y_start;
	int     bpp;
	int     ebitpp;
	int     hbin;
	int     vbin;
	int     source_format;
	int     image_format;
	u_int   frame;
	u_int   event;
        float   scale_x;
        float   scale_y;
        float   image_rotation;
        float   fspare2;
        float   fspare3;
        float   fspare4;
        int     image_flags;
        int     ispare2;
        int     ispare3;
        int     ispare4;
        int     length;
};

struct IMAGE {
        IMH             hdr;
	time_t          sec;
	time_t          usec;
	int             status;
	char	        comment<STRING_LENGTH>;
	u_char	        val<IMAGE_LENGTH>;
	ByteBuffer 	bbuf;
};

union DataUnion switch (int data_sel) {
	case DATA_INT		: int		d_int;
	case DATA_SHORT		: short		d_short;
	case DATA_BOOL		: int		d_bool;
	case DATA_FLOAT		: float		d_float;
	case DATA_DOUBLE	: double	d_double;
	case DATA_STRING	: char		d_char<SHORT_STRING_LENGTH>;
	case DATA_STRING16	: char		d_char16[SHORT_STRING_LENGTH];
	case DATA_TDS		: TDS		d_tds;
	case DATA_XY		: XY		d_xy;
	case DATA_IIII		: IIII		d_iiii;
	case DATA_IFFF		: IFFF		d_ifff;
	case DATA_FIS		: FIS		d_fis;
	case DATA_TTII		: TTII		d_ttii;
        case DATA_A_NAME16FI    : NAME16FI      d_name16fi<NAME16_LENGTH>;
        case DATA_A_NAME16II    : NAME16II      d_name16ii<NAME16_LENGTH>;
        case DATA_A_NAME16      : NAME16        d_name16<NAME16_LENGTH>;
        case DATA_A_NAME32      : NAME32        d_name32<NAME16_LENGTH>;
        case DATA_A_NAME64      : NAME64        d_name64<NAME16_LENGTH>;
	case DATA_SPECTRUM	: SPECTRUM	d_spectrum;
	case DATA_XML		: XML		d_xml;
	case DATA_TEXT		: TEXT		d_text;
	case DATA_XYZS		: XYZS		d_xyzs;
        case DATA_IMAGE		: IMAGE		d_image;
	case DATA_MDA_FLOAT	: MDAF   	d_mdaf;
	case DATA_A_INT		: int		d_int_array<INT_LENGTH>;
	case DATA_A_SHORT	: short		d_short_array<INT_LENGTH>;
	case DATA_A_FLOAT	: float		d_float_array<FLOAT_LENGTH>;
	case DATA_A_DOUBLE	: double	d_double_array<FLOAT_LENGTH>;
	case DATA_A_BYTE	: A_BYTE	d_byte_struct;
	case DATA_A_TDS		: TDS		d_tds_array<TDS_LENGTH>;
	case DATA_A_TDSi	: TDSi		d_tdsi_array<TDS_LENGTH>;
	case DATA_A_XY		: XY		d_xy_array<XY_LENGTH>;
	case DATA_A_USTR	: USTR		d_ustr_array<USTR_LENGTH>;
	case DATA_A_FIS		: FIS		d_fis_array<FIS_LENGTH>;
	case DATA_A_FI		: FI		d_fi_array<FI_LENGTH>;
	case DATA_A_II		: II		d_ii_array<II_LENGTH>;
	case DATA_A_XYZS	: XYZS	        d_xyzs_array  <XYZS_LENGTH>;
	case DATA_A_TS_SPECTRUM	: TS_SPECTRUM	d_ts_spectrum_array<TS_SPECTRUM_LENGTH>;
	default			: void;
};

struct EqDataBlock {
	time_t		tm;
	int		error;
	DataUnion	data_u;
};

struct EqNameString {
	char	n_facility<FACILITY_STRING_LENGTH>;
	char	n_location<LOCATION_STRING_LENGTH>;
	char	n_object<DEVICE_STRING_LENGTH>;
	char	n_property<PROPERTY_STRING_LENGTH>;
};

struct get_param {
	EqNameString*	eq_name;
	EqDataBlock*	eq_data;
};

struct set_param {
	EqNameString*	eq_name;
	EqDataBlock*	eq_data;
};

struct name_param {
	EqNameString*	eq_name;
	EqDataBlock*	eq_data;
};

struct create_param {
	EqNameString*	eq_name;
	EqDataBlock*	eq_data;
};




struct get_results {
	EqDataBlock	eq_data;
};

struct set_results {
	EqDataBlock	eq_data;
};

struct name_results {
	EqDataBlock	eq_data;
};

struct create_results {
	EqDataBlock	eq_data;
};




program EQLIBPROG {
    version EQLIBVERS {
        get_results	RPC_EQ_GET (get_param)		= 1;
        set_results	RPC_EQ_SET (set_param)		= 2;
        name_results	RPC_EQ_NAMES (name_param)	= 3;
        create_results	RPC_EQ_CREATE (create_param)	= 4;
    } = 1;
} = 0x24635321;		/* 0x20000000 + F52 [hex] + 1 */

