/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.impl.CAContext;
import com.cosylab.epics.caj.impl.Request;
import com.cosylab.epics.caj.impl.ResponseHandler;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.reactor.ReactorHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;

public class BroadcastTransport
implements Transport,
ReactorHandler {
    private CAContext context;
    private DatagramChannel channel;
    private InetSocketAddress socketAddress;
    private InetSocketAddress connectAddress;
    private InetSocketAddress[] broadcastAddresses;
    private InetSocketAddress[] ignoredAddresses = null;
    private ByteBuffer receiveBuffer;
    private ByteBuffer[] receiveBufferArray;
    private short remoteTransportRevision;
    protected ResponseHandler responseHandler = null;

    public BroadcastTransport(CAContext context, ResponseHandler responseHandler, DatagramChannel channel, InetSocketAddress connectAddress, short remoteTransportRevision) {
        this.context = context;
        this.responseHandler = responseHandler;
        this.channel = channel;
        this.connectAddress = connectAddress;
        this.remoteTransportRevision = remoteTransportRevision;
        this.broadcastAddresses = new InetSocketAddress[]{new InetSocketAddress("255.255.255.255", context.getBroadcastPort())};
        this.socketAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
        this.receiveBuffer = ByteBuffer.allocate(65551);
        this.receiveBufferArray = new ByteBuffer[]{this.receiveBuffer};
    }

    public void bind(boolean reuseAddress) throws SocketException {
        this.channel.socket().setReuseAddress(reuseAddress);
        this.channel.socket().bind(this.connectAddress);
    }

    public void close() {
        if (this.connectAddress != null) {
            this.context.getLogger().finer("UDP connection to " + this.connectAddress + " closed.");
        }
        this.context.getReactor().unregisterAndClose(this.channel);
    }

    public void handleEvent(SelectionKey key) {
        if (key.isValid() && key.isReadable()) {
            this.processRead();
        }
        if (key.isValid() && key.isWritable()) {
            this.processWrite();
        }
    }

    protected void processRead() {
        try {
            block2: while (true) {
                this.receiveBuffer.clear();
                InetSocketAddress fromAddress = (InetSocketAddress)this.channel.receive(this.receiveBuffer);
                if (fromAddress != null) {
                    if (this.ignoredAddresses != null) {
                        InetAddress fromAddressOnly = fromAddress.getAddress();
                        for (int i = 0; i < this.ignoredAddresses.length; ++i) {
                            if (!this.ignoredAddresses[i].getAddress().equals(fromAddressOnly)) continue;
                        }
                    }
                    this.context.getLogger().finest("Received " + this.receiveBuffer.position() + " bytes from " + fromAddress + ".");
                    this.receiveBuffer.flip();
                    this.context.invalidateLastReceivedSequence();
                    while (true) {
                        if (this.receiveBuffer.limit() - this.receiveBuffer.position() < 16) continue block2;
                        this.responseHandler.handleResponse(fromAddress, this, this.receiveBufferArray);
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void processWrite() {
    }

    protected void send(ByteBuffer buffer) {
        for (int i = 0; i < this.broadcastAddresses.length; ++i) {
            try {
                buffer.flip();
                this.channel.send(buffer, this.broadcastAddresses[i]);
                continue;
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
    }

    protected void send(ByteBuffer buffer, InetSocketAddress address) throws IOException {
        this.context.getLogger().finest("Sending " + buffer.limit() + " bytes to " + address + ".");
        buffer.flip();
        this.channel.send(buffer, address);
    }

    public short getMinorRevision() {
        return this.remoteTransportRevision;
    }

    public void submit(Request requestMessage) {
        this.send(requestMessage.getRequestMessage());
    }

    public void send(Request requestMessage, InetSocketAddress address) throws IOException {
        this.send(requestMessage.getRequestMessage(), address);
    }

    public CAContext getContext() {
        return this.context;
    }

    public short getPriority() {
        return 0;
    }

    public boolean flush() {
        return true;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.socketAddress;
    }

    public InetSocketAddress[] getBroadcastAddresses() {
        return this.broadcastAddresses;
    }

    public InetSocketAddress[] getIgnoredAddresses() {
        return this.ignoredAddresses;
    }

    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    public void setBroadcastAddresses(InetSocketAddress[] addresses) {
        this.broadcastAddresses = addresses;
    }

    public void setIgnoredAddresses(InetSocketAddress[] addresses) {
        this.ignoredAddresses = addresses;
    }
}

