/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.BYTE;
import gov.aps.jca.dbr.CTRL;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DOUBLE;
import gov.aps.jca.dbr.ENUM;
import gov.aps.jca.dbr.FLOAT;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.INT;
import gov.aps.jca.dbr.LABELS;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.SHORT;
import gov.aps.jca.dbr.STRING;
import gov.aps.jca.dbr.STS;
import gov.aps.jca.dbr.TIME;
import java.io.PrintStream;
import java.lang.reflect.Array;

public abstract class DBR {
    public static final DBRType TYPE = new DBRType("UNKNOWN", -1, null);
    protected int _count;
    protected Object _value;

    protected DBR(Object value) {
        this.setValue(value);
    }

    protected void setValue(Object value) {
        this._value = value;
        this._count = Array.getLength(this._value);
    }

    public DBRType getType() {
        return TYPE;
    }

    public int getCount() {
        return this._count;
    }

    public Object getValue() {
        return this._value;
    }

    public abstract DBR convert(DBRType var1) throws CAStatusException;

    public DBR convert(DBRType convertType, Object params) throws CAStatusException {
        return this.convert(convertType);
    }

    public void printInfo() {
        this.printInfo(System.out);
    }

    public void printInfo(PrintStream out) {
        out.println("TYPE: " + this.getType().getName());
        out.println("COUNT: " + this.getCount());
        out.print("VALUE: ");
        Object value = this.getValue();
        if (value instanceof byte[]) {
            DBR.printValue((byte[])value, out);
        } else if (value instanceof short[]) {
            DBR.printValue((short[])value, out);
        } else if (value instanceof int[]) {
            DBR.printValue((int[])value, out);
        } else if (value instanceof float[]) {
            DBR.printValue((float[])value, out);
        } else if (value instanceof double[]) {
            DBR.printValue((double[])value, out);
        } else if (value instanceof String[]) {
            DBR.printValue((String[])value, out);
        }
        out.println();
    }

    public boolean isBYTE() {
        return DBR.isBYTE(this);
    }

    public boolean isSHORT() {
        return DBR.isSHORT(this);
    }

    public boolean isINT() {
        return DBR.isINT(this);
    }

    public boolean isFLOAT() {
        return DBR.isFLOAT(this);
    }

    public boolean isDOUBLE() {
        return DBR.isDOUBLE(this);
    }

    public boolean isSTRING() {
        return DBR.isSTRING(this);
    }

    public boolean isENUM() {
        return DBR.isENUM(this);
    }

    public boolean isSTS() {
        return DBR.isSTS(this);
    }

    public boolean isGR() {
        return DBR.isGR(this);
    }

    public boolean isCTRL() {
        return DBR.isCTRL(this);
    }

    public boolean isLABELS() {
        return DBR.isLABELS(this);
    }

    public boolean isTIME() {
        return DBR.isTIME(this);
    }

    public boolean isPRECSION() {
        return DBR.isPRECISION(this);
    }

    public static boolean isBYTE(DBR dbr) {
        return dbr instanceof BYTE;
    }

    public static boolean isSHORT(DBR dbr) {
        return dbr instanceof SHORT;
    }

    public static boolean isINT(DBR dbr) {
        return dbr instanceof INT;
    }

    public static boolean isFLOAT(DBR dbr) {
        return dbr instanceof FLOAT;
    }

    public static boolean isDOUBLE(DBR dbr) {
        return dbr instanceof DOUBLE;
    }

    public static boolean isSTRING(DBR dbr) {
        return dbr instanceof STRING;
    }

    public static boolean isENUM(DBR dbr) {
        return dbr instanceof ENUM;
    }

    public static boolean isSTS(DBR dbr) {
        return dbr instanceof STS;
    }

    public static boolean isGR(DBR dbr) {
        return dbr instanceof GR;
    }

    public static boolean isCTRL(DBR dbr) {
        return dbr instanceof CTRL;
    }

    public static boolean isLABELS(DBR dbr) {
        return dbr instanceof LABELS;
    }

    public static boolean isTIME(DBR dbr) {
        return dbr instanceof TIME;
    }

    public static boolean isPRECISION(DBR dbr) {
        return dbr instanceof PRECISION;
    }

    public static void printValue(byte[] value) {
        DBR.printValue(value, System.out);
    }

    public static void printValue(byte[] value, PrintStream out) {
        for (int t = 0; t < value.length; ++t) {
            if (t > 0) {
                out.print(",");
            }
            out.print(value[t]);
        }
    }

    public static void printValue(short[] value) {
        DBR.printValue(value, System.out);
    }

    public static void printValue(short[] value, PrintStream out) {
        for (int t = 0; t < value.length; ++t) {
            if (t > 0) {
                out.print(",");
            }
            out.print(value[t]);
        }
    }

    public static void printValue(int[] value) {
        DBR.printValue(value, System.out);
    }

    public static void printValue(int[] value, PrintStream out) {
        for (int t = 0; t < value.length; ++t) {
            if (t > 0) {
                out.print(",");
            }
            out.print(value[t]);
        }
    }

    public static void printValue(long[] value) {
        DBR.printValue(value, System.out);
    }

    public static void printValue(long[] value, PrintStream out) {
        for (int t = 0; t < value.length; ++t) {
            if (t > 0) {
                out.print(",");
            }
            out.print(value[t]);
        }
    }

    public static void printValue(float[] value) {
        DBR.printValue(value, System.out);
    }

    public static void printValue(float[] value, PrintStream out) {
        for (int t = 0; t < value.length; ++t) {
            if (t > 0) {
                out.print(",");
            }
            out.print(value[t]);
        }
    }

    public static void printValue(double[] value) {
        DBR.printValue(value, System.out);
    }

    public static void printValue(double[] value, PrintStream out) {
        for (int t = 0; t < value.length; ++t) {
            if (t > 0) {
                out.print(",");
            }
            out.print(value[t]);
        }
    }

    public static void printValue(String[] value) {
        DBR.printValue(value, System.out);
    }

    public static void printValue(String[] value, PrintStream out) {
        for (int t = 0; t < value.length; ++t) {
            if (t > 0) {
                out.print(",");
            }
            out.print(value[t]);
        }
    }
}

