/*
 * Decompiled with CFR 0.152.
 */
package jsvnbrowser;

import DOOCSComponents.DOOCSParameter;
import editor.StartParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsvnbrowser.JSVNFileInfo;
import jsvnbrowser.JSVNList;
import org.jdesktop.layout.GroupLayout;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xmlparser.DOOCSParser;

public class JSVNBrowser
extends JDialog {
    public static int MAX_NUMBER_OF_LOG_ENTRIES = 10;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public int dialogType = 0;
    private String currentDirectory = null;
    private String xmlsource = null;
    public transient JSVNFileInfo fileInfo = null;
    public String selectedFileType = "All Files (*.*)";
    private JSVNList m_treeSVNList;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanelChangeLog;
    private JPanel jPanelInfo;
    private JScrollPane jScrollPane1;
    private JButton m_btnAddFile;
    private JButton m_btnCancel;
    private JButton m_btnDirUp;
    private JButton m_btnFileDelete;
    private JButton m_btnHome;
    private JButton m_btnNewDir;
    private JButton m_btnSelect;
    private JComboBox m_cbType;
    private JLabel m_lblName;
    private JLabel m_lblPath;
    private JLabel m_lblType;
    private JPanel m_pnlInfo;
    private JScrollPane m_spSVNList;
    private JSplitPane m_spSplitter;
    private JTextField m_textField;
    private JTabbedPane m_tpFileInfos;

    public JSVNBrowser() {
        this.m_treeSVNList = new JSVNList(this);
    }

    public JSVNBrowser(String reposPath) {
        this.m_treeSVNList = new JSVNList(this, reposPath);
    }

    private void initComponents() {
        this.m_btnDirUp = new JButton();
        this.m_btnCancel = new JButton();
        this.m_btnSelect = new JButton();
        this.m_spSplitter = new JSplitPane();
        this.m_spSVNList = new JScrollPane();
        this.m_tpFileInfos = new JTabbedPane();
        this.m_pnlInfo = new JPanel();
        this.jPanelInfo = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelChangeLog = new JPanel();
        this.m_lblName = new JLabel();
        this.m_lblType = new JLabel();
        this.m_cbType = new JComboBox();
        this.m_btnNewDir = new JButton();
        this.m_btnFileDelete = new JButton();
        this.m_lblPath = new JLabel();
        this.m_btnHome = new JButton();
        this.m_textField = new JTextField();
        this.m_btnAddFile = new JButton();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JSVNBrowser.this.formWindowClosing(evt);
            }
        });
        this.m_btnDirUp.setIcon(new ImageIcon(this.getClass().getResource("/jsvnbrowser/icons/dir-up.png")));
        this.m_btnDirUp.setToolTipText("Up One Level");
        this.m_btnDirUp.setBorderPainted(false);
        this.m_btnDirUp.setPreferredSize(new Dimension(55, 22));
        this.m_btnDirUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.m_btnDirUpActionPerformed(evt);
            }
        });
        this.m_btnCancel.setText("Cancel");
        this.m_btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.m_btnCancelActionPerformed(evt);
            }
        });
        this.m_btnSelect.setText("Open");
        this.m_btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.m_btnSelectActionPerformed(evt);
            }
        });
        this.m_spSplitter.setDividerLocation(200);
        this.m_spSplitter.setLeftComponent(this.m_spSVNList);
        this.m_tpFileInfos.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSVNBrowser.this.m_tpFileInfosStateChanged(evt);
            }
        });
        this.jPanelInfo.setLayout(new BorderLayout(10, 10));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setVerticalTextPosition(1);
        this.jPanelInfo.add((Component)this.jLabel1, "North");
        this.jLabel2.setVerticalAlignment(1);
        this.jLabel2.setVerticalTextPosition(1);
        this.jPanelInfo.add((Component)this.jLabel2, "Center");
        GroupLayout m_pnlInfoLayout = new GroupLayout(this.m_pnlInfo);
        this.m_pnlInfo.setLayout(m_pnlInfoLayout);
        m_pnlInfoLayout.setHorizontalGroup(m_pnlInfoLayout.createParallelGroup(1).add(m_pnlInfoLayout.createSequentialGroup().addContainerGap().add(this.jPanelInfo, -1, 438, Short.MAX_VALUE).addContainerGap()));
        m_pnlInfoLayout.setVerticalGroup(m_pnlInfoLayout.createParallelGroup(1).add(m_pnlInfoLayout.createSequentialGroup().addContainerGap().add(this.jPanelInfo, -1, 317, Short.MAX_VALUE).addContainerGap()));
        this.m_tpFileInfos.addTab("Info", this.m_pnlInfo);
        this.jPanelChangeLog.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanelChangeLog);
        this.m_tpFileInfos.addTab("Change Log", this.jScrollPane1);
        this.m_spSplitter.setRightComponent(this.m_tpFileInfos);
        this.m_lblName.setText("File Name:");
        this.m_lblType.setText("File Type:");
        this.m_cbType.setModel(new DefaultComboBoxModel<String>(new String[]{"All Files (*.*)", "xml Files", "Images"}));
        this.m_cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.m_cbTypeActionPerformed(evt);
            }
        });
        this.m_btnNewDir.setIcon(new ImageIcon(this.getClass().getResource("/jsvnbrowser/icons/folder-new.png")));
        this.m_btnNewDir.setToolTipText("Create New Folder");
        this.m_btnNewDir.setBorderPainted(false);
        this.m_btnNewDir.setPreferredSize(new Dimension(55, 22));
        this.m_btnNewDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.m_btnNewDirActionPerformed(evt);
            }
        });
        this.m_btnFileDelete.setIcon(new ImageIcon(this.getClass().getResource("/jsvnbrowser/icons/delete.png")));
        this.m_btnFileDelete.setToolTipText("Delete File or Folder");
        this.m_btnFileDelete.setBorderPainted(false);
        this.m_btnFileDelete.setPreferredSize(new Dimension(55, 22));
        this.m_btnFileDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.m_btnFileDeleteActionPerformed(evt);
            }
        });
        this.m_lblPath.setToolTipText("");
        this.m_btnHome.setIcon(new ImageIcon(this.getClass().getResource("/jsvnbrowser/icons/go-home.png")));
        this.m_btnHome.setToolTipText("Go Home");
        this.m_btnHome.setBorderPainted(false);
        this.m_btnHome.setPreferredSize(new Dimension(55, 22));
        this.m_btnHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.m_btnHomeActionPerformed(evt);
            }
        });
        this.m_btnAddFile.setIcon(new ImageIcon(this.getClass().getResource("/jsvnbrowser/icons/document-save-svn.png")));
        this.m_btnAddFile.setToolTipText("Add Local File to SVN Repository");
        this.m_btnAddFile.setBorderPainted(false);
        this.m_btnAddFile.setPreferredSize(new Dimension(55, 22));
        this.m_btnAddFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.m_btnAddFileActionPerformed(evt);
            }
        });
        this.jButton1.setText("show more");
        this.jButton1.setToolTipText("show 10 more LogEntries");
        this.jButton1.setPreferredSize(new Dimension(66, 22));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSVNBrowser.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.m_spSplitter, -1, 676, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.m_lblPath, -1, 357, Short.MAX_VALUE).add(18, 18, 18).add(this.jButton1, -2, 120, -2).add(35, 35, 35).add(this.m_btnDirUp, -2, 24, -2).addPreferredGap(0).add(this.m_btnNewDir, -2, 24, -2).addPreferredGap(0).add(this.m_btnAddFile, -2, 24, -2).add(8, 8, 8).add(this.m_btnFileDelete, -2, 24, -2).addPreferredGap(0).add(this.m_btnHome, -2, 24, -2)).add(1, layout.createSequentialGroup().add(layout.createParallelGroup(1, false).add(this.m_lblName, -1, -1, Short.MAX_VALUE).add(this.m_lblType, -2, 54, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.m_textField, -1, 498, Short.MAX_VALUE).add(this.m_cbType, 0, 498, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1).add(2, this.m_btnSelect, -2, 92, -2).add(2, this.m_btnCancel, -2, 92, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createParallelGroup(2).add(layout.createParallelGroup(1).add(this.m_btnFileDelete, -2, -1, -2).add(this.m_btnHome, -2, -1, -2).add(this.m_btnDirUp, -2, -1, -2).add(this.m_btnNewDir, -2, -1, -2).add(this.m_btnAddFile, -2, -1, -2)).add(this.jButton1, -2, -1, -2)).add(this.m_lblPath, -2, 22, -2)).addPreferredGap(0).add(this.m_spSplitter, -1, 378, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.m_btnSelect).add(this.m_lblName).add(this.m_textField, -2, 24, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.m_btnCancel).add(this.m_lblType).add(this.m_cbType, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void m_btnAddFileActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(this);
        File selFile = chooser.getSelectedFile();
        if (selFile != null) {
            StringBuffer contents = new StringBuffer();
            try {
                FileReader reader = new FileReader(selFile);
                while (reader.ready()) {
                    char c = (char)reader.read();
                    contents.append(c);
                }
                reader.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.setFileName(selFile.getName());
            this.m_treeSVNList.fileSave(contents.toString());
        }
    }

    private void m_cbTypeActionPerformed(ActionEvent evt) {
        this.selectedFileType = this.m_cbType.getSelectedItem().toString();
        this.m_treeSVNList.reloadTree();
    }

    private void m_tpFileInfosStateChanged(ChangeEvent evt) {
        if (this.m_tpFileInfos.getSelectedIndex() == 1 && this.fileInfo != null) {
            if (evt != null) {
                MAX_NUMBER_OF_LOG_ENTRIES = 10;
                this.jPanelChangeLog.removeAll();
                this.jPanelChangeLog.repaint();
            }
            JSVNFileInfo fInfo = this.fileInfo;
            GridBagLayout gbl = (GridBagLayout)this.jPanelChangeLog.getLayout();
            Collection logEntries = fInfo.logEntries;
            Object[] entries = logEntries.toArray();
            final String buttonPath = fInfo.filepath.substring(5);
            int numberOfShownEntries = this.jPanelChangeLog.getComponentCount() / 2;
            int counter = 1 + numberOfShownEntries;
            int temp = 0;
            if (logEntries.size() - MAX_NUMBER_OF_LOG_ENTRIES > 0 && numberOfShownEntries < logEntries.size()) {
                temp = logEntries.size() - MAX_NUMBER_OF_LOG_ENTRIES;
                this.jButton1.setVisible(true);
            }
            for (int i = temp; i < logEntries.size() - numberOfShownEntries; ++i) {
                Document doc;
                Node rootNode;
                final SVNLogEntry logEntry = (SVNLogEntry)entries[i];
                fInfo = this.m_treeSVNList.fileOpen(this.m_lblPath.getText(), logEntry.getRevision());
                ImageIcon icon = null;
                if (fInfo.filename.endsWith(".xml") && (rootNode = (doc = DOOCSParser.parseXmlStringBuffer(fInfo.buf, false)).getLastChild().getFirstChild()).getNodeName().equalsIgnoreCase("DOOCSLayeredPane")) {
                    icon = DOOCSParameter.getThumbnailIcon(doc);
                }
                if (fInfo.filename.endsWith(".gif") || fInfo.filename.endsWith(".bmp") || fInfo.filename.endsWith(".png") || fInfo.filename.endsWith(".jpg") || fInfo.filename.endsWith(".jpeg")) {
                    icon = new ImageIcon(fInfo.buf);
                }
                String tmp = "<html>revision: " + logEntry.getRevision();
                tmp = tmp + "<P>author: " + logEntry.getAuthor();
                tmp = tmp + "<P>date: " + logEntry.getDate();
                tmp = tmp + "<P>log message: " + logEntry.getMessage() + "</html>";
                JLabel label = new JLabel(tmp, icon, 2);
                label.setIconTextGap(10);
                label.setVerticalAlignment(1);
                label.setVerticalTextPosition(1);
                GridBagConstraints gbc = this.makegbc(0, logEntries.size() - i, 1, 1);
                gbc.weightx = 100.0;
                gbc.anchor = 16;
                gbc.fill = 1;
                gbl.setConstraints(label, gbc);
                this.jPanelChangeLog.add(label);
                JButton button = new JButton("Open");
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JSVNBrowser.this.openOldVersion(buttonPath, logEntry.getRevision());
                    }
                });
                gbc = this.makegbc(1, logEntries.size() - i, 1, 1);
                gbc.anchor = 12;
                gbl.setConstraints(button, gbc);
                this.jPanelChangeLog.add(button);
                ++counter;
            }
            this.jScrollPane1.validate();
            numberOfShownEntries = this.jPanelChangeLog.getComponentCount() / 2;
            if (numberOfShownEntries == logEntries.size()) {
                this.jButton1.setVisible(false);
                return;
            }
        } else {
            this.jButton1.setVisible(false);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.fileInfo = null;
    }

    private void m_btnCancelActionPerformed(ActionEvent evt) {
        this.fileInfo = null;
        this.dispose();
    }

    private void m_btnHomeActionPerformed(ActionEvent evt) {
        this.m_treeSVNList.goHome();
    }

    private void m_btnFileDeleteActionPerformed(ActionEvent evt) {
        this.m_treeSVNList.fileDelete();
    }

    private void m_btnSelectActionPerformed(ActionEvent evt) {
        if (this.dialogType == 1) {
            boolean OK = this.m_treeSVNList.fileSave(this.xmlsource);
            if (OK) {
                this.dispose();
            }
        } else if (this.fileInfo != null) {
            this.dispose();
        }
    }

    private void m_btnNewDirActionPerformed(ActionEvent evt) {
        this.m_treeSVNList.newDir();
    }

    private void m_btnDirUpActionPerformed(ActionEvent evt) {
        this.m_treeSVNList.dirUp();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        MAX_NUMBER_OF_LOG_ENTRIES += 10;
        this.m_tpFileInfosStateChanged(null);
    }

    private void initUserComponents() {
        this.m_treeSVNList.initTree();
        this.m_spSVNList.setViewportView(this.m_treeSVNList);
        this.jButton1.setVisible(false);
        this.setTitle("SVN Browser: " + StartParameters.getInstance().getSvnRepository());
    }

    public JSVNFileInfo showOpenDialog(JFrame frame) {
        if (this.m_treeSVNList.repository == null) {
            return null;
        }
        this.initComponents();
        this.initUserComponents();
        this.setLocationRelativeTo(frame);
        if (this.currentDirectory != null) {
            this.m_treeSVNList.openPath(this.currentDirectory);
        }
        this.setVisible(true);
        if (this.fileInfo != null) {
            return this.fileInfo;
        }
        return null;
    }

    public JSVNFileInfo showSaveDialog(JFrame frame, String source) {
        if (this.m_treeSVNList.repository == null) {
            return null;
        }
        this.initComponents();
        this.initUserComponents();
        this.setLocationRelativeTo(frame);
        if (this.currentDirectory != null) {
            this.m_treeSVNList.openPath(this.currentDirectory);
        }
        this.xmlsource = source;
        this.dialogType = 1;
        this.m_btnSelect.setText("SAVE");
        this.setVisible(true);
        return this.fileInfo;
    }

    public JSVNFileInfo saveFile(String source, String path, String versionDate) {
        if (this.m_treeSVNList.repository == null) {
            return null;
        }
        return this.m_treeSVNList.fileSaveTo(source, path, versionDate);
    }

    public JSVNFileInfo openFile(String filePath) {
        if (this.m_treeSVNList.repository == null) {
            return null;
        }
        return this.m_treeSVNList.fileOpen(filePath, -1L);
    }

    public JSVNFileInfo searchFile(String path, String filename) {
        JSVNFileInfo fInfo = this.m_treeSVNList.fileOpen(path + filename, -1L);
        if (!filename.endsWith(".xml") && path.endsWith("images/") && fInfo != null) {
            return fInfo;
        }
        if (filename.endsWith(".xml") && !path.endsWith("images/") && fInfo != null) {
            return fInfo;
        }
        Vector directories = this.m_treeSVNList.getDirectories(path);
        for (int i = 0; i < directories.size() && (fInfo = this.searchFile(path + directories.get(i), filename)) == null; ++i) {
        }
        return fInfo;
    }

    public void fileSelected(JSVNFileInfo fInfo) {
        this.m_tpFileInfos.setSelectedIndex(0);
        this.fileInfo = fInfo;
        if (fInfo == null) {
            this.jLabel1.setText(null);
            this.jLabel2.setIcon(null);
        } else {
            this.m_textField.setText(fInfo.filename);
            this.m_lblPath.setText(fInfo.filepath.substring(5));
            if (fInfo.filename.endsWith(".xml")) {
                Document doc = DOOCSParser.parseXmlStringBuffer(fInfo.buf, false);
                Node rootNode = doc.getLastChild();
                if ((rootNode = rootNode.getFirstChild()).getNodeName().equalsIgnoreCase("DOOCSLayeredPane")) {
                    String author = null;
                    String description = null;
                    NodeList list = rootNode.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node subNode = list.item(i);
                        String nodeName = subNode.getNodeName();
                        if (nodeName.equalsIgnoreCase("author") && subNode.getFirstChild() != null) {
                            author = subNode.getFirstChild().getNodeValue();
                        }
                        if (!nodeName.equalsIgnoreCase("description") || subNode.getFirstChild() == null) continue;
                        description = subNode.getFirstChild().getNodeValue();
                    }
                    String text = "<html><FONT COLOR=BLUE>Version:</FONT> " + fInfo.revision + "<P><FONT COLOR=BLUE>Date:</FONT> " + fInfo.date + "<P><FONT COLOR=BLUE>Size:</FONT> " + fInfo.size;
                    if (author != null) {
                        text = text + "<P><FONT COLOR=BLUE>Author:</FONT> " + author;
                    }
                    if (fInfo.author != null) {
                        text = text + "<P><FONT COLOR=BLUE>saved by:</FONT> " + fInfo.author;
                    }
                    if (description != null) {
                        text = text + "<P><FONT COLOR=BLUE>Description:</FONT> " + description;
                    }
                    text = text + "</html>";
                    this.jLabel1.setText(text);
                    ImageIcon icon = DOOCSParameter.getThumbnailIcon(doc);
                    this.jLabel2.setIcon(icon);
                }
            }
            if (fInfo.filename.endsWith(".gif") || fInfo.filename.endsWith(".bmp") || fInfo.filename.endsWith(".png") || fInfo.filename.endsWith(".jpg") || fInfo.filename.endsWith(".jpeg")) {
                String text = "<html><FONT COLOR=BLUE>Version:</FONT> " + fInfo.revision + "<P><FONT COLOR=BLUE>Date:</FONT> " + fInfo.date + "<P><FONT COLOR=BLUE>Size:</FONT> " + fInfo.size;
                if (fInfo.author != null) {
                    text = text + "<P><FONT COLOR=BLUE>saved by:</FONT> " + fInfo.author;
                }
                text = text + "</html>";
                this.jLabel1.setText(text);
                this.jLabel2.setIcon(new ImageIcon(fInfo.buf));
            }
        }
    }

    private GridBagConstraints makegbc(int x, int y, int width, int height) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.insets = new Insets(5, 5, 5, 5);
        return gbc;
    }

    private void openOldVersion(String buttonPath, long revision) {
        this.fileInfo = this.m_treeSVNList.fileOpen(buttonPath, revision);
        this.dispose();
    }

    public void updateLabels(String path) {
        this.m_textField.setText(null);
        this.m_lblPath.setText(path);
    }

    public void setFileName(String name) {
        this.m_textField.setText(name);
    }

    public String getFileName() {
        String text = this.m_textField.getText();
        if (text != null && !text.contains(".") && !text.endsWith(".xml")) {
            text = text + ".xml";
        }
        return text;
    }

    public void setCurrentDirectory(String path) {
        if (path != null && path.length() > 5) {
            this.currentDirectory = path.substring(5);
        }
    }
}

