/*
 * Decompiled with CFR 0.152.
 */
package editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GridSizeEditor
extends JDialog {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    public JButton jButtonCancel;
    public JButton jButtonOK;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public GridSizeEditor() {
        this.initComponents();
    }

    public void setText(String text) {
        int komma = text.indexOf(",");
        String gridx = text.substring(0, komma);
        String gridy = text.substring(komma + 1);
        this.jTextField1.setText(gridx);
        this.jTextField2.setText(gridy);
    }

    public String getText() {
        String text = this.jTextField1.getText() + "," + this.jTextField2.getText();
        if (text.matches("^\\d{1,3},\\d{1,3}$")) {
            return text;
        }
        if (text.matches("^[0-9]*\\.?[0-9]*,[0-9]*\\.?[0-9]*$")) {
            return text;
        }
        return null;
    }

    public void setGridX(float gridx) {
        this.jTextField1.setText("" + gridx);
    }

    public void setGridY(float gridy) {
        this.jTextField2.setText("" + gridy);
    }

    public float getGridX() {
        return Float.parseFloat(this.jTextField1.getText());
    }

    public float getGridY() {
        return Float.parseFloat(this.jTextField2.getText());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel1.setPreferredSize(new Dimension(200, 120));
        this.jPanel2 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jPanel1.setLayout(new GridLayout(2, 2, 10, 40));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), "Grid Size Editor"));
        this.jLabel1.setText("  Grid X:");
        this.jPanel1.add(this.jLabel1);
        this.jTextField1.setText("10");
        this.jPanel1.add(this.jTextField1);
        this.jLabel2.setText("  Grid Y:");
        this.jPanel1.add(this.jLabel2);
        this.jTextField2.setText("10");
        this.jPanel1.add(this.jTextField2);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jButtonOK.setText("OK");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jPanel2.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jPanel2.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }
}

