/*
 * Decompiled with CFR 0.152.
 */
package editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TopBar
extends JPanel {
    JPanel contentPanel;
    private static final int BAR_HEIGHT = 17;
    private static final int TOP_OFFSET = 4;
    private static final int RIGHT_OFFSET = 6;
    protected JLabel titleLabel;
    int leftComponentWidth;

    public TopBar(String title) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 23));
        this.titleLabel = new JLabel(title);
        this.add((Component)this.titleLabel, "West");
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.leftComponentWidth = this.titleLabel.getMinimumSize().width + 15;
    }

    public void setTitle(String title, Icon icon) {
        this.titleLabel.setText(title);
        this.titleLabel.setIcon(icon);
        this.leftComponentWidth = this.titleLabel.getMinimumSize().width + 15;
        this.repaint();
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int BAR_WIDTH;
        super.paintComponent(g);
        int y = 0;
        g.setColor(new Color(221, 221, 220));
        g.drawLine(0, y, this.getWidth(), y);
        g.setColor(new Color(233, 231, 216));
        g.drawLine(0, ++y, this.getWidth(), y);
        g.setColor(new Color(233, 232, 218));
        g.drawLine(0, ++y, this.getWidth(), y);
        y = this.getHeight() - 4;
        g.setColor(new Color(233, 231, 217));
        g.drawLine(0, y, this.getWidth(), y);
        g.setColor(new Color(218, 215, 201));
        g.drawLine(0, ++y, this.getWidth(), y);
        g.setColor(new Color(196, 194, 183));
        g.drawLine(0, ++y, this.getWidth(), y);
        g.setColor(new Color(156, 154, 140));
        g.drawLine(0, ++y, this.getWidth(), y);
        int rowDiff = 3;
        int columnDiff = 3;
        for (int i = BAR_WIDTH = this.getWidth() - 6; i > this.leftComponentWidth; i -= columnDiff) {
            for (int j = 4; j < 17; j += rowDiff) {
                if (j % 2 == 0) {
                    this.draw3dSquare(g, i, j);
                    continue;
                }
                this.draw3dSquare(g, i + columnDiff / 2, j);
            }
        }
    }

    private void draw3dSquare(Graphics g, int x, int y) {
        Color oldColor = g.getColor();
        g.fillRect(x, y, 1, 1);
        g.setColor(Color.WHITE);
        g.fillRect(x - 1, y - 1, 1, 1);
        g.setColor(oldColor);
    }
}

