/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSAlive;
import DOOCSComponents.DOOCSAudio;
import DOOCSComponents.DOOCSButton;
import DOOCSComponents.DOOCSCameraImage;
import DOOCSComponents.DOOCSCheckBox;
import DOOCSComponents.DOOCSColouredIndicator;
import DOOCSComponents.DOOCSComboBox;
import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSDeviceTree;
import DOOCSComponents.DOOCSDial;
import DOOCSComponents.DOOCSDynamicList;
import DOOCSComponents.DOOCSGroup;
import DOOCSComponents.DOOCSIcon;
import DOOCSComponents.DOOCSIf;
import DOOCSComponents.DOOCSIfCase;
import DOOCSComponents.DOOCSIncludeComponent;
import DOOCSComponents.DOOCSLabel;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSLine;
import DOOCSComponents.DOOCSLocationChooser;
import DOOCSComponents.DOOCSLogicGroup;
import DOOCSComponents.DOOCSOval;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSPlugin;
import DOOCSComponents.DOOCSProgressBar;
import DOOCSComponents.DOOCSPropertiesTable;
import DOOCSComponents.DOOCSRect;
import DOOCSComponents.DOOCSSlider;
import DOOCSComponents.DOOCSStatusRegister;
import DOOCSComponents.DOOCSSwitch;
import DOOCSComponents.DOOCSSwitchCase;
import DOOCSComponents.DOOCSTab;
import DOOCSComponents.DOOCSTabbedPane;
import DOOCSComponents.DOOCSTextArea;
import DOOCSComponents.DOOCSTextField;
import DOOCSComponents.DOOCSTimerGroup;
import DOOCSComponents.DOOCSToggleButton;
import DOOCSComponents.DOOCSTriangle;
import DOOCSComponents.DOOCSValue;
import DOOCSComponents.ShowException;
import DOOCSPlot.DOOCSPlotHist;
import DOOCSPlot.DOOCSPlotLocation;
import DOOCSPlot.DOOCSPlotSpectrum;
import DOOCSPlot.DOOCSPlotXAxis;
import DOOCSPlot.DOOCSPlotXY;
import DOOCSPlot.DOOCSPlotYAxis;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import editor.EditorPanelPopup;
import editor.StartParameters;
import editor.events.DOOCSAddEvent;
import editor.events.DOOCSButtonPressedEvent;
import editor.events.DOOCSOpenIncludeComponentEvent;
import editor.events.DOOCSSelectEvent;
import editor.events.DOOCSUpdateEditorEvent;
import editor.events.DOOCSUpdateTreeEvent;
import editor.events.UNDOAddComponentEvent;
import editor.events.UNDOGroupComponentsEvent;
import editor.events.UNDOPropertyChangeEvent;
import editor.events.UNDORemoveComponentEvent;
import editor.undo.AddRemoveComp;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.MouseInputListener;
import jsvnbrowser.JSVNFileInfo;
import layoutmanager.ScaleConstraints;

public class EditorPanel
extends DOOCSLayeredPane
implements MouseInputListener,
DOOCSSelectEvent,
DOOCSUpdateEditorEvent {
    private Cursor defaultCursor = new Cursor(0);
    private Cursor moveCursor = new Cursor(13);
    protected Vector<Component> selection;
    protected Vector<DOOCSAddEvent> addListener;
    protected Vector<DOOCSSelectEvent> selectionListener;
    protected Vector<DOOCSUpdateTreeEvent> updateListener;
    protected Vector<DOOCSButtonPressedEvent> buttonPressedListener;
    protected Vector<UNDOAddComponentEvent> undoAddListener;
    protected Vector<UNDORemoveComponentEvent> undoRemoveListener;
    protected Vector<UNDOGroupComponentsEvent> undoGroupListener;
    protected Vector<UNDOPropertyChangeEvent> undoPropertyChangeListener;
    protected Vector<DOOCSOpenIncludeComponentEvent> openIncludeComponentListener;
    private boolean mouseSelection = false;
    private int actX;
    private int actY;
    private int startDragX;
    private int startDragY;
    private Component selectionComponent;
    private Component draggedComponent;
    protected Vector<Component> cutComponent;
    private int compX;
    private int compY;
    private int compW;
    private int compH;
    public boolean add = false;
    private DOOCSComponent addComponent = null;
    private static final short NW = 1;
    private static final short N = 2;
    private static final short NO = 3;
    private static final short O = 4;
    private static final short SO = 5;
    private static final short S = 6;
    private static final short SW = 7;
    private static final short W = 8;
    private short resizeDirection;
    protected boolean shiftPressed = false;
    protected boolean controlPressed = false;
    private boolean move = false;
    private boolean resize = false;
    private boolean showAllGrid = false;
    private DOOCSLayeredPane lastPaneWithGrid = this;
    private int zoomFactor = 100;
    private boolean active = true;
    private boolean transparency = false;
    private boolean isSelectedLayeredPane = false;
    private boolean isSelectedDynamicList = false;

    public EditorPanel() {
        this.setSize(500, 600);
        this.setPreferredSize(new Dimension(500, 600));
        this.setInitialBounds(new Rectangle(0, 0, 500, 600));
        this.editorPanelType = true;
        this.selection = new Vector();
        this.addListener = new Vector();
        this.selectionListener = new Vector();
        this.cutComponent = new Vector();
        this.updateListener = new Vector();
        this.buttonPressedListener = new Vector();
        this.undoAddListener = new Vector();
        this.undoRemoveListener = new Vector();
        this.undoGroupListener = new Vector();
        this.undoPropertyChangeListener = new Vector();
        this.openIncludeComponentListener = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int i;
                if (e.getKeyCode() == 16) {
                    for (i = 0; i < EditorPanel.this.buttonPressedListener.size(); ++i) {
                        EditorPanel.this.buttonPressedListener.get(i).DOOCSShiftPressed(true);
                    }
                    EditorPanel.this.shiftPressed = true;
                }
                if (e.getKeyCode() == 17) {
                    for (i = 0; i < EditorPanel.this.buttonPressedListener.size(); ++i) {
                        EditorPanel.this.buttonPressedListener.get(i).DOOCSControlPressed(true);
                    }
                    EditorPanel.this.controlPressed = true;
                }
                if (e.getKeyCode() == 38) {
                    EditorPanel.this.doMove(0, -1);
                }
                if (e.getKeyCode() == 40) {
                    EditorPanel.this.doMove(0, 1);
                }
                if (e.getKeyCode() == 37) {
                    EditorPanel.this.doMove(-1, 0);
                }
                if (e.getKeyCode() == 39) {
                    EditorPanel.this.doMove(1, 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int i;
                if (e.getKeyCode() == 16) {
                    for (i = 0; i < EditorPanel.this.buttonPressedListener.size(); ++i) {
                        EditorPanel.this.buttonPressedListener.get(i).DOOCSShiftPressed(false);
                    }
                    EditorPanel.this.shiftPressed = false;
                }
                if (e.getKeyCode() == 17) {
                    for (i = 0; i < EditorPanel.this.buttonPressedListener.size(); ++i) {
                        EditorPanel.this.buttonPressedListener.get(i).DOOCSControlPressed(false);
                    }
                    EditorPanel.this.controlPressed = false;
                }
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                    DOOCSComponent[] dummy = new DOOCSComponent[]{};
                    for (int i2 = 0; i2 < EditorPanel.this.selectionListener.size(); ++i2) {
                        EditorPanel.this.selectionListener.get(i2).DOOCSObjectSelected(EditorPanel.this.selection.toArray(dummy));
                    }
                }
            }
        });
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        ((DOOCSComponent)((Object)comp)).addDOOCSMouseListener(this);
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        xmlStructure.append("<jdddPanel>");
        xmlStructure.append(super.getDOOCSXmlStructure());
        xmlStructure.append("</jdddPanel>");
        return xmlStructure;
    }

    public StringBuffer getDOOCSXmlStructureWithThumbnail() {
        StringBuffer xmlStructure = new StringBuffer("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        xmlStructure.append("<jdddPanel>");
        xmlStructure.append(super.getDOOCSXmlStructure());
        try {
            EditorPanel gcomp = this;
            int thumbWidth = Math.round((float)gcomp.getSize().width / 10.0f + 0.5f);
            int thumbHeight = Math.round((float)gcomp.getSize().height / 10.0f + 0.5f);
            BufferedImage bufferedImage = new BufferedImage(thumbWidth, thumbHeight, 1);
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.scale(0.1, 0.1);
            ((Component)gcomp).paint(g2d);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            baos.flush();
            byte[] resultImageAsRawBytes = baos.toByteArray();
            String encodedString = Base64.encode(resultImageAsRawBytes);
            xmlStructure.append("<thumbnail>" + encodedString + "</thumbnail>\n");
            baos.close();
        }
        catch (IOException e) {
            new ShowException(null, "EditorPanel->getDOOCSXmlStructure", e);
        }
        xmlStructure.append("</jdddPanel>");
        return xmlStructure;
    }

    public ImageIcon getDOOCSThumbnail() {
        EditorPanel gcomp = this;
        int thumbWidth = Math.round((float)gcomp.getSize().width / 10.0f + 0.5f);
        int thumbHeight = Math.round((float)gcomp.getSize().height / 10.0f + 0.5f);
        BufferedImage bufferedImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.scale(0.1, 0.1);
        ((Component)gcomp).paint(g2d);
        return new ImageIcon(bufferedImage);
    }

    public void setShowAllGrid(boolean grid) {
        this.showAllGrid = grid;
        if (!grid) {
            this.setShowGrid(false);
            this.lastPaneWithGrid.setShowGrid(false);
        } else if (this.selection.size() == 0) {
            this.setShowGrid(true);
            this.lastPaneWithGrid = this;
        } else {
            Container parentComponent = this.selection.get(0).getParent();
            if (parentComponent instanceof JPanel) {
                parentComponent = this;
            }
            if (parentComponent instanceof DOOCSLayeredPane) {
                ((DOOCSLayeredPane)parentComponent).setShowGrid(true);
                this.lastPaneWithGrid = (DOOCSLayeredPane)parentComponent;
            }
            if (parentComponent instanceof DOOCSTabbedPane) {
                ((DOOCSTabbedPane)parentComponent).setShowGrid(true);
                this.lastPaneWithGrid = (DOOCSLayeredPane)this.selection.get(0);
            }
        }
    }

    public boolean getShowAllGrid() {
        return this.showAllGrid;
    }

    public void setActive(boolean act) {
        this.active = act;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setZoomFactor(int factor) {
        float newFactor = (float)factor / (float)this.zoomFactor;
        this.zoomFactor = factor;
        Dimension dim = new Dimension((int)((float)this.getBounds().width * newFactor), (int)((float)this.getBounds().height * newFactor));
        this.setPreferredSize(dim);
        this.setSize(dim);
        this.doZoom(this, newFactor, false);
    }

    private void doZoom(Container comp, float newFactor, boolean includeComponentIndicator) {
        if (!(comp.getComponentCount() <= 0 || comp instanceof DOOCSDial || comp instanceof DOOCSDeviceTree || comp instanceof DOOCSPlugin || comp instanceof DOOCSSlider || comp instanceof JComboBox || comp instanceof DOOCSLocationChooser || comp instanceof DOOCSTextArea || comp instanceof DOOCSPropertiesTable)) {
            if (comp instanceof DOOCSIncludeComponent) {
                includeComponentIndicator = true;
            }
            if (comp instanceof DOOCSDynamicList) {
                comp = ((DOOCSDynamicList)comp).layeredPane;
            }
            for (int i = 0; i < comp.getComponentCount(); ++i) {
                Component childComp = comp.getComponent(i);
                int x = Math.round((float)childComp.getX() * newFactor);
                int y = Math.round((float)childComp.getY() * newFactor);
                int width = Math.round((float)childComp.getWidth() * newFactor);
                int height = Math.round((float)childComp.getHeight() * newFactor);
                childComp.setBounds(x, y, width, height);
                ((DOOCSComponent)((Object)childComp)).setInitialBounds(new Rectangle(x, y, width, height));
                if (!(includeComponentIndicator || childComp instanceof DOOCSDial || childComp instanceof DOOCSSlider || childComp instanceof DOOCSPlugin || childComp instanceof JComboBox || childComp instanceof DOOCSTextArea || childComp instanceof DOOCSPropertiesTable || childComp instanceof DOOCSDeviceTree)) {
                    int newFontSize = Math.round((float)childComp.getFont().getSize() * newFactor);
                    String fontString = childComp.getFont().getName() + "," + childComp.getFont().getStyle() + "," + newFontSize;
                    if (childComp instanceof DOOCSButton || childComp instanceof DOOCSToggleButton || childComp instanceof DOOCSCheckBox || childComp instanceof DOOCSDial || childComp instanceof JComboBox || childComp instanceof DOOCSLabel || childComp instanceof DOOCSProgressBar || childComp instanceof DOOCSSlider || childComp instanceof DOOCSTextArea || childComp instanceof DOOCSPropertiesTable || childComp instanceof DOOCSDeviceTree || childComp instanceof DOOCSValue) {
                        ((DOOCSComponent)((Object)childComp)).setDOOCSParameter("textFont", fontString);
                    }
                    if (childComp instanceof DOOCSPlotXAxis) {
                        ((DOOCSComponent)((Object)childComp)).setDOOCSParameter("xTextFont", fontString);
                    }
                    if (childComp instanceof DOOCSPlotYAxis) {
                        ((DOOCSComponent)((Object)childComp)).setDOOCSParameter("yTextFont", fontString);
                    }
                }
                this.doZoom((Container)childComp, newFactor, includeComponentIndicator);
            }
        }
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void doDelete() {
        if (this.selection.size() > 0) {
            int i;
            Vector<AddRemoveComp> changeRemove = new Vector<AddRemoveComp>();
            for (i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i) instanceof EditorPanel || this.selection.get(i).getParent() instanceof DOOCSIf || this.selection.get(i) instanceof DOOCSTab && ((DOOCSTabbedPane)this.selection.get(i).getParent()).getTabCount() < 3) continue;
                DOOCSComponent parent = (DOOCSComponent)((Object)this.selection.get(i).getParent());
                changeRemove.add(new AddRemoveComp(parent, this.selection.get(i), null));
                ((DOOCSComponent)((Object)this.selection.get(i))).setRunMode(false);
                this.removeComponent(this.selection.get(i), this.selection.get(i).getParent());
            }
            for (int j = 0; j < this.undoRemoveListener.size(); ++j) {
                this.undoRemoveListener.get(j).DOOCSRemoveComponent(changeRemove);
            }
            this.selection.clear();
            this.repaint();
            for (i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            for (int i2 = 0; i2 < this.selectionListener.size(); ++i2) {
                this.selectionListener.get(i2).DOOCSObjectSelected(this.selection.toArray(dummy));
            }
        }
    }

    public void doDuplicate() {
        if (this.selection.size() > 0) {
            int i;
            Vector<AddRemoveComp> changeAdd = new Vector<AddRemoveComp>();
            this.cutComponent.clear();
            for (i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i) instanceof EditorPanel || this.selection.get(i) instanceof DOOCSIfCase || this.selection.get(i) instanceof DOOCSTab || this.selection.get(i) instanceof DOOCSSwitchCase) continue;
                this.selectionComponent = this.selection.get(i).getParent();
                DOOCSComponent comp = (DOOCSComponent)((Object)this.selection.get(i));
                DOOCSComponent newcomp = this.doClone(comp);
                newcomp.setRunMode(false);
                this.cutComponent.add((JComponent)((Object)newcomp));
                int x = this.cutComponent.get(i).getX();
                int y = this.cutComponent.get(i).getY();
                int width = this.cutComponent.get(i).getWidth();
                int height = this.cutComponent.get(i).getHeight();
                this.cutComponent.get(i).setName(null);
                ScaleConstraints constr = new ScaleConstraints(x + Math.round(((DOOCSLayeredPane)this.selectionComponent).gridX), y + Math.round(((DOOCSLayeredPane)this.selectionComponent).gridY), width, height);
                ((DOOCSComponent)((Object)this.selectionComponent)).add(this.cutComponent.get(i), constr);
                DOOCSLayeredPane parent = (DOOCSLayeredPane)this.cutComponent.get(i).getParent();
                changeAdd.add(new AddRemoveComp(parent, this.cutComponent.get(i), constr));
            }
            this.selection.clear();
            for (i = 0; i < this.cutComponent.size(); ++i) {
                this.selection.add(this.cutComponent.get(i));
            }
            this.doMoveToFront();
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            for (int i2 = 0; i2 < this.selectionListener.size(); ++i2) {
                this.selectionListener.get(i2).DOOCSObjectSelected(this.selection.toArray(dummy));
            }
            for (int j = 0; j < this.undoAddListener.size(); ++j) {
                this.undoAddListener.get(j).DOOCSAddComponent(changeAdd);
            }
        }
    }

    public void doCut() {
        this.cutComponent.clear();
        if (this.selection.size() > 0) {
            int i;
            Vector<AddRemoveComp> changeRemove = new Vector<AddRemoveComp>();
            for (i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i) instanceof EditorPanel) continue;
                this.cutComponent.add(this.selection.get(i));
                DOOCSLayeredPane parent = (DOOCSLayeredPane)this.selection.get(i).getParent();
                changeRemove.add(new AddRemoveComp(parent, this.selection.get(i), null));
                ((DOOCSComponent)((Object)this.selection.get(i))).setRunMode(false);
                this.removeComponent(this.selection.get(i), this.selection.get(i).getParent());
            }
            for (int j = 0; j < this.undoRemoveListener.size(); ++j) {
                this.undoRemoveListener.get(j).DOOCSRemoveComponent(changeRemove);
            }
            this.selection.clear();
            this.repaint();
            for (i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            for (int i2 = 0; i2 < this.selectionListener.size(); ++i2) {
                this.selectionListener.get(i2).DOOCSObjectSelected(this.selection.toArray(dummy));
            }
        }
    }

    public void doCopy() {
        this.cutComponent.clear();
        if (this.selection.size() > 0) {
            for (int i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i) instanceof EditorPanel || this.selection.get(i) instanceof DOOCSIfCase || this.selection.get(i) instanceof DOOCSTab || this.selection.get(i) instanceof DOOCSSwitchCase) continue;
                DOOCSComponent comp = (DOOCSComponent)((Object)this.selection.get(i));
                DOOCSComponent newcomp = this.doClone(comp);
                newcomp.setRunMode(false);
                this.cutComponent.add((JComponent)((Object)newcomp));
            }
            this.selection.clear();
        }
    }

    public DOOCSComponent doClone(DOOCSComponent comp) {
        int j;
        DOOCSComponent newcomp = null;
        if (comp instanceof DOOCSLabel) {
            newcomp = new DOOCSLabel();
        }
        if (comp instanceof DOOCSValue) {
            newcomp = new DOOCSValue();
        }
        if (comp instanceof DOOCSDial) {
            newcomp = new DOOCSDial();
        }
        if (comp instanceof DOOCSCheckBox) {
            newcomp = new DOOCSCheckBox();
        }
        if (comp instanceof DOOCSProgressBar) {
            newcomp = new DOOCSProgressBar();
        }
        if (comp instanceof DOOCSSlider) {
            newcomp = new DOOCSSlider();
        }
        if (comp instanceof DOOCSButton) {
            newcomp = new DOOCSButton();
        }
        if (comp instanceof DOOCSToggleButton) {
            newcomp = new DOOCSToggleButton();
        }
        if (comp instanceof DOOCSPlotSpectrum) {
            newcomp = new DOOCSPlotSpectrum();
        }
        if (comp instanceof DOOCSPlotHist) {
            newcomp = new DOOCSPlotHist();
        }
        if (comp instanceof DOOCSPlotLocation) {
            newcomp = new DOOCSPlotLocation();
        }
        if (comp instanceof DOOCSPlotXY) {
            newcomp = new DOOCSPlotXY();
        }
        if (comp instanceof DOOCSIcon) {
            newcomp = new DOOCSIcon();
        }
        if (comp instanceof DOOCSCameraImage) {
            newcomp = new DOOCSCameraImage();
        }
        if (comp instanceof DOOCSTextField) {
            newcomp = new DOOCSTextField();
        }
        if (comp instanceof DOOCSTextArea) {
            newcomp = new DOOCSTextArea();
        }
        if (comp instanceof DOOCSPropertiesTable) {
            newcomp = new DOOCSPropertiesTable();
        }
        if (comp instanceof DOOCSDeviceTree) {
            newcomp = new DOOCSDeviceTree();
        }
        if (comp instanceof DOOCSDynamicList) {
            newcomp = new DOOCSDynamicList();
        }
        if (comp instanceof DOOCSAlive) {
            newcomp = new DOOCSAlive();
        }
        if (comp instanceof DOOCSAudio) {
            newcomp = new DOOCSAudio();
        }
        if (comp instanceof DOOCSLine) {
            newcomp = new DOOCSLine();
        }
        if (comp instanceof DOOCSRect) {
            newcomp = new DOOCSRect();
        }
        if (comp instanceof DOOCSTriangle) {
            newcomp = new DOOCSTriangle();
        }
        if (comp instanceof DOOCSOval) {
            newcomp = new DOOCSOval();
        }
        if (comp instanceof DOOCSStatusRegister) {
            newcomp = new DOOCSStatusRegister();
        }
        if (comp instanceof DOOCSColouredIndicator) {
            newcomp = new DOOCSColouredIndicator();
        }
        if (comp instanceof DOOCSComboBox) {
            newcomp = new DOOCSComboBox();
        }
        if (comp instanceof DOOCSLocationChooser) {
            newcomp = new DOOCSLocationChooser();
        }
        if (comp instanceof DOOCSSwitch) {
            newcomp = new DOOCSSwitch();
        }
        if (comp instanceof DOOCSSwitchCase) {
            newcomp = new DOOCSSwitchCase();
            newcomp.setName(comp.getName());
        }
        if (comp instanceof DOOCSIfCase) {
            newcomp = new DOOCSIfCase();
            newcomp.setName(comp.getName());
        }
        if (comp instanceof DOOCSIf) {
            newcomp = new DOOCSIf();
        }
        if (comp instanceof DOOCSTabbedPane) {
            newcomp = new DOOCSTabbedPane();
        }
        if (comp instanceof DOOCSTab) {
            newcomp = new DOOCSTab();
        }
        if (comp instanceof DOOCSIncludeComponent) {
            newcomp = new DOOCSIncludeComponent();
        }
        if (comp instanceof DOOCSGroup && !(comp instanceof DOOCSLogicGroup) && !(comp instanceof DOOCSTimerGroup)) {
            newcomp = new DOOCSGroup();
        }
        if (comp instanceof DOOCSLogicGroup) {
            newcomp = new DOOCSLogicGroup();
        }
        if (comp instanceof DOOCSTimerGroup) {
            newcomp = new DOOCSTimerGroup();
        }
        if (!(!(comp instanceof DOOCSLayeredPane) || comp instanceof DOOCSGroup || comp instanceof DOOCSAlive || comp instanceof DOOCSIf || comp instanceof DOOCSIfCase || comp instanceof DOOCSSwitch || comp instanceof DOOCSSwitchCase || comp instanceof DOOCSIncludeComponent || comp instanceof DOOCSTab)) {
            newcomp = new DOOCSLayeredPane();
        }
        if (comp instanceof DOOCSPlugin) {
            String pluginPath = StartParameters.getInstance().getPluginPath();
            try {
                if (pluginPath != null && pluginPath.length() > 0) {
                    URLClassLoader newCL = StartParameters.getInstance().getClassLoader();
                    Class<?> cl = newCL.loadClass(comp.getClass().getName());
                    newcomp = (DOOCSComponent)cl.newInstance();
                }
            }
            catch (ClassNotFoundException ex) {
                System.out.println("EditorPanel: " + ex);
            }
            catch (InstantiationException ex) {
                System.out.println("EditorPanel: " + ex);
            }
            catch (IllegalAccessException ex) {
                System.out.println("EditorPanel: " + ex);
            }
        }
        DOOCSParameter[] paramList = comp.getDOOCSParameterList();
        for (j = 0; j < paramList.length; ++j) {
            String param = paramList[j].parameter;
            String value = null;
            if (comp.getDOOCSParameter(param) != null) {
                value = comp.getDOOCSParameter(param).toString();
            }
            if (value == null) continue;
            newcomp.setDOOCSParameter(param, value);
        }
        EditorPanel.resetInitialBounds((Component)((Object)newcomp));
        if (!(comp.getComponentCount() <= 0 || comp instanceof DOOCSDial || comp instanceof DOOCSSlider || comp instanceof DOOCSPlugin || comp instanceof JComboBox || comp instanceof DOOCSLocationChooser || comp instanceof DOOCSTextArea || comp instanceof DOOCSPropertiesTable || comp instanceof DOOCSDeviceTree)) {
            if (comp instanceof DOOCSDynamicList) {
                comp = ((DOOCSDynamicList)comp).layeredPane;
            }
            for (j = 0; j < comp.getComponentCount(); ++j) {
                DOOCSComponent childComp = this.doClone((DOOCSComponent)((Object)comp.getComponent(j)));
                int x = childComp.getX();
                int y = childComp.getY();
                int width = childComp.getWidth();
                int height = childComp.getHeight();
                ScaleConstraints constr = new ScaleConstraints(x, y, width, height);
                newcomp.add((JComponent)((Object)childComp), constr);
                if (!(childComp instanceof DOOCSTab)) continue;
                int tabIndex = ((DOOCSTabbedPane)newcomp).getTabCount() - 1;
                String tabTitle = null;
                if (childComp.getDOOCSParameter("title") != null) {
                    tabTitle = childComp.getDOOCSParameter("title").toString();
                }
                ((DOOCSTabbedPane)newcomp).setTitleAt(tabIndex, tabTitle);
            }
        }
        return newcomp;
    }

    public void doPaste() {
        if (this.selectionComponent instanceof DOOCSTabbedPane) {
            this.selectionComponent = ((DOOCSTabbedPane)this.selectionComponent).getSelectedComponent();
        }
        if (this.selectionComponent instanceof DOOCSDynamicList) {
            this.selectionComponent = ((DOOCSDynamicList)this.selectionComponent).layeredPane;
        }
        if (this.selectionComponent instanceof DOOCSIncludeComponent) {
            this.selectionComponent = this.selectionComponent.getParent();
        }
        if (!(this.selectionComponent instanceof DOOCSLayeredPane)) {
            this.selectionComponent = DOOCSParameter.getParentLayeredPane((DOOCSComponent)((Object)this.selectionComponent));
        }
        if (this.cutComponent.size() > 0) {
            int i;
            int x = 0;
            int y = 0;
            if (this.selectionComponent.getMousePosition() != null) {
                x = this.selectionComponent.getMousePosition().x;
                y = this.selectionComponent.getMousePosition().y;
            }
            if (this.getShowAllGrid()) {
                x = Math.round((float)Math.round((float)x / ((DOOCSLayeredPane)this.selectionComponent).gridX) * ((DOOCSLayeredPane)this.selectionComponent).gridX);
                y = Math.round((float)Math.round((float)y / ((DOOCSLayeredPane)this.selectionComponent).gridY) * ((DOOCSLayeredPane)this.selectionComponent).gridY);
            }
            int ulx = -1;
            int uly = -1;
            int lrx = -1;
            int lry = -1;
            for (int i2 = 0; i2 < this.cutComponent.size(); ++i2) {
                if (ulx == -1 || this.cutComponent.get(i2).getX() < ulx) {
                    ulx = this.cutComponent.get(i2).getX();
                }
                if (uly == -1 || this.cutComponent.get(i2).getY() < uly) {
                    uly = this.cutComponent.get(i2).getY();
                }
                if (this.cutComponent.get(i2).getX() + this.cutComponent.get(i2).getWidth() > lrx) {
                    lrx = this.cutComponent.get(i2).getX() + this.cutComponent.get(i2).getWidth();
                }
                if (this.cutComponent.get(i2).getY() + this.cutComponent.get(i2).getHeight() <= lry) continue;
                lry = this.cutComponent.get(i2).getY() + this.cutComponent.get(i2).getHeight();
            }
            int w = lrx - ulx;
            int h = lry - uly;
            this.selection.clear();
            Vector<AddRemoveComp> changeAdd = new Vector<AddRemoveComp>();
            for (i = this.cutComponent.size() - 1; i >= 0; --i) {
                int width = this.cutComponent.get(i).getWidth();
                int height = this.cutComponent.get(i).getHeight();
                int posx = x + this.cutComponent.get(i).getX() - ulx;
                int posy = y + this.cutComponent.get(i).getY() - uly;
                if (x + w > this.selectionComponent.getWidth()) {
                    posx = this.selectionComponent.getWidth() + this.cutComponent.get(i).getX() - lrx;
                }
                if (y + h > this.selectionComponent.getHeight()) {
                    posy = this.selectionComponent.getHeight() + this.cutComponent.get(i).getY() - lry;
                }
                if (posx < 0) {
                    posx = 0;
                    width = this.selectionComponent.getWidth();
                }
                if (posy < 0) {
                    posy = 0;
                    height = this.selectionComponent.getHeight();
                }
                ScaleConstraints constr = new ScaleConstraints(posx, posy, width, height);
                ((DOOCSComponent)((Object)this.cutComponent.get(i))).setRunMode(false);
                this.cutComponent.get(i).setName(null);
                this.selection.add(this.cutComponent.get(i));
                ((DOOCSComponent)((Object)this.selectionComponent)).add(this.cutComponent.get(i), constr);
                changeAdd.add(new AddRemoveComp((DOOCSLayeredPane)this.selectionComponent, this.cutComponent.get(i), constr));
            }
            for (int j = 0; j < this.undoAddListener.size(); ++j) {
                this.undoAddListener.get(j).DOOCSAddComponent(changeAdd);
            }
            this.doMoveToFront();
            this.cutComponent.clear();
            if (this.selection.size() > 0) {
                for (i = 0; i < this.selection.size(); ++i) {
                    if (this.selection.get(i) instanceof EditorPanel) continue;
                    DOOCSComponent comp = (DOOCSComponent)((Object)this.selection.get(i));
                    DOOCSComponent newcomp = this.doClone(comp);
                    newcomp.setRunMode(false);
                    this.cutComponent.add((JComponent)((Object)newcomp));
                }
            }
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            for (int i3 = 0; i3 < this.selectionListener.size(); ++i3) {
                this.selectionListener.get(i3).DOOCSObjectSelected(this.selection.toArray(dummy));
            }
        }
    }

    public void doAlignLeft() {
        if (this.selection.size() > 1) {
            int i;
            int leftx = 10000;
            for (i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i).getX() >= leftx) continue;
                leftx = this.selection.get(i).getX();
            }
            for (i = 0; i < this.selection.size(); ++i) {
                this.selection.get(i).setLocation(leftx, this.selection.get(i).getY());
            }
            this.repaint();
            this.sendUndoAlignEvent();
        }
    }

    public void doAlignRight() {
        if (this.selection.size() > 1) {
            int i;
            int rightx = 0;
            for (i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i).getX() + this.selection.get(i).getWidth() <= rightx) continue;
                rightx = this.selection.get(i).getX() + this.selection.get(i).getWidth();
            }
            for (i = 0; i < this.selection.size(); ++i) {
                this.selection.get(i).setLocation(rightx - this.selection.get(i).getWidth(), this.selection.get(i).getY());
            }
            this.repaint();
            this.sendUndoAlignEvent();
        }
    }

    public void doAlignTop() {
        if (this.selection.size() > 1) {
            int i;
            int topy = 10000;
            for (i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i).getY() >= topy) continue;
                topy = this.selection.get(i).getY();
            }
            for (i = 0; i < this.selection.size(); ++i) {
                this.selection.get(i).setLocation(this.selection.get(i).getX(), topy);
            }
            this.repaint();
            this.sendUndoAlignEvent();
        }
    }

    public void doAlignBottom() {
        if (this.selection.size() > 1) {
            int i;
            int bottomy = 0;
            for (i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i).getY() + this.selection.get(i).getHeight() <= bottomy) continue;
                bottomy = this.selection.get(i).getY() + this.selection.get(i).getHeight();
            }
            for (i = 0; i < this.selection.size(); ++i) {
                this.selection.get(i).setLocation(this.selection.get(i).getX(), bottomy - this.selection.get(i).getHeight());
            }
            this.repaint();
            this.sendUndoAlignEvent();
        }
    }

    public void doAlignCenterH() {
        if (this.selection.size() > 1) {
            int i;
            int centerv = 0;
            for (i = 0; i < this.selection.size(); ++i) {
                centerv += this.selection.get(i).getY() + this.selection.get(i).getHeight() / 2;
            }
            centerv /= this.selection.size();
            for (i = 0; i < this.selection.size(); ++i) {
                this.selection.get(i).setLocation(this.selection.get(i).getX(), centerv - this.selection.get(i).getHeight() / 2);
            }
            this.repaint();
            this.sendUndoAlignEvent();
        }
    }

    public void doAlignCenterV() {
        if (this.selection.size() > 1) {
            int i;
            int centerh = 0;
            for (i = 0; i < this.selection.size(); ++i) {
                centerh += this.selection.get(i).getX() + this.selection.get(i).getWidth() / 2;
            }
            centerh /= this.selection.size();
            for (i = 0; i < this.selection.size(); ++i) {
                this.selection.get(i).setLocation(centerh - this.selection.get(i).getWidth() / 2, this.selection.get(i).getY());
            }
            this.repaint();
            this.sendUndoAlignEvent();
        }
    }

    public void doAlignDistributeH() {
        if (this.selection.size() > 2) {
            int x1 = 10000;
            int x2 = 0;
            for (int i = 0; i < this.selection.size(); ++i) {
                int centerx = this.selection.get(i).getX() + this.selection.get(i).getWidth() / 2;
                if (centerx < x1) {
                    x1 = centerx;
                }
                if (centerx <= x2) continue;
                x2 = centerx;
            }
            Vector a = new Vector();
            Vector b = new Vector();
            int counterSamePosition = 0;
            for (int i = 0; i < this.selection.size(); ++i) {
                int centerx = this.selection.get(i).getX() + this.selection.get(i).getWidth() / 2;
                int position = 0;
                boolean samePosition = false;
                for (int j = 0; j < a.size(); ++j) {
                    if (centerx > this.selection.get((Integer)((Vector)a.get(j)).get(0)).getX() + this.selection.get((Integer)((Vector)a.get(j)).get(0)).getWidth() / 2) {
                        position = j + 1;
                    }
                    if (centerx != this.selection.get((Integer)((Vector)a.get(j)).get(0)).getX() + this.selection.get((Integer)((Vector)a.get(j)).get(0)).getWidth() / 2) continue;
                    samePosition = true;
                    ++counterSamePosition;
                    position = j;
                }
                b.clear();
                if (samePosition) {
                    b = (Vector)a.get(position);
                }
                b.add(i);
                if (!samePosition) {
                    a.add(position, new Vector(b));
                    continue;
                }
                a.set(position, new Vector(b));
            }
            int distance = (x2 - x1) / (this.selection.size() - 1 - counterSamePosition);
            for (int i = 1; i < a.size() - 1; ++i) {
                for (int j = 0; j < ((Vector)a.get(i)).size(); ++j) {
                    int newPosition = this.selection.get((Integer)((Vector)a.get(0)).get(0)).getX() + this.selection.get((Integer)((Vector)a.get(0)).get(0)).getWidth() / 2 + i * distance - this.selection.get((Integer)((Vector)a.get(i)).get(0)).getWidth() / 2;
                    this.selection.get((Integer)((Vector)a.get(i)).get(j)).setLocation(newPosition, this.selection.get((Integer)((Vector)a.get(i)).get(j)).getY());
                }
            }
            this.repaint();
            this.sendUndoAlignEvent();
        }
    }

    public void doAlignDistributeV() {
        if (this.selection.size() > 2) {
            int y1 = 10000;
            int y2 = 0;
            for (int i = 0; i < this.selection.size(); ++i) {
                int centery = this.selection.get(i).getY() + this.selection.get(i).getHeight() / 2;
                if (centery < y1) {
                    y1 = centery;
                }
                if (centery <= y2) continue;
                y2 = centery;
            }
            Vector a = new Vector();
            Vector b = new Vector();
            int counterSamePosition = 0;
            for (int i = 0; i < this.selection.size(); ++i) {
                int centery = this.selection.get(i).getY() + this.selection.get(i).getHeight() / 2;
                int position = 0;
                boolean samePosition = false;
                for (int j = 0; j < a.size(); ++j) {
                    if (centery > this.selection.get((Integer)((Vector)a.get(j)).get(0)).getY() + this.selection.get((Integer)((Vector)a.get(j)).get(0)).getHeight() / 2) {
                        position = j + 1;
                    }
                    if (centery != this.selection.get((Integer)((Vector)a.get(j)).get(0)).getY() + this.selection.get((Integer)((Vector)a.get(j)).get(0)).getHeight() / 2) continue;
                    samePosition = true;
                    ++counterSamePosition;
                    position = j;
                }
                b.clear();
                if (samePosition) {
                    b = (Vector)a.get(position);
                }
                b.add(i);
                if (!samePosition) {
                    a.add(position, new Vector(b));
                    continue;
                }
                a.set(position, new Vector(b));
            }
            int distance = (y2 - y1) / (this.selection.size() - 1 - counterSamePosition);
            for (int i = 1; i < a.size() - 1; ++i) {
                for (int j = 0; j < ((Vector)a.get(i)).size(); ++j) {
                    int newPosition = this.selection.get((Integer)((Vector)a.get(0)).get(0)).getY() + this.selection.get((Integer)((Vector)a.get(0)).get(0)).getHeight() / 2 + i * distance - this.selection.get((Integer)((Vector)a.get(i)).get(0)).getHeight() / 2;
                    this.selection.get((Integer)((Vector)a.get(i)).get(j)).setLocation(this.selection.get((Integer)((Vector)a.get(i)).get(j)).getX(), newPosition);
                }
            }
            this.repaint();
            this.sendUndoAlignEvent();
        }
    }

    private void sendUndoAlignEvent() {
        Vector<SetProperty> change = new Vector<SetProperty>();
        change = this.collectUNDOPropertyChangeEvents(this.selection, change);
        for (int j = 0; j < this.undoPropertyChangeListener.size(); ++j) {
            this.undoPropertyChangeListener.get(j).DOOCSPropertyChanged(change);
        }
        this.resetInitialBounds(this.selection);
    }

    public void doFlipHorizontal() {
        Vector<SetProperty> change = new Vector<SetProperty>();
        for (int i = 0; i < this.selection.size(); ++i) {
            change = ((DOOCSComponent)((Object)this.selection.get(i))).flipHorizontal(change);
        }
        for (int j = 0; j < this.undoPropertyChangeListener.size(); ++j) {
            this.undoPropertyChangeListener.get(j).DOOCSPropertyChanged(change);
        }
        DOOCSComponent[] dummy = new DOOCSComponent[]{};
        for (int i = 0; i < this.selectionListener.size(); ++i) {
            this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
        }
    }

    public void doFlipVertical() {
        Vector<SetProperty> change = new Vector<SetProperty>();
        for (int i = 0; i < this.selection.size(); ++i) {
            change = ((DOOCSComponent)((Object)this.selection.get(i))).flipVertical(change);
        }
        for (int j = 0; j < this.undoPropertyChangeListener.size(); ++j) {
            this.undoPropertyChangeListener.get(j).DOOCSPropertyChanged(change);
        }
        DOOCSComponent[] dummy = new DOOCSComponent[]{};
        for (int i = 0; i < this.selectionListener.size(); ++i) {
            this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
        }
    }

    public void doRotateLeft() {
        Vector<SetProperty> change = new Vector<SetProperty>();
        for (int i = 0; i < this.selection.size(); ++i) {
            change = this.rotateComponentBounds(this.selection.get(i), change);
            change = ((DOOCSComponent)((Object)this.selection.get(i))).rotateLeft(change);
        }
        for (int j = 0; j < this.undoPropertyChangeListener.size(); ++j) {
            this.undoPropertyChangeListener.get(j).DOOCSPropertyChanged(change);
        }
        DOOCSComponent[] dummy = new DOOCSComponent[]{};
        for (int i = 0; i < this.selectionListener.size(); ++i) {
            this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
        }
    }

    public void doRotateRight() {
        Vector<SetProperty> change = new Vector<SetProperty>();
        for (int i = 0; i < this.selection.size(); ++i) {
            change = this.rotateComponentBounds(this.selection.get(i), change);
            change = ((DOOCSComponent)((Object)this.selection.get(i))).rotateRight(change);
        }
        for (int j = 0; j < this.undoPropertyChangeListener.size(); ++j) {
            this.undoPropertyChangeListener.get(j).DOOCSPropertyChanged(change);
        }
        DOOCSComponent[] dummy = new DOOCSComponent[]{};
        for (int i = 0; i < this.selectionListener.size(); ++i) {
            this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
        }
    }

    public Vector<SetProperty> rotateComponentBounds(Component comp, Vector<SetProperty> change) {
        int height;
        int x = comp.getX();
        int y = comp.getY();
        int width = comp.getWidth();
        if (width > (height = comp.getHeight())) {
            x += (width - height) / 2;
            y -= (width - height) / 2;
        } else {
            x -= (height - width) / 2;
            y += (height - width) / 2;
        }
        if (comp == this) {
            ((EditorPanel)comp).setNewBounds(x, y, height, width, true);
            comp.setPreferredSize(new Dimension(height, width));
            this.getParent().getParent().getParent().validate();
        } else if (!(comp instanceof DOOCSPlugin || comp instanceof DOOCSAudio || comp instanceof DOOCSDial || comp instanceof JComboBox)) {
            if (comp instanceof DOOCSLabel || comp instanceof DOOCSValue || comp instanceof DOOCSProgressBar || comp instanceof DOOCSCheckBox || comp instanceof DOOCSButton || comp instanceof DOOCSSlider || comp instanceof DOOCSIcon || comp instanceof DOOCSToggleButton) {
                comp.setLocation(x, y);
            } else {
                if (comp instanceof DOOCSLine) {
                    ((DOOCSLine)comp).adjust = true;
                }
                comp.setBounds(x, y, height, width);
                Container parent = comp.getParent();
                if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
                    if (comp.getX() < 0) {
                        comp.setLocation(0, comp.getY());
                    }
                    if (comp.getY() < 0) {
                        comp.setLocation(comp.getX(), 0);
                    }
                    if (comp.getX() + comp.getWidth() > parent.getWidth()) {
                        comp.setLocation(parent.getWidth() - comp.getWidth(), comp.getY());
                    }
                    if (comp.getY() + comp.getHeight() > parent.getHeight()) {
                        comp.setLocation(comp.getX(), parent.getHeight() - comp.getHeight());
                    }
                }
            }
        }
        String startBounds = DOOCSParameter.getDoocsBounds(((DOOCSComponent)((Object)comp)).getInitialBounds());
        String stopBounds = DOOCSParameter.getDoocsBounds(comp.getBounds());
        change.add(new SetProperty((DOOCSComponent)((Object)comp), "bounds", startBounds, stopBounds));
        ((DOOCSComponent)((Object)comp)).setInitialBounds(comp.getBounds());
        return change;
    }

    public void doMove(int xchange, int ychange) {
        if (!(this.isRunMode() || this.selection.size() <= 0 || this.selection.contains(this) || this.resizeDirection != 0 || this.add)) {
            for (int i = 0; i < this.selection.size(); ++i) {
                int xinit = this.selection.get(i).getX();
                int yinit = this.selection.get(i).getY();
                int x = xinit;
                int y = yinit;
                if (this.getShowAllGrid()) {
                    DOOCSLayeredPane bgcomponent = (DOOCSLayeredPane)this.selection.get(i).getParent();
                    x += Math.round((float)xchange * bgcomponent.gridX);
                    y += Math.round((float)ychange * bgcomponent.gridY);
                    x = Math.round((float)Math.round((float)x / bgcomponent.gridX) * bgcomponent.gridX);
                    y = Math.round((float)Math.round((float)y / bgcomponent.gridY) * bgcomponent.gridY);
                } else {
                    x += xchange;
                    y += ychange;
                }
                int compWidth = this.selection.get(i).getWidth();
                int compHeight = this.selection.get(i).getHeight();
                int parentWidth = this.selection.get(i).getParent().getWidth();
                int parentHeight = this.selection.get(i).getParent().getHeight();
                if (!(x >= 0 && y >= 0 && x <= parentWidth - compWidth && y <= parentHeight - compHeight || xinit < 0 && x > xinit || yinit < 0 && y > yinit || xinit + compWidth > parentWidth && x + compWidth < xinit + compWidth) && (yinit + compHeight <= parentHeight || y + compHeight >= yinit + compHeight)) continue;
                this.selection.get(i).setLocation(x, y);
                this.repaint();
            }
        }
    }

    public void doMoveToFront() {
        if (this.selection.size() > 0) {
            int i;
            for (i = 0; i < this.selection.size(); ++i) {
                Component comp = this.selection.get(i);
                if (comp == this) continue;
                this.getBgLayeredPane(comp).moveToFront(comp);
            }
            for (i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
        }
    }

    public void doMoveToBack() {
        if (this.selection.size() > 0) {
            int i;
            for (i = 0; i < this.selection.size(); ++i) {
                Component comp = this.selection.get(i);
                if (comp == this) continue;
                this.getBgLayeredPane(comp).moveToBack(comp);
            }
            for (i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
        }
    }

    public void doMoveForward() {
        if (this.selection.size() > 0) {
            int i;
            for (i = 0; i < this.selection.size(); ++i) {
                Component comp = this.selection.get(i);
                if (comp == this) continue;
                DOOCSLayeredPane background = this.getBgLayeredPane(comp);
                int compIndex = background.getComponentZOrder(comp);
                background.moveToFront(comp);
                for (int k = 1; k < compIndex; ++k) {
                    background.moveToFront(background.getComponent(compIndex - 1));
                }
            }
            for (i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
        }
    }

    public void doMoveBackward() {
        if (this.selection.size() > 0) {
            int i;
            for (i = 0; i < this.selection.size(); ++i) {
                DOOCSLayeredPane background;
                int compIndex;
                Component comp = this.selection.get(i);
                if (comp == this || (compIndex = (background = this.getBgLayeredPane(comp)).getComponentZOrder(comp)) + 1 >= background.getComponentCount()) continue;
                background.moveToBack(background.getComponent(compIndex + 1));
                for (int k = 1; k < background.getComponentCount() - compIndex; ++k) {
                    background.moveToBack(background.getComponent(compIndex));
                }
            }
            for (i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
        }
    }

    private DOOCSLayeredPane getBgLayeredPane(Component comp) {
        DOOCSComponent bgcomponent = (DOOCSComponent)((Object)comp.getParent());
        while (!(bgcomponent instanceof DOOCSLayeredPane)) {
            bgcomponent = (DOOCSComponent)((Object)bgcomponent.getParent());
        }
        return (DOOCSLayeredPane)bgcomponent;
    }

    public void doGroup(boolean isLogicGroup, boolean isTimerGroup) {
        if (isTimerGroup || isLogicGroup || !isTimerGroup && !isLogicGroup && this.selection.size() > 1) {
            DOOCSComponent bgcomponent = (DOOCSComponent)((Object)this.selection.get(0).getParent());
            if (!(bgcomponent instanceof DOOCSLayeredPane)) {
                new ShowException(null, "Grouping failed", "Selected components cannot be grouped.");
                return;
            }
            for (int i = 1; i < this.selection.size(); ++i) {
                if (bgcomponent == (DOOCSComponent)((Object)this.selection.get(i).getParent())) continue;
                new ShowException(null, "Grouping failed", "Selected components are not in the same layer.");
                return;
            }
            int gx1 = this.selection.get(0).getX();
            int gy1 = this.selection.get(0).getY();
            int gx2 = gx1 + this.selection.get(0).getWidth();
            int gy2 = gy1 + this.selection.get(0).getHeight();
            for (int i = 1; i < this.selection.size(); ++i) {
                Component comp = this.selection.get(i);
                int x1 = comp.getX();
                int y1 = comp.getY();
                int x2 = x1 + comp.getWidth();
                int y2 = y1 + comp.getHeight();
                if (x1 < gx1) {
                    gx1 = x1;
                }
                if (y1 < gy1) {
                    gy1 = y1;
                }
                if (x2 > gx2) {
                    gx2 = x2;
                }
                if (y2 <= gy2) continue;
                gy2 = y2;
            }
            Vector<AddRemoveComp> changeRemove = new Vector<AddRemoveComp>();
            for (int i = 0; i < this.selection.size(); ++i) {
                int x = this.selection.get(i).getX();
                int y = this.selection.get(i).getY();
                int width = this.selection.get(i).getWidth();
                int height = this.selection.get(i).getHeight();
                ScaleConstraints constr = new ScaleConstraints(x, y, width, height);
                changeRemove.add(new AddRemoveComp((DOOCSLayeredPane)bgcomponent, this.selection.get(i), constr));
                this.removeComponent(this.selection.get(i), this.selection.get(i).getParent());
            }
            Vector<AddRemoveComp> changeAdd = new Vector<AddRemoveComp>();
            DOOCSGroup dgroup = new DOOCSGroup();
            DOOCSLogicGroup lgroup = new DOOCSLogicGroup();
            DOOCSTimerGroup tgroup = new DOOCSTimerGroup();
            for (int i = 0; i < this.selection.size(); ++i) {
                int x = this.selection.get(i).getX() - gx1;
                int y = this.selection.get(i).getY() - gy1;
                int width = this.selection.get(i).getWidth();
                int height = this.selection.get(i).getHeight();
                ScaleConstraints constr = new ScaleConstraints(x, y, width, height);
                if (isLogicGroup) {
                    lgroup.add((Component)((JComponent)this.selection.get(i)), constr);
                    changeAdd.add(new AddRemoveComp(lgroup, this.selection.get(i), constr));
                }
                if (isTimerGroup) {
                    tgroup.add((Component)((JComponent)this.selection.get(i)), constr);
                    changeAdd.add(new AddRemoveComp(tgroup, this.selection.get(i), constr));
                }
                if (isLogicGroup || isTimerGroup) continue;
                dgroup.add((Component)((JComponent)this.selection.get(i)), constr);
                changeAdd.add(new AddRemoveComp(dgroup, this.selection.get(i), constr));
            }
            ScaleConstraints constr = new ScaleConstraints(gx1, gy1, gx2 - gx1, gy2 - gy1);
            if (isLogicGroup) {
                bgcomponent.add(lgroup, constr);
                changeAdd.add(new AddRemoveComp((DOOCSLayeredPane)bgcomponent, lgroup, constr));
                EditorPanel.resetInitialBounds(lgroup);
            }
            if (isTimerGroup) {
                bgcomponent.add(tgroup, constr);
                changeAdd.add(new AddRemoveComp((DOOCSLayeredPane)bgcomponent, tgroup, constr));
                EditorPanel.resetInitialBounds(tgroup);
            }
            if (!isLogicGroup && !isTimerGroup) {
                bgcomponent.add(dgroup, constr);
                changeAdd.add(new AddRemoveComp((DOOCSLayeredPane)bgcomponent, dgroup, constr));
                EditorPanel.resetInitialBounds(dgroup);
            }
            for (int j = 0; j < this.undoGroupListener.size(); ++j) {
                this.undoGroupListener.get(j).DOOCSGroupComponents(changeRemove, changeAdd);
            }
            this.selection.clear();
            if (isLogicGroup) {
                this.selection.add(lgroup);
                this.selectionComponent = lgroup;
            }
            if (isTimerGroup) {
                this.selection.add(tgroup);
                this.selectionComponent = tgroup;
            }
            if (!isLogicGroup && !isTimerGroup) {
                this.selection.add(dgroup);
                this.selectionComponent = dgroup;
            }
            this.repaint();
            for (int i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            for (int i = 0; i < this.selectionListener.size(); ++i) {
                this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
            }
        }
    }

    public void doUngroup() {
        if (this.selection.size() == 1 && this.selection.get(0) instanceof DOOCSGroup) {
            DOOCSGroup selgroup = (DOOCSGroup)this.selection.get(0);
            DOOCSLayeredPane parent = (DOOCSLayeredPane)selgroup.getParent();
            this.removeComponent(selgroup, parent);
            Vector<AddRemoveComp> changeRemove = new Vector<AddRemoveComp>();
            int x = selgroup.getX();
            int y = selgroup.getY();
            int width = selgroup.getWidth();
            int height = selgroup.getHeight();
            ScaleConstraints constr = new ScaleConstraints(x, y, width, height);
            changeRemove.add(new AddRemoveComp(parent, selgroup, constr));
            for (int j = 0; j < selgroup.getComponentCount(); ++j) {
                x = selgroup.getComponent(j).getX();
                y = selgroup.getComponent(j).getY();
                width = selgroup.getComponent(j).getWidth();
                height = selgroup.getComponent(j).getHeight();
                constr = new ScaleConstraints(x, y, width, height);
                changeRemove.add(new AddRemoveComp(selgroup, selgroup.getComponent(j), constr));
            }
            Vector<AddRemoveComp> changeAdd = new Vector<AddRemoveComp>();
            while (selgroup.getComponentCount() > 0) {
                x = selgroup.getX() + selgroup.getComponent(0).getX();
                y = selgroup.getY() + selgroup.getComponent(0).getY();
                width = selgroup.getComponent(0).getWidth();
                height = selgroup.getComponent(0).getHeight();
                constr = new ScaleConstraints(x, y, width, height);
                ((DOOCSComponent)((Object)selgroup.getComponent(0))).setInitialBounds(new Rectangle(x, y, width, height));
                changeAdd.add(new AddRemoveComp(parent, selgroup.getComponent(0), constr));
                this.selection.add(selgroup.getComponent(0));
                parent.add(selgroup.getComponent(0), constr);
            }
            for (int j = 0; j < this.undoGroupListener.size(); ++j) {
                this.undoGroupListener.get(j).DOOCSGroupComponents(changeRemove, changeAdd);
            }
            this.selection.remove(0);
            this.repaint();
            for (int i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            for (int i = 0; i < this.selectionListener.size(); ++i) {
                this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
            }
        }
    }

    public void doSelectNone() {
        this.selection.clear();
        this.repaint();
        for (int i = 0; i < this.updateListener.size(); ++i) {
            this.updateListener.get(i).DOOCSPanelStructureChanged();
        }
        DOOCSComponent[] dummy = new DOOCSComponent[]{};
        for (int i = 0; i < this.selectionListener.size(); ++i) {
            this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
        }
    }

    public void doSelectAll() {
        int i;
        DOOCSLayeredPane bgcomponent = this;
        if (this.selection.size() == 1 && this.selection.get(0) instanceof DOOCSLayeredPane) {
            bgcomponent = (DOOCSLayeredPane)this.selection.get(0);
        }
        if (this.selection.size() == 1 && this.selection.get(0) instanceof DOOCSDynamicList) {
            bgcomponent = (DOOCSLayeredPane)((Container)((Container)this.selection.get(0)).getComponent(0)).getComponent(0);
        }
        this.selection.clear();
        for (i = 0; i < bgcomponent.getComponentCount(); ++i) {
            this.selection.add(bgcomponent.getComponent(i));
        }
        this.repaint();
        for (i = 0; i < this.updateListener.size(); ++i) {
            this.updateListener.get(i).DOOCSPanelStructureChanged();
        }
        DOOCSComponent[] dummy = new DOOCSComponent[]{};
        for (int i2 = 0; i2 < this.selectionListener.size(); ++i2) {
            this.selectionListener.get(i2).DOOCSObjectSelected(this.selection.toArray(dummy));
        }
    }

    public void doInvertSelection() {
        int i;
        Container bgcomponent = this;
        if (this.selection.size() > 0) {
            bgcomponent = this.selectionComponent.getParent();
        }
        for (i = 0; i < bgcomponent.getComponentCount(); ++i) {
            if (this.selection.contains(bgcomponent.getComponent(i))) {
                this.selection.remove(bgcomponent.getComponent(i));
                continue;
            }
            this.selection.add(bgcomponent.getComponent(i));
        }
        this.repaint();
        for (i = 0; i < this.updateListener.size(); ++i) {
            this.updateListener.get(i).DOOCSPanelStructureChanged();
        }
        DOOCSComponent[] dummy = new DOOCSComponent[]{};
        for (int i2 = 0; i2 < this.selectionListener.size(); ++i2) {
            this.selectionListener.get(i2).DOOCSObjectSelected(this.selection.toArray(dummy));
        }
    }

    public void doSnap() {
        if (this.getShowAllGrid()) {
            for (int i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i) == this) continue;
                DOOCSLayeredPane bgcomponent = (DOOCSLayeredPane)this.selection.get(i).getParent();
                int x = this.selection.get(i).getX();
                int y = this.selection.get(i).getY();
                int width = this.selection.get(i).getWidth();
                int height = this.selection.get(i).getHeight();
                x = Math.round((float)Math.round((float)x / bgcomponent.gridX) * bgcomponent.gridX);
                y = Math.round((float)Math.round((float)y / bgcomponent.gridY) * bgcomponent.gridY);
                width = Math.round((float)Math.round((float)width / bgcomponent.gridX) * bgcomponent.gridX);
                height = Math.round((float)Math.round((float)height / bgcomponent.gridY) * bgcomponent.gridY);
                this.selection.get(i).setBounds(x, y, width, height);
                if (!(this.selection.get(i) instanceof DOOCSLine)) continue;
                DOOCSLine line = (DOOCSLine)this.selection.get(i);
                int x1 = line.getDoocsPoints().x1 + line.getX();
                int y1 = line.getDoocsPoints().y1 + line.getY();
                int x2 = line.getDoocsPoints().x2 + line.getX();
                int y2 = line.getDoocsPoints().y2 + line.getY();
                x1 = Math.round((float)Math.round((float)x1 / bgcomponent.gridX) * bgcomponent.gridX);
                y1 = Math.round((float)Math.round((float)y1 / bgcomponent.gridY) * bgcomponent.gridY);
                x2 = Math.round((float)Math.round((float)x2 / bgcomponent.gridX) * bgcomponent.gridX);
                y2 = Math.round((float)Math.round((float)y2 / bgcomponent.gridY) * bgcomponent.gridY);
                line.setDoocsPoints(x1 - line.getX(), y1 - line.getY(), x2 - line.getX(), y2 - line.getY());
            }
            this.repaint();
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            for (int i = 0; i < this.selectionListener.size(); ++i) {
                this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
            }
        }
    }

    public void doUpdateIncludeComponents(DOOCSComponent comp) {
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            if (comp.getComponent(i) instanceof DOOCSIncludeComponent) {
                String filename = ((DOOCSIncludeComponent)comp.getComponent(i)).getIncludeDoocsXmlFile();
                ((DOOCSIncludeComponent)comp.getComponent(i)).setIncludeDoocsXmlFile(filename);
            }
            if (!(comp.getComponent(i) instanceof DOOCSLayeredPane) && !(comp.getComponent(i) instanceof DOOCSTabbedPane)) continue;
            this.doUpdateIncludeComponents((DOOCSComponent)((Object)comp.getComponent(i)));
        }
    }

    public void removeComponent(Component comp, Container parent) {
        parent.remove(comp);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isRunMode()) {
            Color col = g.getColor();
            for (int i = 0; i < this.selection.size(); ++i) {
                Point pt;
                Component actComp = this.selection.get(i);
                int compWidth = actComp.getWidth();
                int compHeight = actComp.getHeight();
                if (actComp instanceof DOOCSLine) {
                    DOOCSLine line = (DOOCSLine)actComp;
                    Rectangle corners = this.getHandles(line, true);
                    g.setColor(Color.GRAY);
                    if (corners != null) {
                        g.draw3DRect(corners.x, corners.y, 4, 4, true);
                        g.draw3DRect(corners.width, corners.height, 4, 4, true);
                    }
                    pt = actComp.getLocation();
                    for (actComp = actComp.getParent(); !(actComp instanceof EditorPanel) && actComp != this; actComp = actComp.getParent()) {
                        pt.x += actComp.getLocation().x;
                        pt.y += actComp.getLocation().y;
                    }
                    g.setColor(Color.ORANGE);
                    g.drawRect(pt.x - 1, pt.y - 1, compWidth + 1, compHeight + 1);
                    continue;
                }
                if (!(actComp instanceof EditorPanel) && actComp != this) {
                    pt = actComp.getLocation();
                    boolean paintHandles = !(actComp instanceof DOOCSAudio) && !(actComp instanceof DOOCSTab) && !(actComp instanceof DOOCSSwitchCase) && !(actComp instanceof DOOCSIfCase);
                    for (actComp = actComp.getParent(); !(actComp instanceof EditorPanel) && actComp != this; actComp = actComp.getParent()) {
                        pt.x += actComp.getLocation().x;
                        pt.y += actComp.getLocation().y;
                    }
                    g.setColor(Color.ORANGE);
                    g.drawRect(pt.x - 1, pt.y - 1, compWidth + 1, compHeight + 1);
                    if (!paintHandles) continue;
                    g.setColor(Color.GRAY);
                    g.draw3DRect(pt.x - 6, pt.y - 6, 4, 4, true);
                    g.draw3DRect(pt.x - 3 + compWidth / 2, pt.y - 6, 4, 4, true);
                    g.draw3DRect(pt.x + compWidth + 1, pt.y - 6, 4, 4, true);
                    g.draw3DRect(pt.x + compWidth + 1, pt.y - 3 + compHeight / 2, 4, 4, true);
                    g.draw3DRect(pt.x + compWidth + 1, pt.y + compHeight + 1, 4, 4, true);
                    g.draw3DRect(pt.x - 3 + compWidth / 2, pt.y + compHeight + 1, 4, 4, true);
                    g.draw3DRect(pt.x - 6, pt.y + compHeight + 1, 4, 4, true);
                    g.draw3DRect(pt.x - 6, pt.y - 3 + compHeight / 2, 4, 4, true);
                    continue;
                }
                g.setColor(Color.ORANGE);
                g.drawRect(0, 0, actComp.getWidth() - 1, actComp.getHeight() - 1);
                g.setColor(Color.GRAY);
                g.draw3DRect(1, 1, 4, 4, true);
                g.draw3DRect(compWidth / 2 - 2, 1, 4, 4, true);
                g.draw3DRect(compWidth - 5, 1, 4, 4, true);
                g.draw3DRect(compWidth - 5, compHeight / 2 - 2, 4, 4, true);
                g.draw3DRect(compWidth - 5, compHeight - 5, 4, 4, true);
                g.draw3DRect(compWidth / 2 - 2, compHeight - 5, 4, 4, true);
                g.draw3DRect(1, compHeight - 5, 4, 4, true);
                g.draw3DRect(1, compHeight / 2 - 2, 4, 4, true);
            }
            if (this.mouseSelection) {
                int height;
                int y;
                int width;
                int x;
                g.setColor(Color.BLACK);
                if (this.startDragX < this.actX) {
                    x = this.startDragX;
                    width = this.actX - this.startDragX;
                } else {
                    x = this.actX;
                    width = this.startDragX - this.actX;
                }
                if (this.startDragY < this.actY) {
                    y = this.startDragY;
                    height = this.actY - this.startDragY;
                } else {
                    y = this.actY;
                    height = this.startDragY - this.actY;
                }
                for (Component dummyComp = this.draggedComponent; dummyComp != this; dummyComp = dummyComp.getParent()) {
                    x += dummyComp.getX();
                    y += dummyComp.getY();
                }
                g.drawRect(x, y, width, height);
            }
            g.setColor(col);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JSVNFileInfo fInfo;
        DOOCSIncludeComponent icomp;
        String ifilename;
        if (e.getClickCount() == 1 && e.isMetaDown() && this.selection.size() > 0) {
            boolean group = false;
            if (this.selection.size() == 1 && this.selection.get(0) instanceof DOOCSGroup) {
                group = true;
            }
            EditorPanelPopup popup = new EditorPanelPopup(this, this.selection.size(), group);
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
        if (e.getClickCount() == 2 && this.selectionComponent instanceof DOOCSIncludeComponent && (ifilename = (icomp = (DOOCSIncludeComponent)this.selectionComponent).getIncludeDoocsXmlFile()) != null && (fInfo = DOOCSParameter.getDoocsFilePath(ifilename, this)) != null) {
            for (int i = 0; i < this.openIncludeComponentListener.size(); ++i) {
                this.openIncludeComponentListener.get(i).DOOCSOpenIncludeComponent(DOOCSParameter.getDoocsFilePath(ifilename, this));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.selectionComponent = e.getComponent();
        this.startDragX = e.getX();
        this.startDragY = e.getY();
        this.move = false;
        this.resize = false;
        if (e.isMetaDown() && e.getClickCount() == 1 && this.add) {
            this.add = false;
            this.setCursor(this.defaultCursor);
            for (int i = 0; i < this.addListener.size(); ++i) {
                this.addListener.get(i).DOOCSAddObjectSelected(null);
            }
        }
        if (!e.isMetaDown() && e.getClickCount() == 1 && this.add) {
            int x = e.getX();
            int y = e.getY();
            DOOCSComponent bgcomponent = (DOOCSComponent)((Object)e.getComponent());
            this.addDoocsComponent(x, y, bgcomponent);
        }
        if (this.resizeDirection == 0) {
            this.setSelection(e.isShiftDown(), e.getX(), e.getY(), false, e.getClickCount());
        }
    }

    public void addDoocsComponent(int x, int y, DOOCSComponent bgcomponent) {
        int i;
        if (this.addComponent == null) {
            return;
        }
        if (!(!(this.addComponent instanceof DOOCSLayeredPane) || this.addComponent instanceof DOOCSSwitch || this.addComponent instanceof DOOCSSwitchCase || this.addComponent instanceof DOOCSIfCase || this.addComponent instanceof DOOCSTab || this.addComponent instanceof DOOCSIncludeComponent || this.addComponent instanceof DOOCSAlive)) {
            this.addComponent.setDOOCSParameter("fillColor", "255,255,255");
        }
        Dimension dim = this.addComponent.getPreferredSize();
        int width = dim.width;
        int height = dim.height;
        while (!(bgcomponent instanceof DOOCSLayeredPane) && !(bgcomponent instanceof DOOCSTabbedPane) || bgcomponent instanceof DOOCSSwitchCase && this.addComponent instanceof DOOCSSwitchCase || bgcomponent instanceof DOOCSIfCase && this.addComponent instanceof DOOCSIfCase || bgcomponent instanceof DOOCSTab && this.addComponent instanceof DOOCSTab || bgcomponent instanceof DOOCSIncludeComponent || bgcomponent instanceof DOOCSGroup) {
            x += bgcomponent.getX();
            y += bgcomponent.getY();
            bgcomponent = (DOOCSComponent)((Object)bgcomponent.getParent());
        }
        if (this.addComponent instanceof DOOCSSwitchCase && !(bgcomponent instanceof DOOCSSwitch) || bgcomponent instanceof DOOCSIf) {
            this.add = false;
            this.setCursor(this.defaultCursor);
            for (int i2 = 0; i2 < this.addListener.size(); ++i2) {
                this.addListener.get(i2).DOOCSAddObjectSelected(null);
            }
            return;
        }
        if (this.addComponent instanceof DOOCSTab && !(bgcomponent instanceof DOOCSTabbedPane)) {
            this.add = false;
            this.setCursor(this.defaultCursor);
            for (int i3 = 0; i3 < this.addListener.size(); ++i3) {
                this.addListener.get(i3).DOOCSAddObjectSelected(null);
            }
            return;
        }
        if (this.getShowAllGrid() && !(bgcomponent instanceof DOOCSSwitch) && !(bgcomponent instanceof DOOCSTabbedPane)) {
            x = Math.round((float)Math.round((float)x / ((DOOCSLayeredPane)bgcomponent).gridX) * ((DOOCSLayeredPane)bgcomponent).gridX);
            y = Math.round((float)Math.round((float)y / ((DOOCSLayeredPane)bgcomponent).gridY) * ((DOOCSLayeredPane)bgcomponent).gridY);
            if (this.addComponent instanceof DOOCSLabel || this.addComponent instanceof DOOCSValue) {
                width = 50;
            }
            if (!(this.addComponent instanceof DOOCSAudio)) {
                width = Math.round((float)Math.round((float)width / ((DOOCSLayeredPane)bgcomponent).gridX) * ((DOOCSLayeredPane)bgcomponent).gridX);
                height = Math.round((float)Math.round((float)height / ((DOOCSLayeredPane)bgcomponent).gridY) * ((DOOCSLayeredPane)bgcomponent).gridY);
            }
        }
        if (x + width > bgcomponent.getWidth()) {
            x = bgcomponent.getWidth() - width;
        }
        if (y + height > bgcomponent.getHeight()) {
            y = bgcomponent.getHeight() - height;
        }
        if (x < 0) {
            x = 0;
            if (bgcomponent.getWidth() < width) {
                width = bgcomponent.getWidth();
            }
        }
        if (y < 0) {
            y = 0;
            if (bgcomponent.getHeight() < height) {
                height = bgcomponent.getHeight();
            }
        }
        ScaleConstraints constr = new ScaleConstraints(x, y, width, height);
        bgcomponent.add((JComponent)((Object)this.addComponent), constr);
        if (bgcomponent instanceof DOOCSLayeredPane) {
            ((DOOCSLayeredPane)bgcomponent).moveToFront((JComponent)((Object)this.addComponent));
        }
        this.addComponent.setInitialBounds(this.addComponent.getBounds());
        this.validate();
        this.setCursor(this.defaultCursor);
        for (i = 0; i < this.updateListener.size(); ++i) {
            this.updateListener.get(i).DOOCSPanelStructureChanged();
        }
        this.selectionComponent = (Component)((Object)this.addComponent);
        for (int j = 0; j < this.undoAddListener.size(); ++j) {
            if (!(bgcomponent instanceof DOOCSLayeredPane)) continue;
            Vector<AddRemoveComp> changeAdd = new Vector<AddRemoveComp>();
            changeAdd.add(new AddRemoveComp((DOOCSLayeredPane)bgcomponent, (Component)((Object)this.addComponent), constr));
            this.undoAddListener.get(j).DOOCSAddComponent(changeAdd);
        }
        for (i = 0; i < this.addListener.size(); ++i) {
            this.addListener.get(i).DOOCSAddObjectSelected(null);
        }
    }

    public void setSelection(boolean isShiftDown, int x, int y, boolean drop, int clickCount) {
        if (this.selectionComponent != null) {
            Container parentComponent = this.selectionComponent.getParent();
            if (parentComponent == null) {
                return;
            }
            if (!drop && (this.selectionComponent instanceof DOOCSRect && !((DOOCSRect)this.selectionComponent).isSelected(x, y) || this.selectionComponent instanceof DOOCSOval && !((DOOCSOval)this.selectionComponent).isSelected(x, y) || this.selectionComponent instanceof DOOCSLine && !((DOOCSLine)this.selectionComponent).isSelected(x, y))) {
                this.transparency = true;
                this.startDragX = x + this.selectionComponent.getX();
                this.startDragY = y + this.selectionComponent.getY();
                this.selectionComponent = parentComponent;
            }
            if ((this.selectionComponent instanceof DOOCSSwitchCase || this.selectionComponent instanceof DOOCSIfCase) && ((DOOCSLayeredPane)this.selectionComponent).isSelected(x, y)) {
                this.selectionComponent = parentComponent;
            }
            if (parentComponent instanceof DOOCSDial) {
                this.selectionComponent = parentComponent;
            }
            if (parentComponent.getParent() instanceof DOOCSDial) {
                this.selectionComponent = parentComponent.getParent();
            }
            if (parentComponent instanceof JComboBox) {
                this.selectionComponent = parentComponent;
            }
            if (parentComponent.getParent() instanceof JComboBox) {
                this.selectionComponent = parentComponent.getParent();
            }
            if (parentComponent instanceof DOOCSLocationChooser) {
                this.selectionComponent = parentComponent;
            }
            if (parentComponent.getParent() instanceof DOOCSLocationChooser) {
                this.selectionComponent = parentComponent.getParent();
            }
            if (parentComponent instanceof DOOCSSlider) {
                this.selectionComponent = parentComponent;
            }
            if (parentComponent.getParent() instanceof DOOCSDynamicList || parentComponent.getParent() instanceof DOOCSTextArea || parentComponent.getParent() instanceof DOOCSPropertiesTable || parentComponent.getParent() instanceof DOOCSDeviceTree) {
                this.selectionComponent = parentComponent.getParent();
            }
            if (parentComponent.getParent().getParent() instanceof DOOCSTextArea) {
                this.selectionComponent = parentComponent.getParent().getParent();
            }
            while (!(parentComponent instanceof JViewport)) {
                if (parentComponent instanceof DOOCSPlugin) {
                    this.selectionComponent = parentComponent;
                }
                if (clickCount == 1 && parentComponent instanceof DOOCSGroup) {
                    this.selectionComponent = parentComponent;
                }
                if (parentComponent instanceof DOOCSIncludeComponent) {
                    this.selectionComponent = parentComponent;
                }
                parentComponent = parentComponent.getParent();
            }
            if (!this.selection.contains(this.selectionComponent)) {
                if (!isShiftDown) {
                    this.selection.clear();
                    this.selection.add(this.selectionComponent);
                } else if (this.selection.size() == 0 || this.selection.get(0).getParent() == this.selectionComponent.getParent()) {
                    this.selection.add(this.selectionComponent);
                }
            } else if (isShiftDown) {
                this.selection.remove(this.selectionComponent);
            } else {
                this.mouseSelection = false;
            }
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            for (int i = 0; i < this.selectionListener.size(); ++i) {
                this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int i;
        if (this.mouseSelection) {
            this.selection.clear();
            Container container = (Container)this.draggedComponent;
            if (this.draggedComponent instanceof DOOCSDynamicList) {
                container = (Container)((Container)container.getComponent(0)).getComponent(0);
            }
            for (i = 0; i < container.getComponentCount(); ++i) {
                Component comp = container.getComponent(i);
                int x1 = comp.getX();
                int y1 = comp.getY();
                int x2 = x1 + comp.getWidth();
                int y2 = y1 + comp.getHeight();
                boolean checkX = false;
                boolean checkY = false;
                if (this.startDragX < this.actX) {
                    if (this.startDragX < x1 && x1 < this.actX && this.startDragX < x2 && x2 < this.actX) {
                        checkX = true;
                    }
                } else if (this.actX < x1 && x1 < this.startDragX && this.actX < x2 && x2 < this.startDragX) {
                    checkX = true;
                }
                if (this.startDragY < this.actY) {
                    if (this.startDragY < y1 && y1 < this.actY && this.startDragY < y2 && y2 < this.actY) {
                        checkY = true;
                    }
                } else if (this.actY < y1 && y1 < this.startDragY && this.actY < y2 && y2 < this.startDragY) {
                    checkY = true;
                }
                if (!checkX || !checkY) continue;
                this.selection.add(comp);
            }
            this.repaint();
            for (i = 0; i < this.updateListener.size(); ++i) {
                this.updateListener.get(i).DOOCSPanelStructureChanged();
            }
        }
        DOOCSComponent[] dummy = new DOOCSComponent[]{};
        for (i = 0; i < this.selectionListener.size(); ++i) {
            this.selectionListener.get(i).DOOCSObjectSelected(this.selection.toArray(dummy));
        }
        this.add = false;
        this.mouseSelection = false;
        this.transparency = false;
        this.isSelectedLayeredPane = false;
        this.isSelectedDynamicList = false;
        if (this.move || this.resize) {
            Vector<SetProperty> change = new Vector<SetProperty>();
            change = this.collectUNDOPropertyChangeEvents(this.selection, change);
            for (int j = 0; j < this.undoPropertyChangeListener.size(); ++j) {
                this.undoPropertyChangeListener.get(j).DOOCSPropertyChanged(change);
            }
        }
        this.resetInitialBounds(this.selection);
    }

    public Vector<SetProperty> collectUNDOPropertyChangeEvents(Vector<Component> selcomp, Vector<SetProperty> change) {
        for (int k = 0; k < this.selection.size(); ++k) {
            Component comp = selcomp.get(k);
            DOOCSComponent dcomp = (DOOCSComponent)((Object)comp);
            String startBounds = DOOCSParameter.getDoocsBounds(dcomp.getInitialBounds());
            String stopBounds = DOOCSParameter.getDoocsBounds(comp.getBounds());
            change.add(new SetProperty(dcomp, "bounds", startBounds, stopBounds));
            if (dcomp instanceof DOOCSLayeredPane) {
                String startGrid = ((DOOCSLayeredPane)dcomp).getInitialGrid();
                String stopGrid = ((DOOCSLayeredPane)dcomp).getDoocsGrid();
                change.add(new SetProperty(dcomp, "grid", startGrid, stopGrid));
            }
            for (int i = 0; i < dcomp.getComponentCount(); ++i) {
                if (dcomp instanceof DOOCSPlugin || dcomp instanceof DOOCSSlider || dcomp instanceof DOOCSDial || dcomp instanceof JComboBox || dcomp instanceof DOOCSLocationChooser || dcomp instanceof DOOCSPropertiesTable || dcomp instanceof DOOCSTextArea || dcomp instanceof DOOCSDeviceTree || dcomp instanceof DOOCSDynamicList) continue;
                this.collectUNDOPropertyChangeEvents(dcomp.getComponent(i), change);
            }
        }
        return change;
    }

    public Vector<SetProperty> collectUNDOPropertyChangeEvents(Component comp, Vector<SetProperty> change) {
        DOOCSComponent dcomp = (DOOCSComponent)((Object)comp);
        String startBounds = DOOCSParameter.getDoocsBounds(dcomp.getInitialBounds());
        String stopBounds = DOOCSParameter.getDoocsBounds(comp.getBounds());
        change.add(new SetProperty(dcomp, "bounds", startBounds, stopBounds));
        if (dcomp instanceof DOOCSLayeredPane) {
            String startGrid = ((DOOCSLayeredPane)dcomp).getInitialGrid();
            String stopGrid = ((DOOCSLayeredPane)dcomp).getDoocsGrid();
            change.add(new SetProperty(dcomp, "grid", startGrid, stopGrid));
        }
        for (int i = 0; i < dcomp.getComponentCount(); ++i) {
            if (dcomp instanceof DOOCSPlugin || dcomp instanceof DOOCSSlider || dcomp instanceof DOOCSDial || dcomp instanceof JComboBox || dcomp instanceof DOOCSLocationChooser || dcomp instanceof DOOCSPropertiesTable || dcomp instanceof DOOCSTextArea || dcomp instanceof DOOCSDeviceTree || dcomp instanceof DOOCSDynamicList) continue;
            this.collectUNDOPropertyChangeEvents(dcomp.getComponent(i), change);
        }
        return change;
    }

    public void resetInitialBounds(Vector<Component> selcomp) {
        for (int k = 0; k < this.selection.size(); ++k) {
            Component comp = selcomp.get(k);
            DOOCSComponent dcomp = (DOOCSComponent)((Object)comp);
            dcomp.setInitialBounds(comp.getBounds());
            if (dcomp instanceof DOOCSLayeredPane) {
                ((DOOCSLayeredPane)dcomp).setInitialGrid();
            }
            for (int i = 0; i < dcomp.getComponentCount(); ++i) {
                if (dcomp instanceof DOOCSPlugin || dcomp instanceof DOOCSSlider || dcomp instanceof DOOCSDial || dcomp instanceof JComboBox || dcomp instanceof DOOCSLocationChooser || dcomp instanceof DOOCSPropertiesTable || dcomp instanceof DOOCSTextArea || dcomp instanceof DOOCSDeviceTree || dcomp instanceof DOOCSDynamicList) continue;
                EditorPanel.resetInitialBounds(dcomp.getComponent(i));
            }
        }
    }

    public static void resetInitialBounds(Component comp) {
        DOOCSComponent dcomp = (DOOCSComponent)((Object)comp);
        dcomp.setInitialBounds(comp.getBounds());
        for (int i = 0; i < dcomp.getComponentCount(); ++i) {
            if (dcomp instanceof DOOCSPlugin || dcomp instanceof DOOCSSlider || dcomp instanceof DOOCSDial || dcomp instanceof JComboBox || dcomp instanceof DOOCSLocationChooser || dcomp instanceof DOOCSPropertiesTable || dcomp instanceof DOOCSTextArea || dcomp instanceof DOOCSDeviceTree || dcomp instanceof DOOCSDynamicList) continue;
            EditorPanel.resetInitialBounds(dcomp.getComponent(i));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!(this.move || this.selectionComponent == this || !(this.selectionComponent instanceof DOOCSLayeredPane) || this.selectionComponent instanceof DOOCSGroup || this.selectionComponent instanceof DOOCSAlive || this.selectionComponent instanceof DOOCSIncludeComponent || this.selectionComponent instanceof DOOCSTab || ((DOOCSLayeredPane)this.selectionComponent).isSelected(e.getX(), e.getY()))) {
            this.isSelectedLayeredPane = true;
        }
        if (!this.move && this.selectionComponent instanceof DOOCSDynamicList && !((DOOCSDynamicList)this.selectionComponent).isSelected(e.getX(), e.getY())) {
            this.isSelectedDynamicList = true;
        }
        if (!(this.isRunMode() || this.selection.contains(this) || this.resizeDirection != 0 || this.add || this.selectionComponent instanceof DOOCSTab || this.isSelectedDynamicList || this.isSelectedLayeredPane)) {
            int x2 = 0;
            int y2 = 0;
            int x1 = this.selection.get(0).getParent().getWidth();
            int y1 = this.selection.get(0).getParent().getHeight();
            for (int i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i).getX() < x1) {
                    x1 = this.selection.get(i).getX();
                }
                if (this.selection.get(i).getY() < y1) {
                    y1 = this.selection.get(i).getY();
                }
                if (this.selection.get(i).getX() + this.selection.get(i).getWidth() > x2) {
                    x2 = this.selection.get(i).getX() + this.selection.get(i).getWidth();
                }
                if (this.selection.get(i).getY() + this.selection.get(i).getHeight() <= y2) continue;
                y2 = this.selection.get(i).getY() + this.selection.get(i).getHeight();
            }
            int xnew = x1 - this.startDragX + e.getX();
            int ynew = y1 - this.startDragY + e.getY();
            if (this.transparency) {
                xnew += e.getComponent().getX();
                ynew += e.getComponent().getY();
            }
            if (this.getShowAllGrid()) {
                DOOCSLayeredPane bgcomponent = (DOOCSLayeredPane)this.selection.get(0).getParent();
                xnew = Math.round((float)Math.round((float)xnew / bgcomponent.gridX) * bgcomponent.gridX);
                ynew = Math.round((float)Math.round((float)ynew / bgcomponent.gridY) * bgcomponent.gridY);
            }
            int parentWidth = this.selection.get(0).getParent().getWidth();
            int parentHeight = this.selection.get(0).getParent().getHeight();
            boolean snapToBorderX = false;
            boolean snapToBorderY = false;
            if (this.getShowAllGrid() && this.selection.size() == 1 && xnew > parentWidth - (x2 - x1)) {
                snapToBorderX = true;
            }
            if (this.getShowAllGrid() && this.selection.size() == 1 && ynew > parentHeight - (y2 - y1)) {
                snapToBorderY = true;
            }
            if (xnew >= 0 && ynew >= 0 && xnew <= parentWidth - (x2 - x1) && ynew <= parentHeight - (y2 - y1) || x1 < 0 && xnew > x1 || y1 < 0 && ynew > y1 || x2 > parentWidth && xnew < x1 || y2 > parentHeight && ynew < y1 || snapToBorderX || snapToBorderY) {
                for (int i = 0; i < this.selection.size(); ++i) {
                    this.move = true;
                    if (snapToBorderX) {
                        this.selection.get(i).setLocation(parentWidth - this.selection.get(i).getWidth(), ynew - y1 + this.selection.get(i).getY());
                    } else if (snapToBorderY) {
                        this.selection.get(i).setLocation(xnew - x1 + this.selection.get(i).getX(), parentHeight - this.selection.get(i).getHeight());
                    } else {
                        this.selection.get(i).setLocation(xnew - x1 + this.selection.get(i).getX(), ynew - y1 + this.selection.get(i).getY());
                    }
                    if (this.getCursor().getType() != 13) {
                        this.setCursor(this.moveCursor);
                    }
                    this.validate();
                    this.repaint();
                }
            } else if (!(this.draggedComponent instanceof DOOCSLayeredPane)) {
                this.startDragX = e.getX();
                this.startDragY = e.getY();
            }
        }
        if (!(this.isRunMode() || this.resizeDirection <= 0 || this.draggedComponent instanceof DOOCSIfCase || this.draggedComponent instanceof DOOCSSwitchCase || this.draggedComponent instanceof DOOCSTab)) {
            int parentHeight;
            int parentWidth;
            int y2;
            int x2;
            int y1;
            int x1;
            this.resize = true;
            int x = this.draggedComponent.getX();
            int y = this.draggedComponent.getY();
            int w = this.draggedComponent.getWidth();
            int h = this.draggedComponent.getHeight();
            if (this.resizeDirection == 1) {
                x = x - this.startDragX + e.getX();
                y = y - this.startDragY + e.getY();
                w = w + this.startDragX - e.getX();
                h = h + this.startDragY - e.getY();
            }
            if (this.resizeDirection == 2) {
                y = y - this.startDragY + e.getY();
                h = h + this.startDragY - e.getY();
            }
            if (this.resizeDirection == 3) {
                y = y - this.startDragY + e.getY();
                w = w - this.startDragX + e.getX();
                h = h + this.startDragY - e.getY();
            }
            if (this.resizeDirection == 4) {
                w = w - this.startDragX + e.getX();
            }
            if (this.resizeDirection == 5) {
                w = w - this.startDragX + e.getX();
                h = h - this.startDragY + e.getY();
            }
            if (this.resizeDirection == 6) {
                h = h - this.startDragY + e.getY();
            }
            if (this.resizeDirection == 7) {
                x = x - this.startDragX + e.getX();
                w = w + this.startDragX - e.getX();
                h = h - this.startDragY + e.getY();
            }
            if (this.resizeDirection == 8) {
                x = x - this.startDragX + e.getX();
                w = w + this.startDragX - e.getX();
            }
            if (this.resizeDirection == 11) {
                x = e.getX() - this.startDragX;
                y = e.getY() - this.startDragY;
                DOOCSLine line = (DOOCSLine)this.draggedComponent;
                x1 = line.getDoocsPoints().x1 + x;
                y1 = line.getDoocsPoints().y1 + y;
                x2 = line.getDoocsPoints().x2;
                y2 = line.getDoocsPoints().y2;
                if (this.getShowAllGrid()) {
                    DOOCSLayeredPane bgcomponent = (DOOCSLayeredPane)this.draggedComponent.getParent();
                    x1 = Math.round((float)Math.round((float)(x1 + line.getX()) / bgcomponent.gridX) * bgcomponent.gridX) - line.getX();
                    y1 = Math.round((float)Math.round((float)(y1 + line.getY()) / bgcomponent.gridY) * bgcomponent.gridY) - line.getY();
                    this.startDragX = x1 + line.getX();
                    this.startDragY = y1 + line.getY();
                    if (e.getComponent() != bgcomponent) {
                        this.startDragX -= DOOCSParameter.getBgDoocsComponent(e.getComponent()).getX();
                    }
                    if (e.getComponent() != bgcomponent) {
                        this.startDragY -= DOOCSParameter.getBgDoocsComponent(e.getComponent()).getY();
                    }
                }
                parentWidth = this.draggedComponent.getParent().getWidth();
                parentHeight = this.draggedComponent.getParent().getHeight();
                if (this.draggedComponent.getX() + x1 >= 0 && this.draggedComponent.getX() + x1 <= parentWidth && this.draggedComponent.getY() + y1 >= 0 && this.draggedComponent.getY() + y1 <= parentHeight) {
                    ((DOOCSLine)this.draggedComponent).setDoocsPoints(x1, y1, x2, y2);
                }
                if (!this.getShowAllGrid()) {
                    this.startDragX = e.getX();
                    this.startDragY = e.getY();
                }
            }
            if (this.resizeDirection == 12) {
                x = e.getX() - this.startDragX;
                y = e.getY() - this.startDragY;
                DOOCSLine line = (DOOCSLine)this.draggedComponent;
                x1 = line.getDoocsPoints().x1;
                y1 = line.getDoocsPoints().y1;
                x2 = line.getDoocsPoints().x2 + x;
                y2 = line.getDoocsPoints().y2 + y;
                if (this.getShowAllGrid()) {
                    DOOCSLayeredPane bgcomponent = (DOOCSLayeredPane)this.draggedComponent.getParent();
                    x2 = Math.round((float)Math.round((float)(x2 + line.getX()) / bgcomponent.gridX) * bgcomponent.gridX) - line.getX();
                    y2 = Math.round((float)Math.round((float)(y2 + line.getY()) / bgcomponent.gridY) * bgcomponent.gridY) - line.getY();
                    this.startDragX = x2 + line.getX();
                    this.startDragY = y2 + line.getY();
                    if (e.getComponent() != bgcomponent) {
                        this.startDragX -= DOOCSParameter.getBgDoocsComponent(e.getComponent()).getX();
                    }
                    if (e.getComponent() != bgcomponent) {
                        this.startDragY -= DOOCSParameter.getBgDoocsComponent(e.getComponent()).getY();
                    }
                }
                parentWidth = this.draggedComponent.getParent().getWidth();
                parentHeight = this.draggedComponent.getParent().getHeight();
                if (this.draggedComponent.getX() + x2 >= 0 && this.draggedComponent.getX() + x2 <= parentWidth && this.draggedComponent.getY() + y2 >= 0 && this.draggedComponent.getY() + y2 <= parentHeight) {
                    ((DOOCSLine)this.draggedComponent).setDoocsPoints(x1, y1, x2, y2);
                }
                if (!this.getShowAllGrid()) {
                    this.startDragX = e.getX();
                    this.startDragY = e.getY();
                }
            }
            if (!(this.draggedComponent instanceof DOOCSLine)) {
                if (this.getShowAllGrid() && this.draggedComponent != this) {
                    DOOCSLayeredPane bgcomponent = (DOOCSLayeredPane)this.draggedComponent.getParent();
                    if (this.resizeDirection == 1 || this.resizeDirection == 8 || this.resizeDirection == 7) {
                        x = Math.round((float)Math.round((float)x / bgcomponent.gridX) * bgcomponent.gridX);
                    }
                    if (this.resizeDirection == 1 || this.resizeDirection == 2 || this.resizeDirection == 3) {
                        y = Math.round((float)Math.round((float)y / bgcomponent.gridY) * bgcomponent.gridY);
                    }
                    if (this.resizeDirection == 1 || this.resizeDirection == 2 || this.resizeDirection == 3) {
                        h = this.draggedComponent.getHeight();
                    }
                    if ((this.resizeDirection == 1 || this.resizeDirection == 2 || this.resizeDirection == 3) && y != this.draggedComponent.getY()) {
                        h += this.draggedComponent.getY() - y;
                    }
                    if (this.resizeDirection == 5 || this.resizeDirection == 6 || this.resizeDirection == 7) {
                        int y22 = y + h;
                        y22 = Math.round((float)Math.round((float)y22 / bgcomponent.gridY) * bgcomponent.gridY);
                        h = y22 - y;
                    }
                    if (this.resizeDirection == 1 || this.resizeDirection == 8 || this.resizeDirection == 7) {
                        w = this.draggedComponent.getWidth();
                    }
                    if ((this.resizeDirection == 1 || this.resizeDirection == 8 || this.resizeDirection == 7) && x != this.draggedComponent.getX()) {
                        w += this.draggedComponent.getX() - x;
                    }
                    if (this.resizeDirection == 3 || this.resizeDirection == 4 || this.resizeDirection == 5) {
                        int x22 = x + w;
                        x22 = Math.round((float)Math.round((float)x22 / bgcomponent.gridX) * bgcomponent.gridX);
                        w = x22 - x;
                    }
                    if ((this.resizeDirection == 1 || this.resizeDirection == 8 || this.resizeDirection == 7) && x != this.draggedComponent.getX()) {
                        this.startDragX = x;
                        if (e.getComponent() != bgcomponent) {
                            this.startDragX -= DOOCSParameter.getBgDoocsComponent(e.getComponent()).getX();
                        }
                    }
                    if ((this.resizeDirection == 1 || this.resizeDirection == 2 || this.resizeDirection == 3) && y != this.draggedComponent.getY()) {
                        this.startDragY = y;
                        if (e.getComponent() != bgcomponent) {
                            this.startDragY -= DOOCSParameter.getBgDoocsComponent(e.getComponent()).getY();
                        }
                    }
                    if ((this.resizeDirection == 3 || this.resizeDirection == 4 || this.resizeDirection == 5) && w != this.draggedComponent.getWidth()) {
                        this.startDragX = x + w;
                        if (e.getComponent() != bgcomponent) {
                            this.startDragX -= DOOCSParameter.getBgDoocsComponent(e.getComponent()).getX();
                        }
                    }
                    if ((this.resizeDirection == 5 || this.resizeDirection == 6 || this.resizeDirection == 7) && h != this.draggedComponent.getHeight()) {
                        this.startDragY = y + h;
                        if (e.getComponent() != bgcomponent) {
                            this.startDragY -= DOOCSParameter.getBgDoocsComponent(e.getComponent()).getY();
                        }
                    }
                }
                if (w > 0 && h > 0) {
                    if (this.shiftPressed) {
                        int dx = this.draggedComponent.getX();
                        int dy = this.draggedComponent.getY();
                        int dw = this.draggedComponent.getWidth();
                        int dh = this.draggedComponent.getHeight();
                        if (w != dw && h == dh) {
                            float factor = (float)dw / (float)w;
                            h = Math.round((float)h / factor);
                        } else if (w == dw && h != dh) {
                            float factor = (float)dh / (float)h;
                            w = Math.round((float)w / factor);
                        } else {
                            float factorx = (float)dw / (float)w;
                            float factory = (float)dh / (float)h;
                            if (factorx > factory) {
                                h = Math.round((float)dh / factorx);
                            }
                            if (factory > factorx) {
                                w = Math.round((float)dw / factory);
                            }
                        }
                        if (this.resizeDirection == 8) {
                            y = y + dh - h;
                        }
                        if (this.resizeDirection == 2) {
                            x = x + dw - w;
                        }
                        if (this.resizeDirection == 1) {
                            x = dx + dw - w;
                            y = dy + dh - h;
                        }
                        if (this.resizeDirection == 3) {
                            y = dy + dh - h;
                        }
                        if (this.resizeDirection == 7) {
                            x = dx + dw - w;
                        }
                    }
                    int parentWidth2 = this.draggedComponent.getParent().getWidth();
                    int parentHeight2 = this.draggedComponent.getParent().getHeight();
                    if (this.draggedComponent != this && x >= 0 && y >= 0 && w <= parentWidth2 - x && h <= parentHeight2 - y) {
                        if (this.draggedComponent instanceof DOOCSLayeredPane) {
                            ((DOOCSLayeredPane)this.draggedComponent).setNewBounds(x, y, w, h, this.controlPressed);
                        } else if (this.draggedComponent instanceof DOOCSTabbedPane) {
                            ((DOOCSTabbedPane)this.draggedComponent).setNewBounds(x, y, w, h, this.controlPressed);
                        } else {
                            this.draggedComponent.setBounds(x, y, w, h);
                        }
                        this.draggedComponent.setPreferredSize(new Dimension(w, h));
                    }
                    if (this.draggedComponent == this && x > 0 && y > 0) {
                        ((EditorPanel)this.draggedComponent).setNewBounds(x, y, w, h, this.controlPressed);
                        this.draggedComponent.setPreferredSize(new Dimension(w, h));
                        this.getParent().getParent().getParent().validate();
                        this.startDragX = e.getX();
                        this.startDragY = e.getY();
                    }
                    if (!this.getShowAllGrid()) {
                        this.startDragX = e.getX();
                        this.startDragY = e.getY();
                    }
                }
            }
            this.validate();
            this.repaint();
        }
        if (!this.isRunMode() && this.selection.size() == 1 && this.resizeDirection == 0 && !this.add && !this.move && (this.selection.get(0) == this || this.isSelectedLayeredPane || this.isSelectedDynamicList || this.selection.get(0) instanceof DOOCSTab || this.selection.get(0) instanceof DOOCSIfCase || this.selection.get(0) instanceof DOOCSSwitchCase)) {
            this.mouseSelection = true;
            if (this.transparency) {
                this.actX = e.getX() + e.getComponent().getX();
                this.actY = e.getY() + e.getComponent().getY();
            } else {
                this.actX = e.getX();
                this.actY = e.getY();
            }
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isRunMode() && this.draggedComponent != null && this.selection.size() == 1 && !this.add) {
            Component parent;
            int x = e.getX();
            int y = e.getY();
            for (parent = (Component)e.getSource(); this.draggedComponent != this && parent != this && this.draggedComponent.getParent() != parent; parent = parent.getParent()) {
                x += parent.getX();
                y += parent.getY();
            }
            for (Container tmp = this.draggedComponent.getParent(); tmp != null && this.draggedComponent != this && tmp != parent; tmp = tmp.getParent()) {
                x -= tmp.getX();
                y -= tmp.getY();
            }
            if (!(this.draggedComponent == this || this.draggedComponent instanceof DOOCSLine || this.draggedComponent instanceof DOOCSAudio || this.draggedComponent instanceof DOOCSTab || this.draggedComponent instanceof DOOCSSwitchCase || this.draggedComponent instanceof DOOCSIfCase || this.add)) {
                if (this.compX - 6 < x && x < this.compX && this.compY - 6 < y && y < this.compY) {
                    this.resizeDirection = 1;
                    this.setCursor(new Cursor(6));
                } else if (this.compX - 3 + this.compW / 2 < x && x < this.compX + 3 + this.compW / 2 && this.compY - 6 < y && y < this.compY) {
                    this.resizeDirection = (short)2;
                    this.setCursor(new Cursor(8));
                } else if (this.compX + this.compW < x && x < this.compX + this.compW + 6 && this.compY - 6 < y && y < this.compY) {
                    this.resizeDirection = (short)3;
                    this.setCursor(new Cursor(7));
                } else if (this.compX + this.compW < x && x < this.compX + this.compW + 6 && this.compY - 3 + this.compH / 2 < y && y < this.compY + 3 + this.compH / 2) {
                    this.resizeDirection = (short)4;
                    this.setCursor(new Cursor(11));
                } else if (this.compX + this.compW < x && x < this.compX + this.compW + 6 && this.compY + this.compH < y && y < this.compY + this.compH + 6) {
                    this.resizeDirection = (short)5;
                    this.setCursor(new Cursor(5));
                } else if (this.compX - 3 + this.compW / 2 < x && x < this.compX + 3 + this.compW / 2 && this.compY + this.compH < y && y < this.compY + this.compH + 6) {
                    this.resizeDirection = (short)6;
                    this.setCursor(new Cursor(9));
                } else if (this.compX - 6 < x && x < this.compX && this.compY + this.compH < y && y < this.compY + this.compH + 6) {
                    this.resizeDirection = (short)7;
                    this.setCursor(new Cursor(4));
                } else if (this.compX - 6 < x && x < this.compX && this.compY - 3 + this.compH / 2 < y && y < this.compY + 3 + this.compH / 2) {
                    this.resizeDirection = (short)8;
                    this.setCursor(new Cursor(10));
                } else if (x > this.compX && x < this.compX + this.compW && y > this.compY && y < this.compY + this.compH) {
                    Component testComp;
                    boolean canMove = true;
                    int testx = e.getX();
                    int testy = e.getY();
                    for (testComp = (Component)e.getSource(); testComp != null && testComp != this.draggedComponent; testComp = testComp.getParent()) {
                        testx += testComp.getX();
                        testy += testComp.getY();
                    }
                    if (testComp != null) {
                        if (this.draggedComponent instanceof DOOCSRect && !((DOOCSRect)this.draggedComponent).isSelected(testx, testy) || this.draggedComponent instanceof DOOCSOval && !((DOOCSOval)this.draggedComponent).isSelected(testx, testy) || this.draggedComponent instanceof DOOCSTabbedPane && !((DOOCSTabbedPane)this.draggedComponent).isSelected(testx, testy) || this.draggedComponent instanceof DOOCSDynamicList && !((DOOCSDynamicList)this.draggedComponent).isSelected(testx, testy) || this.draggedComponent instanceof DOOCSLayeredPane && !(this.draggedComponent instanceof DOOCSIncludeComponent) && !(this.draggedComponent instanceof DOOCSAlive) && !(this.draggedComponent instanceof DOOCSTab) && !(this.draggedComponent instanceof DOOCSSwitchCase) && !(this.draggedComponent instanceof DOOCSIfCase) && !((DOOCSLayeredPane)this.draggedComponent).isSelected(testx, testy)) {
                            canMove = false;
                        }
                    } else {
                        canMove = false;
                    }
                    if (canMove) {
                        if (this.getCursor().getType() != 13) {
                            this.resizeDirection = 0;
                            this.setCursor(this.moveCursor);
                        }
                    } else if (this.getCursor().getType() != 0) {
                        this.resizeDirection = 0;
                        this.setCursor(this.defaultCursor);
                    }
                } else if (this.getCursor().getType() != 0) {
                    this.resizeDirection = 0;
                    this.setCursor(this.defaultCursor);
                }
            }
            if (this.draggedComponent instanceof DOOCSAudio && !this.add) {
                if (x > this.compX && x < this.compX + this.compW && y > this.compY && y < this.compY + this.compH) {
                    if (this.getCursor().getType() != 13) {
                        this.resizeDirection = 0;
                        this.setCursor(this.moveCursor);
                    }
                } else if (this.getCursor().getType() != 0) {
                    this.resizeDirection = 0;
                    this.setCursor(this.defaultCursor);
                }
            }
            if ((this.draggedComponent instanceof DOOCSTab || this.draggedComponent instanceof DOOCSSwitchCase || this.draggedComponent instanceof DOOCSIfCase) && !this.add && this.getCursor().getType() != 0) {
                this.resizeDirection = 0;
                this.setCursor(this.defaultCursor);
            }
            if (this.draggedComponent instanceof DOOCSLine && !this.add) {
                DOOCSLine line = (DOOCSLine)this.draggedComponent;
                Rectangle corners = this.getHandles(line, false);
                int x1 = corners.x;
                int y1 = corners.y;
                int x2 = corners.width;
                int y2 = corners.height;
                if (x > x1 && x < x1 + 4 && y > y1 && y < y1 + 4) {
                    this.resizeDirection = (short)11;
                    this.setCursor(new Cursor(12));
                } else if (x > x2 && x < x2 + 4 && y > y2 && y < y2 + 4) {
                    this.resizeDirection = (short)12;
                    this.setCursor(new Cursor(12));
                } else if (((DOOCSLine)this.draggedComponent).isSelected(e.getX(), e.getY())) {
                    if (this.getCursor().getType() != 13) {
                        this.resizeDirection = 0;
                        this.setCursor(this.moveCursor);
                    }
                } else if (this.getCursor().getType() != 0) {
                    this.resizeDirection = 0;
                    this.setCursor(this.defaultCursor);
                }
            }
            if (this.draggedComponent == this && !this.add) {
                this.compW = this.getWidth();
                this.compH = this.getHeight();
                if (0 < x && x < 6 && 0 < y && y < 6) {
                    this.resizeDirection = 1;
                    this.setCursor(new Cursor(6));
                } else if (this.compW / 2 - 3 < x && x < this.compW / 2 + 3 && 0 < y && y < 6) {
                    this.resizeDirection = (short)2;
                    this.setCursor(new Cursor(8));
                } else if (this.compW - 6 < x && x < this.compW && 0 < y && y < 6) {
                    this.resizeDirection = (short)3;
                    this.setCursor(new Cursor(7));
                } else if (this.compW - 6 < x && x < this.compW && this.compH / 2 - 3 < y && y < this.compH / 2 + 3) {
                    this.resizeDirection = (short)4;
                    this.setCursor(new Cursor(11));
                } else if (this.compW - 6 < x && x < this.compW && this.compH - 6 < y && y < this.compH) {
                    this.resizeDirection = (short)5;
                    this.setCursor(new Cursor(5));
                } else if (this.compW / 2 - 3 < x && x < this.compW / 2 + 3 && this.compH - 6 < y && y < this.compH) {
                    this.resizeDirection = (short)6;
                    this.setCursor(new Cursor(9));
                } else if (0 < x && x < 6 && this.compH - 6 < y && y < this.compH) {
                    this.resizeDirection = (short)7;
                    this.setCursor(new Cursor(4));
                } else if (0 < x && x < 6 && this.compH / 2 - 3 < y && y < this.compH / 2 + 3) {
                    this.resizeDirection = (short)8;
                    this.setCursor(new Cursor(10));
                } else if (this.getCursor().getType() != 0) {
                    this.resizeDirection = 0;
                    this.setCursor(this.defaultCursor);
                }
            }
        }
        if (!this.isRunMode() && this.draggedComponent != null && this.selection.size() != 1 && !this.add && this.getCursor().getType() != 0) {
            this.resizeDirection = 0;
            this.setCursor(this.defaultCursor);
        }
        if (this.add && this.getCursor() != DragSource.DefaultCopyDrop) {
            this.resizeDirection = 0;
            this.setCursor(DragSource.DefaultCopyDrop);
        }
    }

    private Rectangle getHandles(DOOCSLine line, boolean ofEditorPanel) {
        int x1 = line.getDoocsPoints().x1;
        int y1 = line.getDoocsPoints().y1;
        int x2 = line.getDoocsPoints().x2;
        int y2 = line.getDoocsPoints().y2;
        Point pt = line.getLocation();
        if (ofEditorPanel) {
            for (Container actComp = line.getParent(); !(actComp instanceof EditorPanel) && actComp != this; actComp = actComp.getParent()) {
                pt.x += actComp.getLocation().x;
                pt.y += actComp.getLocation().y;
            }
        }
        Rectangle corners = null;
        Dimension dim = line.getSize();
        if (x1 < x2 && y1 < y2) {
            corners = new Rectangle(pt.x - 4, pt.y - 4, pt.x + dim.width, pt.y + dim.height);
        }
        if (x1 > x2 && y1 > y2) {
            corners = new Rectangle(pt.x + dim.width, pt.y + dim.height, pt.x - 4, pt.y - 4);
        }
        if (x1 < x2 && y1 > y2) {
            corners = new Rectangle(pt.x - 4, pt.y + dim.height, pt.x + dim.width, pt.y - 4);
        }
        if (x1 > x2 && y1 < y2) {
            corners = new Rectangle(pt.x + dim.width, pt.y - 4, pt.x - 4, pt.y + dim.height);
        }
        if (x1 == x2 && y1 < y2) {
            corners = new Rectangle(pt.x + x1 - 2, pt.y + y1 - 4, pt.x + x2 - 2, pt.y + y2);
        }
        if (x1 == x2 && y1 > y2) {
            corners = new Rectangle(pt.x + x1 - 2, pt.y + y1, pt.x + x2 - 2, pt.y + y2 - 4);
        }
        if (y1 == y2 && x1 < x2) {
            corners = new Rectangle(pt.x + x1 - 4, pt.y + y1 - 2, pt.x + x2, pt.y + y2 - 2);
        }
        if (y1 == y2 && x1 > x2) {
            corners = new Rectangle(pt.x + x1, pt.y + y1 - 2, pt.x + x2 - 4, pt.y + y2 - 2);
        }
        return corners;
    }

    public void addDOOCSAddListener(DOOCSAddEvent dae) {
        this.addListener.add(dae);
    }

    public void addDOOCSSelectionListener(DOOCSSelectEvent dse) {
        this.selectionListener.add(dse);
    }

    @Override
    public void DOOCSObjectSelected(DOOCSComponent[] comp) {
        int i;
        if (this.active) {
            this.selection.clear();
            for (i = 0; i < comp.length; ++i) {
                this.selection.add((Component)((Object)comp[i]));
            }
            if (comp.length == 1) {
                this.draggedComponent = (Component)((Object)comp[0]);
                this.selectionComponent = (Component)((Object)comp[0]);
                this.compX = this.draggedComponent.getX();
                this.compY = this.draggedComponent.getY();
                this.compW = this.draggedComponent.getWidth();
                this.compH = this.draggedComponent.getHeight();
                Container parent = this.draggedComponent.getParent();
                if (this.showAllGrid) {
                    if (parent instanceof JPanel) {
                        parent = this;
                    }
                    while (parent instanceof DOOCSGroup || parent instanceof DOOCSSwitch) {
                        parent = parent.getParent();
                    }
                    this.lastPaneWithGrid.setShowGrid(false);
                    if (this.draggedComponent instanceof DOOCSTab) {
                        ((DOOCSLayeredPane)this.draggedComponent).setShowGrid(true);
                        this.lastPaneWithGrid = (DOOCSLayeredPane)this.draggedComponent;
                    } else {
                        ((DOOCSLayeredPane)parent).setShowGrid(true);
                        this.lastPaneWithGrid = (DOOCSLayeredPane)parent;
                    }
                }
            }
            this.repaint();
            this.requestFocusInWindow();
        }
        for (i = 0; i < this.buttonPressedListener.size(); ++i) {
            this.buttonPressedListener.get(i).DOOCSNumberOfSelectedComponentsChanged(this.selection.size());
        }
    }

    public void setAddObject(DOOCSComponent comp) {
        this.setCursor(DragSource.DefaultCopyDrop);
        this.add = true;
        this.addComponent = comp;
    }

    @Override
    public void DOOCSComponentPropertiesChanged() {
        if (this.draggedComponent != null) {
            this.compX = this.draggedComponent.getX();
            this.compY = this.draggedComponent.getY();
            this.compW = this.draggedComponent.getWidth();
            this.compH = this.draggedComponent.getHeight();
        }
        this.repaint();
    }

    public void addDOOCSUpdateTreeListener(DOOCSUpdateTreeEvent due) {
        this.updateListener.add(due);
    }

    public void addDOOCSButtonPressedListener(DOOCSButtonPressedEvent due) {
        this.buttonPressedListener.add(due);
    }

    public void addDOOCSAddComponentListener(UNDOAddComponentEvent due) {
        this.undoAddListener.add(due);
    }

    public void addDOOCSRemoveComponentListener(UNDORemoveComponentEvent due) {
        this.undoRemoveListener.add(due);
    }

    public void addDOOCSGroupComponentsListener(UNDOGroupComponentsEvent due) {
        this.undoGroupListener.add(due);
    }

    public void addDOOCSPropertyChangeListener(UNDOPropertyChangeEvent due) {
        this.undoPropertyChangeListener.add(due);
    }

    public void addDOOCSOpenIncludeComponentListener(DOOCSOpenIncludeComponentEvent due) {
        this.openIncludeComponentListener.add(due);
    }
}

