/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.DOOCSParameter;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotHist;
import DOOCSPlot.DOOCSPlotXAxisHist;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Calendar;
import java.util.IllegalFormatException;
import javax.swing.JComponent;
import xmlparser.IntegerParser;

public class DOOCSPlotAxis
extends JComponent {
    public double defaultMin = 0.0;
    public double defaultMax = 1000.0;
    public double limitMin = -1000000.0;
    public double limitMax = 1000000.0;
    public double actTimeOffset = 0.0;
    public double actMin = 0.0;
    public double actMax = 10.0;
    public double actDuration = 36000.0;
    public double delMajor = 2.0;
    public double delMinor = 0.2;
    public boolean isLog = false;
    public boolean hasGrid = false;
    public boolean autoScale = true;
    public boolean showText = true;
    public boolean isTimeScale = false;
    public boolean initDone = false;
    public String eguText;
    public boolean spaceForText = true;
    public int nMajorTicks = 5;
    public int nMinorTicks = 5;
    public int strokeSize = 1;
    public int tickLength = 5;
    public int precision = 1;
    public int tickStringLength = 6;
    public Font font;
    protected int p0X = 20;
    protected int p0Y = 20;
    protected int p1X = 80;
    protected int p1Y = 80;
    protected int p2XY;
    public int pixelLength = 100;
    protected double transformScale;
    protected DOOCSPlot plot = null;

    public DOOCSPlotAxis() {
        this.font = new Font("Dialog", 1, 12);
        this.setForeground(new Color(50, 0, 150));
    }

    public DOOCSPlotAxis(DOOCSPlot p) {
    }

    private void update() {
        this.plot.boundsNeedsUpdate = true;
        this.plot.repaint();
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.font = new Font("Dialog", 1, 12);
        }
        return this.font;
    }

    @Override
    public void setFont(Font f) {
        this.font = f;
        this.update();
    }

    public double getMin() {
        return this.actMin;
    }

    public void setMin(double val) {
        this.actMin = val;
        this.update();
    }

    public double getMax() {
        return this.actMax;
    }

    public double getDuration() {
        return this.actDuration;
    }

    public void setMax(double val) {
        this.actMax = val;
        this.update();
    }

    public void setDuration(double val) {
        double old1 = this.actMin;
        double old2 = this.actMax;
        this.actDuration = val;
        this.actMin = this.actMax - this.actDuration;
        if (old1 != this.actMin || old2 != this.actMax) {
            this.update();
        }
    }

    public void setActMinMax(double f1, double f2) {
        double old1 = this.actMin;
        double old2 = this.actMax;
        if (f2 < f1) {
            double t = f1;
            f1 = f2;
            f2 = t;
        }
        if (f1 < this.limitMin) {
            f1 = this.limitMin;
        }
        if (f2 > this.limitMax) {
            f2 = this.limitMax;
        }
        this.actMin = f1;
        this.actMax = f2;
        if (old1 != this.actMin || old2 != this.actMax) {
            this.update();
        }
    }

    public double getDefaultMin() {
        return this.defaultMin;
    }

    public void setDefaultMin(double val) {
        this.defaultMin = val;
    }

    public double getDefaultMax() {
        return this.defaultMax;
    }

    public void setDefaultMax(double val) {
        this.defaultMax = val;
    }

    public double getLimitMin() {
        return this.limitMin;
    }

    public void setLimitMin(double val) {
        this.limitMin = val;
    }

    public double getLimitMax() {
        return this.limitMax;
    }

    public void setLimitMax(double val) {
        this.limitMax = val;
    }

    public boolean getIsLog() {
        return this.isLog;
    }

    public void setIsLog(boolean val) {
        this.isLog = val;
        this.update();
    }

    public boolean getHasGrid() {
        return this.hasGrid;
    }

    public void setHasGrid(boolean val) {
        this.hasGrid = val;
        this.update();
    }

    public boolean getAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean val) {
        this.autoScale = val;
        this.update();
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void setShowText(boolean val) {
        this.showText = val;
        this.update();
    }

    public String getEguText() {
        return this.eguText;
    }

    public void setEguText(String val) {
        this.eguText = val;
        this.update();
    }

    public int getStrokeSize() {
        return this.strokeSize;
    }

    public void setStrokeSize(int val) {
        this.strokeSize = val;
        this.update();
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(int val) {
        this.tickLength = val;
        this.update();
    }

    public int getP0X() {
        return this.p0X;
    }

    public void setP0X(int val) {
        this.p0X = val;
        this.update();
    }

    public int getP0Y() {
        return this.p0Y;
    }

    public void setP0Y(int val) {
        this.p0Y = val;
        this.update();
    }

    public int getP1X() {
        return this.p1X;
    }

    public void setP1X(int val) {
        this.p1X = val;
        this.update();
    }

    public int getP1Y() {
        return this.p1Y;
    }

    public void setP1Y(int val) {
        this.p1Y = val;
        this.update();
    }

    public void roundUp(double rmin, double rmax) {
        if (this.isLog) {
            this.logRoundUp(rmin, rmax);
        } else {
            this.linRoundUp(rmin, rmax);
        }
    }

    public String time_to_single_string(double t) {
        long tl = (long)(t * 1000.0);
        String[] tmp = new String[2];
        tmp = this.time_to_str(tl);
        return tmp[1] + tmp[0];
    }

    public String[] time_to_str(long tMilli) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(tMilli);
        int tm_sec = cal.get(13);
        int tm_min = cal.get(12);
        int tm_hour = cal.get(11);
        int tm_day = cal.get(5);
        int tm_month = cal.get(2) + 1;
        int tm_year = cal.get(1);
        String[] timerString = new String[]{"", ""};
        timerString[1] = String.format("%d.%d.%d", tm_day, tm_month, tm_year);
        if (tm_sec == 0) {
            if (tm_min == 0) {
                if (tm_hour == 0) {
                    timerString[0] = String.format("%2d.%2d.", tm_day, tm_month);
                    timerString[1] = String.format("%d", tm_year);
                } else {
                    timerString[0] = String.format("%2d h", tm_hour);
                }
            } else {
                timerString[0] = String.format("%2d:%02d", tm_hour, tm_min);
            }
        } else {
            timerString[0] = String.format("%2d:%02d.%02d", tm_hour, tm_min, tm_sec);
        }
        return timerString;
    }

    public String numberToString(double number, int precision) {
        double n = Math.abs(number);
        if (n > 1.0 && n <= 1000.0) {
            String fmt = String.format("%%%d.%dg", this.tickStringLength, precision);
            return String.format(fmt, number);
        }
        String fmt = String.format("%%%d.%dg", this.tickStringLength, precision);
        return String.format(fmt, number);
    }

    public void logRoundUp(double rmin, double rmax) {
        double r2;
        double r1;
        if (this.plot == null) {
            return;
        }
        if (rmin > rmax) {
            double f = rmax;
            rmax = rmin;
            rmin = f;
        }
        if (rmax <= 0.0) {
            rmax = 10.0;
        }
        if (rmin <= 0.0) {
            rmin = rmax * 0.01;
        }
        if ((r1 = Math.floor(Math.log10(rmin))) == (r2 = Math.ceil(Math.log10(rmax)))) {
            r2 += 1.0;
        }
        this.actMin = Math.pow(10.0, r1);
        this.actMax = Math.pow(10.0, r2);
        this.nMajorTicks = (int)(r2 - r1 + 0.5);
        this.nMinorTicks = 10;
        this.delMajor = 10.0;
        this.setScale(this.actMin, this.actMax);
    }

    public void linRoundUp(double rmin, double rmax) {
        double del;
        double f;
        if (this.plot == null) {
            return;
        }
        if (rmin > rmax) {
            f = rmax;
            rmax = rmin;
            rmin = f;
        }
        if ((del = rmax - rmin) == 0.0) {
            double offset = rmin * 0.01;
            if (offset == 0.0) {
                offset = 1.0;
            }
            del = (rmax += offset) - (rmin -= offset);
        }
        if (del == 0.0) {
            this.actMin = rmin;
            this.delMajor = 1.0;
            this.actMax = rmin + 1.0;
            this.nMajorTicks = 1;
            this.nMinorTicks = 2;
            this.delMinor = 0.5;
        } else {
            double gr;
            if (del < 0.0) {
                gr = rmin;
                rmin = rmax;
                rmax = gr;
                del = Math.abs(del);
            }
            if (Math.abs(rmax) / del > 10000.0) {
                rmax = rmin + Math.abs(rmax + rmin) / 10000.0;
                del = rmax - rmin;
            }
            double dl = Math.log10(del);
            gr = Math.abs(rmin) > Math.abs(rmax) ? Math.log10(Math.abs(rmin)) : Math.log10(Math.abs(rmax));
            if (rmin < 0.0 && rmax > 0.0) {
                dl = gr;
            }
            double ii = Math.rint(gr);
            int i = (int)gr;
            double dlm = i;
            i = (int)dl;
            double fdl = i;
            f = Math.abs(dl - fdl);
            if (fdl >= 0.0) {
                if (fdl > dlm + 2.0) {
                    fdl = dlm + 1.0;
                    f = 0.0;
                }
            } else if (fdl < dlm - 2.0) {
                fdl = dlm - 3.0;
                f = 0.0;
            }
            this.delMajor = 1.0;
            if (del > 1.0) {
                this.delMajor = f <= 0.31 ? (double)Math.round(Math.pow(10.0, fdl)) / 5.0 : (f <= 0.71 ? (double)Math.round(Math.pow(10.0, fdl)) / 2.0 : (double)Math.round(Math.pow(10.0, fdl)));
            } else {
                fdl -= 1.0;
                this.delMajor = f > 0.69 ? Math.pow(10.0, fdl) / 5.0 : (f > 0.29 ? Math.pow(10.0, fdl) / 2.0 : Math.pow(10.0, fdl));
            }
            if (this.plot instanceof DOOCSPlotHist && ((DOOCSPlotHist)this.plot).isLogicPlot) {
                this.delMajor = 1.0;
            }
            this.actMin = Math.floor(rmin / this.delMajor) * this.delMajor;
            this.actMax = Math.ceil(rmax / this.delMajor) * this.delMajor;
        }
        this.setScale(this.actMin, this.actMax);
    }

    public void setScale(double rmin, double rmax) {
        this.actMin = rmin;
        this.actMax = rmax;
        if (this.isLog) {
            double lmin = rmin <= 0.0 ? -20.0 : Math.log10(rmin);
            double lmax = rmax <= 0.0 ? -20.0 : Math.log10(rmax);
            this.precision = 2;
            try {
                String fmt = String.format("%%2.%dg", this.precision);
                String t1 = String.format(fmt, this.actMin);
                String t2 = String.format(fmt, this.actMax);
                this.tickStringLength = Math.max(t1.length(), t2.length());
            }
            catch (IllegalFormatException e) {
                this.tickStringLength = 5;
            }
            this.transformScale = (double)this.pixelLength / (lmax - lmin);
        } else {
            int ideca;
            this.nMajorTicks = (int)Math.round((this.actMax - this.actMin) / this.delMajor);
            if (this.nMajorTicks < 1) {
                this.nMajorTicks = 1;
            }
            if (this.pixelLength > 0 && this.nMajorTicks > this.pixelLength / 4) {
                this.nMajorTicks = this.pixelLength / 4;
                this.delMajor = (this.actMax - this.actMin) / (double)this.nMajorTicks;
            }
            if ((ideca = (int)Math.log10(Math.abs(this.delMajor))) < 0) {
                --ideca;
            }
            this.delMinor = Math.pow(10.0, ideca);
            this.nMinorTicks = (int)(this.delMajor / this.delMinor);
            if (Math.abs(this.actMax) > Math.abs(this.actMin)) {
                this.precision = (int)(Math.log10(Math.abs(this.actMax) / this.delMajor) + 1.5);
                ideca = (int)(Math.log10(Math.abs(this.actMax)) + 1.0);
            } else {
                this.precision = (int)(Math.log10(Math.abs(this.actMin) / this.delMajor) + 1.5);
                ideca = (int)(Math.log10(Math.abs(this.actMin)) + 1.0);
            }
            double max = Math.max(Math.abs(this.actMin), Math.abs(this.actMax));
            this.precision = (int)(Math.log10(max) + 0.99);
            int plus = (int)(Math.log10(this.delMajor) - 0.99);
            if (plus < 0) {
                this.precision -= plus;
            }
            if (this.nMajorTicks > 10) {
                ++this.precision;
            }
            if (this.precision < 2) {
                this.precision = 2;
            }
            if (this.precision > 10) {
                this.precision = 10;
            }
            if (this.nMinorTicks < 1) {
                this.nMinorTicks = 1;
            }
            if (this.nMinorTicks > 100) {
                this.nMinorTicks = 100;
            }
            if (this.plot instanceof DOOCSPlotHist && ((DOOCSPlotHist)this.plot).isLogicPlot) {
                if (this.tickStringLength < 4) {
                    this.tickStringLength = 4;
                }
            } else {
                try {
                    String fmt = String.format("%%.%dg", this.precision);
                    String t1 = this.actMin == 0.0 ? "0.0" : String.format(fmt, this.actMin);
                    String t2 = String.format(fmt, this.actMax);
                    this.tickStringLength = Math.max(t1.length(), t2.length());
                }
                catch (IllegalFormatException e) {
                    this.tickStringLength = 5;
                }
            }
            this.transformScale = (double)this.pixelLength / (this.actMax - this.actMin);
        }
    }

    public void rescaleDrag(double min, double max) {
        if (this.isLog) {
            double delta = Math.log10(this.actMax) - Math.log10(this.actMin);
            double lmin = Math.log10(this.actMin);
            double lmax = Math.log10(this.actMax);
            double ldmin = this.defaultMin > 0.0 ? Math.log10(this.defaultMin) : lmin;
            double ldmax = this.defaultMax > 0.0 ? Math.log10(this.defaultMax) : lmax;
            double llmin = this.limitMin > 0.0 ? Math.log10(this.limitMin) : lmin;
            double llmax = this.limitMax > 0.0 ? Math.log10(this.limitMax) : lmax;
            min = min * delta + lmin;
            max = max * delta + lmin;
            if (min < lmin) {
                this.actMin = min > ldmin ? this.defaultMin : (this.actMin /= 1000.0);
                if (lmin < llmin) {
                    this.actMin = this.limitMin;
                }
            } else {
                this.actMin = Math.pow(10.0, min);
            }
            if (max > lmax) {
                this.actMax = max < ldmax ? this.defaultMax : (this.actMax *= 1000.0);
                if (lmax > llmax) {
                    this.actMax = this.limitMax;
                }
            } else {
                this.actMax = Math.pow(10.0, max);
            }
        } else {
            double delta = this.actMax - this.actMin;
            min = min * delta + this.actMin;
            max = max * delta + this.actMin;
            if (min < this.actMin) {
                this.actMin = min > this.defaultMin ? this.defaultMin : (this.actMin -= (this.actMax - this.actMin) * 3.0);
                if (this.actMin < this.limitMin) {
                    this.actMin = this.limitMin;
                }
            } else {
                this.actMin = min;
            }
            if (max > this.actMax) {
                this.actMax = max < this.defaultMax ? this.defaultMax : (this.actMax += (this.actMax - this.actMin) * 3.0);
                if (this.actMax > this.limitMax) {
                    this.actMax = this.limitMax;
                }
            } else {
                this.actMax = max;
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        if (this instanceof DOOCSPlotXAxisHist) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("xDuration", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X axis duration in sec</html>"), new DOOCSParameter("xDefaultMin", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X default min</html>"), new DOOCSParameter("xDefaultMax", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X default max</html>"), new DOOCSParameter("xLimitMin", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X hard left limit of the axis</html>"), new DOOCSParameter("xLimitMax", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X hard right limit of the axis</html>"), new DOOCSParameter("xTextFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.XAXIS, "<html>X font of the axis</html>"), new DOOCSParameter("xTextColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.XAXIS, "<html>color fo the axis text</html>"), new DOOCSParameter("xIsLog", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.XAXIS, "<html>X is a log scale</html>"), new DOOCSParameter("xHasGrid", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.XAXIS, "<html>Display X grid lines</html>"), new DOOCSParameter("xAutoScale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.XAXIS, "<html>Do autoscaling</html>"), new DOOCSParameter("xShowText", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.XAXIS, "<html>Show the text of the axis</html>"), new DOOCSParameter("xStrokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.XAXIS, "<html>Stroke size of the axis</html>"), new DOOCSParameter("xTickLength", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.XAXIS, "<html>Tick mark length in pixel</html>")};
            return parameters;
        }
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("xMin", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X axis minimum</html>"), new DOOCSParameter("xMax", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X axis maximum</html>"), new DOOCSParameter("xDefaultMin", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X default min</html>"), new DOOCSParameter("xDefaultMax", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X default max</html>"), new DOOCSParameter("xLimitMin", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X hard left limit of the axis</html>"), new DOOCSParameter("xLimitMax", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.XAXIS, "<html>X hard right limit of the axis</html>"), new DOOCSParameter("xTextFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.XAXIS, "<html>X font of the axis</html>"), new DOOCSParameter("xTextColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.XAXIS, "<html>color fo the axis text</html>"), new DOOCSParameter("xIsLog", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.XAXIS, "<html>X is a log scale</html>"), new DOOCSParameter("xHasGrid", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.XAXIS, "<html>Display X grid lines</html>"), new DOOCSParameter("xAutoScale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.XAXIS, "<html>Do autoscaling</html>"), new DOOCSParameter("xShowText", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.XAXIS, "<html>Show the text of the axis</html>"), new DOOCSParameter("xStrokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.XAXIS, "<html>Stroke size of the axis</html>"), new DOOCSParameter("xTickLength", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.XAXIS, "<html>Tick mark length in pixel</html>")};
        return parameters;
    }

    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("xDuration")) {
            return this.getDuration();
        }
        if (parameter.equalsIgnoreCase("xMin")) {
            return this.getMin();
        }
        if (parameter.equalsIgnoreCase("xMax")) {
            return this.getMax();
        }
        if (parameter.equalsIgnoreCase("xDefaultMin")) {
            return this.getDefaultMin();
        }
        if (parameter.equalsIgnoreCase("xDefaultMax")) {
            return this.getDefaultMax();
        }
        if (parameter.equalsIgnoreCase("xLimitMin")) {
            return this.getLimitMin();
        }
        if (parameter.equalsIgnoreCase("xLimitMax")) {
            return this.getLimitMax();
        }
        if (parameter.equalsIgnoreCase("xTextFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("xTextColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("xIsLog")) {
            return this.getIsLog();
        }
        if (parameter.equalsIgnoreCase("xHasGrid")) {
            return this.getHasGrid();
        }
        if (parameter.equalsIgnoreCase("xAutoScale")) {
            return this.getAutoScale();
        }
        if (parameter.equalsIgnoreCase("xShowText")) {
            return this.getShowText();
        }
        if (parameter.equalsIgnoreCase("xStrokeSize")) {
            return this.getStrokeSize();
        }
        if (parameter.equalsIgnoreCase("xTickLength")) {
            return this.getTickLength();
        }
        return null;
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("xMin")) {
            this.setMin(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("xMax")) {
            this.setMax(Double.parseDouble(value));
            if (this.actMin < this.actMax) {
                this.actDuration = this.actMax - this.actMin;
                this.roundUp(this.actMin, this.actMax);
            }
        } else if (parameter.equalsIgnoreCase("xDuration")) {
            this.setDuration(Double.parseDouble(value));
            this.actMin = this.actMax - this.actDuration;
            this.roundUp(this.actMin, this.actMax);
        } else if (parameter.equalsIgnoreCase("xMinMax")) {
            String[] str = value.split("\\s", 2);
            this.setMin(Double.parseDouble(str[0]));
            this.setMax(Double.parseDouble(str[1]));
            this.setAutoScale(false);
            this.roundUp(this.actMin, this.actMax);
            this.plot.repaint();
        } else if (parameter.equalsIgnoreCase("xDefaultMin")) {
            this.setDefaultMin(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("xDefaultMax")) {
            this.setDefaultMax(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("xLimitMin")) {
            this.setLimitMin(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("xLimitMax")) {
            this.setLimitMax(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("xTextFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("xTextColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("xIsLog")) {
            this.setIsLog(Boolean.parseBoolean(value));
            this.roundUp(this.actMin, this.actMax);
        } else if (parameter.equalsIgnoreCase("xHasGrid")) {
            this.setHasGrid(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("xAutoScale")) {
            this.setAutoScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("xShowText")) {
            this.setShowText(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("xStrokeSize")) {
            this.setStrokeSize(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("xTickLength")) {
            this.setTickLength(IntegerParser.parseInt(value));
        }
    }
}

