/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSToggleButtonUI;
import DOOCSComponents.ShowException;
import editor.EditorPanel;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import jsvnbrowser.JSVNFileInfo;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSToggleButton
extends JToggleButton
implements ActionListener,
DOOCSComponent,
MouseListener,
EqCallback {
    private String doocsTextON = null;
    private String doocsTextOFF = null;
    private Color doocsTextColorON;
    private Color doocsTextColorOFF;
    private Color doocsBgColorON;
    private Color doocsBgColorOFF;
    private String doocsIconFileON = null;
    private String doocsIconFileOFF = null;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private float doocsUpdateTime = 10.0f;
    private int doocsIndex = 0;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private int doocsClipX = 2;
    private int doocsClipY = 2;
    private String doocsRotate = "0";
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String errorMessage = null;
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    private EqAdr adrData = null;
    private Cursor myCursor;

    public DOOCSToggleButton() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setDoocsTextON("Button");
        this.setDoocsTextOFF("Button");
        this.setBackground(new Color(238, 238, 238));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setEnabled(this.doocsRunMode);
        this.addActionListener(this);
        this.addMouseListener(this);
        this.myCursor = this.getToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("icons/lightning.gif")).getImage(), new Point(0, 0), "Cursor");
        this.doocsTextColorON = this.getForeground();
        this.doocsTextColorOFF = this.getForeground();
        this.doocsBgColorON = this.getBackground();
        this.doocsBgColorOFF = this.getBackground();
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, null);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, null);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = new Dimension(1, 1);
        return dim;
    }

    public void setDoocsTextON(String text) {
        this.doocsTextON = text;
        this.setText(this.doocsTextON);
    }

    public String getDoocsTextON() {
        return this.doocsTextON;
    }

    public void setDoocsTextOFF(String text) {
        this.doocsTextOFF = text;
        this.setText(this.doocsTextOFF);
    }

    public String getDoocsTextOFF() {
        return this.doocsTextOFF;
    }

    public void setDoocsTextColorON(Color textColor) {
        this.doocsTextColorON = textColor;
    }

    public Color getDoocsTextColorON() {
        return this.doocsTextColorON;
    }

    public void setDoocsTextColorOFF(Color textColor) {
        this.doocsTextColorOFF = textColor;
    }

    public Color getDoocsTextColorOFF() {
        return this.doocsTextColorOFF;
    }

    public void setDoocsBgColorON(Color bgColor) {
        this.doocsBgColorON = bgColor;
    }

    public Color getDoocsBgColorON() {
        return this.doocsBgColorON;
    }

    public void setDoocsBgColorOFF(Color bgColor) {
        this.doocsBgColorOFF = bgColor;
        this.setBackground(bgColor);
    }

    public Color getDoocsBgColorOFF() {
        return this.doocsBgColorOFF;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsIndex(int index) {
        this.doocsIndex = index;
    }

    public int getDoocsIndex() {
        return this.doocsIndex;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsClipX(int clip) {
        this.doocsClipX = clip;
    }

    public int getDoocsClipX() {
        return this.doocsClipX;
    }

    public void setDoocsClipY(int clip) {
        this.doocsClipY = clip;
    }

    public int getDoocsClipY() {
        return this.doocsClipY;
    }

    public void setTheIcon(String file) {
        if (file != null && file.length() > 3) {
            if (file.startsWith("http://")) {
                try {
                    this.setIcon(new ImageIcon(new URL(file)));
                }
                catch (MalformedURLException mue) {
                    System.out.println(this.getName() + mue);
                }
            } else {
                JSVNFileInfo fInfo = DOOCSParameter.getDoocsFilePath(file, this);
                if (fInfo != null) {
                    this.setIcon(new ImageIcon(fInfo.buf));
                } else {
                    this.setIcon(null);
                }
            }
        } else {
            this.setIcon(null);
        }
    }

    public void setDoocsIconFileON(String file) {
        this.doocsIconFileON = file;
    }

    public String getDoocsIconFileON() {
        return this.doocsIconFileON;
    }

    public void setDoocsIconFileOFF(String file) {
        this.doocsIconFileOFF = file;
        this.setTheIcon(file);
    }

    public String getDoocsIconFileOFF() {
        return this.doocsIconFileOFF;
    }

    public void setDoocsRotate(String rotate) {
        if ((this.doocsRotate.equalsIgnoreCase("0") || this.doocsRotate.equalsIgnoreCase("180")) && (rotate.equalsIgnoreCase("90") || rotate.equalsIgnoreCase("270")) || (this.doocsRotate.equalsIgnoreCase("90") || this.doocsRotate.equalsIgnoreCase("270")) && (rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180"))) {
            this.setPreferredSize(new Dimension(this.getHeight(), this.getWidth()));
            this.setSize(this.getHeight(), this.getWidth());
            Container parent = this.getParent();
            if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
                if (this.getX() < 0) {
                    this.setLocation(0, this.getY());
                }
                if (this.getY() < 0) {
                    this.setLocation(this.getX(), 0);
                }
                if (this.getX() + this.getWidth() > parent.getWidth()) {
                    this.setLocation(parent.getWidth() - this.getWidth(), this.getY());
                }
                if (this.getY() + this.getHeight() > parent.getHeight()) {
                    this.setLocation(this.getX(), parent.getHeight() - this.getHeight());
                }
            }
        }
        this.doocsRotate = rotate;
        if (rotate.equalsIgnoreCase("270")) {
            this.setUI(new DOOCSToggleButtonUI(270, this.doocsBgColorOFF, this.doocsBgColorON));
        } else if (rotate.equalsIgnoreCase("90")) {
            this.setUI(new DOOCSToggleButtonUI(90, this.doocsBgColorOFF, this.doocsBgColorON));
        } else {
            this.setUI(new DOOCSToggleButtonUI(0, this.doocsBgColorOFF, this.doocsBgColorON));
        }
    }

    public void setDoocsRotateText(String rotate) {
        this.doocsRotate = rotate;
        if (rotate.equalsIgnoreCase("270")) {
            this.setUI(new DOOCSToggleButtonUI(270, this.doocsBgColorOFF, this.doocsBgColorON));
        } else if (rotate.equalsIgnoreCase("90")) {
            this.setUI(new DOOCSToggleButtonUI(90, this.doocsBgColorOFF, this.doocsBgColorON));
        } else {
            this.setUI(new DOOCSToggleButtonUI(0, this.doocsBgColorOFF, this.doocsBgColorON));
        }
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.startMonitors();
        } else if (this.adrData != null) {
            this.eq.clear_monitor(this.adrData);
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textON", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textOFF", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColorON", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColorOFF", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColorON", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColorOFF", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFileON", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconFileOFF", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSToggleButton ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSToggleButton>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("dataIndex")) {
            this.setDoocsIndex(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("textON")) {
            this.setDoocsTextON(value);
        } else if (parameter.equalsIgnoreCase("textOFF")) {
            this.setDoocsTextOFF(value);
        } else if (parameter.equalsIgnoreCase("textColorON")) {
            this.setDoocsTextColorON(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("textColorOFF")) {
            this.setDoocsTextColorOFF(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColorON")) {
            this.setDoocsBgColorON(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColorOFF")) {
            this.setDoocsBgColorOFF(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("buttonColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("iconFileON")) {
            this.setDoocsIconFileON(value);
        } else if (parameter.equalsIgnoreCase("iconFileOFF")) {
            this.setDoocsIconFileOFF(value);
        } else if (parameter.equalsIgnoreCase("iconTextGap")) {
            this.setIconTextGap(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("rotateText")) {
            this.setDoocsRotateText(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("clipX")) {
            this.setDoocsClipX(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("clipY")) {
            this.setDoocsClipY(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSToggleButton.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("dataIndex")) {
            return this.getDoocsIndex();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("textON")) {
            return this.getDoocsTextON();
        }
        if (parameter.equalsIgnoreCase("textOFF")) {
            return this.getDoocsTextOFF();
        }
        if (parameter.equalsIgnoreCase("textColorON")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsTextColorON());
        }
        if (parameter.equalsIgnoreCase("textColorOFF")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsTextColorOFF());
        }
        if (parameter.equalsIgnoreCase("bgColorON")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsBgColorON());
        }
        if (parameter.equalsIgnoreCase("bgColorOFF")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsBgColorOFF());
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("buttonColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("iconFileON")) {
            return this.getDoocsIconFileON();
        }
        if (parameter.equalsIgnoreCase("iconFileOFF")) {
            return this.getDoocsIconFileOFF();
        }
        if (parameter.equalsIgnoreCase("iconTextGap")) {
            return this.getIconTextGap();
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("clipX")) {
            return this.getDoocsClipX();
        }
        if (parameter.equalsIgnoreCase("clipY")) {
            return this.getDoocsClipY();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSToggleButton.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((DOOCSComponent)((Object)this.getComponent(i))).addDOOCSMouseListener(ml);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.doocsRunMode && this.doocsAddress != null && this.fullDoocsAddress != null) {
            EqAdr ea = new EqAdr(this.fullDoocsAddress);
            this.data.init();
            this.eq.get(ea, this.ed, this.data);
            if (this.data.error() == 0) {
                if (this.data.type() == 4 || this.data.type() == 119 || this.data.type() == 1 || this.data.type() == 105) {
                    int ivalue = this.data.get_int(this.doocsIndex);
                    int newValue = 0;
                    if (ivalue == 0) {
                        newValue = 1;
                    }
                    if (this.data.type() == 4 || this.data.type() == 119) {
                        this.ed.set_bool(newValue);
                    }
                    if (this.data.type() == 1 || this.data.type() == 105) {
                        this.ed.set(newValue, this.doocsIndex);
                    }
                    this.eq.set(ea, this.ed, this.data);
                    if (this.data.error() != 0) {
                        new ShowException(null, this.getName(), this.data.get_string_arg());
                        this.setSelected(!this.isSelected());
                        return;
                    }
                    if (newValue == 0) {
                        this.setBorder(BorderFactory.createBevelBorder(0));
                        this.setText(this.doocsTextOFF);
                        this.setTheIcon(this.doocsIconFileOFF);
                        this.setForeground(this.doocsTextColorOFF);
                        this.setBackground(this.doocsBgColorOFF);
                    } else {
                        this.setBorder(BorderFactory.createBevelBorder(1));
                        this.setText(this.doocsTextON);
                        this.setTheIcon(this.doocsIconFileON);
                        this.setForeground(this.doocsTextColorON);
                        this.setBackground(this.doocsBgColorON);
                    }
                    if (this.getToolTipText() != null) {
                        this.setToolTipText(this.fullDoocsAddress + " = " + ivalue);
                    }
                } else {
                    this.setSelected(!this.isSelected());
                    new ShowException(null, this.getName(), this.fullDoocsAddress + ": Wrong data type!");
                }
            } else {
                new ShowException(null, this.getName(), this.data.get_string_arg());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.doocsRunMode) {
            this.setCursor(this.myCursor);
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.doocsRunMode) {
            this.setCursor(new Cursor(0));
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void dataCallback(EqData dataOut, Object userData) {
        if (dataOut.error() == 0) {
            if (dataOut.type() == 4 || dataOut.type() == 119 || dataOut.type() == 1 || dataOut.type() == 105) {
                this.errorMessage = null;
                final int ivalue = dataOut.get_int(this.doocsIndex);
                if (ivalue != 0 && !this.isSelected() || ivalue == 0 && this.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ivalue == 0) {
                                DOOCSToggleButton.this.setSelected(false);
                                DOOCSToggleButton.this.setBorder(BorderFactory.createBevelBorder(0));
                                DOOCSToggleButton.this.setText(DOOCSToggleButton.this.doocsTextOFF);
                                DOOCSToggleButton.this.setTheIcon(DOOCSToggleButton.this.doocsIconFileOFF);
                                DOOCSToggleButton.this.setForeground(DOOCSToggleButton.this.doocsTextColorOFF);
                                DOOCSToggleButton.this.setBackground(DOOCSToggleButton.this.doocsBgColorOFF);
                                if (DOOCSToggleButton.this.getToolTipText() != null) {
                                    DOOCSToggleButton.this.setToolTipText(DOOCSToggleButton.this.fullDoocsAddress + " = 1");
                                }
                            } else {
                                DOOCSToggleButton.this.setSelected(true);
                                DOOCSToggleButton.this.setBorder(BorderFactory.createBevelBorder(1));
                                DOOCSToggleButton.this.setText(DOOCSToggleButton.this.doocsTextON);
                                DOOCSToggleButton.this.setTheIcon(DOOCSToggleButton.this.doocsIconFileON);
                                DOOCSToggleButton.this.setForeground(DOOCSToggleButton.this.doocsTextColorON);
                                DOOCSToggleButton.this.setBackground(DOOCSToggleButton.this.doocsBgColorON);
                                if (DOOCSToggleButton.this.getToolTipText() != null) {
                                    DOOCSToggleButton.this.setToolTipText(DOOCSToggleButton.this.fullDoocsAddress + " = 0");
                                }
                            }
                        }
                    });
                }
            } else if (this.errorMessage == null) {
                this.errorMessage = "Wrong data type!";
                System.out.println(DOOCSParameter.getFullName(this) + ": " + this.errorMessage);
            }
        } else if (this.errorMessage == null && this.doocsRunMode) {
            this.errorMessage = dataOut.get_string_arg();
            System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }
}

