/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSSlider;
import DOOCSComponents.DOOCSSliderDialog;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class DOOCSSliderUI
extends BasicSliderUI
implements MouseMotionListener,
MouseListener {
    final JPopupMenu pop = new JPopupMenu();
    JMenuItem item = new JMenuItem("0");
    private JSlider myslider;
    double stepSize = 0.0;

    public DOOCSSliderUI(JSlider slider) {
        super(slider);
        this.myslider = slider;
        slider.addMouseMotionListener(this);
        slider.addMouseListener(this);
        this.pop.add(this.item);
        this.pop.setDoubleBuffered(true);
    }

    public void showToolTip(MouseEvent me) {
        double doocsValue = this.myslider.getValue();
        for (int i = 0; i < ((DOOCSSlider)this.myslider.getParent()).getDoocsPrecision(); ++i) {
            doocsValue /= 10.0;
        }
        double tmp = Math.pow(10.0, ((DOOCSSlider)this.myslider.getParent()).getDoocsPrecision());
        doocsValue = Math.rint(doocsValue * tmp) / tmp;
        this.item.setText("" + doocsValue);
        Rectangle b = me.getComponent().getBounds();
        int x = me.getX();
        float sx = this.myslider.getValue();
        float d = this.myslider.getMaximum() - this.myslider.getMinimum();
        x = (int)(sx / d * (float)this.myslider.getWidth());
        int off = this.pop.getWidth() / 2;
        if (off == 0) {
            off = 32;
        }
        if (x > b.width - off) {
            x = b.width - off;
        }
        if (x < off) {
            x = off;
        }
        this.pop.show(me.getComponent(), x - off, -18);
        this.item.setArmed(false);
    }

    public void updateToolTip() {
        float doocsValue = this.myslider.getValue();
        for (int i = 0; i < ((DOOCSSlider)this.myslider.getParent()).getDoocsPrecision(); ++i) {
            doocsValue /= 10.0f;
        }
        this.item.setText("" + doocsValue);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.showToolTip(me);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isMetaDown()) {
            DOOCSSliderDialog sdialog = new DOOCSSliderDialog(this.stepSize);
            String tmp = sdialog.showDialog((JComponent)me.getSource());
            if (!tmp.equalsIgnoreCase("CANCEL")) {
                try {
                    this.stepSize = Double.parseDouble(tmp);
                }
                catch (NumberFormatException nfe) {}
            }
        } else {
            this.showToolTip(me);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.myslider.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.showToolTip(me);
        this.myslider.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.pop.setVisible(false);
    }
}

