/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class DOOCSLabelUI
extends BasicLabelUI {
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    protected int angle;

    public DOOCSLabelUI(int angle) {
        this.angle = angle;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        paintViewInsets = c.getInsets(paintViewInsets);
        DOOCSLabelUI.paintViewR.x = DOOCSLabelUI.paintViewInsets.left;
        DOOCSLabelUI.paintViewR.y = DOOCSLabelUI.paintViewInsets.top;
        DOOCSLabelUI.paintViewR.height = c.getWidth() - (DOOCSLabelUI.paintViewInsets.left + DOOCSLabelUI.paintViewInsets.right);
        DOOCSLabelUI.paintViewR.width = c.getHeight() - (DOOCSLabelUI.paintViewInsets.top + DOOCSLabelUI.paintViewInsets.bottom);
        DOOCSLabelUI.paintIconR.height = 0;
        DOOCSLabelUI.paintIconR.width = 0;
        DOOCSLabelUI.paintIconR.y = 0;
        DOOCSLabelUI.paintIconR.x = 0;
        DOOCSLabelUI.paintTextR.height = 0;
        DOOCSLabelUI.paintTextR.width = 0;
        DOOCSLabelUI.paintTextR.y = 0;
        DOOCSLabelUI.paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (this.angle == 90) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
        }
        if (this.angle == 180) {
            g2.rotate(Math.PI);
            g2.translate(-c.getHeight(), -c.getWidth());
        }
        if (this.angle == 270) {
            g2.rotate(-1.5707963267948966);
            g2.translate(-c.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(c, g, DOOCSLabelUI.paintIconR.x, DOOCSLabelUI.paintIconR.y);
        }
        if (text != null) {
            int textX = DOOCSLabelUI.paintTextR.x;
            int textY = DOOCSLabelUI.paintTextR.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, g, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, g, clippedText, textX, textY);
            }
        }
        g2.setTransform(tr);
    }
}

