/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import ttf.doocs.clnt.A_BYTE;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;

public class DOOCSCameraImage
extends JComponent
implements DOOCSComponent,
EqCallback {
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    private EqAdr adrData = null;
    private String errorMessage = null;
    private transient BufferedImage bimage = null;
    private MouseAdapter listener;
    private MouseMotionAdapter motionListener;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private float doocsUpdateTime = 1.0f;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private Image img = null;
    private byte[] R = new byte[256];
    private byte[] G = new byte[256];
    private byte[] B = new byte[256];
    private int xSize;
    private int ySize;
    private int len;
    private String doocsBits = "middle";
    private boolean doocsGrey = true;
    private byte[] XY;
    private int[] IXY;
    private ColorModel color_model;
    private MemoryImageSource memory_image_source;

    public DOOCSCameraImage() {
        this.setEnabled(this.doocsRunMode);
        this.setPreferredSize(new Dimension(100, 100));
        this.setSize(new Dimension(100, 100));
        this.listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1 && e.isMetaDown() && DOOCSCameraImage.this.doocsRunMode && DOOCSCameraImage.this.img != null) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenu submenu = new JMenu("Bits");
                    JCheckBoxMenuItem cmi = new JCheckBoxMenuItem("low", DOOCSCameraImage.this.doocsBits.equalsIgnoreCase("low"));
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSCameraImage.this.doocsBits = "low";
                        }
                    });
                    submenu.add(cmi);
                    cmi = new JCheckBoxMenuItem("middle", DOOCSCameraImage.this.doocsBits.equalsIgnoreCase("middle"));
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSCameraImage.this.doocsBits = "middle";
                        }
                    });
                    submenu.add(cmi);
                    cmi = new JCheckBoxMenuItem("high", DOOCSCameraImage.this.doocsBits.equalsIgnoreCase("high"));
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSCameraImage.this.doocsBits = "high";
                        }
                    });
                    submenu.add(cmi);
                    cmi = new JCheckBoxMenuItem("grey", DOOCSCameraImage.this.doocsGrey);
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DOOCSCameraImage.this.doocsGrey = !DOOCSCameraImage.this.doocsGrey;
                        }
                    });
                    popup.add(cmi);
                    popup.add(submenu);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.motionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DOOCSCameraImage.this.setTTT(e);
            }
        };
    }

    public void setTTT(MouseEvent e) {
        int xpos = Math.round((float)this.xSize / (float)this.getWidth() * (float)e.getX());
        int ypos = Math.round((float)this.ySize / (float)this.getHeight() * (float)e.getY());
        this.setToolTipText("<html>" + this.fullDoocsAddress + "<p>" + xpos + "," + ypos + "</html>");
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, null);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, null);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return this.fullDoocsAddress;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.addMouseListener(this.listener);
            this.addMouseMotionListener(this.motionListener);
            this.startMonitors();
        } else {
            this.removeMouseListener(this.listener);
            this.removeMouseMotionListener(this.motionListener);
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsGrey(boolean grey) {
        this.doocsGrey = grey;
    }

    public boolean getDoocsGrey() {
        return this.doocsGrey;
    }

    public void setDoocsBits(String bits) {
        this.doocsBits = bits;
    }

    public String getDoocsBits() {
        return this.doocsBits;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("grey", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bits", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("bits")) {
            String[] allowedValues = new String[]{"low", "middle", "high"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSCameraImage ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSCameraImage>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("grey")) {
            this.setDoocsGrey(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bits")) {
            this.setDoocsBits(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSCameraImage.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("grey")) {
            return this.getDoocsGrey();
        }
        if (parameter.equalsIgnoreCase("bits")) {
            return this.getDoocsBits();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSCameraImage.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void dataCallback(EqData dataOut, Object userData) {
        if (dataOut.error() == 0) {
            this.errorMessage = null;
            if (dataOut.type() == 106) {
                this.img = null;
                this.bimage = null;
                A_BYTE imageByteArray = dataOut.get_byte();
                byte[] iba = imageByteArray.d_byte_array;
                if (imageByteArray.option == 0 || imageByteArray.option == 2 || imageByteArray.option == 4) {
                    this.xSize = imageByteArray.x_dim;
                    this.ySize = imageByteArray.y_dim;
                    this.doImage(iba, imageByteArray.option);
                } else if (imageByteArray.option == 1) {
                    try {
                        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)new ByteArrayInputStream(iba));
                        this.bimage = decoder.decodeAsBufferedImage();
                        this.xSize = this.bimage.getWidth();
                        this.ySize = this.bimage.getHeight();
                    }
                    catch (IOException e) {}
                } else if (imageByteArray.option == 3) {
                    try {
                        this.bimage = ImageIO.read(new ByteArrayInputStream(iba));
                        this.xSize = this.bimage.getWidth();
                        this.ySize = this.bimage.getHeight();
                    }
                    catch (IOException e) {}
                } else {
                    System.err.println(this.getName() + ": unsupported image format");
                }
                this.repaint();
            }
        } else if (this.errorMessage == null && this.doocsRunMode) {
            this.errorMessage = dataOut.get_string_arg();
            System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
        }
    }

    private void doImage(byte[] xy, int op) {
        int index;
        if (op == 0) {
            this.len = this.xSize * this.ySize / 3;
            this.IXY = new int[this.len];
            for (index = 0; index < this.len; ++index) {
                this.IXY[index] = 0;
                this.IXY[index] = xy[3 * index] << 24 | xy[3 * index + 1] << 16 | xy[3 * index + 2] << 8;
            }
            this.memory_image_source = new MemoryImageSource(this.xSize / 3, this.ySize, this.IXY, 0, this.xSize / 3);
        }
        if (op == 2) {
            this.len = this.xSize * this.ySize;
            this.XY = new byte[this.len];
            for (index = 0; index < this.len; ++index) {
                this.XY[index] = xy[index];
            }
            if (this.doocsGrey) {
                this.do_gray();
            } else {
                this.do_jet();
            }
            this.color_model = new IndexColorModel(8, 256, this.R, this.G, this.B);
            this.memory_image_source = new MemoryImageSource(this.xSize, this.ySize, this.color_model, this.XY, 0, this.xSize);
        }
        if (op == 4) {
            this.len = this.xSize * this.ySize / 2;
            this.XY = new byte[this.len];
            if (this.doocsBits.equalsIgnoreCase("low")) {
                for (index = 0; index < this.len; ++index) {
                    this.XY[index] = xy[2 * index];
                }
            } else if (this.doocsBits.equalsIgnoreCase("high")) {
                for (index = 0; index < this.len; ++index) {
                    this.XY[index] = xy[2 * index + 1];
                }
            } else {
                for (index = 0; index < this.len; ++index) {
                    this.XY[index] = (byte)(xy[2 * index] & 0xF | xy[2 * index + 1] & 0xF0);
                }
            }
            if (this.doocsGrey) {
                this.do_gray();
            } else {
                this.do_jet();
            }
            this.color_model = new IndexColorModel(8, 256, this.R, this.G, this.B);
            this.memory_image_source = new MemoryImageSource(this.xSize / 2, this.ySize, this.color_model, this.XY, 0, this.xSize / 2);
        }
        this.memory_image_source.setAnimated(true);
        this.memory_image_source.setFullBufferUpdates(true);
        this.img = this.createImage(this.memory_image_source);
        if (this.img != null) {
            this.img.flush();
        }
    }

    public void do_gray() {
        for (int index = 0; index < 256; ++index) {
            this.G[index] = this.B[index] = (byte)index;
            this.R[index] = this.B[index];
        }
    }

    public void do_jet() {
        for (int i = 0; i < 256; ++i) {
            if (i < 32) {
                this.G[i] = 0;
                this.R[i] = 0;
                this.B[i] = (byte)(127 + i * 4);
            }
            if (i >= 32 && i < 96) {
                this.G[i] = (byte)(3 + (i - 32) * 4);
                this.R[i] = 0;
                this.B[i] = -1;
            }
            if (i >= 96 && i < 160) {
                this.R[i] = (byte)(3 + (i - 96) * 4);
                this.G[i] = -1;
                this.B[i] = (byte)(255 - (i - 96) * 4);
            }
            if (i >= 160 && i < 224) {
                this.R[i] = -1;
                this.G[i] = (byte)(255 - (i - 160) * 4);
                this.B[i] = 0;
            }
            if (i < 224) continue;
            this.G[i] = 0;
            this.B[i] = 0;
            this.R[i] = (byte)(255 - (i - 224) * 4);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.isRunMode() && this.bimage != null && this.img == null) {
            g2.scale((double)this.getWidth() / (double)this.bimage.getWidth(), (double)this.getHeight() / (double)this.bimage.getHeight());
            g2.drawImage(this.bimage, null, 0, 0);
        } else if (this.isRunMode() && this.bimage == null && this.img != null) {
            g2.scale((double)this.getWidth() / (double)this.img.getWidth(null), (double)this.getHeight() / (double)this.img.getHeight(null));
            g2.drawImage(this.img, 0, 0, null);
        } else {
            Color col = g2.getColor();
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(col);
        }
        g2.dispose();
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

