/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.BrowserControl;
import DOOCSComponents.DOOCSButtonAdrList;
import DOOCSComponents.DOOCSButtonSetList;
import DOOCSComponents.DOOCSButtonUI;
import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSIncludeComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.PrintUtilities;
import DOOCSComponents.ShowException;
import editor.EditorPanel;
import editor.StartParameters;
import editor.undo.SetProperty;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ButtonUI;
import jsvnbrowser.JSVNFileInfo;
import layoutmanager.ScaleLayout;
import runtime.jdddPanel;
import runtime.jddd_run;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.DOOCSParser;
import xmlparser.IntegerParser;

public class DOOCSButton
extends JButton
implements ActionListener,
DOOCSComponent,
MouseListener {
    private Cursor defaultCursor = new Cursor(0);
    private Cursor waitCursor = new Cursor(3);
    private String doocsFunction = "Data to Device";
    private String doocsText = null;
    private String doocsAddress = null;
    private String doocsIndirectAddress = null;
    public DOOCSButtonAdrList doocsAdrList;
    private DOOCSButtonSetList doocsSetList;
    private String fullDoocsAddress = null;
    private String doocsIconFile = null;
    private String doocsToolTipText = null;
    private String doocsDataOp = null;
    private String doocsXmlFile = null;
    private String doocsCommand = null;
    private String doocsPrinter = null;
    private String doocsHelpURL = null;
    private boolean doocsScale = true;
    private boolean doocsButtonTransparent = false;
    private boolean doocsButton3D = true;
    private int doocsClipX = 2;
    private int doocsClipY = 2;
    private String doocsRotate = "0";
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private boolean mouseOver = false;
    private Rectangle m_initialBounds;
    private ButtonUI defaultUI;
    private Border defaultBorder;
    private Cursor myCursor;
    private transient BufferedImage highlight;

    public DOOCSButton() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setDoocsText("Button");
        this.setBackground(new Color(238, 238, 238));
        this.setEnabled(this.doocsRunMode);
        this.addActionListener(this);
        this.defaultBorder = this.getBorder();
        this.myCursor = this.getToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("icons/lightning.gif")).getImage(), new Point(0, 0), "Cursor");
        this.defaultUI = this.getUI();
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.doocsAdrList = new DOOCSButtonAdrList();
        this.doocsSetList = new DOOCSButtonSetList();
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = new Dimension(1, 1);
        return dim;
    }

    public void setDoocsText(String text) {
        this.doocsText = text;
        if (!this.doocsButtonTransparent) {
            this.setText(this.doocsText);
        }
    }

    public String getDoocsText() {
        return this.doocsText;
    }

    public void setDoocsFunction(String function) {
        this.doocsFunction = function;
    }

    public String getDoocsFunction() {
        return this.doocsFunction;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    public void setDoocsIndirectAddress(String address) {
        this.doocsIndirectAddress = address;
    }

    public String getDoocsIndirectAddress() {
        return this.doocsIndirectAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
        if (!DOOCSParameter.getLastLayeredPane(this).isEditMode()) {
            String text = this.doocsText;
            if (address != null && this.doocsText != null) {
                EqAdr ea = new EqAdr(address);
                if (EqAdr.isValidAdr((String)address)) {
                    text = text.replace("$f", ea.facility());
                    text = text.replace("$d", ea.device());
                    text = text.replace("$l", ea.location());
                    text = text.replace("$p", ea.property());
                }
                this.setText(text);
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        if (this.doocsFunction.equalsIgnoreCase("Data to Device")) {
            return this.doocsAdrList.getFullDoocsAddress();
        }
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        if (ttt != null && ttt.startsWith("<html>/")) {
            ttt = "<html>&#47;" + ttt.substring(7);
        }
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public String getCorrectDoocsToolTipText() {
        if (!this.isRunMode() && this.doocsToolTipText != null) {
            return this.doocsToolTipText;
        }
        if (this.isRunMode() || DOOCSParameter.getParentLayeredPane((DOOCSComponent)this).showToolTip) {
            if (this.doocsFunction.equalsIgnoreCase("Data to Device")) {
                return this.getFullDoocsAddress();
            }
            if (this.doocsFunction.equalsIgnoreCase("New Window")) {
                if (this.fullDoocsAddress == null) {
                    return "New Window: " + this.doocsXmlFile;
                }
                return "<html>New Window: " + this.doocsXmlFile + "<br>Adr: " + this.fullDoocsAddress + "</html>";
            }
            if (this.doocsFunction.equalsIgnoreCase("Replace Window")) {
                if (this.fullDoocsAddress == null) {
                    return "Replace Window: " + this.doocsXmlFile;
                }
                return "<html>Replace Window: " + this.doocsXmlFile + "<br>Adr: " + this.fullDoocsAddress + "</html>";
            }
            if (this.doocsFunction.equalsIgnoreCase("Override Window")) {
                if (this.fullDoocsAddress == null) {
                    return "Override Window: " + this.doocsXmlFile;
                }
                return "<html>Override Window: " + this.doocsXmlFile + "<br>Adr: " + this.fullDoocsAddress + "</html>";
            }
            if (this.doocsFunction.equalsIgnoreCase("Close Window")) {
                return "Close Window: " + this.doocsXmlFile;
            }
            if (this.doocsFunction.equalsIgnoreCase("Set Component Property")) {
                return this.doocsSetList.getToolTipText();
            }
            if (this.doocsFunction.equalsIgnoreCase("Shell Command")) {
                String command = this.doocsCommand;
                if (this.doocsAddress != null) {
                    command = command + " " + this.fullDoocsAddress;
                }
                if (this.doocsIndirectAddress != null) {
                    command = command + " " + DOOCSParser.inheritDoocsAddress(this, this.doocsIndirectAddress);
                }
                return command;
            }
            if (this.doocsFunction.equalsIgnoreCase("Print Panel")) {
                return "Print panel to " + this.doocsPrinter + ".";
            }
            if (this.doocsFunction.equalsIgnoreCase("Help")) {
                return "Open " + this.doocsHelpURL;
            }
        }
        return null;
    }

    public void setDoocsDataOp(String dataOp) {
        this.doocsDataOp = dataOp;
    }

    public String getDoocsDataOp() {
        return this.doocsDataOp;
    }

    public void setDoocsXmlFile(String file) {
        this.doocsXmlFile = file;
    }

    public String getDoocsXmlFile() {
        return this.doocsXmlFile;
    }

    public void setDoocsCommand(String command) {
        if (command != null) {
            this.doocsCommand = command.trim();
        }
    }

    public String getDoocsCommand() {
        return this.doocsCommand;
    }

    public void setDoocsPrinter(String printer) {
        if (printer != null) {
            this.doocsPrinter = printer.trim();
        }
    }

    public String getDoocsPrinter() {
        return this.doocsPrinter;
    }

    public void setDoocsHelpURL(String url) {
        this.doocsHelpURL = url;
    }

    public String getDoocsHelpURL() {
        return this.doocsHelpURL;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsClipX(int clip) {
        this.doocsClipX = clip;
    }

    public int getDoocsClipX() {
        return this.doocsClipX;
    }

    public void setDoocsClipY(int clip) {
        this.doocsClipY = clip;
    }

    public int getDoocsClipY() {
        return this.doocsClipY;
    }

    public void setDoocsIconFile(String file) {
        this.doocsIconFile = file;
        if (file != null) {
            if (file.startsWith("http://")) {
                try {
                    this.setIcon(new ImageIcon(new URL(file)));
                }
                catch (MalformedURLException mue) {
                    System.out.println(DOOCSParameter.getFullName(this) + ": " + mue);
                }
            } else {
                JSVNFileInfo fInfo = DOOCSParameter.getDoocsFilePath(file, this);
                if (fInfo != null) {
                    this.setIcon(new ImageIcon(fInfo.buf));
                } else {
                    this.setIcon(null);
                }
            }
        }
        if (file == null) {
            this.setIcon(null);
        }
    }

    public String getDoocsIconFile() {
        return this.doocsIconFile;
    }

    public void setDoocsRotate(String rotate) {
        if ((this.doocsRotate.equalsIgnoreCase("0") || this.doocsRotate.equalsIgnoreCase("180")) && (rotate.equalsIgnoreCase("90") || rotate.equalsIgnoreCase("270")) || (this.doocsRotate.equalsIgnoreCase("90") || this.doocsRotate.equalsIgnoreCase("270")) && (rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180"))) {
            this.setPreferredSize(new Dimension(this.getHeight(), this.getWidth()));
            this.setSize(this.getHeight(), this.getWidth());
            Container parent = this.getParent();
            if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
                if (this.getX() < 0) {
                    this.setLocation(0, this.getY());
                }
                if (this.getY() < 0) {
                    this.setLocation(this.getX(), 0);
                }
                if (this.getX() + this.getWidth() > parent.getWidth()) {
                    this.setLocation(parent.getWidth() - this.getWidth(), this.getY());
                }
                if (this.getY() + this.getHeight() > parent.getHeight()) {
                    this.setLocation(this.getX(), parent.getHeight() - this.getHeight());
                }
            }
        }
        this.doocsRotate = rotate;
        if (rotate.equalsIgnoreCase("270")) {
            this.setUI(new DOOCSButtonUI(270));
        } else if (rotate.equalsIgnoreCase("90")) {
            this.setUI(new DOOCSButtonUI(90));
        } else {
            this.setUI(this.defaultUI);
        }
    }

    public void setDoocsRotateText(String rotate) {
        this.doocsRotate = rotate;
        if (rotate.equalsIgnoreCase("270")) {
            this.setUI(new DOOCSButtonUI(270));
        } else if (rotate.equalsIgnoreCase("90")) {
            this.setUI(new DOOCSButtonUI(90));
        } else {
            this.setUI(this.defaultUI);
        }
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.addMouseListener(this);
            int HIGHLIGHT_SIZE = Math.round((float)this.getHeight() * 1.5f);
            if (this.getWidth() < this.getHeight()) {
                HIGHLIGHT_SIZE = Math.round((float)this.getWidth() * 1.5f);
            }
            if (HIGHLIGHT_SIZE <= 0) {
                HIGHLIGHT_SIZE = 1;
            }
            this.highlight = new BufferedImage(HIGHLIGHT_SIZE, HIGHLIGHT_SIZE, 2);
            Graphics2D g2d = this.highlight.createGraphics();
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, HIGHLIGHT_SIZE, HIGHLIGHT_SIZE);
            g2d.setComposite(AlphaComposite.SrcOver);
            Point2D.Float center = new Point2D.Float((float)HIGHLIGHT_SIZE / 2.0f, (float)HIGHLIGHT_SIZE / 2.0f);
            float radius = (float)HIGHLIGHT_SIZE / 2.0f;
            float[] dist = new float[]{0.0f, 0.95f};
            Color[] colors = new Color[]{new Color(255, 255, 255, 150), new Color(255, 255, 255, 0)};
            RadialGradientPaint paint = new RadialGradientPaint(center, radius, dist, colors);
            g2d.setPaint(paint);
            g2d.fillOval(0, 0, HIGHLIGHT_SIZE, HIGHLIGHT_SIZE);
            g2d.dispose();
        } else {
            this.removeMouseListener(this);
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setDoocsButtonTransparent(boolean trans) {
        this.doocsButtonTransparent = trans;
        if (trans) {
            this.setOpaque(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setText(null);
        } else {
            this.setOpaque(true);
            this.setBorderPainted(true);
            this.setContentAreaFilled(true);
            this.setText(this.doocsText);
        }
    }

    public boolean isDoocsButtonTransparent() {
        return this.doocsButtonTransparent;
    }

    public void setDoocsButton3D(boolean dd) {
        this.doocsButton3D = dd;
        if (dd) {
            this.setBorder(BorderFactory.createBevelBorder(0));
        } else {
            this.setBorder(this.defaultBorder);
        }
    }

    public boolean isDoocsButton3D() {
        return this.doocsButton3D;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g);
        if (this.isRunMode() && this.mouseOver) {
            g.drawImage(this.highlight, this.getWidth() / 2 - this.highlight.getWidth() / 2, this.getHeight() / 2 - this.highlight.getHeight() / 2, null);
        }
        if (this.doocsButtonTransparent) {
            if (!this.isRunMode()) {
                Color col = g2.getColor();
                g2.setColor(Color.LIGHT_GRAY);
                g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g2.setColor(col);
            } else if (this.mouseOver) {
                Color col = g2.getColor();
                g2.setColor(Color.GREEN);
                g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                g2.setColor(col);
            }
        }
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        if (this.doocsFunction.equalsIgnoreCase("New Window") || this.doocsFunction.equalsIgnoreCase("Replace Window") || this.doocsFunction.equalsIgnoreCase("Override Window")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("button3D", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("indirectAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "Control system property containing an address string."), new DOOCSParameter("xmlFile", DOOCSParameter.ParameterTypes.XMLFILE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        if (this.doocsFunction.equalsIgnoreCase("Close Window")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("button3D", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        if (this.doocsFunction.equalsIgnoreCase("Set Component Property")) {
            DOOCSParameter[] parameters1 = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("button3D", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("indirectAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "Control system property containing an address string.")};
            DOOCSParameter[] parameters2 = this.doocsSetList.getDOOCSParameterList();
            DOOCSParameter[] parameters3 = new DOOCSParameter[]{new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            DOOCSParameter[] parameters = new DOOCSParameter[parameters1.length + parameters2.length + parameters3.length];
            System.arraycopy(parameters1, 0, parameters, 0, parameters1.length);
            System.arraycopy(parameters2, 0, parameters, parameters1.length, parameters2.length);
            System.arraycopy(parameters3, 0, parameters, parameters1.length + parameters2.length, parameters3.length);
            return parameters;
        }
        if (this.doocsFunction.equalsIgnoreCase("Shell Command")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("button3D", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("command", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("indirectAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "Control system property containing an address string."), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        if (this.doocsFunction.equalsIgnoreCase("Print Panel")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("button3D", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("printer", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        if (this.doocsFunction.equalsIgnoreCase("Help")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("button3D", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("helpURL", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        DOOCSParameter[] parameters1 = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("buttonTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("button3D", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.EXPERT)};
        DOOCSParameter[] parameters2 = this.doocsAdrList.getDOOCSParameterList();
        DOOCSParameter[] parameters3 = new DOOCSParameter[]{new DOOCSParameter("dataOp", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        DOOCSParameter[] parameters = new DOOCSParameter[parameters1.length + parameters2.length + parameters3.length];
        System.arraycopy(parameters1, 0, parameters, 0, parameters1.length);
        System.arraycopy(parameters2, 0, parameters, parameters1.length, parameters2.length);
        System.arraycopy(parameters3, 0, parameters, parameters1.length + parameters2.length, parameters3.length);
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("function")) {
            String[] allowedValues = new String[]{"Data to Device", "New Window", "Replace Window", "Override Window", "Close Window", "Set Component Property", "Shell Command", "Print Panel", "Help"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("printer")) {
            PrintService[] service = PrintServiceLookup.lookupPrintServices(null, null);
            String[] allowedValues = new String[service.length + 1];
            allowedValues[0] = "File";
            for (int i = 0; i < service.length; ++i) {
                allowedValues[i + 1] = service[i].getName();
            }
            return allowedValues;
        }
        if (parameter.startsWith("property") && !parameter.startsWith("propertyValue")) {
            return this.getPropertyList(parameter);
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSButton ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSButton>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("function")) {
            this.setDoocsFunction(value);
        } else if (parameter.equalsIgnoreCase("text")) {
            this.setDoocsText(value);
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("buttonColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("buttonTransparent")) {
            this.setDoocsButtonTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("button3D")) {
            this.setDoocsButton3D(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("iconFile")) {
            this.setDoocsIconFile(value);
        } else if (parameter.equalsIgnoreCase("iconTextGap")) {
            this.setIconTextGap(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("indirectAdr")) {
            this.setDoocsIndirectAddress(value);
        } else if (parameter.startsWith("adr") && !parameter.equalsIgnoreCase("adr")) {
            this.doocsAdrList.setDoocsAddress(parameter, value);
        } else if (parameter.startsWith("value")) {
            this.doocsAdrList.setDoocsValue(parameter, value);
        } else if (parameter.equalsIgnoreCase("dataOp")) {
            this.setDoocsDataOp(value);
        } else if (parameter.equalsIgnoreCase("xmlFile")) {
            this.setDoocsXmlFile(value);
        } else if (parameter.startsWith("component")) {
            this.doocsSetList.setDoocsComponent(parameter, value);
        } else if (parameter.startsWith("property") && !parameter.startsWith("propertyValue")) {
            this.doocsSetList.setDoocsProperty(parameter, value);
        } else if (parameter.startsWith("propertyValue")) {
            this.doocsSetList.setDoocsPropertyValue(parameter, value);
        } else if (parameter.equalsIgnoreCase("command")) {
            this.setDoocsCommand(value);
        } else if (parameter.equalsIgnoreCase("printer")) {
            this.setDoocsPrinter(value);
        } else if (parameter.equalsIgnoreCase("helpURL")) {
            this.setDoocsHelpURL(value);
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("rotateText")) {
            this.setDoocsRotateText(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("clipX")) {
            this.setDoocsClipX(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("clipY")) {
            this.setDoocsClipY(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSButton.setDOOCSParameter: wrong parameter " + this.getName() + "." + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("function")) {
            return this.getDoocsFunction();
        }
        if (parameter.equalsIgnoreCase("text")) {
            return this.getDoocsText();
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("buttonColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("buttonTransparent")) {
            return this.isDoocsButtonTransparent();
        }
        if (parameter.equalsIgnoreCase("button3D")) {
            return this.isDoocsButton3D();
        }
        if (parameter.equalsIgnoreCase("iconFile")) {
            return this.getDoocsIconFile();
        }
        if (parameter.equalsIgnoreCase("iconTextGap")) {
            return this.getIconTextGap();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("indirectAdr")) {
            return this.getDoocsIndirectAddress();
        }
        if (parameter.startsWith("adr") && !parameter.equalsIgnoreCase("adr")) {
            return this.doocsAdrList.getDoocsAddress(parameter);
        }
        if (parameter.startsWith("value")) {
            return this.doocsAdrList.getDoocsValue(parameter);
        }
        if (parameter.equalsIgnoreCase("dataOp")) {
            return this.getDoocsDataOp();
        }
        if (parameter.equalsIgnoreCase("xmlFile")) {
            return this.getDoocsXmlFile();
        }
        if (parameter.startsWith("component")) {
            return this.doocsSetList.getDoocsComponent(parameter);
        }
        if (parameter.startsWith("property") && !parameter.startsWith("propertyValue")) {
            return this.doocsSetList.getDoocsProperty(parameter);
        }
        if (parameter.startsWith("propertyValue")) {
            return this.doocsSetList.getDoocsPropertyValue(parameter);
        }
        if (parameter.equalsIgnoreCase("command")) {
            return this.getDoocsCommand();
        }
        if (parameter.equalsIgnoreCase("printer")) {
            return this.getDoocsPrinter();
        }
        if (parameter.equalsIgnoreCase("helpURL")) {
            return this.getDoocsHelpURL();
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("clipX")) {
            return this.getDoocsClipX();
        }
        if (parameter.equalsIgnoreCase("clipY")) {
            return this.getDoocsClipY();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSButton.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    private String[] getPropertyList(String name) {
        String doocsComponent = this.doocsSetList.getDoocsComponent(IntegerParser.parseInt(name.substring(8)));
        if (doocsComponent == null || doocsComponent.length() < 3) {
            return new String[1];
        }
        Vector<String> props = new Vector<String>();
        Container rootPane = this;
        while (!(rootPane instanceof EditorPanel)) {
            rootPane = rootPane.getParent();
        }
        DOOCSComponent dcomp = jdddPanel.getDoocsComponent(rootPane, doocsComponent);
        if (dcomp != null) {
            for (int i = 0; i < dcomp.getDOOCSParameterList().length; ++i) {
                String parameter = dcomp.getDOOCSParameterList()[i].parameter;
                if (parameter.equalsIgnoreCase("name") || parameter.equalsIgnoreCase("toolTipText") || parameter.equalsIgnoreCase("layer") || parameter.equalsIgnoreCase("scale")) continue;
                props.add(parameter);
            }
        }
        String[] criteria = new String[props.size()];
        return props.toArray(criteria);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.doocsRunMode) {
            EqData data;
            EqData ed;
            EqAdr ea;
            EqCall eq;
            if (this.doocsFunction.equalsIgnoreCase("Help") && this.doocsHelpURL != null) {
                BrowserControl.displayURL(this.doocsHelpURL);
            }
            if (this.doocsFunction.equalsIgnoreCase("Data to Device")) {
                for (int i = 0; i < this.doocsAdrList.size(); ++i) {
                    if (this.doocsAdrList.getFullDoocsAddress(i) == null || this.doocsAdrList.getFullDoocsAddress(i).length() <= 5) continue;
                    eq = new EqCall();
                    ea = new EqAdr(this.doocsAdrList.getFullDoocsAddress(i));
                    ed = new EqData();
                    data = new EqData();
                    data.init();
                    eq.get(ea, ed, data);
                    if (data.error() == 0) {
                        String doocsValue = this.doocsAdrList.getDoocsValue(i);
                        if (data.type() == 0) {
                            data.set_type(4);
                        }
                        try {
                            switch (data.type()) {
                                case 105: 
                                case 119: {
                                    ed.allocate_array(data.type(), 1, 0);
                                    ed.set(IntegerParser.parseInt(doocsValue));
                                    break;
                                }
                                case 1: {
                                    ed.set(IntegerParser.parseInt(doocsValue));
                                    break;
                                }
                                case 4: {
                                    ed.set_bool(IntegerParser.parseInt(doocsValue));
                                    break;
                                }
                                case 2: 
                                case 100: {
                                    ed.allocate_array(data.type(), 1, 0);
                                    ed.set(Float.parseFloat(doocsValue));
                                    break;
                                }
                                case 3: 
                                case 5: 
                                case 7: 
                                case 16: 
                                case 103: {
                                    ed.allocate_array(data.type(), 1, 0);
                                    ed.set_from_string(doocsValue);
                                    break;
                                }
                                default: {
                                    new ShowException(null, "DOOCSButton", "to Elke: insert new Data type " + data.type() + " in DOOCSButton.java");
                                }
                            }
                            eq.set(ea, ed, data);
                            if (data.error() == 0) continue;
                            new ShowException(null, DOOCSParameter.getFullName(this) + ": " + this.doocsAdrList.getFullDoocsAddress(i), data.get_string_arg());
                        }
                        catch (NumberFormatException nfe) {
                            new ShowException(null, DOOCSParameter.getFullName(this) + ": " + this.doocsAdrList.getFullDoocsAddress(i), nfe);
                        }
                        continue;
                    }
                    new ShowException(null, this.getName(), data.get_string_arg());
                }
            }
            if ((this.doocsFunction.equalsIgnoreCase("New Window") || this.doocsFunction.equalsIgnoreCase("Replace Window") || this.doocsFunction.equalsIgnoreCase("Override Window")) && this.doocsXmlFile != null) {
                String newIndirectAdr = null;
                if (this.doocsIndirectAddress != null && this.doocsIndirectAddress.length() > 3) {
                    eq = new EqCall();
                    ea = new EqAdr(DOOCSParser.inheritDoocsAddress(this, this.doocsIndirectAddress));
                    ed = new EqData();
                    data = new EqData();
                    eq.get(ea, ed, data);
                    if (data.error() == 0) {
                        newIndirectAdr = data.get_string_arg();
                    } else {
                        new ShowException(null, this.getName(), data.get_string_arg());
                    }
                }
                if (this.doocsFunction.equalsIgnoreCase("Override Window")) {
                    if (newIndirectAdr != null) {
                        jddd_run.startPanel(this.doocsXmlFile, newIndirectAdr, this, true, false, null);
                    } else {
                        jddd_run.startPanel(this.doocsXmlFile, this.fullDoocsAddress, this, true, false, null);
                    }
                }
                if (this.doocsFunction.equalsIgnoreCase("Replace Window")) {
                    Point position = DOOCSParameter.getParentFrame(this).getLocation();
                    if (newIndirectAdr != null) {
                        jddd_run.startPanel(this.doocsXmlFile, newIndirectAdr, this, false, false, position);
                    } else {
                        jddd_run.startPanel(this.doocsXmlFile, this.fullDoocsAddress, this, false, false, position);
                    }
                    DOOCSParameter.getParentFrame(this).dispose();
                }
                if (this.doocsFunction.equalsIgnoreCase("New Window")) {
                    if (newIndirectAdr != null) {
                        jddd_run.startPanel(this.doocsXmlFile, newIndirectAdr, this, false, false, null);
                    } else {
                        jddd_run.startPanel(this.doocsXmlFile, this.fullDoocsAddress, this, false, false, null);
                    }
                }
            }
            if (this.doocsFunction.equalsIgnoreCase("Close Window")) {
                DOOCSParameter.getParentFrame(this).dispose();
            }
            if (this.doocsFunction.equalsIgnoreCase("Set Component Property")) {
                DOOCSParameter.getParentFrame(this).setCursor(this.waitCursor);
                Container rootPane = this;
                while (!(rootPane.getParent() instanceof JViewport)) {
                    rootPane = rootPane.getParent();
                }
                for (int i = 0; i < this.doocsSetList.size(); ++i) {
                    String doocsComponent = this.doocsSetList.getDoocsComponent(i);
                    String doocsProperty = this.doocsSetList.getDoocsProperty(i);
                    String doocsPropertyValue = this.doocsSetList.getDoocsPropertyValue(i);
                    DOOCSComponent dcomp = jdddPanel.getDoocsComponent(rootPane, doocsComponent);
                    if (dcomp != null && !doocsProperty.equalsIgnoreCase("bounds") && !doocsProperty.equalsIgnoreCase("adr")) {
                        dcomp.setDOOCSParameter(doocsProperty, doocsPropertyValue);
                    }
                    if (doocsProperty.equalsIgnoreCase("bounds") && dcomp.getParent() instanceof DOOCSLayeredPane) {
                        double xfactor = ((ScaleLayout)dcomp.getParent().getLayout()).getXFactor();
                        double yfactor = ((ScaleLayout)dcomp.getParent().getLayout()).getYFactor();
                        Rectangle bounds = DOOCSParameter.convertToBounds(doocsPropertyValue);
                        bounds.x = Math.round((float)((double)bounds.x * xfactor));
                        bounds.y = Math.round((float)((double)bounds.y * yfactor));
                        bounds.width = Math.round((float)((double)bounds.width * xfactor));
                        bounds.height = Math.round((float)((double)bounds.height * yfactor));
                        ((ScaleLayout)dcomp.getParent().getLayout()).changeComponentBounds((Component)((Object)dcomp), DOOCSParameter.convertToBounds(doocsPropertyValue));
                        ((Component)((Object)dcomp)).setBounds(bounds);
                    }
                    if (doocsProperty.equalsIgnoreCase("xmlFile") && dcomp instanceof DOOCSIncludeComponent) {
                        if (this.doocsAddress != null) {
                            dcomp.setDOOCSParameter("adr", this.doocsAddress);
                        }
                        if (this.doocsIndirectAddress != null && this.doocsIndirectAddress.length() > 3) {
                            EqCall eq2 = new EqCall();
                            EqAdr ea2 = new EqAdr(DOOCSParser.inheritDoocsAddress(this, this.doocsIndirectAddress));
                            EqData ed2 = new EqData();
                            EqData data2 = new EqData();
                            eq2.get(ea2, ed2, data2);
                            if (data2.error() == 0) {
                                dcomp.setDOOCSParameter("adr", data2.get_string_arg());
                            }
                        }
                    }
                    if (!doocsProperty.equalsIgnoreCase("adr")) continue;
                    if (doocsPropertyValue != null && this.fullDoocsAddress == null) {
                        String mergedAddress = DOOCSParser.inheritDoocsAddress(dcomp, doocsPropertyValue);
                        dcomp.setDOOCSParameter(doocsProperty, mergedAddress);
                    }
                    if (doocsPropertyValue == null || this.fullDoocsAddress == null) continue;
                    EqAdr ea3 = new EqAdr(this.fullDoocsAddress);
                    if (EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                        doocsPropertyValue = doocsPropertyValue.replace("$f", ea3.facility());
                        doocsPropertyValue = doocsPropertyValue.replace("$d", ea3.device());
                        doocsPropertyValue = doocsPropertyValue.replace("$l", ea3.location());
                        doocsPropertyValue = doocsPropertyValue.replace("$p", ea3.property());
                    }
                    if (dcomp == null) continue;
                    String mergedAddress = DOOCSParser.inheritDoocsAddress(dcomp, doocsPropertyValue);
                    dcomp.setDOOCSParameter(doocsProperty, mergedAddress);
                }
                DOOCSParameter.getParentFrame(this).setCursor(this.defaultCursor);
            }
            if (this.doocsFunction.equalsIgnoreCase("Shell Command") && this.doocsCommand != null) {
                try {
                    Vector<String> commands = new Vector<String>();
                    String tmp = this.doocsCommand;
                    while (tmp.contains(" ")) {
                        commands.add(tmp.substring(0, tmp.indexOf(32)));
                        tmp = tmp.substring(tmp.indexOf(32) + 1);
                    }
                    commands.add(tmp);
                    if (this.doocsAddress != null) {
                        commands.add(this.fullDoocsAddress);
                    }
                    if (this.doocsIndirectAddress != null) {
                        commands.add(DOOCSParser.inheritDoocsAddress(this, this.doocsIndirectAddress));
                    }
                    String[] dummy = new String[]{};
                    Runtime.getRuntime().exec(commands.toArray(dummy));
                }
                catch (IOException ioe) {
                    new ShowException(null, "DOOCSButton", "Problem on executing Shell Command: " + ioe);
                }
            }
            if (this.doocsFunction.equalsIgnoreCase("Print Panel")) {
                if (this.doocsPrinter == null) {
                    this.doocsPrinter = StartParameters.getInstance().getLastPrinter();
                }
                if (this.doocsPrinter != null) {
                    if (this.doocsPrinter.equalsIgnoreCase("File")) {
                        DOOCSParameter.getParentLayeredPane(this).savePng(null);
                    } else {
                        PrintUtilities.printComponent(DOOCSParameter.getParentFrame(this), this.doocsPrinter);
                    }
                } else {
                    new ShowException(null, "DOOCSButton", "No printer selected!");
                    return;
                }
                new ShowException(null, "DOOCSButton", "Panel printed to " + this.doocsPrinter + ".");
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.doocsRunMode) {
            if (this.doocsFunction.equalsIgnoreCase("Data to Device")) {
                this.setCursor(this.myCursor);
            }
            this.mouseOver = true;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.doocsRunMode) {
            if (this.doocsFunction.equalsIgnoreCase("Data to Device")) {
                this.setCursor(new Cursor(0));
            }
            this.mouseOver = false;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.doocsButton3D) {
            this.setBorder(BorderFactory.createBevelBorder(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.doocsButton3D) {
            this.setBorder(BorderFactory.createBevelBorder(1));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void checkBounds() {
        Font f = this.getFont();
        String t = this.getText();
        if (t == null) {
            t = " ";
        }
        int fontHeight = (int)f.getStringBounds(t, this.getFontMetrics(f).getFontRenderContext()).getHeight() + this.getInsets().bottom + this.getInsets().top;
        int fontWidth = (int)f.getStringBounds(t, this.getFontMetrics(f).getFontRenderContext()).getWidth() + this.getInsets().right + this.getInsets().left;
        Rectangle rbounds = this.getBounds();
        if (this.doocsRotate.equalsIgnoreCase("0") || this.doocsRotate.equalsIgnoreCase("180")) {
            if (this.getBounds().getHeight() < (double)fontHeight) {
                rbounds.setSize(rbounds.width, fontHeight);
                this.setBounds(rbounds);
            }
            if (this.getBounds().getWidth() < (double)fontWidth) {
                rbounds.setSize(fontWidth, rbounds.height);
                this.setBounds(rbounds);
            }
        } else {
            if (this.getBounds().getWidth() < (double)fontHeight) {
                rbounds.setSize(fontHeight, rbounds.height);
                this.setBounds(rbounds);
            }
            if (this.getBounds().getHeight() < (double)fontWidth) {
                rbounds.setSize(rbounds.width, fontWidth);
                this.setBounds(rbounds);
            }
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }
}

