/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

public class ValidatedTolerance {
    private boolean valid;
    private float toleranceAbsolute;
    private float tolerancePercent;

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public ValidatedTolerance() {
        this.valid = false;
        this.toleranceAbsolute = 0.0f;
    }

    public void set(float toleranceAbsolute, float tolerancePercent, boolean valid) {
        this.valid = valid;
        this.toleranceAbsolute = toleranceAbsolute;
        this.tolerancePercent = tolerancePercent;
    }

    public ValidatedTolerance(float toleranceAbsolute, float tolerancePercent, boolean valid) {
        this.valid = valid;
        this.toleranceAbsolute = toleranceAbsolute;
        this.tolerancePercent = tolerancePercent;
    }

    public String toString() {
        return "[" + Float.toString(this.toleranceAbsolute) + "," + (this.valid ? " VALID]" : "NOT VALID]");
    }

    static ValidatedTolerance parse(String s) {
        if (s == null || s.length() == 0) {
            return new ValidatedTolerance(0.0f, 0.0f, false);
        }
        float tolA = 0.0f;
        float tolP = 0.0f;
        String[] parts = s.split("\\+");
        try {
            for (String ss : parts) {
                if (ss.contains("%")) {
                    tolP = Float.parseFloat(ss.substring(0, ss.indexOf("%")));
                    continue;
                }
                tolA = Float.parseFloat(ss);
            }
            return new ValidatedTolerance(tolA, tolP, true);
        }
        catch (Exception e) {
            tolA = 0.0f;
            tolP = 0.0f;
            return new ValidatedTolerance(0.0f, 0.0f, false);
        }
    }

    public float getToleranceAbsolute() {
        return this.toleranceAbsolute;
    }

    public void setToleranceAbsolute(float toleranceAbsolute) {
        this.toleranceAbsolute = toleranceAbsolute;
    }

    public float getTolerancePercent() {
        return this.tolerancePercent;
    }

    public void setTolerancePercent(float tolerancePercent) {
        this.tolerancePercent = tolerancePercent;
    }
}

