/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.xmlUtils.AlarmDefinitionCfg;
import de.desy.tine.xmlUtils.DeviceCfg;
import de.desy.tine.xmlUtils.NameCfgList;
import de.desy.tine.xmlUtils.PropertyCfg;
import de.desy.tine.xmlUtils.TineConfigItem;
import de.desy.tine.xmlUtils.ValidatedInt;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqmCfg
extends TineConfigItem {
    private String name = new String("");
    private String server = new String("");
    private String context = new String("");
    private String subsystem = new String("");
    private String group = new String("");
    private String description = new String("");
    private String hardware = new String("");
    private String responsible = new String("");
    private ValidatedInt groupIndex = new ValidatedInt();
    private LinkedList<AlarmDefinitionCfg> alarmDefinitions = new LinkedList();
    private LinkedList<NameCfgList> nameCfgList = new LinkedList();
    private ValidatedInt deviceSpace = new ValidatedInt();
    private LinkedList<DeviceCfg> devices = new LinkedList();
    private LinkedList<PropertyCfg> properties = new LinkedList();

    public EqmCfg(String n) {
        super(n);
    }

    public LinkedList<AlarmDefinitionCfg> getAlarmDefinitions() {
        return this.alarmDefinitions;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContext() {
        return this.context;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public String getHardware() {
        return this.hardware;
    }

    public LinkedList<DeviceCfg> getDeviceList() {
        return this.devices;
    }

    public ValidatedInt getDeviceSpace() {
        return this.deviceSpace;
    }

    public String getGroup() {
        return this.group;
    }

    public LinkedList<DeviceCfg> getDevices() {
        return this.devices;
    }

    public LinkedList<PropertyCfg> getProperties() {
        return this.properties;
    }

    public ValidatedInt getGroupIndex() {
        return this.groupIndex;
    }

    public String getName() {
        return this.name;
    }

    public LinkedList<NameCfgList> getNameCfgList() {
        return this.nameCfgList;
    }

    public LinkedList<PropertyCfg> getPropertyList() {
        return this.properties;
    }

    public String getServer() {
        return this.server;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setAlarmDefinition(LinkedList<AlarmDefinitionCfg> alarmDefinitions) {
        this.alarmDefinitions = alarmDefinitions;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setDeviceList(LinkedList<DeviceCfg> devices) {
        this.devices = devices;
    }

    public void setDeviceSpace(ValidatedInt deviceSpace) {
        this.deviceSpace = deviceSpace;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setGroupIndex(ValidatedInt groupIndex) {
        this.groupIndex = groupIndex;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameCfgList(LinkedList<NameCfgList> NameCfgList2) {
        this.nameCfgList = NameCfgList2;
    }

    public void setPropertyList(LinkedList<PropertyCfg> properties) {
        this.properties = properties;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    @Override
    void dump(int margin) {
        String m = new String("");
        for (int i = 0; i < margin; ++i) {
            m = m + " ";
        }
        System.out.println(m + "Name = " + this.getName());
        System.out.println(m + "Server = " + this.getServer());
        System.out.println(m + "Description = " + this.getDescription());
        System.out.println(m + "Context = " + this.getContext());
        System.out.println(m + "Hardware = " + this.getHardware());
        System.out.println(m + "Responsible = " + this.getResponsible());
        System.out.println(m + "Subsystem = " + this.getSubsystem());
        System.out.println(m + "Group Index = " + this.getGroupIndex().toString());
        System.out.println(m + "Group = " + this.getGroup());
        System.out.println(m + "Device space = " + this.getDeviceSpace());
        System.out.println(m + "ALARM DEFINITIONS:");
        for (AlarmDefinitionCfg a : this.alarmDefinitions) {
            a.dump(margin + 3);
            System.out.println();
        }
        System.out.println(m + "NAME LIST:");
        for (NameCfgList n : this.nameCfgList) {
            n.dump(margin + 3);
            System.out.println();
        }
        System.out.println(m + "DEVICES:");
        for (DeviceCfg d : this.devices) {
            d.dump(margin + 3);
            System.out.println();
        }
        System.out.println(m + "PROPERTIES:");
        for (PropertyCfg p : this.properties) {
            p.dump(margin + 3);
            System.out.println();
        }
    }

    @Override
    void parse(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Text textNode;
            Node child = children.item(i);
            if (!(child instanceof Element) || (textNode = (Text)(childElement = (Element)child).getFirstChild()) == null) continue;
            String text = textNode.getData().trim();
            if (childElement.getTagName().equalsIgnoreCase("NAME")) {
                this.setName(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SERVER")) {
                this.setServer(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("CONTEXT")) {
                this.setContext(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("HARDWARE")) {
                this.setHardware(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("RESPONSIBLE")) {
                this.setResponsible(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SUBSYSTEM")) {
                this.setSubsystem(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("GROUP")) {
                this.setGroup(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("GROUP_INDEX")) {
                this.setGroupIndex(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM_DEFINITION")) {
                AlarmDefinitionCfg adc = new AlarmDefinitionCfg("ALARM DEFINITION");
                this.alarmDefinitions.add(adc);
                adc.parse(childElement);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("NAME_LIST")) {
                NameCfgList ncl = new NameCfgList("NAME LIST");
                this.nameCfgList.add(ncl);
                ncl.parse(childElement);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DEVICE_SPACE")) {
                this.setDeviceSpace(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DEVICE")) {
                DeviceCfg dc = new DeviceCfg("DEVICE");
                this.devices.add(dc);
                dc.parse(childElement);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("PROPERTY")) {
                PropertyCfg pc = new PropertyCfg("PROPERTY");
                this.properties.add(pc);
                pc.parse(childElement);
                continue;
            }
            MsgLog.log("EqmCfg", "-WARNING: unsupported tag: " + childElement.getTagName(), 136, null, 0);
        }
    }
}

