/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.xmlUtils.TineConfigItem;
import de.desy.tine.xmlUtils.ValidatedInt;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DeviceCfg
extends TineConfigItem {
    private String name = new String("");
    private ValidatedInt number = new ValidatedInt();
    private String propertySet = new String("");
    private String redirection = new String("");
    private String description = new String("");

    public String getName() {
        return this.name;
    }

    public DeviceCfg(String name) {
        super(name);
    }

    public ValidatedInt getNumber() {
        return this.number;
    }

    public String getPropertySet() {
        return this.propertySet;
    }

    public String getRedirection() {
        return this.redirection;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNumber(ValidatedInt number) {
        this.number = number;
    }

    public void setPropertySet(String propertySet) {
        this.propertySet = propertySet;
    }

    public void setRedirection(String redirection) {
        this.redirection = redirection;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    void dump(int margin) {
        String m = new String("");
        for (int i = 0; i < margin; ++i) {
            m = m + " ";
        }
        System.out.println(m + "Name =  " + this.getName());
        System.out.println(m + "Property set = " + this.getPropertySet());
        System.out.println(m + "Redirection = " + this.getRedirection());
        System.out.println(m + "Number = " + this.getNumber());
        System.out.println(m + "Description =  " + this.getDescription());
    }

    void parse(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Text textNode;
            Node child = children.item(i);
            if (!(child instanceof Element) || (textNode = (Text)(childElement = (Element)child).getFirstChild()) == null) continue;
            String text = textNode.getData().trim();
            if (childElement.getTagName().equalsIgnoreCase("NAME")) {
                this.setName(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("NUMBER")) {
                this.setNumber(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("PROPERTY_SET")) {
                this.setPropertySet(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("REDIRECTION")) {
                this.setRedirection(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(text);
                continue;
            }
            MsgLog.log("DeviceCfg", "-WARNING: unsupported tag: " + childElement.getTagName(), 136, null, 0);
        }
    }
}

