/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NAME16FI
implements TCompoundDataObject {
    public String name;
    public int ival;
    public float fval;
    public static final int sizeInBytes = 24;
    public static final short dFormat = 10;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(24);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.fval;
    }

    public int getIntegerValue() {
        return this.ival;
    }

    public void setValues(String newName, float newFValue, int newIValue) {
        this.name = newName;
        this.ival = newIValue;
        this.fval = newFValue;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public int getSizeInBytes() {
        return 24;
    }

    public short getFormat() {
        return 10;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public NAME16FI() {
        this.name = new String(new StringBuffer(16));
        this.ival = 0;
        this.fval = 0.0f;
    }

    public NAME16FI(String Name2) {
        this.name = Name2;
        this.ival = 0;
        this.fval = 0.0f;
    }

    public NAME16FI(String Name2, int i) {
        this.name = Name2;
        this.ival = i;
        this.fval = 0.0f;
    }

    public NAME16FI(String Name2, float f) {
        this.name = Name2;
        this.ival = 0;
        this.fval = f;
    }

    public NAME16FI(String Name2, int i, float f) {
        this.name = Name2;
        this.ival = i;
        this.fval = f;
    }

    public NAME16FI(String Name2, float f, int i) {
        this.name = Name2;
        this.ival = i;
        this.fval = f;
    }

    public NAME16FI(NAME16FI instance) {
        this.name = instance.name == null ? new String(new StringBuffer(16)) : new String(instance.name);
        this.ival = instance.ival;
        this.fval = instance.fval;
    }

    public String toString() {
        return "[" + this.name + this.fval + ", " + this.ival + "]";
    }

    public boolean equals(NAME16FI instance) {
        if (instance.name == null || this.name == null) {
            return false;
        }
        if (instance.name.compareTo(this.name) != 0) {
            return false;
        }
        if (instance.fval != this.fval) {
            return false;
        }
        return instance.ival == this.ival;
    }

    public byte[] toByteArray() {
        if (this.name == null) {
            this.name = new String(new StringBuffer(16));
        }
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bname = this.name.getBytes();
            byte[] b = new byte[16];
            for (int i = 0; i < 16 && i < bname.length; ++i) {
                b[i] = bname[i];
            }
            ds.write(b, 0, b.length);
            byte[] fb = Swap.Float(this.fval);
            ds.write(fb, 0, 4);
            ds.writeInt(Swap.Long(this.ival));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAME16DBLDBL", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[24];
            ds.read(b, 0, 16);
            int len = 0;
            int i = 0;
            while (i < 16 && b[i] != 0) {
                ++i;
                ++len;
            }
            this.name = new String(b, 0, len);
            byte[] fb = new byte[4];
            ds.read(fb, 0, 4);
            this.fval = Swap.Float(fb);
            this.ival = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAME16FI", "could not prepare byte stream", 66, e, 0);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.fval);
        result = 31 * result + this.ival;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NAME16FI other = (NAME16FI)obj;
        if (Float.floatToIntBits(this.fval) != Float.floatToIntBits(other.fval)) {
            return false;
        }
        return this.equals(other);
    }
}

