/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.test.classes;

import de.desy.tine.definitions.TErrorList;
import de.desy.tine.traceUtils.TTrace;
import de.desy.tine.traceUtils.TTraceHandler;
import java.io.IOException;
import java.util.Date;
import javax.naming.NamingException;

public class GetTraceInfo
implements TTraceHandler {
    private static GetTraceInfo instance = new GetTraceInfo();
    private Date d = new Date();

    public static void main(String[] args) {
        try {
            int i;
            int n;
            TTrace ttr = new TTrace("LINAC2", "RF.PulseMod", "Mod3_I", "Trace");
            TTrace pttr = new TTrace("LINAC2", "RF.PulseCharge", "Mod1", "Trace");
            float[][] s2 = pttr.getTraceSequence();
            for (n = 0; n < s2.length; ++n) {
                System.out.println("trace " + n + " :");
                for (i = 0; i < 10; ++i) {
                    System.out.print(s2[n][i] + " ");
                }
                System.out.println("\n");
            }
            float[][] s = ttr.getTraceSequence();
            for (n = 0; n < s.length; ++n) {
                System.out.println("trace " + n + " :");
                for (i = 0; i < 10; ++i) {
                    System.out.print(s[n][i] + " ");
                }
                System.out.println("\n");
            }
            String xunits = ttr.getXAxisUnits();
            float[] xaxis = ttr.getXAxis();
            System.out.println("x-axis : (" + xunits + ")\n");
            for (int i2 = 0; i2 < 10; ++i2) {
                System.out.print(xaxis[i2] + " ");
            }
            System.out.println("\n");
            String yunits = ttr.getYAxisUnits();
            System.out.println("y-axis : (" + yunits + ")\n");
            float[] y = ttr.getTrace();
            for (int i3 = 0; i3 < 10; ++i3) {
                System.out.print(y[i3] + " ");
            }
            System.out.println("\n");
            float[] r = ttr.getReference();
            for (int i4 = 0; i4 < 10; ++i4) {
                System.out.print(r[i4] + " ");
            }
            System.out.println("\n");
            long start = System.currentTimeMillis();
            int rc = ttr.monitorTrace(instance, true, 1000);
            if (rc != 0) {
                System.out.println("can't start monitor : " + TErrorList.getErrorString(rc));
            }
            for (int i5 = 0; i5 < 2000; ++i5) {
                Thread.sleep(1000L);
            }
            long tt = System.currentTimeMillis() - start;
            System.out.println("monitor ran for " + tt / 60000L + " minutes\n Good bye and good luck!");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void update(TTrace trace) {
        if (trace.getTraceStatus() != 0) {
            System.out.println("problems getting trace update: " + trace.getTraceStatusString());
            return;
        }
        try {
            this.d.setTime(trace.getTraceTimestamp());
            System.out.println("trace update at " + this.d.toString());
            float[] y = trace.getTrace();
            for (int i = 0; i < 10; ++i) {
                System.out.print(y[i] + " ");
            }
            System.out.println("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

