/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.alarms;

import de.desy.tine.definitions.TErrorList;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.alarms.TAlarmDefinition;
import de.desy.tine.server.devices.TDevice;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;

public class TAlarm {
    public static final int ALM_SYSTEM_SYSTEM = 5000;
    public static final int ALM_SYSTEM_HARDWARE = 5001;
    public static final int ALM_SEVERITY_NONE = 0;
    public static final int ALM_SEVERITY_INFO = 3;
    public static final int ALM_SEVERITY_WARN = 8;
    public static final int ALM_SEVERITY_ERR = 12;
    public static final int ALM_SEVERITY_FATAL = 15;
    private long almTimestamp = System.currentTimeMillis();
    private long almStarttime;
    private int almCode;
    private boolean almRemovalBlocked = false;
    private byte almDescriptor;
    private byte almClearCount = 0;
    private byte[] almData = null;
    private TAlarmDefinition almDef = null;
    private TDevice almDevice = null;
    private boolean isTerminated = false;
    private static int almCollapseWindow = 100;
    private static int almOscillationWindow = 8;
    private static int almTerminationWindow = 30;
    private static int almHeartbeatWindow = 1200;

    public static int getAlmCollapseWindow() {
        return almCollapseWindow;
    }

    public static void setAlmCollapseWindow(int window) {
        if (window > 10) {
            almCollapseWindow = window;
        }
    }

    public static int getAlmOscillationWindow() {
        return almOscillationWindow;
    }

    public static void setAlmOscillationWindow(int window) {
        if (window > 8) {
            almOscillationWindow = window;
        }
    }

    public static int getAlmHeartbeatWindow() {
        return almHeartbeatWindow;
    }

    public static void setAlmHeartbeatWindow(int window) {
        almHeartbeatWindow = window;
    }

    public static int getTerminationWindow() {
        return almTerminationWindow;
    }

    public static void setTerminationWindow(int window) {
        if (window > 0) {
            almTerminationWindow = window;
        }
    }

    public int getTimeStamp() {
        return (int)(this.almTimestamp / 1000L);
    }

    public int getTimeStampUSec() {
        return (int)(this.almTimestamp % 1000L * 1000L);
    }

    public int getStarttime() {
        return (int)(this.almStarttime / 1000L);
    }

    public int getStarttimeUSec() {
        return (int)(this.almStarttime % 1000L * 1000L);
    }

    public void setTimeStamp(long timestamp) {
        if (timestamp > 0L) {
            this.almTimestamp = timestamp;
        }
    }

    public void setTimeStamp(int timestamp) {
        if (timestamp > 0) {
            this.almTimestamp = (long)timestamp * 1000L;
        }
    }

    public int getCode() {
        return this.almCode;
    }

    public boolean isRemovalBlocked() {
        return this.almRemovalBlocked;
    }

    public void blockRemoval() {
        this.almRemovalBlocked = true;
    }

    public void allowRemoval() {
        this.almRemovalBlocked = false;
    }

    public byte getDescriptor() {
        return this.almDescriptor;
    }

    public void setDescriptor(byte flags) {
        this.almDescriptor = flags;
    }

    public byte getClearCount() {
        return this.almClearCount;
    }

    public void resetClearCount() {
        this.almClearCount = 0;
    }

    public void clear() {
        if ((this.almDescriptor & 0x40) == 64) {
            this.almClearCount = (byte)almOscillationWindow;
        }
        if (this.almClearCount < almOscillationWindow) {
            this.almClearCount = (byte)(this.almClearCount + 1);
        }
    }

    public byte[] getData() {
        return this.almData;
    }

    public void setData(byte[] data) {
        this.almData = data;
    }

    public void setData(Object data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
        DataOutputStream ds = new DataOutputStream(baos);
        int range = 64;
        try {
            int i;
            int mrange;
            if (data instanceof short[]) {
                mrange = ((short[])data).length;
                range = Math.min(range / 2, mrange);
                for (i = 0; i < range; ++i) {
                    ds.writeShort(Swap.Short(((short[])data)[i]));
                }
            }
            if (data instanceof int[]) {
                mrange = ((int[])data).length;
                range = Math.min(range / 4, mrange);
                for (i = 0; i < range; ++i) {
                    ds.writeInt(Swap.Long(((int[])data)[i]));
                }
            }
            if (data instanceof float[]) {
                mrange = ((float[])data).length;
                range = Math.min(range / 4, mrange);
                for (i = 0; i < range; ++i) {
                    ds.write(Swap.Float(((float[])data)[i]));
                }
            }
            if (data instanceof double[]) {
                mrange = ((double[])data).length;
                range = Math.min(range / 8, mrange);
                for (i = 0; i < range; ++i) {
                    ds.write(Swap.Double(((double[])data)[i]));
                }
            }
            if (data instanceof char[]) {
                mrange = ((char[])data).length;
                range = Math.min(range, mrange);
                ds.writeBytes(new String((char[])data, 0, range));
            }
            if (data instanceof String) {
                mrange = ((String)data).length();
                range = Math.min(range, mrange);
                ds.writeBytes(((String)data).substring(0, range));
            }
            if (data instanceof StringBuffer) {
                mrange = ((StringBuffer)data).length();
                range = Math.min(range, mrange);
                ds.writeBytes(((StringBuffer)data).toString().substring(0, range));
            }
            if (data instanceof TCompoundDataObject[]) {
                TCompoundDataObject[] tdo = (TCompoundDataObject[])data;
                mrange = ((TCompoundDataObject[])data).length;
                range = Math.min(range / tdo[0].getSizeInBytes(), mrange);
                for (int i2 = 0; i2 < range; ++i2) {
                    ds.write(tdo[i2].toByteArray());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int getSeverity() {
        return this.almDef == null ? 0 : this.almDef.getAlarmSeverity();
    }

    public String getTag() {
        return this.almDef == null ? "" : this.almDef.getAlarmTag();
    }

    public TAlarm(int code, byte flags, byte[] data, TDevice device) {
        this.almCode = code;
        this.almDescriptor = flags;
        this.almData = data;
        this.almDevice = device;
        TEquipmentModule eqm = null;
        if (this.almDevice != null && (eqm = this.almDevice.getEqm()) != null) {
            this.almDef = eqm.getAlarmDefinitionList().get(code);
        }
        if (this.almDef == null) {
            this.almDef = (TAlarmDefinition)eqm.getEquipmentModuleFactory().getStockAlarmDefinitions().get(Integer.toString(code));
        }
        if (this.almDef == null) {
            String as = TErrorList.getErrorString(code);
            this.almDef = new TAlarmDefinition(as, as, "this device", code, 8, 0);
        }
        if ((flags & 0x40) == 64) {
            this.isTerminated = true;
        }
        if ((flags & 1) == 1) {
            this.almStarttime = this.almTimestamp;
        }
    }

    public TAlarmDefinition getAlmDef() {
        return this.almDef;
    }

    public void setAlarmDefinition(TAlarmDefinition almDef) {
        this.almDef = almDef;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public boolean isTransient() {
        return (this.almDescriptor & 0x10) == 16;
    }

    public void setTerminated(boolean isTerminated) {
        this.almDescriptor = (byte)(this.almDescriptor & 0xFFFFFFFE);
        this.almDescriptor = (byte)(this.almDescriptor | 0x40);
        this.isTerminated = isTerminated;
    }
}

