/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server;

import de.desy.tine.io.TDataOutputStream;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.stringUtils.StringToBytes;
import de.desy.tine.structUtils.TStructDescription;
import de.desy.tine.structUtils.TStructIfc;
import de.desy.tine.structUtils.TStructRegistry;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TServerStatistics
implements TStructIfc {
    TEquipmentModuleFactory myServer;
    private byte[] reserved = new byte[4];
    private int localtime;
    private int starttime;
    private int systemPollingRate;
    private short numBkgTsks;
    private short numTotalContracts;
    private short numTotalClients;
    private short numTargetContracts;
    private short numTargetClients;
    private short numConnections;
    private int numConnectionTimeouts;
    private int numConnectionArrivals;
    private int numUdpPkts;
    private int numTcpPkts;
    private int numIpxPkts;
    private int numSpxPkts;
    private static TStructDescription myStructDsc;

    public TServerStatistics(TEquipmentModuleFactory server) {
        this.myServer = server;
    }

    private static void createTaggedStructure() {
        myStructDsc = new TStructDescription("AQS");
        myStructDsc.beginDefinition();
        myStructDsc.addField("fecName", (short)4, 16);
        myStructDsc.addField("reserved", (short)2, 4);
        myStructDsc.addField("localtime", (short)3, 1);
        myStructDsc.addField("starttime", (short)3, 1);
        myStructDsc.addField("sysPollRate", (short)3, 1);
        myStructDsc.addField("numBkgTasks", (short)1, 1);
        myStructDsc.addField("numContracts", (short)1, 1);
        myStructDsc.addField("numClients", (short)1, 1);
        myStructDsc.addField("numTgtCont", (short)1, 1);
        myStructDsc.addField("numTgtCln", (short)1, 1);
        myStructDsc.addField("numConnections", (short)1, 1);
        myStructDsc.addField("numTimeouts", (short)3, 1);
        myStructDsc.addField("numArrivals", (short)3, 1);
        myStructDsc.addField("numUDPPkts", (short)3, 1);
        myStructDsc.addField("numTCPPkts", (short)3, 1);
        myStructDsc.addField("numIPXPkts", (short)3, 1);
        myStructDsc.addField("numSPSPkts", (short)3, 1);
        myStructDsc.setArraySize(1);
        myStructDsc.endDefinition();
        TStructRegistry.add(myStructDsc);
    }

    public static TStructDescription getStructDescription() {
        return myStructDsc;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bfout = new ByteArrayOutputStream();
        TDataOutputStream dsout = new TDataOutputStream(bfout);
        try {
            this.writeData(dsout);
            dsout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bfout.toByteArray();
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.write(StringToBytes.stringToFixedBytes(this.myServer.getFecName(), 16));
        dout.write(this.reserved);
        this.localtime = (int)(System.currentTimeMillis() / 1000L);
        dout.writeInt(this.localtime);
        dout.writeInt(this.starttime);
        dout.writeInt(this.systemPollingRate);
        dout.writeShort(this.numBkgTsks);
        dout.writeShort(this.numTotalContracts);
        dout.writeShort(this.numTotalClients);
        dout.writeShort(this.numTargetContracts);
        dout.writeShort(this.numTargetClients);
        dout.writeShort(this.numConnections);
        dout.writeInt(this.numConnectionTimeouts);
        dout.writeInt(this.numConnectionArrivals);
        dout.writeInt(this.numUdpPkts);
        dout.writeInt(this.numTcpPkts);
        dout.writeInt(this.numIpxPkts);
        dout.writeInt(this.numSpxPkts);
    }

    public void readData(DataInput din) throws IOException {
    }

    public int getLocaltime() {
        this.localtime = (int)(System.currentTimeMillis() / 1000L);
        return this.localtime;
    }

    public void setLocaltime(int localtime) {
        this.localtime = localtime;
    }

    public short getNumBkgTsks() {
        return this.numBkgTsks;
    }

    public void setNumBkgTsks(short numBkgTsks) {
        this.numBkgTsks = numBkgTsks;
    }

    public int getNumConnectionArrivals() {
        return this.numConnectionArrivals;
    }

    public void setNumConnectionArrivals(int numConnectionArrivals) {
        this.numConnectionArrivals = numConnectionArrivals;
    }

    public short getNumConnections() {
        return this.numConnections;
    }

    public void setNumConnections(short numConnections) {
        this.numConnections = numConnections;
    }

    public void addNumConnections(short numConnections) {
        this.numConnections = (short)(this.numConnections + numConnections);
    }

    public void incNumConnections() {
        this.numConnections = (short)(this.numConnections + 1);
    }

    public int getNumConnectionTimeouts() {
        return this.numConnectionTimeouts;
    }

    public void setNumConnectionTimeouts(int numConnectionTimeouts) {
        this.numConnectionTimeouts = numConnectionTimeouts;
    }

    public void incNumConnectionTimeouts() {
        ++this.numConnectionTimeouts;
    }

    public int getNumIpxPkts() {
        return this.numIpxPkts;
    }

    public void setNumIpxPkts(int numIPXpkts) {
        this.numIpxPkts = numIPXpkts;
    }

    public void incNumIpxPkts() {
        ++this.numIpxPkts;
    }

    public int getNumSpxPkts() {
        return this.numSpxPkts;
    }

    public void setNumSpxPkts(int numSPXpkts) {
        this.numSpxPkts = numSPXpkts;
    }

    public void incNumSpxPkts() {
        ++this.numSpxPkts;
    }

    public short getNumTargetClients() {
        return this.numTargetClients;
    }

    public void setNumTargetClients(short numTargetClients) {
        this.numTargetClients = numTargetClients;
    }

    public short getNumTargetContracts() {
        return this.numTargetContracts;
    }

    public void setNumTargetContracts(short numTargetContracts) {
        this.numTargetContracts = numTargetContracts;
    }

    public int getNumTcpPkts() {
        return this.numTcpPkts;
    }

    public void incNumTcpPkts() {
        ++this.numTcpPkts;
    }

    public short getNumTotalClients() {
        return this.numTotalClients;
    }

    public void setNumTotalClients(short numTotalClients) {
        this.numTotalClients = numTotalClients;
    }

    public short getNumTotalContracts() {
        return this.numTotalContracts;
    }

    public void setNumTotalContracts(short numTotalContracts) {
        this.numTotalContracts = numTotalContracts;
    }

    public int getNumUdpPkts() {
        return this.numUdpPkts;
    }

    public void incNumUdpPkts() {
        ++this.numUdpPkts;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public void setReserved(byte[] reserved) {
        this.reserved = reserved;
    }

    public int getStarttime() {
        return this.starttime;
    }

    public void setStarttime(int starttime) {
        this.starttime = starttime;
    }

    public int getSystemPollingRate() {
        return this.systemPollingRate;
    }

    public void setSystemPollingRate(int systemPollingRate) {
        this.systemPollingRate = systemPollingRate;
    }

    public void setNumTcpPkts(int numTcpPkts) {
        this.numTcpPkts = numTcpPkts;
    }

    public void setNumUdpPkts(int numUdpPkts) {
        this.numUdpPkts = numUdpPkts;
    }

    static {
        TServerStatistics.createTaggedStructure();
    }
}

