/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.queryUtils;

import de.desy.tine.addrUtils.FECInfo;
import de.desy.tine.addrUtils.TSrvEntry;
import de.desy.tine.bitfieldUtils.TBitfield;
import de.desy.tine.bitfieldUtils.TBitfieldRegistry;
import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.queryUtils.PropertyQuery;
import de.desy.tine.queryUtils.PropertyQueryEx;
import de.desy.tine.queryUtils.PropertyQueryLegacy;
import de.desy.tine.queryUtils.ServerQuery;
import de.desy.tine.queryUtils.TPropertyQuery;
import de.desy.tine.queryUtils.XPropertyQuery;
import de.desy.tine.server.connections.TClientStruct;
import de.desy.tine.server.connections.TContractStruct;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.structUtils.TStructIo;
import de.desy.tine.structUtils.TStructRegistry;
import de.desy.tine.structUtils.TTaggedStructure;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.NAME;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME16II;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME64;
import de.desy.tine.types.TCompoundDataObject;
import de.desy.tine.types.USTRING;
import java.io.IOException;

public final class TQuery {
    public static final int nicePropertyQuerySize = 10;
    public static final int niceContextsQuerySize = 100;
    private static int maxQueryBufferSize = 65000;
    private static byte[] hByteBlobX = new byte[10 * XPropertyQuery.sizeInBytes];
    private static byte[] hByteBlobL = new byte[10 * PropertyQueryLegacy.sizeInBytes];
    private static byte[] hByteBlob = new byte[4320];
    private static byte[] hLegacyByteBlob;
    private static String lastQueriedContext;
    private static String lastQueriedServer;
    private static String lastQueriedDevice;
    private static TSrvEntry srvAddr;
    public static boolean properties_have_query_function;
    public static boolean devices_have_query_function;
    private static final int FECINFO_BASESIZE = 208;
    private static TQuery tQueryInstance;

    public static boolean isStockProperty(String property) {
        if (property.lastIndexOf("PROPS") >= 0) {
            return true;
        }
        if (property.lastIndexOf("PROPERTIES") >= 0) {
            return true;
        }
        if (property.lastIndexOf("DEVICES") >= 0) {
            return true;
        }
        if (property.lastIndexOf("STOCKPROPS") >= 0) {
            return true;
        }
        if (property.lastIndexOf("USERS") >= 0) {
            return true;
        }
        if (property.compareToIgnoreCase("ACTIVITY") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("SRVSTARTTIME") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("SRVLOGFILE") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("LOGFILE") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("BINFILE") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("SRVOS") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("SRVSTATS") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("SRVVERSION") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("SRVGLOBALS") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("ALARMS") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("ALARMSEXT") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("NALARMS") == 0) {
            return true;
        }
        if (property.compareToIgnoreCase("ALMDEFS") == 0) {
            return true;
        }
        return property.compareToIgnoreCase("NALMDEFS") == 0;
    }

    public static String getModuleAddressInfo() {
        if (srvAddr == null) {
            srvAddr = new TSrvEntry();
        }
        return srvAddr.toString(lastQueriedServer, lastQueriedContext);
    }

    public static String getModuleAddressInfo(String server, String context) {
        srvAddr = new TSrvEntry(server, context);
        return srvAddr.toString(server, context);
    }

    public static TSrvEntry getModuleAddress(String server, String context) {
        return new TSrvEntry(server, context);
    }

    private static String[] getTagList(String context, String tagtype) {
        return TQuery.getTagList(context, tagtype, null);
    }

    private static String[] getTagList(String context, String tagtype, String subsys) {
        return TQuery.getTagList(context, tagtype, subsys, TLink.defaultTimeout);
    }

    private static String[] getTagList(String context, String tagtype, String subsys, int timeout) {
        int i;
        int cc;
        TLink tl;
        StringBuffer host = new StringBuffer(32);
        StringBuffer query = new StringBuffer(32);
        short[] numout = new short[1];
        TDataType numoutData = new TDataType(numout);
        TDataType din = subsys == null || subsys.compareTo("ALL") == 0 ? new TDataType() : new TDataType(subsys);
        host.delete(0, 31);
        query.delete(0, 31);
        if (context != null && context.length() != 0) {
            host.insert(0, "ENS/" + context);
        } else {
            host.insert(0, "ENS");
        }
        query.insert(0, "N" + tagtype);
        try {
            tl = new TLink(host.toString(), query.toString(), numoutData, din, 1);
            cc = tl.execute(timeout, true);
            srvAddr = tl.srvAddr;
            tl.cancel();
        }
        catch (Exception e) {
            cc = 86;
        }
        if (cc != 0) {
            return null;
        }
        query.delete(0, 31);
        query.insert(0, tagtype);
        int n = numout[0];
        TCompoundDataObject[] taglist32 = new NAME32[n];
        for (i = 0; i < n; ++i) {
            taglist32[i] = new NAME32();
        }
        if (taglist32.length == 0) {
            return null;
        }
        if (numout[0] > taglist32.length) {
            numout[0] = (short)taglist32.length;
        }
        TDataType dout = new TDataType(taglist32);
        tl = new TLink(host.toString(), query.toString(), dout, din, 1);
        cc = tl.execute(TLink.defaultTimeout, true);
        tl.cancel();
        if (cc == 0) {
            String[] strlist = new String[n];
            for (i = 0; i < n; ++i) {
                strlist[i] = ((NAME32)taglist32[i]).name;
            }
            return strlist;
        }
        if (cc == 2) {
            TCompoundDataObject[] taglist16 = new NAME16[n];
            for (i = 0; i < n; ++i) {
                taglist16[i] = new NAME16();
            }
            if (taglist16.length == 0) {
                return null;
            }
            if (numout[0] > taglist16.length) {
                numout[0] = (short)taglist16.length;
            }
            dout = new TDataType(taglist16);
            tl = new TLink(host.toString(), query.toString(), dout, din, 1);
            cc = tl.execute(TLink.defaultTimeout, true);
            tl.cancel();
            if (cc != 0) {
                return null;
            }
            String[] strlist = new String[n];
            for (i = 0; i < n; ++i) {
                strlist[i] = ((NAME16)taglist16[i]).name;
            }
            return strlist;
        }
        return null;
    }

    private static int getNumberOf(String property, String target) throws IOException {
        return TQuery.getNumberOf(property, target, TLink.defaultTimeout);
    }

    private static int getNumberOf(String property, String target, int timeout) throws IOException {
        int cc = 86;
        short[] n = new short[1];
        if (property == null || target == null) {
            return -20;
        }
        TDataType dout = new TDataType(n);
        String propertyq = new String("N" + property);
        TLink tl = new TLink(target, propertyq, dout, null, 1);
        cc = tl.execute(timeout, true);
        srvAddr = tl.srvAddr;
        tl.cancel();
        if (cc == 45 || cc == 98) {
            throw new IOException("timeout getting information from " + target);
        }
        return cc > 0 ? -cc : n[0];
    }

    public static short setMaximumQueryBufferSize(int size) {
        if (size < 4000 || size > 256000) {
            return 37;
        }
        maxQueryBufferSize = size;
        return 0;
    }

    public static String[] getContexts() {
        return TQuery.getTagList(null, "CONTEXTS");
    }

    public static String[] getContexts(String serverName) {
        int i;
        TDataType din = serverName == null || serverName.compareToIgnoreCase("ALL") == 0 ? new TDataType() : new TDataType(serverName);
        TCompoundDataObject[] taglist32 = new NAME32[100];
        for (i = 0; i < 100; ++i) {
            taglist32[i] = new NAME32();
        }
        if (taglist32.length == 0) {
            return null;
        }
        TDataType dout = new TDataType(taglist32);
        TLink tl = new TLink("/SITE/ENS", "CONTEXTS", dout, din, 1);
        int cc = tl.execute(TLink.defaultTimeout, true);
        tl.cancel();
        int n = dout.getCompletionLength();
        if (cc == 0) {
            String[] strlist = new String[n];
            for (i = 0; i < n; ++i) {
                strlist[i] = ((NAME32)taglist32[i]).name;
            }
            return strlist;
        }
        return null;
    }

    public static String[] getDeviceServers(String context) {
        return TQuery.getTagList(context, "TAGS");
    }

    public static String[] getDeviceServers(String context, String subsys) {
        return TQuery.getTagList(context, "TAGS", subsys);
    }

    public static ServerQuery[] getDeviceServersEx(String context, String subsys, String importance) {
        return TQuery.getDeviceServersEx(context, subsys, importance, TLink.defaultTimeout);
    }

    public static ServerQuery[] getDeviceServersEx(String context, String subsys, String importance, int timeout) {
        return TQuery.getXTagList(context, "TAGS", subsys, importance, timeout);
    }

    public static String[] getDeviceSubsystems() {
        return TQuery.getTagList(null, "SUBSYSTEMS");
    }

    public static String[] getDeviceSubsystems(String context) {
        return TQuery.getTagList(context, "SUBSYSTEMS");
    }

    public static String[] getServers(String context) {
        return TQuery.getTagList(context, "FECS");
    }

    public static String[] getServers(String context, String subsys) {
        return TQuery.getTagList(context, "FECS", subsys);
    }

    public static ServerQuery[] getServersEx(String context, String subsys, String importance) {
        return TQuery.getServersEx(context, subsys, importance, TLink.defaultTimeout);
    }

    public static ServerQuery[] getServersEx(String context, String subsys, String importance, int timeout) {
        return TQuery.getXTagList(context, "FECS", subsys, importance, timeout);
    }

    public static TClientStruct[] getServerClients(String fullServerName) {
        if (fullServerName == null) {
            return null;
        }
        TTaggedStructure[] tcs = new TClientStruct[100];
        for (int i = 0; i < 100; ++i) {
            tcs[i] = new TClientStruct();
        }
        TDataType tcsd = new TDataType(tcs);
        TLink tl = new TLink(fullServerName, "CLIENTS", tcsd, null, 1);
        if (tl.execute(400, true) == 0) {
            int len;
            for (len = 0; len < 100 && ((TClientStruct)tcs[len]).getProtocol()[0] != 0; ++len) {
            }
            if (len < 100) {
                TClientStruct[] tcss = new TClientStruct[len];
                System.arraycopy(tcs, 0, tcss, 0, len);
                return tcss;
            }
            return tcs;
        }
        DbgLog.log("getServerClients", "error : " + tl.linkStatus);
        return null;
    }

    public static TContractStruct[] getServerContracts(String fullServerName) {
        if (fullServerName == null) {
            return null;
        }
        TTaggedStructure[] tcs = new TContractStruct[100];
        for (int i = 0; i < 100; ++i) {
            tcs[i] = new TContractStruct();
        }
        TDataType tcsd = new TDataType(tcs);
        TLink tl = new TLink(fullServerName, "CONTRACTS", tcsd, null, 1);
        if (tl.execute(400, true) == 0) {
            int len;
            for (len = 0; len < 100 && ((TContractStruct)tcs[len]).getEqpProperty()[0] != '\u0000'; ++len) {
            }
            if (len < 100) {
                TContractStruct[] tcss = new TContractStruct[len];
                System.arraycopy(tcs, 0, tcss, 0, len);
                return tcss;
            }
            return tcs;
        }
        DbgLog.log("getServerContracts", "error : " + tl.linkStatus);
        return null;
    }

    public static FECInfo getServerInformation(String frontEndComputer) {
        String resp;
        String hdw;
        String ver;
        String loc;
        String desc;
        String os;
        char[] fi = new char[208];
        TDataType fid = new TDataType(fi);
        TLink tl = new TLink("ENS/FEC.EXT", frontEndComputer, fid, null, 1);
        if (tl.execute(400, true) == 0) {
            int p;
            int off = 0;
            os = new String(fi, off, 16);
            desc = new String(fi, off += 16, 64);
            loc = new String(fi, off += 64, 48);
            ver = new String(fi, off += 48, 16);
            hdw = new String(fi, off += 16, 32);
            resp = new String(fi, off += 32, 32);
            off += 32;
            if (desc.startsWith("[") && (p = desc.indexOf(93)) != -1) {
                desc = desc.substring(p + 1);
            }
        } else {
            os = "unknown";
            desc = "unknown";
            loc = "unknown";
            hdw = "unknown";
            ver = "unknown";
            resp = "unknown";
        }
        return new FECInfo(os, desc, loc, hdw, ver, resp);
    }

    public static String[] getDeviceProperties(String context, String server, String device) {
        return TQuery.getDeviceProperties(context, server, device, TLink.defaultTimeout);
    }

    public static String[] getDeviceProperties(String context, String server, String device, int timeout) {
        return TQuery.getDeviceProperties(context, server, device, null, timeout);
    }

    public static String[] getDeviceProperties(String context, String server, String device, String property) {
        return TQuery.getDeviceProperties(context, server, device, property, TLink.defaultTimeout);
    }

    public static String[] getDeviceProperties(String context, String server, String device, String property, int timeout) {
        String[] prps = null;
        try {
            prps = TQuery.getDeviceProperties64(context, server, device, property, timeout);
            if (prps != null) {
                return prps;
            }
            prps = TQuery.getDeviceProperties16(context, server, device, property, timeout);
        }
        catch (Exception e) {
            return null;
        }
        return prps;
    }

    private static String[] getDeviceProperties16(String context, String server, String device, String property, int timeout) throws IOException {
        TLink tl;
        int i;
        String tgt = TQuery.getNamesQueryTarget(context, server, device);
        if (tgt == null) {
            return null;
        }
        int cc = 0;
        int n = TQuery.getNumberOf("PROPS", tgt);
        if (n <= 0) {
            return null;
        }
        if (n * 32 > maxQueryBufferSize) {
            n = maxQueryBufferSize / 32;
        }
        TCompoundDataObject[] properties = new NAME32[n];
        for (i = 0; i < n; ++i) {
            properties[i] = new NAME32();
        }
        if (properties.length <= 0) {
            return null;
        }
        TDataType dout = new TDataType(properties);
        TDataType din = property != null ? new TDataType(property) : null;
        properties_have_query_function = false;
        try {
            tl = new TLink(tgt, "PROPS", dout, din, 1);
            cc = tl.execute(TLink.defaultTimeout, true);
            tl.cancel();
            if ((cc & 0x4000) == 16384) {
                if ((cc & 0x80) == 128) {
                    properties_have_query_function = true;
                }
                cc = 0;
            }
        }
        catch (Exception e) {
            cc = 86;
        }
        if (cc == 0) {
            n = 0;
            for (i = 0; i < properties.length; ++i) {
                if (((NAME32)properties[i]).name.length() <= 0) continue;
                ++n;
            }
            String[] strprops = new String[n];
            int j = 0;
            for (i = 0; j < n && i < properties.length; ++i) {
                if (((NAME32)properties[i]).name.length() == 0) continue;
                strprops[j++] = ((NAME32)properties[i]).name;
            }
            return strprops;
        }
        if (cc != 45) {
            if (lastQueriedContext == context && lastQueriedServer == server && lastQueriedDevice == device && lastQueriedServer != null) {
                cc = 0;
            } else {
                hLegacyByteBlob = new byte[n * PropertyQuery.sizeInBytes];
                dout = new TDataType(hLegacyByteBlob, "");
                tl = new TLink(tgt, "PROPS", dout, din, 1);
                cc = tl.execute(TLink.defaultTimeout, false);
                tl.cancel();
            }
            if (cc == 0) {
                lastQueriedContext = context;
                lastQueriedServer = server;
                lastQueriedDevice = device;
                String[] strprops = new String[n];
                PropertyQuery[] pq = new PropertyQuery[n];
                if (hLegacyByteBlob == null) {
                    return null;
                }
                for (i = 0; i < n; ++i) {
                    pq[i] = new PropertyQuery();
                    byte[] b = pq[i].toByteArray();
                    System.arraycopy(hLegacyByteBlob, i * PropertyQuery.sizeInBytes, b, 0, PropertyQuery.sizeInBytes);
                    pq[i].toStruct();
                    strprops[i] = pq[i].name;
                }
                return strprops;
            }
        }
        throw new IOException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
    }

    public static String[] getPropertiesWithPattern(String context, String server, String device, String propertyPattern, int timeout) throws IOException {
        int i;
        String tgt = TQuery.getNamesQueryTarget(context, server, device);
        if (tgt == null || propertyPattern == null) {
            return null;
        }
        int cc = 0;
        int n = 64;
        TCompoundDataObject[] properties = new NAME64[n];
        for (i = 0; i < n; ++i) {
            properties[i] = new NAME64();
        }
        TDataType dout = new TDataType(properties);
        try {
            TLink tl = new TLink(tgt, propertyPattern, dout, null, 1);
            cc = tl.execute(timeout, true);
            tl.cancel();
            if ((cc & 0x4000) == 16384) {
                cc = 0;
            }
        }
        catch (Exception e) {
            cc = 86;
        }
        if (cc == 2) {
            return null;
        }
        if (cc == 0) {
            n = dout.getCompletionLength();
            String[] strprops = new String[n];
            int j = 0;
            for (i = 0; j < n && i < properties.length; ++i) {
                if (((NAME64)properties[i]).name.length() == 0) continue;
                strprops[j++] = ((NAME64)properties[i]).name;
            }
            return strprops;
        }
        throw new IOException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
    }

    private static String[] getDeviceProperties64(String context, String server, String device, String property, int timeout) throws IOException {
        int i;
        String tgt = TQuery.getNamesQueryTarget(context, server, device);
        if (tgt == null) {
            return null;
        }
        int cc = 0;
        int n = TQuery.getNumberOf("PROPS", tgt);
        if (n == -35) {
            String[] strprops = new String[]{"INVALID"};
            properties_have_query_function = true;
            return strprops;
        }
        if (n <= 0) {
            return null;
        }
        if (n * 32 > maxQueryBufferSize) {
            n = maxQueryBufferSize / 64;
        }
        TCompoundDataObject[] properties = new NAME64[n];
        for (i = 0; i < n; ++i) {
            properties[i] = new NAME64();
        }
        if (properties.length <= 0) {
            return null;
        }
        TDataType dout = new TDataType(properties);
        TDataType din = property != null ? new TDataType(property) : null;
        properties_have_query_function = false;
        try {
            TLink tl = new TLink(tgt, "PROPS", dout, din, 1);
            cc = tl.execute(TLink.defaultTimeout, true);
            tl.cancel();
            if ((cc & 0x4000) == 16384) {
                if ((cc & 0x80) == 128) {
                    properties_have_query_function = true;
                }
                cc = 0;
            }
            if (cc == 35) {
                properties_have_query_function = true;
            }
        }
        catch (Exception e) {
            cc = 86;
        }
        if (cc == 2) {
            return null;
        }
        if (cc == 0) {
            if (((NAME64)properties[0]).name.length() == 0) {
                return null;
            }
            n = 0;
            for (i = 0; i < properties.length; ++i) {
                if (((NAME64)properties[i]).name.length() <= 0) continue;
                ++n;
            }
            String[] strprops = new String[n];
            int j = 0;
            for (i = 0; j < n && i < properties.length; ++i) {
                if (((NAME64)properties[i]).name.length() == 0) continue;
                strprops[j++] = ((NAME64)properties[i]).name;
            }
            return strprops;
        }
        throw new IOException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
    }

    private static String getTineStockString(String context, String server, String property, String text) {
        int cc = 0;
        StringBuffer ver = new StringBuffer(32);
        String tgt = new String("/" + context + "/" + server + "/#0");
        TDataType dout = new TDataType(ver);
        try {
            TLink tl = new TLink(tgt, property, dout, null, 1);
            cc = tl.execute(TLink.defaultTimeout, true);
            tl.cancel();
        }
        catch (Exception e) {
            cc = 86;
        }
        if (cc == 0) {
            return text + " : " + ver.toString().trim();
        }
        return text + " : unavailable";
    }

    public static String getTineVersion(String context, String server) {
        return TQuery.getTineStockString(context, server, "SRVVERSION", "tine version");
    }

    public static String getAppVersion(String context, String server) {
        return TQuery.getTineStockString(context, server, "APPVERSION", "Appl version");
    }

    public static String getAppDate(String context, String server) {
        return TQuery.getTineStockString(context, server, "APPDATE", "Appl date");
    }

    public static String[] getStockProperties(String context, String server) {
        return TQuery.getStockProperties(context, server, "#0", null);
    }

    public static String[] getStockProperties(String context, String server, String device, String property) {
        int i;
        int cc = 0;
        int n = 0;
        String tgt = new String("/" + context + "/" + server + "/" + device);
        try {
            n = TQuery.getNumberOf("STOCKPROPS", tgt);
        }
        catch (IOException e) {
            return null;
        }
        if (n <= 0) {
            return null;
        }
        if (n * 32 > maxQueryBufferSize) {
            n = maxQueryBufferSize / 32;
        }
        TCompoundDataObject[] properties = new NAME32[n];
        for (i = 0; i < n; ++i) {
            properties[i] = new NAME32();
        }
        if (properties.length <= 0) {
            throw new NullPointerException("properties argument has zero length!");
        }
        TDataType dout = new TDataType(properties);
        TDataType din = property != null ? new TDataType(property) : null;
        properties_have_query_function = false;
        TLink tl = new TLink(tgt, "STOCKPROPS", dout, din, 1);
        cc = tl.execute(TLink.defaultTimeout, true);
        if ((cc & 0x4000) == 16384) {
            if ((cc & 0x80) == 128) {
                properties_have_query_function = true;
            }
            cc = 0;
        }
        tl.cancel();
        if (cc == 0) {
            n = 0;
            for (i = 0; i < properties.length; ++i) {
                if (((NAME32)properties[i]).name.length() <= 0) continue;
                ++n;
            }
            String[] strprops = new String[n];
            int j = 0;
            for (i = 0; j < n && i < properties.length; ++i) {
                if (((NAME32)properties[i]).name.length() == 0) continue;
                strprops[j++] = ((NAME32)properties[i]).name;
            }
            return strprops;
        }
        if (cc != 45) {
            if (lastQueriedContext == context && lastQueriedServer == server && lastQueriedDevice == device && lastQueriedServer != null) {
                cc = 0;
            } else {
                hLegacyByteBlob = new byte[n * PropertyQuery.sizeInBytes];
                dout = new TDataType(hLegacyByteBlob, "");
                tl = new TLink(tgt, "STOCKPROPS", dout, din, 1);
                cc = tl.execute(TLink.defaultTimeout, false);
                tl.cancel();
            }
            if (cc == 0) {
                lastQueriedContext = context;
                lastQueriedServer = server;
                lastQueriedDevice = device;
                String[] strprops = new String[n];
                PropertyQuery[] pq = new PropertyQuery[n];
                if (hLegacyByteBlob == null) {
                    return null;
                }
                for (i = 0; i < n; ++i) {
                    pq[i] = new PropertyQuery();
                    byte[] b = pq[i].toByteArray();
                    System.arraycopy(hLegacyByteBlob, i * PropertyQuery.sizeInBytes, b, 0, PropertyQuery.sizeInBytes);
                    pq[i].toStruct();
                    strprops[i] = pq[i].name;
                }
                return strprops;
            }
        }
        throw new NullPointerException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
    }

    public static String[] getDeviceNames(String context, String server) {
        return TQuery.getDeviceNames(context, server, null);
    }

    public static String[] getDeviceNames(String context, String server, String property) {
        return TQuery.getDeviceNames(context, server, property, TLink.defaultTimeout);
    }

    public static String[] getDeviceNames(String context, String server, String property, int timeout) {
        String[] devs = null;
        try {
            devs = TQuery.getDeviceNames64(context, server, property, timeout);
            if (devs != null) {
                return devs;
            }
            devs = TQuery.getDeviceNames16(context, server, property, timeout);
        }
        catch (Exception e) {
            return null;
        }
        return devs;
    }

    private static String[] getDeviceNames16(String context, String server, String property, int timeout) throws IOException {
        int i;
        DeviceNamesQueryParams dnqp = TQuery.getDeviceNamesQueryProperty(context, server, property, timeout);
        if (dnqp == null) {
            return null;
        }
        int n = dnqp.size;
        int cc = 0;
        if (n * 16 > maxQueryBufferSize) {
            n = maxQueryBufferSize / 16;
        }
        TCompoundDataObject[] devices = new NAME16[n];
        for (i = 0; i < n; ++i) {
            devices[i] = new NAME16();
        }
        if (devices.length == 0) {
            return null;
        }
        if (n == 1) {
            devices[0].name = "#0";
        }
        TDataType dout = new TDataType(devices);
        TLink tl = new TLink(dnqp.target, dnqp.property, dout, null, 1);
        cc = tl.execute(timeout, true);
        tl.cancel();
        if ((cc & 0x4000) == 16384) {
            if ((cc & 0x80) == 128) {
                devices_have_query_function = true;
            }
            cc = 0;
        }
        if (cc != 0) {
            return null;
        }
        n = 0;
        for (i = 0; i < devices.length; ++i) {
            if (((NAME16)devices[i]).name.length() <= 0 || ((NAME16)devices[i]).name.endsWith("&")) continue;
            ++n;
        }
        String[] strdevs = new String[n];
        int j = 0;
        for (i = 0; i < devices.length && j < n; ++i) {
            String tmp = ((NAME16)devices[i]).name;
            if (tmp.length() == 0) continue;
            if (tmp.endsWith("&")) {
                tmp = tmp.substring(0, tmp.length() - 1) + ((NAME16)devices[++i]).name;
            }
            strdevs[j++] = tmp;
        }
        return strdevs;
    }

    private static String getNamesQueryTarget(String context, String server, String device) {
        if (server == null || server.length() == 0) {
            throw new NullPointerException("empty server name entry !");
        }
        String dev = device == null ? "#0" : device;
        String tgt = context == null || context.length() == 0 ? new String("/DEFAULT/" + server + "/" + dev) : new String("/" + context + "/" + server + "/" + dev);
        return tgt;
    }

    private static TQuery getInstance() {
        if (tQueryInstance == null) {
            tQueryInstance = new TQuery();
        }
        return tQueryInstance;
    }

    private static DeviceNamesQueryParams getDeviceNamesQueryProperty(String context, String server, String property, int timeout) throws IOException {
        TQuery tq = TQuery.getInstance();
        String tgt = TQuery.getNamesQueryTarget(context, server, null);
        TQuery tQuery = tq;
        tQuery.getClass();
        DeviceNamesQueryParams dnqp = tQuery.new DeviceNamesQueryParams();
        int n = 0;
        String prp = null;
        n = TQuery.getNumberOf("DEVICES", tgt, timeout);
        if (property != null && property.length() > 0 && !TQuery.isStockProperty(property)) {
            devices_have_query_function = false;
            TPropertyQuery[] tpq = TQuery.getPropertyInformation(context, server, "#0", property, timeout);
            if (tpq != null) {
                if (tpq[0].prpSize > n) {
                    n = tpq[0].prpSize;
                }
                prp = property + ".NAM";
            }
        }
        if (prp == null) {
            devices_have_query_function = false;
            if (n < 0) {
                return null;
            }
            if (n == 0) {
                ++n;
            }
            prp = "DEVICES";
        }
        dnqp.target = tgt;
        dnqp.property = prp;
        dnqp.size = n;
        return dnqp;
    }

    public static int getNumberOfDevices(String context, String server, String property, int timeout) throws IOException {
        DeviceNamesQueryParams dnqp = TQuery.getDeviceNamesQueryProperty(context, server, property, timeout);
        return dnqp == null ? 0 : dnqp.size;
    }

    private static String[] getDeviceNames64(String context, String server, String property, int timeout) throws IOException {
        int i;
        DeviceNamesQueryParams dnqp = TQuery.getDeviceNamesQueryProperty(context, server, property, timeout);
        if (dnqp == null) {
            return null;
        }
        int cc = 0;
        int n = dnqp.size;
        if (n * 64 > maxQueryBufferSize) {
            n = maxQueryBufferSize / 64;
        }
        TCompoundDataObject[] devices = new NAME64[n];
        for (i = 0; i < n; ++i) {
            devices[i] = new NAME64();
        }
        if (devices.length == 0) {
            return null;
        }
        TDataType dout = new TDataType(devices);
        TLink tl = new TLink(dnqp.target, dnqp.property, dout, null, 1);
        cc = tl.execute(timeout, true);
        tl.cancel();
        if ((cc & 0x4000) == 16384) {
            if ((cc & 0x80) == 128) {
                devices_have_query_function = true;
            }
            cc = 0;
        }
        if (cc != 0) {
            if (cc == 45 || cc == 98) {
                throw new IOException("/" + context + "/" + server + " timed out getting device names");
            }
            return null;
        }
        if (((NAME64)devices[0]).name.length() == 0) {
            return null;
        }
        n = 0;
        for (i = 0; i < devices.length; ++i) {
            if (((NAME64)devices[i]).name.length() <= 0) continue;
            ++n;
        }
        String[] strdevs = new String[n];
        for (i = 0; i < n; ++i) {
            if (((NAME64)devices[i]).name.length() == 0) continue;
            strdevs[i] = ((NAME64)devices[i]).name;
        }
        return strdevs;
    }

    public static PropertyQueryEx[] getDevicePropertyInformation(String context, String server, String device, String property) {
        return TQuery.getDevicePropertyInformation(context, server, device, property, TLink.defaultTimeout);
    }

    public static synchronized PropertyQueryEx[] getDevicePropertyInformation(String context, String server, String device, String property, int timeout) {
        XPropertyQuery[] xpq = TQuery.getDevicePropertyInformationX(context, server, device, property, timeout);
        if (xpq == null) {
            return null;
        }
        PropertyQueryEx[] pqx = new PropertyQueryEx[xpq.length];
        for (int i = 0; i < pqx.length; ++i) {
            pqx[i] = new PropertyQueryEx(xpq[i]);
        }
        return pqx;
    }

    public static synchronized int AcquireAndRegisterBitfieldInfo(String context, String server, String tag, short format) {
        if (TBitfieldRegistry.getBitfield(context, server, tag) != null) {
            return 0;
        }
        if (context == null || context.length() == 0) {
            context = "DEFAULT";
        }
        String tgt = new String("/" + context + "/" + server);
        TBitfield bf = new TBitfield(tgt, tag, format);
        return bf.acquireAndRegisterFields(tgt);
    }

    public static synchronized int AcquireAndRegisterStructInfo(String context, String server, String tag) {
        TDataType din;
        TCompoundDataObject[] sf;
        TDataType dout;
        if (TStructRegistry.contains(tag)) {
            return 0;
        }
        int cc = 0;
        String tgt = context == null || context.length() == 0 ? new String("/DEFAULT/" + server + "/#0") : new String("/" + context + "/" + server + "/#0");
        TLink tl = new TLink(tgt, "STRUCTFORMAT", dout = new TDataType(sf = new NAME16II[64]), din = new TDataType(tag), 1);
        cc = tl.execute(500, true);
        if ((cc & 0x4000) == 16384) {
            cc = 0;
        }
        tl.cancel();
        if (cc == 0) {
            for (int i = 0; i < 64 && ((NAME16II)sf[i]).i2val % 512 != 255; ++i) {
                TStructRegistry.fill(tag, ((NAME16II)sf[i]).name, (short)((NAME16II)sf[i]).i2val, ((NAME16II)sf[i]).i1val);
            }
            TStructRegistry.fill(tag, (short)255, 100);
        } else if (cc == 2) {
            cc = TQuery.AcquireAndRegisterStructInfoLegacy(context, server, tag);
        }
        return cc;
    }

    private static int AcquireAndRegisterStructInfoLegacy(String context, String server, String tag) {
        TDataType din;
        TCompoundDataObject[] sf;
        TDataType dout;
        if (TStructRegistry.contains(tag)) {
            return 0;
        }
        int cc = 0;
        String tgt = context == null || context.length() == 0 ? new String("/DEFAULT/" + server + "/#0") : new String("/" + context + "/" + server + "/#0");
        TLink tl = new TLink(tgt, "STRUCTFORMAT", dout = new TDataType(sf = new INTINT[64]), din = new TDataType(tag), 1);
        cc = tl.execute(500, true);
        if ((cc & 0x4000) == 16384) {
            cc = 0;
        }
        tl.cancel();
        if (cc == 0) {
            for (int i = 0; i < 64 && ((INTINT)sf[i]).i2val % 512 != 255; ++i) {
                TStructRegistry.fill(tag, (short)((INTINT)sf[i]).i2val, ((INTINT)sf[i]).i1val);
            }
            TStructRegistry.fill(tag, (short)255, 100);
        }
        return cc;
    }

    public static XPropertyQuery[] getDevicePropertyInformationX(String context, String server, String device, String property) {
        return TQuery.getDevicePropertyInformationX(context, server, device, property, TLink.defaultTimeout);
    }

    public static XPropertyQuery[] getDevicePropertyInformationX(String context, String server, String device, String property, int timeout) {
        return TQuery.getDevicePropertyInformationX("PROPS", context, server, device, property, timeout);
    }

    private static synchronized XPropertyQuery[] getDevicePropertyInformationX(String stockprop, String context, String server, String device, String property, int timeout) {
        TLink tl;
        TDataType din;
        int cc = 0;
        XPropertyQuery[] xpq = null;
        XPropertyQuery xpq1 = new XPropertyQuery();
        byte[] blob = hByteBlobX;
        boolean hasTarget = true;
        if (server == null || server.length() == 0) {
            throw new NullPointerException("empty server name entry !");
        }
        String dev = device == null || device.length() == 0 ? new String("#0") : device;
        String tgt = context == null || context.length() == 0 ? new String("/DEFAULT/" + server + "/" + dev) : new String("/" + context + "/" + server + "/" + dev);
        if (property == null || property.compareTo("*") == 0) {
            din = new TDataType();
            String target = "/" + context + "/" + server;
            int np = 10;
            try {
                np = TQuery.getNumberOf("PROPERTIES", target, timeout);
            }
            catch (Exception e) {
                throw new NullPointerException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
            }
            blob = new byte[2 * np * XPropertyQuery.sizeInBytes];
            hasTarget = false;
        } else {
            din = new TDataType(property);
        }
        TDataType dout = new TDataType(blob, "XPQS");
        try {
            tl = new TLink(tgt, stockprop, dout, din, 1);
            cc = tl.execute(timeout, true);
            srvAddr = tl.srvAddr;
            if ((cc & 0x4000) == 16384) {
                cc = 0;
            }
            tl.cancel();
        }
        catch (Exception e) {
            cc = 86;
        }
        if (cc == 0) {
            try {
                TStructIo.bytesToStruct(xpq1, blob, 0, XPropertyQuery.sizeInBytes);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int nxpq = dout.dCompletionLength;
            if (hasTarget) {
                if (xpq1.prpNumOverloads < 1) {
                    xpq1.prpNumOverloads = 1;
                }
                if ((nxpq = xpq1.prpNumOverloads) > 10) {
                    nxpq = 10;
                }
            }
            if (nxpq == 0) {
                return null;
            }
            if (xpq1.prpNumOverloads < 1) {
                xpq1.prpNumOverloads = 1;
            }
            if (nxpq > 10) {
                nxpq = 10;
            }
            xpq = new XPropertyQuery[nxpq];
            xpq[0] = xpq1;
            for (int i = 1; i < nxpq; ++i) {
                xpq[i] = new XPropertyQuery();
                try {
                    TStructIo.bytesToStruct(xpq[i], blob, i * XPropertyQuery.sizeInBytes, XPropertyQuery.sizeInBytes);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return xpq;
        }
        if (cc == 45) {
            throw new NullPointerException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
        }
        if (cc == 8) {
            return null;
        }
        PropertyQueryLegacy[] pqx = null;
        PropertyQueryLegacy pqx1 = new PropertyQueryLegacy();
        dout = new TDataType(hByteBlobL, "PQSX");
        tl = new TLink(tgt, stockprop, dout, din, 1);
        cc = tl.execute(timeout, true);
        tl.cancel();
        if (cc == 0) {
            int i;
            int npqx;
            byte[] b = pqx1.toByteArray();
            System.arraycopy(hByteBlobL, 0, b, 0, PropertyQueryLegacy.sizeInBytes);
            pqx1.toStruct();
            if (pqx1.prpNumOverloads < 1) {
                pqx1.prpNumOverloads = 1;
            }
            if ((npqx = pqx1.prpNumOverloads) > 10) {
                npqx = 10;
            }
            pqx = new PropertyQueryLegacy[npqx];
            xpq = new XPropertyQuery[npqx];
            pqx[0] = pqx1;
            for (i = 1; i < npqx; ++i) {
                pqx[i] = new PropertyQueryLegacy();
                b = pqx[i].toByteArray();
                System.arraycopy(hByteBlobL, i * PropertyQueryLegacy.sizeInBytes, b, 0, PropertyQueryLegacy.sizeInBytes);
                pqx[i].toStruct();
            }
            for (i = 0; i < npqx; ++i) {
                xpq[i] = new XPropertyQuery();
                xpq[i].prpFormat = pqx[i].prpFormat;
                xpq[i].prpFormatIn = pqx[i].prpFormatIn;
                xpq[i].prpSize = pqx[i].prpSize;
                xpq[i].prpSizeIn = pqx[i].prpSizeIn;
                xpq[i].prpAccess = pqx[i].prpAccess;
                xpq[i].prpDescription = pqx[i].prpDescription;
                xpq[i].prpName = pqx[i].prpName;
                xpq[i].prpNumOverloads = pqx[i].prpNumOverloads;
                xpq[i].prpTag = pqx[i].prpTag;
                xpq[i].prpTagIn = pqx[i].prpTagIn;
                xpq[i].prpRedirection = pqx[i].prpRedirection;
                xpq[i].prpHistoryDepthLong = pqx[i].prpHistoryDepthLong;
                xpq[i].prpHistoryDepthShort = pqx[i].prpHistoryDepthShort;
                xpq[i].prpUnits = pqx[i].prpUnits;
                xpq[i].prpMaxValue = pqx[i].prpMaxValue;
                xpq[i].prpMinValue = pqx[i].prpMinValue;
                xpq[i].prpGraphType = pqx[i].prpGraphType;
            }
            return xpq;
        }
        if (cc == 45) {
            throw new NullPointerException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
        }
        hLegacyByteBlob = null;
        String[] prps = TQuery.getDeviceProperties(context, server, device);
        if (prps == null || prps.length == 0) {
            throw new NullPointerException("empty properties list !");
        }
        PropertyQuery[] pq = new PropertyQuery[prps.length];
        xpq = new XPropertyQuery[1];
        if (hLegacyByteBlob == null) {
            return null;
        }
        for (int i = 0; i < prps.length; ++i) {
            pq[i] = new PropertyQuery();
            byte[] b = pq[i].toByteArray();
            System.arraycopy(hLegacyByteBlob, i * PropertyQuery.sizeInBytes, b, 0, PropertyQuery.sizeInBytes);
            pq[i].toStruct();
            if (pq[i].name.compareTo(property) != 0) continue;
            xpq[0] = new XPropertyQuery();
            xpq[0].prpFormat = pq[i].prpFormat;
            xpq[0].prpSize = pq[i].prpSize;
            xpq[0].prpAccess = pq[i].prpAccess;
            xpq[0].prpDescription = pq[i].prpDesc;
            xpq[0].prpName = pq[i].name;
            xpq[0].prpNumOverloads = 1;
            if ((pq[0].prpAccess & 2) == 2) {
                xpq[0].prpFormatIn = pq[i].prpFormat;
                xpq[0].prpSizeIn = pq[i].prpSize;
            } else {
                xpq[0].prpFormatIn = (byte)-1;
                xpq[0].prpSizeIn = 0;
            }
            TCompoundDataObject[] egu = new USTRING[]{new USTRING()};
            dout = new TDataType(egu);
            din = new TDataType();
            String prpegu = new String(property + ".EGU");
            tl = new TLink(tgt, prpegu, dout, din, 1);
            cc = tl.execute(timeout, false);
            tl.cancel();
            if (cc != 0) break;
            xpq[0].prpMinValue = ((USTRING)egu[0]).f1val;
            xpq[0].prpMaxValue = ((USTRING)egu[0]).f2val;
            xpq[0].prpUnits = ((USTRING)egu[0]).str;
            xpq[0].prpGraphType = (byte)((USTRING)egu[0]).ival;
            break;
        }
        return xpq;
    }

    public static TPropertyQuery[] getPropertyInformation(String context, String server, String device, String property) {
        return TQuery.getPropertyInformation(context, server, device, property, 500);
    }

    public static TPropertyQuery[] getPropertyInformation(String context, String server, String device, String property, int timeout) {
        try {
            return TQuery.getPropertyInformation("PROPS", context, server, device, property, timeout);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static int getNumberOfProperties(String context, String server, int timeout) throws IOException {
        if (context == null || server == null) {
            return 0;
        }
        return TQuery.getNumberOf("PROPERTIES", "/" + context + "/" + server, timeout);
    }

    private static synchronized TPropertyQuery[] getPropertyInformation(String stockprop, String context, String server, String device, String property, int timeout) throws IOException {
        TDataType dout;
        byte[] blob;
        boolean hasTarget;
        TPropertyQuery tpq0;
        TPropertyQuery[] tpq;
        int cc;
        block23: {
            TDataType din;
            TLink tl = null;
            cc = 0;
            tpq = null;
            tpq0 = new TPropertyQuery();
            hasTarget = true;
            blob = hByteBlob;
            if (server == null || server.length() == 0) {
                MsgLog.log("getPropertyInformation", "argument list error", 20, null, 0);
                throw new NullPointerException("empty server name entry !");
            }
            String dev = device == null || device.length() == 0 ? new String("#0") : device;
            String tgt = context == null || context.length() == 0 ? new String("/DEFAULT/" + server + "/" + dev) : new String("/" + context + "/" + server + "/" + dev);
            if (property == null || property.compareTo("*") == 0) {
                hasTarget = false;
                din = new TDataType();
                String target = "/" + context + "/" + server;
                int np = 10;
                try {
                    np = TQuery.getNumberOf("PROPERTIES", target, timeout);
                }
                catch (Exception e) {
                    MsgLog.log("getPropertyInformation", TErrorList.getErrorString(cc), cc, null, 0);
                    throw new NullPointerException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
                }
                blob = new byte[2 * np * 432];
            } else {
                if (TQuery.isStockProperty(property)) {
                    stockprop = "STOCKPROPS";
                }
                din = new TDataType(property);
            }
            dout = new TDataType(blob, "PRPQSr4");
            try {
                tl = new TLink(tgt, stockprop, dout, din, 1);
                cc = tl.execute(timeout, true);
                srvAddr = tl.srvAddr;
                if ((cc & 0x4000) == 16384) {
                    cc = 0;
                }
                tl.cancel();
            }
            catch (Exception e) {
                MsgLog.log("getPropertyInformation", TErrorList.getErrorString(cc), cc, null, 0);
                cc = 86;
                if (tl == null) break block23;
                tl.cancel();
            }
        }
        if (cc == 0) {
            try {
                TStructIo.bytesToStruct(tpq0, blob, 0, 432);
            }
            catch (IOException e1) {
                cc = 66;
                MsgLog.log("getPropertyInformation", TErrorList.getErrorString(cc), cc, e1, 0);
                e1.printStackTrace();
            }
            int ntpq = dout.dCompletionLength;
            if (hasTarget) {
                if (tpq0.prpNumOverloads < 1) {
                    tpq0.prpNumOverloads = 1;
                }
                if ((ntpq = tpq0.prpNumOverloads) > 10) {
                    ntpq = 10;
                }
            }
            if (ntpq == 0) {
                return null;
            }
            tpq = new TPropertyQuery[ntpq];
            tpq[0] = tpq0;
            for (int i = 1; i < ntpq; ++i) {
                tpq[i] = new TPropertyQuery();
                try {
                    TStructIo.bytesToStruct(tpq[i], blob, i * 432, 432);
                    continue;
                }
                catch (Exception e) {
                    cc = 66;
                    MsgLog.log("getPropertyInformation", TErrorList.getErrorString(cc), cc, e, 0);
                }
            }
            return tpq;
        }
        if (cc == 45) {
            MsgLog.log("getPropertyInformation", TErrorList.getErrorString(cc), cc, null, 0);
            throw new IOException("Could not acquire property information for " + server + " (" + TErrorList.getErrorString(cc) + ")");
        }
        if (cc == 8) {
            return null;
        }
        XPropertyQuery[] xpq = TQuery.getDevicePropertyInformationX(stockprop, context, server, device, property, timeout);
        if (xpq == null || xpq.length == 0) {
            return null;
        }
        tpq = new TPropertyQuery[xpq.length];
        for (int i = 0; i < xpq.length; ++i) {
            tpq[i] = new TPropertyQuery();
            tpq[i].prpFormat = xpq[i].prpFormat;
            tpq[i].prpFormatIn = xpq[i].prpFormatIn;
            tpq[i].prpSize = xpq[i].prpSize;
            tpq[i].prpSizeIn = xpq[i].prpSizeIn;
            tpq[i].prpAccess = xpq[i].prpAccess;
            tpq[i].prpDescription = xpq[i].prpDescription;
            tpq[i].prpName = xpq[i].prpName;
            tpq[i].prpNumOverloads = xpq[i].prpNumOverloads;
            tpq[i].prpTag = xpq[i].prpTag;
            tpq[i].prpTagIn = xpq[i].prpTagIn;
            tpq[i].prpRedirection = xpq[i].prpRedirection;
            tpq[i].prpHistoryDepthLong = xpq[i].prpHistoryDepthLong;
            tpq[i].prpHistoryDepthShort = xpq[i].prpHistoryDepthShort;
            tpq[i].prpUnits = xpq[i].prpUnits;
            tpq[i].prpMaxValue = xpq[i].prpMaxValue;
            tpq[i].prpMinValue = xpq[i].prpMinValue;
            tpq[i].prpGraphType = xpq[i].prpGraphType;
            tpq[i].numRows = xpq[i].numRows;
            tpq[i].rowSize = xpq[i].rowSize;
            tpq[i].rngMaxValue = xpq[i].rngMaxValue;
            tpq[i].rngMinValue = xpq[i].rngMinValue;
            tpq[i].rngUnits = xpq[i].rngUnits;
        }
        return tpq;
    }

    public static TPropertyQuery[] getStockPropertyInformation(String context, String server, String device, String property) {
        return TQuery.getStockPropertyInformation(context, server, device, property, 500);
    }

    public static TPropertyQuery[] getStockPropertyInformation(String context, String server, String device, String property, int timeout) {
        try {
            return TQuery.getPropertyInformation("STOCKPROPS", context, server, device, property, timeout);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static synchronized XPropertyQuery[] getStockPropertyInformationX(String context, String server, String device, String property) {
        return TQuery.getDevicePropertyInformationX("STOCKPROPS", context, server, device, property, TLink.defaultTimeout);
    }

    private static ServerQuery[] getXTagList(String context, String tagtype, String subsys, String importance) {
        return TQuery.getXTagList(context, tagtype, subsys, importance, TLink.defaultTimeout);
    }

    private static ServerQuery[] getXTagList(String context, String tagtype, String subsys, String importance, int timeout) {
        int i;
        int cc;
        TLink tl;
        StringBuffer host = new StringBuffer(32);
        StringBuffer query = new StringBuffer(32);
        short[] numout = new short[1];
        TDataType numoutData = new TDataType(numout);
        TCompoundDataObject[] inplist = new NAME16[]{subsys == null || subsys.length() == 0 ? new NAME16("ALL") : new NAME16(subsys), importance == null || importance.length() == 0 ? new NAME16("ALL") : new NAME16(importance)};
        TDataType din = new TDataType(inplist);
        host.delete(0, 31);
        query.delete(0, 31);
        if (context != null && context.length() != 0) {
            host.insert(0, "ENS/" + context);
        } else {
            host.insert(0, "ENS");
        }
        query.insert(0, "N" + tagtype);
        try {
            tl = new TLink(host.toString(), query.toString(), numoutData, din, 1);
            cc = tl.execute(timeout, true);
            srvAddr = tl.srvAddr;
            tl.cancel();
        }
        catch (Exception e) {
            cc = 86;
        }
        if (cc != 0) {
            return null;
        }
        query.delete(0, 31);
        query.insert(0, tagtype);
        int n = numout[0];
        TCompoundDataObject[] taglist = new USTRING[n];
        for (i = 0; i < n; ++i) {
            taglist[i] = new USTRING();
        }
        if (taglist.length == 0) {
            return null;
        }
        if (numout[0] > taglist.length) {
            numout[0] = (short)taglist.length;
        }
        TDataType dout = new TDataType(taglist);
        tl = new TLink(host.toString(), query.toString(), dout, din, 1);
        cc = tl.execute(TLink.defaultTimeout, true);
        tl.cancel();
        if (cc != 0) {
            return null;
        }
        ServerQuery[] strlist = new ServerQuery[n];
        for (i = 0; i < n; ++i) {
            String s = ((USTRING)taglist[i]).getString();
            strlist[i] = new ServerQuery();
            String srv = s.substring(0, 16).trim();
            if (srv.endsWith("&")) {
                srv = srv.substring(0, 15) + s.substring(48, 64).trim();
            }
            strlist[i].setName(srv);
            strlist[i].setOs(s.substring(16, 24).trim());
            strlist[i].setSubsystem(s.substring(24, 32).trim());
            int zidx = s.indexOf(0, 32);
            strlist[i].setXref(s.substring(32, zidx).trim());
            strlist[i].setContext(context);
        }
        return strlist;
    }

    private static int tryAccessLock(String context, String server, TLinkFactory.AccessLockType lockType) {
        short[] lvals = new short[]{(short)lockType.ordinal(), 1};
        TDataType din = new TDataType(lvals);
        TLink lnk = new TLink("/" + context + "/" + server, "ACCESSLOCK", null, din, 258);
        int rc = lnk.execute(500, true);
        lnk.close();
        return rc;
    }

    public static int setAccessLock(String context, String server, TLinkFactory.AccessLockType lockType, int lockDuration) {
        int rc = TQuery.tryAccessLock(context, server, lockType);
        if (rc != 0) {
            return rc;
        }
        return TLinkFactory.setAccessLock(context, server, lockType, lockDuration);
    }

    public static String[] getAccessLockInformation(String context, String server) {
        TCompoundDataObject[] n32 = new NAME32[2];
        TDataType dout = new TDataType(n32);
        TLink lnk = new TLink("/" + context + "/" + server, "ACCESSLOCK", dout, null, 1);
        int rc = lnk.execute(500);
        lnk.close();
        if (rc != 0) {
            return null;
        }
        String[] rs = new String[]{((NAME)((Object)n32[0])).getName(), ((NAME)((Object)n32[1])).getName()};
        return rs;
    }

    static {
        lastQueriedContext = null;
        lastQueriedServer = null;
        lastQueriedDevice = null;
        srvAddr = null;
        properties_have_query_function = false;
        devices_have_query_function = false;
        tQueryInstance = new TQuery();
    }

    private class DeviceNamesQueryParams {
        String target;
        String property;
        int size;

        private DeviceNamesQueryParams() {
        }
    }
}

