/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.queryUtils;

import de.desy.tine.client.TLink;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.types.FLTINT;

public final class THistoryQuery {
    public static boolean isMetaProperty(String key) {
        if (key.endsWith(".HST")) {
            return true;
        }
        if (key.endsWith(".HIST")) {
            return true;
        }
        if (key.endsWith(".ARCH")) {
            return true;
        }
        if (key.endsWith(".ARC")) {
            return true;
        }
        return key.endsWith(".AR");
    }

    public static int getArchivedDataAsFloat(String fullName, long starttime, long stoptime, FLTINT[] fiArray) {
        double[] startstop;
        TDataType din;
        TDataType npts;
        TLink nl;
        int cc;
        int[] npoints = new int[1];
        String[] names = TLink.splitDeviceAndPropertyFromName(fullName);
        String srv = names[0];
        if (srv == null) {
            return 20;
        }
        String key = names[1];
        if (key == null) {
            return 20;
        }
        if (!srv.contains("HISTORY") && !THistoryQuery.isMetaProperty(key)) {
            key.concat(".HIST");
        }
        if ((cc = (nl = new TLink(srv, key, npts = new TDataType(npoints), din = new TDataType(startstop = new double[]{(double)(starttime / 1000L) + (double)(starttime % 1000L) / 1000.0, (double)(stoptime / 1000L) + (double)(stoptime % 1000L) / 1000.0}), 1)).execute(1000, true)) != 0) {
            return -cc;
        }
        TDataType dout = new TDataType(fiArray);
        TLink tl = new TLink(srv, key, dout, din, 1);
        cc = tl.execute(1000, true);
        if (cc != 0) {
            return -cc;
        }
        return npoints[0];
    }
}

