/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.headers;

import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.connections.TClientEntry;
import de.desy.tine.server.connections.TContractTable;
import de.desy.tine.server.logger.DbgLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.LinkedList;

public class TPHdr {
    public short msgSizeInBytes;
    private int umsgSizeInBytes;
    public short subId;
    public short lnkCompCode;
    public short numblks;
    public short blknum;
    public short mtu;
    private int umtu;
    public short dFormat;
    public short lnkCounter;
    public short srvProtocol;
    public short xferReason;
    public int lnkStarttime;
    public short stsSize;
    public short stsCode;
    public int dTimeStamp;
    public int dTimeStampUSEC;
    public int usrStamp;
    public int sysStamp;
    public static final int hdrSizeInBytes = 44;
    public static final int hdrSizeInBytesLegacy = 24;
    public ByteArrayOutputStream dBuffer;
    private byte[] bBuffer = new byte[64000];
    private byte[] stsBuffer = new byte[192];
    private LinkedList<TLink> lnks = new LinkedList();
    TLinkFactory tf;

    private void prepare(int protocolLevel) {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeShort(Swap.Short(this.msgSizeInBytes));
            ds.writeShort(Swap.Short(this.subId));
            ds.writeShort(Swap.Short(this.lnkCompCode));
            ds.writeShort(Swap.Short(this.numblks));
            ds.writeShort(Swap.Short(this.blknum));
            ds.writeShort(Swap.Short(this.mtu));
            if (protocolLevel > 5) {
                ds.writeShort(Swap.Short(this.dFormat));
                ds.writeShort(Swap.Short(this.lnkCounter));
                ds.writeShort(Swap.Short(this.srvProtocol));
                ds.writeShort(Swap.Short(this.xferReason));
                ds.writeInt(Swap.Long(this.lnkStarttime));
                ds.writeShort(Swap.Short(this.stsSize));
                ds.writeShort(Swap.Short(this.stsCode));
                ds.writeInt(Swap.Long(this.dTimeStamp));
                ds.writeInt(Swap.Long(this.dTimeStampUSEC));
                ds.writeInt(Swap.Long(this.usrStamp));
                ds.writeInt(Swap.Long(this.sysStamp));
            } else {
                ds.writeShort(Swap.Short(this.dTimeStampUSEC / 1000));
                ds.writeByte(this.dFormat);
                ds.writeByte(this.lnkCounter);
                ds.writeInt(Swap.Long(this.dTimeStamp));
                ds.writeInt(Swap.Long(this.lnkStarttime));
            }
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getRdrString(byte[] b, int offset, int length) {
        int len = 0;
        for (int i = 0; i < length && b[i + offset] != 0; ++i) {
            ++len;
        }
        return new String(b, offset, len).trim();
    }

    public static int UnsignedShort(short sval) {
        int ival = sval;
        if (ival < 0) {
            ival += 65536;
        }
        return ival;
    }

    public static short UnsignedShort(int ival) {
        if (ival > Short.MAX_VALUE) {
            ival -= 65536;
        }
        return (short)ival;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLink[] toStruct(InetAddress inetAddr, int port, byte[] data, int length) {
        this.lnks.clear();
        int bytesread = 0;
        int pktsread = 0;
        int hdrSize = 44;
        int nlnks = 0;
        boolean isLegacy = false;
        long ltime = System.currentTimeMillis();
        try {
            ByteArrayInputStream dinBuffer = new ByteArrayInputStream(data);
            DataInputStream ds = new DataInputStream(dinBuffer);
            int len = TPHdr.UnsignedShort(Swap.Short(ds.readShort()));
            if (TLinkFactory.debugLevel > 1) {
                DbgLog.log("TPHdr", "recv : " + length + " bytes (hdr " + len + " bytes)");
            }
            if (len < length) {
                if (TLinkFactory.debugLevel > 0) {
                    DbgLog.log("TPHdr", "recv error : abort ! ");
                }
                return null;
            }
            bytesread = 2;
            block12: while (bytesread < length) {
                byte[] d;
                TLink lnk;
                this.msgSizeInBytes = Swap.Short(ds.readShort());
                this.umsgSizeInBytes = TPHdr.UnsignedShort(this.msgSizeInBytes);
                this.subId = Swap.Short(ds.readShort());
                this.lnkCompCode = Swap.Short(ds.readShort());
                this.numblks = Swap.Short(ds.readShort());
                this.blknum = Swap.Short(ds.readShort());
                this.mtu = Swap.Short(ds.readShort());
                this.umtu = TPHdr.UnsignedShort(this.mtu);
                ds.mark(this.umsgSizeInBytes);
                this.dFormat = Swap.Short(ds.readShort());
                this.lnkCounter = Swap.Short(ds.readShort());
                this.srvProtocol = Swap.Short(ds.readShort());
                this.xferReason = Swap.Short(ds.readShort());
                this.lnkStarttime = Swap.Long(ds.readInt());
                if (this.lnkCompCode == 94) {
                    lnk = this.tf.findLink(inetAddr, port);
                    if (lnk == null) {
                        if (TLinkFactory.debugLevel <= 0) break;
                        DbgLog.log("TPHdr", "link for " + inetAddr.getHostAddress() + " not found!");
                        break;
                    }
                } else {
                    lnk = this.tf.findTLink(this.subId, this.lnkStarttime);
                    if (lnk == null) {
                        if (TLinkFactory.debugLevel <= 0) break;
                        DbgLog.log("TPHdr", "id " + this.subId + " not found!");
                        break;
                    }
                    if (lnk.getTineProtocol() > 5) {
                        this.stsSize = Swap.Short(ds.readShort());
                        this.stsCode = Swap.Short(ds.readShort());
                        this.dTimeStamp = Swap.Long(ds.readInt());
                        this.dTimeStampUSEC = Swap.Long(ds.readInt());
                        this.usrStamp = Swap.Long(ds.readInt());
                        this.sysStamp = Swap.Long(ds.readInt());
                    }
                }
                if (TLinkFactory.debugLevel > 1) {
                    DbgLog.log("TPHdr", "data : bytes " + this.umsgSizeInBytes + ", blknum " + this.blknum + " from " + this.numblks + " <" + this.lnkCompCode + ">");
                }
                bytesread += this.umsgSizeInBytes;
                if (lnk.getTineProtocol() == 5) {
                    ds.reset();
                    this.dTimeStampUSEC = Swap.Short(ds.readShort()) * 1000;
                    this.dFormat = ds.readByte();
                    this.lnkCounter = ds.readByte();
                    this.dTimeStamp = Swap.Long(ds.readInt());
                    this.lnkStarttime = Swap.Long(ds.readInt());
                    this.stsSize = (short)(this.lnkCompCode == 0 ? 0 : 32);
                    this.stsCode = this.lnkCompCode;
                    this.usrStamp = 0;
                    this.sysStamp = 0;
                    hdrSize = 24;
                    isLegacy = true;
                }
                lnk.dOutput.numblks = this.numblks;
                if (lnk.linkStatus != 113) {
                    lnk.linkStatus = this.lnkCompCode;
                }
                lnk.linkCounter = this.lnkCounter;
                int datasize = lnk.dOutput.dArrayLength * TFormat.formatSizeOf(this.dFormat);
                short doutsize = this.umsgSizeInBytes - hdrSize;
                short extsize = 0;
                int extptr = 0;
                ++pktsread;
                switch (this.lnkCompCode) {
                    case 121: 
                    case 130: {
                        Arrays.fill(this.stsBuffer, (byte)0);
                        d = this.stsBuffer;
                        ds.read(d, 0, this.stsSize);
                        int offset = 0;
                        String ctx = null;
                        String srv = null;
                        String dev = null;
                        String prp = null;
                        if (isLegacy) {
                            if (d[offset] != 0) {
                                srv = this.getRdrString(d, offset, 16);
                            }
                            if (d[offset += 16] != 0) {
                                prp = this.getRdrString(d, offset, 16);
                            }
                        } else {
                            if (d[offset] != 0) {
                                ctx = this.getRdrString(d, offset, 32);
                            }
                            if (d[offset += 32] != 0) {
                                srv = this.getRdrString(d, offset, 32);
                            }
                            if (d[offset += 32] != 0) {
                                dev = this.getRdrString(d, offset, 64);
                            }
                            if (d[offset += 64] != 0) {
                                prp = this.getRdrString(d, offset, 64);
                            }
                        }
                        TLinkFactory.getInstance().addLinkToRedirectionList(lnk, ctx, srv, dev, prp);
                        if (ctx != null) {
                            lnk.cntName = ctx;
                        }
                        if (srv != null) {
                            lnk.expName = srv;
                        }
                        if (dev != null) {
                            lnk.devName = dev;
                        }
                        if (prp == null) break;
                        lnk.devProperty = prp;
                        break;
                    }
                    case 157: {
                        Arrays.fill(this.stsBuffer, (byte)0);
                        d = this.stsBuffer;
                        ds.read(d, 0, 16);
                        String tag = this.getRdrString(d, 0, 16);
                        lnk.dOutput.setTag(tag);
                        break;
                    }
                    case 94: {
                        if (isLegacy) break;
                        break;
                    }
                    case 119: {
                        lnk.srvId = Swap.Short(ds.readShort());
                        break;
                    }
                    default: {
                        lnk.linkStale = true;
                        if (doutsize < this.stsSize && lnk.dOutput.blksin == 0) {
                            lnk.dOutput.bytesin = 0;
                            continue block12;
                        }
                        if ((this.lnkCompCode & 0x4000) != 16384) {
                            datasize = 0;
                        }
                        extsize = 0;
                        short extbytes = doutsize * this.blknum - datasize;
                        if (this.blknum == this.numblks || extbytes > 0) {
                            if (extbytes > 0) {
                                extsize = extbytes;
                                extptr = 0;
                            } else {
                                if (this.numblks == 1 && doutsize < this.stsSize) continue block12;
                                extsize = doutsize < this.stsSize ? doutsize : (short)this.stsSize;
                                extptr = this.stsSize - extsize;
                            }
                            doutsize -= extsize;
                            lnk.dOutput.bytesin += extsize;
                        }
                        if (datasize == 0) {
                            lnk.dOutput.blknum = this.blknum;
                            lnk.dOutput.blksin = 1;
                            lnk.dOutput.numblks = 1;
                            break;
                        }
                    }
                    case 0: {
                        lnk.linkStale = true;
                        if (lnk.dOutput.dFormat == 254) {
                            TDataType tDataType = lnk.dOutput;
                            synchronized (tDataType) {
                                lnk.dOutput.dFormat = this.dFormat;
                                int fmtsize = TFormat.formatSizeOf(lnk.dOutput.dFormat);
                                if (fmtsize < 1) {
                                    continue block12;
                                }
                                lnk.dOutput.dArrayLength = doutsize / fmtsize * lnk.dOutput.numblks;
                                if (this.dFormat != 7 && lnk.dOutput.getDataObject() == null) {
                                    lnk.dOutput.setDataObject(lnk.dOutput.dArrayLength, lnk.dOutput.dFormat);
                                }
                                lnk.adjustDefaultValues = true;
                            }
                        }
                        int sizeInBytes = this.umsgSizeInBytes - hdrSize - extsize;
                        d = this.bBuffer;
                        ds.read(d, 0, sizeInBytes);
                        lnk.dOutput.update(d, 0, sizeInBytes, this.blknum, this.lnkCounter);
                    }
                }
                if (extsize > 0) {
                    d = new byte[extsize];
                    ds.read(d, 0, d.length);
                    System.arraycopy(d, 0, lnk.linkStatusStringBuffer, extptr, extsize);
                }
                if (lnk.linkStatus == 113) {
                    d = TErrorList.getErrorString(113).getBytes();
                    System.arraycopy(d, 0, lnk.linkStatusStringBuffer, extptr, extsize);
                }
                lnk.dOutput.bytesin += doutsize;
                if (lnk.dOutput.blksin != lnk.dOutput.numblks) continue;
                lnk.dOutput.timestamp = this.dTimeStamp;
                lnk.dOutput.timestampMSEC = this.dTimeStampUSEC / 1000;
                lnk.dOutput.usrDataStamp = this.usrStamp;
                lnk.dOutput.sysDataStamp = this.sysStamp;
                lnk.dOutput.xferReason = this.xferReason;
                lnk.getSubscription().linkLastTime = ltime;
                this.lnks.add(lnk);
                if (TLinkFactory.debugLevel > 1) {
                    DbgLog.log("TPHdr", "adding link " + lnk.getFullDeviceName());
                }
                ++nlnks;
            }
            if (TLinkFactory.debugLevel > 1) {
                DbgLog.log("TPHdr", pktsread + " incoming contracts scanned");
            }
            ds.close();
            dinBuffer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.lnks.toArray(new TLink[0]);
    }

    public TPHdr(TLinkFactory tfactory) {
        this.tf = tfactory;
    }

    public TPHdr(int msgsize, TClientEntry clnTblEntry, TContractTable conTblEntry) {
        this.msgSizeInBytes = (short)msgsize;
        this.srvProtocol = (short)6;
        if (clnTblEntry != null && clnTblEntry.sts != null) {
            this.subId = clnTblEntry.sts.id;
            this.lnkCompCode = clnTblEntry.sts.statusCode;
            if (this.lnkCompCode != 0) {
                this.stsSize = (short)192;
            }
            this.numblks = clnTblEntry.sts.numblks;
            this.blknum = clnTblEntry.sts.blknum;
            this.umtu = clnTblEntry.sts.mtu;
            this.mtu = TPHdr.UnsignedShort(this.umtu);
            this.lnkCounter = clnTblEntry.sts.counter;
            this.lnkStarttime = (int)(clnTblEntry.sts.starttime / 1000L);
            this.xferReason = 0;
            this.stsCode = 0;
        }
        if (conTblEntry != null) {
            this.srvProtocol = clnTblEntry.cln.tineProtocol;
            this.dTimeStampUSEC = (int)(conTblEntry.dtimestamp % 1000L * 1000L);
            this.dTimeStamp = (int)(conTblEntry.dtimestamp / 1000L);
            this.usrStamp = conTblEntry.usrstamp;
            this.sysStamp = conTblEntry.sysstamp;
            if (conTblEntry.contract != null) {
                this.dFormat = conTblEntry.contract.dataFormatOut;
            }
        }
        this.dBuffer = new ByteArrayOutputStream(44);
        this.prepare(this.srvProtocol);
    }
}

