/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.definitions;

public class TMode {
    public static final short CM_CANCEL = 0;
    public static final short CM_SINGLE = 1;
    public static final short CM_REFRESH = 2;
    public static final short CM_DATACHANGE = 2;
    public static final short CM_POLL = 3;
    public static final short CM_TIMER = 3;
    public static final short CM_REGISTER = 4;
    public static final short CM_GLOBAL = 5;
    public static final short CM_EVENT = 6;
    public static final short CM_NODUPLICATES = 16;
    public static final short CM_SEEKPATTERN = 32;
    public static final short CM_MISSPATTERN = 64;
    public static final short CM_BCAST = 256;
    public static final short CM_NETWORK = 512;
    public static final short CM_MCAST = 512;
    public static final short CM_USE_ON_ERROR = 1024;
    public static final short CM_USEONERROR = 1024;
    public static final short CM_RETRY = 2048;
    public static final short CM_GROUPED = 4096;
    public static final short CM_CONNECT = 8192;
    public static final short CM_WAIT = 16384;

    public static boolean canClose(int mode) {
        switch (TMode.getBaseMode(mode)) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean canTimeOut(int mode) {
        switch (TMode.getBaseMode(mode)) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static final short getBaseMode(int mode) {
        return (short)(mode & 0xF);
    }

    public static String toString(int mode) {
        String add = "";
        if ((mode & 0x100) == 256) {
            add = add + " + broadcast";
        }
        if ((mode & 0x200) == 512) {
            add = add + " + network";
        }
        if ((mode & 0x400) == 1024) {
            add = add + " + use on error";
        }
        if ((mode & 0x800) == 2048) {
            add = add + " + retry on error";
        }
        if ((mode & 0x1000) == 4096) {
            add = add + " + grouped";
        }
        if ((mode & 0x2000) == 8192) {
            add = add + " + connected";
        }
        if ((mode & 0x4000) == 16384) {
            add = add + " + wait";
        }
        switch (mode & 0xFF) {
            case 0: {
                return "cancel" + add;
            }
            case 1: {
                return "single" + add;
            }
            case 2: {
                return "refresh" + add;
            }
            case 3: {
                return "poll" + add;
            }
            case 4: {
                return "register" + add;
            }
            case 5: {
                return "receive" + add;
            }
            case 6: {
                return "event" + add;
            }
        }
        return "unknown";
    }
}

