/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.dataUtils;

import de.desy.tine.bitfieldUtils.TBitfield;
import de.desy.tine.bitfieldUtils.TBitfieldRegistry;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.structUtils.TStructDescription;
import de.desy.tine.structUtils.TStructRegistry;
import de.desy.tine.structUtils.TTaggedStructure;
import de.desy.tine.types.DBLDBL;
import de.desy.tine.types.DBLDBLDBL;
import de.desy.tine.types.DBLINT;
import de.desy.tine.types.FLTFLT;
import de.desy.tine.types.FLTFLTINT;
import de.desy.tine.types.FLTINT;
import de.desy.tine.types.FLTINTINT;
import de.desy.tine.types.HISTORY;
import de.desy.tine.types.IMAGE;
import de.desy.tine.types.INTFLTFLTFLT;
import de.desy.tine.types.INTFLTINT;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.INTINTFLTFLT;
import de.desy.tine.types.INTINTINT;
import de.desy.tine.types.INTINTINTINT;
import de.desy.tine.types.NAME;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME16DBLDBL;
import de.desy.tine.types.NAME16FI;
import de.desy.tine.types.NAME16I;
import de.desy.tine.types.NAME16II;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME32DBLDBL;
import de.desy.tine.types.NAME32I;
import de.desy.tine.types.NAME48;
import de.desy.tine.types.NAME48I;
import de.desy.tine.types.NAME64;
import de.desy.tine.types.NAME64DBL;
import de.desy.tine.types.NAME64DBLDBL;
import de.desy.tine.types.NAME64DBLDBLDBL;
import de.desy.tine.types.NAME64I;
import de.desy.tine.types.NAME8;
import de.desy.tine.types.NAMEINT;
import de.desy.tine.types.SPECTRUM;
import de.desy.tine.types.TCompoundDataObject;
import de.desy.tine.types.UNAME;
import de.desy.tine.types.USTRING;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TDataType
implements Cloneable {
    public boolean acquireDefaultFormat = false;
    public boolean isLocked = false;
    public static int RPCERR_SIZE = 192;
    private static int dBufferSegSize = 1472;
    public int dCompletionLength;
    public int dArrayLength;
    public short dFormat;
    protected Vector<Object> dVector;
    private boolean removeTagAtLinkTime = false;
    private String arrayDelimiter = new String("\n");
    private String dTag = new String(new StringBuffer(16));
    private TBitfield dBitField = null;
    private String dField = null;
    private int dSizeInBytes;
    private ByteArrayOutputStream dBuffer;
    private ByteArrayOutputStream[] dBuffers;
    public long dTimestamp;
    public int timestamp;
    public int timestampMSEC;
    public int usrDataStamp;
    public int sysDataStamp;
    public int xferReason;
    public int numblks;
    public int blknum;
    public int blkid;
    public int blkcnt;
    public int mtu;
    public int blksin;
    public int bytesin;
    private Object hDataObject;
    private Object hStructObject;

    public void pushBytes(byte[] bytestream) {
        try {
            this.dBuffers[0].reset();
            this.dBuffers[0].write(bytestream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getUserDataStamp() {
        return this.usrDataStamp;
    }

    public void setUserDataStamp(int dataStamp) {
        this.usrDataStamp = dataStamp;
    }

    public int getSystemDataStamp() {
        return this.sysDataStamp;
    }

    public void setSystemDataStamp(int dataStamp) {
        this.sysDataStamp = dataStamp;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("TDataType cannot clone");
        }
        return o;
    }

    public void resetCounters(int tineProtocol) {
        switch (tineProtocol) {
            case 6: {
                this.mtu = 1246;
                this.initCounters();
                break;
            }
            case 5: {
                this.mtu = 1346;
                this.initCounters();
                break;
            }
        }
    }

    private void initCounters() {
        this.mtu = 1246;
        if (this.dFormat != 255) {
            this.mtu -= this.mtu % TFormat.formatSizeOf(this.dFormat);
        }
        this.numblks = this.dSizeInBytes / this.mtu;
        if (this.dSizeInBytes == 0 || this.dSizeInBytes % this.mtu > 0) {
            ++this.numblks;
        }
        this.blkid = 1;
        this.blknum = 1;
        this.blkcnt = 0;
    }

    public boolean equals(TDataType dt) {
        return this.equals(true, dt);
    }

    public boolean equals(boolean compareContents, TDataType dt) {
        if (dt == null) {
            return this.dFormat == 255;
        }
        if (dt.dFormat == 255 && this.dFormat == 255) {
            return true;
        }
        if (dt.dFormat == 254 && this.acquireDefaultFormat) {
            return true;
        }
        if (dt.dFormat != this.dFormat) {
            return false;
        }
        if (dt.dArrayLength == 0) {
            return false;
        }
        if (dt.dFormat != 57 && dt.dArrayLength != this.dArrayLength) {
            return false;
        }
        if (dt.dBuffers == null || this.dBuffers == null) {
            return false;
        }
        if (dt.getTag().compareTo(this.getTag()) != 0) {
            return false;
        }
        if (compareContents) {
            for (int i = 0; i < dt.dBuffers.length && dBufferSegSize * i <= this.dArrayLength; ++i) {
                if (this.dBuffers[i] == null || dt.dBuffers[i] == null) {
                    return false;
                }
                if (Arrays.equals(dt.dBuffers[i].toByteArray(), this.dBuffers[i].toByteArray())) continue;
                return false;
            }
        }
        return true;
    }

    public int copy(TDataType dt) {
        if (dt == null) {
            return 20;
        }
        if (dt.dFormat == 255 && this.dFormat == 255) {
            return 0;
        }
        if (dt.dFormat != this.dFormat) {
            return 2;
        }
        if (dt.dFormat == 57) {
            this.dSizeInBytes = dt.dSizeInBytes;
        } else if (dt.dArrayLength > this.dArrayLength) {
            return 23;
        }
        if (dt.dBuffers == null || this.dBuffers == null) {
            return 12;
        }
        this.dCompletionLength = dt.dCompletionLength;
        if (this.dBuffers == dt.dBuffers) {
            return 0;
        }
        try {
            for (int i = 0; i < dt.dBuffers.length; ++i) {
                this.dBuffers[i].reset();
                dt.dBuffers[i].writeTo(this.dBuffers[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void setArrayDelimiter(String delimiter) {
        if (this.arrayDelimiter.compareTo(delimiter) == 0) {
            return;
        }
        this.arrayDelimiter = new String(delimiter);
    }

    public String getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    public TDataType() {
        this.dFormat = (short)255;
        this.dArrayLength = 0;
        this.dSizeInBytes = 0;
        this.initCounters();
    }

    private void makeDataObject(int dataSize, short dataFormat) {
        this.dFormat = dataFormat >= 0 ? dataFormat : (short)(256 + dataFormat);
        switch (this.dFormat % 256) {
            case 0: {
                this.hDataObject = new double[dataSize];
                break;
            }
            case 5: {
                this.hDataObject = new float[dataSize];
                break;
            }
            case 1: 
            case 51: {
                this.hDataObject = new short[dataSize];
                break;
            }
            case 3: 
            case 33: 
            case 52: {
                this.hDataObject = new int[dataSize];
                break;
            }
            case 6: {
                this.hDataObject = new long[dataSize];
                break;
            }
            case 9: {
                this.hDataObject = new NAME16[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME16[])this.hDataObject)[i] = new NAME16();
                }
                break;
            }
            case 13: {
                this.hDataObject = new NAME32[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME32[])this.hDataObject)[i] = new NAME32();
                }
                break;
            }
            case 19: {
                this.hDataObject = new NAME48[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME48[])this.hDataObject)[i] = new NAME48();
                }
                break;
            }
            case 36: {
                this.hDataObject = new NAME64[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME64[])this.hDataObject)[i] = new NAME64();
                }
                break;
            }
            case 8: {
                this.hDataObject = new NAME8[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME8[])this.hDataObject)[i] = new NAME8();
                }
                break;
            }
            case 2: 
            case 7: 
            case 50: 
            case 56: {
                this.hDataObject = new byte[dataSize];
                break;
            }
            case 16: {
                this.hDataObject = new DBLINT[dataSize];
                break;
            }
            case 40: {
                this.hDataObject = new DBLDBL[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((DBLDBL[])this.hDataObject)[i] = new DBLDBL();
                }
                break;
            }
            case 48: {
                this.hDataObject = new DBLDBLDBL[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((DBLDBLDBL[])this.hDataObject)[i] = new DBLDBLDBL();
                }
                break;
            }
            case 14: {
                this.hDataObject = new FLTINT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((FLTINT[])this.hDataObject)[i] = new FLTINT();
                }
                break;
            }
            case 15: {
                this.hDataObject = new INTINT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((INTINT[])this.hDataObject)[i] = new INTINT();
                }
                break;
            }
            case 21: {
                this.hDataObject = new NAME16I[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME16I[])this.hDataObject)[i] = new NAME16I();
                }
                break;
            }
            case 10: {
                this.hDataObject = new NAME16FI[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME16FI[])this.hDataObject)[i] = new NAME16FI();
                }
                break;
            }
            case 42: {
                this.hDataObject = new NAME16II[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME16II[])this.hDataObject)[i] = new NAME16II();
                }
                break;
            }
            case 22: {
                this.hDataObject = new NAME32I[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME32I[])this.hDataObject)[i] = new NAME32I();
                }
                break;
            }
            case 23: {
                this.hDataObject = new NAME48I[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME48I[])this.hDataObject)[i] = new NAME48I();
                }
                break;
            }
            case 37: {
                this.hDataObject = new NAME64I[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME64I[])this.hDataObject)[i] = new NAME64I();
                }
                break;
            }
            case 41: {
                this.hDataObject = new NAME16DBLDBL[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME16DBLDBL[])this.hDataObject)[i] = new NAME16DBLDBL();
                }
                break;
            }
            case 44: {
                this.hDataObject = new NAME32DBLDBL[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME32DBLDBL[])this.hDataObject)[i] = new NAME32DBLDBL();
                }
                break;
            }
            case 54: {
                this.hDataObject = new NAME64DBL[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME64DBL[])this.hDataObject)[i] = new NAME64DBL();
                }
                break;
            }
            case 45: {
                this.hDataObject = new NAME64DBLDBL[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME64DBLDBL[])this.hDataObject)[i] = new NAME64DBLDBL();
                }
                break;
            }
            case 49: {
                this.hDataObject = new NAME64DBLDBLDBL[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((NAME64DBLDBLDBL[])this.hDataObject)[i] = new NAME64DBLDBLDBL();
                }
                break;
            }
            case 28: {
                this.hDataObject = new SPECTRUM(dataSize);
                break;
            }
            case 18: {
                this.hDataObject = new INTFLTINT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((INTFLTINT[])this.hDataObject)[i] = new INTFLTINT();
                }
                break;
            }
            case 4: 
            case 47: {
                this.hDataObject = new char[dataSize];
                break;
            }
            case 57: {
                this.hDataObject = new String[dataSize];
                break;
            }
            case 24: {
                this.hDataObject = new USTRING[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((USTRING[])this.hDataObject)[i] = new USTRING();
                }
                break;
            }
            case 46: {
                this.hDataObject = new UNAME[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((UNAME[])this.hDataObject)[i] = new UNAME();
                }
                break;
            }
            case 29: {
                this.hDataObject = new INTINTINTINT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((INTINTINTINT[])this.hDataObject)[i] = new INTINTINTINT();
                }
                break;
            }
            case 43: {
                this.hDataObject = new INTINTINT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((INTINTINT[])this.hDataObject)[i] = new INTINTINT();
                }
                break;
            }
            case 31: {
                this.hDataObject = new FLTFLT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((FLTFLT[])this.hDataObject)[i] = new FLTFLT();
                }
                break;
            }
            case 27: {
                this.hDataObject = new INTFLTFLTFLT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((INTFLTFLTFLT[])this.hDataObject)[i] = new INTFLTFLTFLT();
                }
                break;
            }
            case 25: {
                this.hDataObject = new FLTFLTINT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((FLTFLTINT[])this.hDataObject)[i] = new FLTFLTINT();
                }
                break;
            }
            case 26: {
                this.hDataObject = new FLTINTINT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((FLTINTINT[])this.hDataObject)[i] = new FLTINTINT();
                }
                break;
            }
            case 34: {
                this.hDataObject = new INTINTFLTFLT[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    ((INTINTFLTFLT[])this.hDataObject)[i] = new INTINTFLTFLT();
                }
                break;
            }
        }
    }

    public TDataType(int dataSize, short dataFormat) {
        int hsiz;
        this.dFormat = dataFormat >= 0 ? dataFormat : (short)(256 + dataFormat);
        switch (this.dFormat % 256) {
            case 254: {
                this.acquireDefaultFormat = true;
                this.dSizeInBytes = dataSize;
                this.dArrayLength = dataSize;
                this.blknum = 1;
                this.blkcnt = 0;
                return;
            }
        }
        this.makeDataObject(dataSize, dataFormat);
        this.dArrayLength = dataSize;
        this.dSizeInBytes = dataSize * TFormat.formatSizeOf(this.dFormat) + TFormat.getFormatHeaderSize(this.dFormat);
        if (this.dFormat == 56 && (hsiz = TFormat.getCarriedFormatSize(this.dTag)) > 0) {
            this.dArrayLength = dataSize / (hsiz += TFormat.getHistoryHeaderSize());
        }
        this.initCounters();
        this.dBuffers = new ByteArrayOutputStream[this.numblks * 3 / 2];
        int i = 0;
        for (int n = 0; n < this.numblks; ++n) {
            this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
            DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
            try {
                while (i < this.dSizeInBytes && i < (n + 1) * this.mtu) {
                    ds.write(0);
                    ++i;
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public int getTimeStamp() {
        return this.timestamp;
    }

    public long getDataTimeStamp() {
        if (this.dTimestamp > 0L) {
            return this.dTimestamp;
        }
        return (long)this.timestamp * 1000L + (long)this.timestampMSEC;
    }

    public void setDataTimeStamp(long TimeStamp) {
        this.dTimestamp = TimeStamp;
        this.timestamp = (int)(TimeStamp / 1000L);
        this.timestampMSEC = (int)(TimeStamp % 1000L);
    }

    public void setDataTimeStamp(double TimeStamp) {
        long t = (long)TimeStamp * 1000L + (long)(TimeStamp * 1000.0) % 1000L;
        this.setDataTimeStamp(t);
    }

    public int getLastDataSize() {
        return this.dCompletionLength;
    }

    public TDataType(byte[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(byte[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(byte[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = (short)2;
            this.dArrayLength = length;
            this.dSizeInBytes = length;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu) {
                    ds.writeByte(data[i]);
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(byte[] data, String tag) {
        this.dTag = tag;
        try {
            this.dFormat = (short)7;
            this.dArrayLength = data.length;
            this.dSizeInBytes = data.length;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu) {
                    ds.writeByte(data[i]);
                    ++i;
                }
                byte[] b = this.dBuffers[n].toByteArray();
                this.dBuffers[n].reset();
                ds.write(b, 0, b.length);
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(TTaggedStructure data) {
        this.dTag = data.getName();
        try {
            byte[] hb = data.toByteArray();
            this.dFormat = (short)7;
            this.dArrayLength = this.dSizeInBytes = data.getSizeInBytes();
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dSizeInBytes && i < (n + 1) * this.mtu) {
                    ds.writeByte(hb[i]);
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data.getByteArray();
            this.hStructObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(TTaggedStructure[] data) {
        if (data[0] == null) {
            MsgLog.log("TDataType", "Tagged Structure data type unallocated !", 62, null, 0);
            return;
        }
        for (int k = 1; k < data.length; ++k) {
            if (data[k] != null) continue;
            data[k] = (TTaggedStructure)data[0].clone();
        }
        this.dTag = data[0].getName();
        byte[] hbytes = new byte[data[0].getSizeInBytes() * data.length];
        try {
            int dsiz = data[0].getSizeInBytes();
            this.dFormat = (short)7;
            this.dArrayLength = dsiz * data.length;
            this.dSizeInBytes = dsiz * data.length;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            for (int k = 0; k < data.length; ++k) {
                System.arraycopy(data[k].toByteArray(), 0, hbytes, k * dsiz, dsiz);
            }
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu) {
                    ds.writeByte(hbytes[i]);
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = hbytes;
            this.hStructObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(short[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(short[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(short[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = 1;
            this.dArrayLength = length;
            this.dSizeInBytes = length * 2;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu / 2) {
                    ds.writeShort(Swap.Short(data[i]));
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(short data) {
        try {
            this.dFormat = 1;
            this.dArrayLength = 1;
            this.dSizeInBytes = 2;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            this.dBuffers[0] = new ByteArrayOutputStream(dBufferSegSize);
            DataOutputStream ds = new DataOutputStream(this.dBuffers[0]);
            ds.writeShort(data);
            byte[] b = this.dBuffers[0].toByteArray();
            Swap.Bytes(b, 2);
            this.dBuffers[0].reset();
            ds.write(b, 0, b.length);
            ds.close();
            this.hDataObject = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(int[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(int[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(int[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = (short)3;
            this.dArrayLength = length;
            this.dSizeInBytes = length * 4;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu / 4) {
                    ds.writeInt(Swap.Long(data[i]));
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(boolean[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(boolean[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(boolean[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = (short)33;
            this.dArrayLength = length;
            this.dSizeInBytes = length * 4;
            this.initCounters();
            int[] idata = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                idata[i] = data[i] ? 1 : 0;
            }
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu / 4) {
                    ds.writeInt(Swap.Long(idata[i]));
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(float[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(float[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(float[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = (short)5;
            this.dArrayLength = length;
            this.dSizeInBytes = length * 4;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks * 3 / 2];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu / 4) {
                    ds.write(Swap.Float(data[i]));
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(TCompoundDataObject[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(TCompoundDataObject[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(TCompoundDataObject[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            if (data instanceof TBitfield[]) {
                if (((TBitfield[])data)[0] == null) {
                    return;
                }
                this.dTag = ((TBitfield[])data)[0].getName();
            }
            TCompoundDataObject tdo = data[0] != null ? data[0] : data.getClass().getComponentType().newInstance();
            this.dFormat = tdo.getFormat();
            int elementSize = TFormat.formatSizeOf(this.dFormat);
            this.dArrayLength = length;
            this.dSizeInBytes = length * elementSize;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < length && i < (n + 1) * this.mtu / elementSize) {
                    this.setObjectContents(ds, data, i);
                    ++i;
                }
                ds.close();
            }
            this.setObjectHandle(data);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTDataType(Object data, int length) {
        try {
            if (length > TDataType.getObjectSize(data)) {
                length = TDataType.getObjectSize(data);
            }
            this.dFormat = TDataType.getObjectFormat(data);
            int elementSize = TFormat.formatSizeOf(this.dFormat);
            this.dArrayLength = length;
            this.dSizeInBytes = length * elementSize;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < length && i < (n + 1) * this.mtu / elementSize) {
                    this.setObjectContents(ds, data, i);
                    ++i;
                }
                ds.close();
            }
            this.setObjectHandle(data);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(SPECTRUM data) {
        try {
            this.dFormat = (short)28;
            this.dArrayLength = data.length;
            this.dSizeInBytes = data.length * 4 + 96;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            byte[] bdata = data.toByteArray();
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dSizeInBytes && i < (n + 1) * this.mtu) {
                    ds.writeByte(bdata[i]);
                    ++i;
                }
                byte[] b = this.dBuffers[n].toByteArray();
                this.dBuffers[n].reset();
                ds.write(b, 0, b.length);
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(IMAGE data) {
        try {
            this.dFormat = (short)55;
            this.dArrayLength = data.getImageFrameSize();
            this.dSizeInBytes = data.getSizeInBytes();
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            byte[] bdata = data.toByteArray();
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dSizeInBytes && i < (n + 1) * this.mtu) {
                    ds.writeByte(bdata[i]);
                    ++i;
                }
                byte[] b = this.dBuffers[n].toByteArray();
                this.dBuffers[n].reset();
                ds.write(b, 0, b.length);
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void repackageDataForOutput() {
        try {
            int fsiz = TFormat.formatSizeOf(this.dFormat);
            this.initCounters();
            int i = 0;
            int m = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n].reset();
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < m + dBufferSegSize / fsiz) {
                    this.setObjectContents(ds, this.getDataObject(), i);
                    if (this.dFormat == 4 || this.dFormat == 47 || this.dFormat == 57) {
                        i = this.dArrayLength;
                    }
                    ++i;
                }
                ds.close();
                m = i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(double[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(double[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(double[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = 0;
            this.dArrayLength = length;
            this.dSizeInBytes = length * 8;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu / 8) {
                    ds.write(Swap.Double(data[i]));
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(long[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(long[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(long[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = (short)6;
            this.dArrayLength = length;
            this.dSizeInBytes = length * 8;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu / 8) {
                    ds.writeLong(Swap.DLong(data[i]));
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void update(byte[] data, int num, int id) {
        this.update(data, 0, data.length, num, id);
    }

    public void update(byte[] data, int off, int len, int num, int id) {
        if (TLinkFactory.debugLevel > 1) {
            DbgLog.log("TDataType", "update: blk " + num + " id " + id + " (" + len + " bytes)");
        }
        this.blknum = num;
        if (id != this.blkid) {
            this.blkid = id;
            this.blksin = 0;
            this.bytesin = 0;
        }
        if (data.length == 0) {
            this.blksin = 1;
            return;
        }
        if (this.dBuffers == null) {
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
            }
        }
        try {
            if (this.dBuffers[num - 1] == null) {
                this.dBuffers[num - 1] = new ByteArrayOutputStream(dBufferSegSize);
            }
            this.dBuffers[num - 1].reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffers[num - 1]);
            ds.write(data, off, len);
            ds.close();
            ++this.blksin;
            if (TLinkFactory.debugLevel > 1) {
                String tag = this.blksin == this.numblks ? " transfer complete" : " missing " + (this.numblks - this.blksin) + " blocks";
                DbgLog.log("TDataType", "update: blks received " + this.blksin + tag);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getData(byte[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(byte[] data, int length, int offset) {
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        int len = this.dArrayLength;
        if (len > length) {
            len = length;
        }
        try {
            TStructDescription tsd;
            int i = 0;
            int m = 0;
            for (int n = 0; n < this.numblks; ++n) {
                byte[] b = this.dBuffers[n].toByteArray();
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                while (i < len && i < m + b.length) {
                    data[i + offset] = ds.readByte();
                    ++i;
                }
                ds.close();
                bs.close();
                m = i;
            }
            this.dCompletionLength = i;
            if (this.dFormat == 7 && (tsd = TStructRegistry.get(this.dTag)) != null && tsd.getSize() != 0) {
                this.dCompletionLength /= tsd.getSize();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getData(short[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(short[] data, int length, int offset) {
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        int len = this.dArrayLength;
        if (len > length) {
            len = length;
        }
        try {
            int fmtsiz = TFormat.formatSizeOf(this.dFormat);
            int i = 0;
            int m = 0;
            for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
                byte[] b = this.dBuffers[n].toByteArray();
                Swap.Bytes(b, fmtsiz);
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                switch (this.dFormat) {
                    case 0: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (short)ds.readDouble();
                            ++i;
                        }
                        break;
                    }
                    case 5: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (short)ds.readFloat();
                            ++i;
                        }
                        break;
                    }
                    case 6: 
                    case 53: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (short)ds.readLong();
                            ++i;
                        }
                        break;
                    }
                    case 3: 
                    case 33: 
                    case 52: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (short)ds.readInt();
                            ++i;
                        }
                        break;
                    }
                    case 1: 
                    case 51: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readShort();
                            ++i;
                        }
                        break;
                    }
                    default: {
                        ds.close();
                        bs.close();
                        return 2;
                    }
                }
                ds.close();
                bs.close();
                m = i;
            }
            this.dCompletionLength = i;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int putData(short data) {
        short[] d = new short[]{data};
        return this.putData(d);
    }

    public int putData(short[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(short[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((double[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((float[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((short[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 3: 
            case 33: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((int[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((long[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public void applyBitField() {
        if (this.dBitField == null) {
            return;
        }
        if (this.hDataObject instanceof TBitfield[]) {
            return;
        }
        switch (this.dFormat) {
            case 50: {
                if (!(this.hDataObject instanceof byte[])) break;
                for (int i = 0; i < this.dCompletionLength; ++i) {
                    ((byte[])this.hDataObject)[i] = (byte)this.dBitField.getField(this.dField, ((byte[])this.hDataObject)[i]);
                }
                break;
            }
            case 51: {
                int i;
                if (this.hDataObject instanceof short[]) {
                    for (i = 0; i < this.dCompletionLength; ++i) {
                        ((short[])this.hDataObject)[i] = (short)this.dBitField.getField(this.dField, ((short[])this.hDataObject)[i]);
                    }
                }
            }
            case 52: {
                int i;
                if (this.hDataObject instanceof int[]) {
                    for (i = 0; i < this.dCompletionLength; ++i) {
                        ((int[])this.hDataObject)[i] = this.dBitField.getField(this.dField, ((int[])this.hDataObject)[i]);
                    }
                }
            }
            case 53: {
                int i;
                if (!(this.hDataObject instanceof long[])) break;
                for (i = 0; i < this.dCompletionLength; ++i) {
                    ((long[])this.hDataObject)[i] = this.dBitField.getField(this.dField, (int)((long[])this.hDataObject)[i]);
                }
                break;
            }
        }
    }

    public int getData() {
        switch (this.dFormat) {
            case 7: {
                if (this.hDataObject != null) {
                    this.getData(this.hDataObject);
                }
                if (this.hStructObject != null && this.hStructObject instanceof TTaggedStructure) {
                    ((TTaggedStructure)this.hStructObject).toStruct((byte[])this.hDataObject);
                    break;
                }
                if (!(this.hStructObject instanceof TTaggedStructure[])) break;
                TTaggedStructure[] tts = (TTaggedStructure[])this.hStructObject;
                int dsiz = tts[0].getSizeInBytes();
                byte[] hb = new byte[dsiz];
                for (int i = 0; i < tts.length; ++i) {
                    System.arraycopy((byte[])this.hDataObject, i * dsiz, hb, 0, dsiz);
                    tts[i].toStruct(hb);
                }
                break;
            }
            default: {
                this.getData(this.getDataObject());
            }
        }
        return 0;
    }

    public int getData(boolean[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(boolean[] data, int length, int offset) {
        if (data == null || data.length == 0) {
            return 20;
        }
        int[] idata = new int[data.length];
        int cc = this.getData(idata, length, offset);
        if (cc == 0) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = idata[i] != 0;
            }
        }
        return cc;
    }

    public int getData(int[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(int[] data, int length, int offset) {
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        int len = this.dArrayLength;
        if (len > length) {
            len = length;
        }
        try {
            int fmtsiz = TFormat.formatSizeOf(this.dFormat);
            int i = 0;
            int m = 0;
            for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
                byte[] b = this.dBuffers[n].toByteArray();
                Swap.Bytes(b, fmtsiz);
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                switch (this.dFormat) {
                    case 0: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (int)ds.readDouble();
                            ++i;
                        }
                        break;
                    }
                    case 5: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (int)ds.readFloat();
                            ++i;
                        }
                        break;
                    }
                    case 3: 
                    case 33: 
                    case 52: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readInt();
                            ++i;
                        }
                        break;
                    }
                    case 6: 
                    case 53: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (int)ds.readLong();
                            ++i;
                        }
                        break;
                    }
                    case 1: 
                    case 51: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readShort();
                            ++i;
                        }
                        break;
                    }
                    default: {
                        ds.close();
                        bs.close();
                        return 2;
                    }
                }
                ds.close();
                bs.close();
                m = i;
            }
            this.dCompletionLength = i;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("TINE copyData Exception " + e.toString());
        }
        return 0;
    }

    public int putData(boolean data) {
        boolean[] d = new boolean[]{data};
        return this.putData(d);
    }

    public int putData(boolean[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(boolean[] data, int length, int offset) {
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        int[] idata = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            idata[i] = data[i] ? 1 : 0;
        }
        return this.putData(idata, length, offset);
    }

    public int putData(int data) {
        int[] d = new int[]{data};
        return this.putData(d);
    }

    public int putData(int[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(int[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((double[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((float[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((short[])this.hDataObject)[i] = (short)data[i + offset];
                }
                break;
            }
            case 3: 
            case 33: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((int[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((double[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int getData(float[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(float[] data, int length, int offset) {
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        int len = this.dArrayLength;
        if (len > length) {
            len = length;
        }
        try {
            int fmtsiz = TFormat.formatSizeOf(this.dFormat);
            int i = 0;
            int m = 0;
            for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
                if (this.dBuffers[0].size() == 0) {
                    System.out.println("dout=" + this.toString());
                    System.out.println("getData dBuffers=" + this.dBuffers[0].toString());
                }
                byte[] b = this.dBuffers[n].toByteArray();
                Swap.Bytes(b, fmtsiz);
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                switch (this.dFormat) {
                    case 0: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (float)ds.readDouble();
                            ++i;
                        }
                        break;
                    }
                    case 5: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readFloat();
                            ++i;
                        }
                        break;
                    }
                    case 3: 
                    case 33: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readInt();
                            ++i;
                        }
                        break;
                    }
                    case 6: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readLong();
                            ++i;
                        }
                        break;
                    }
                    case 1: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readShort();
                            ++i;
                        }
                        break;
                    }
                    default: {
                        ds.close();
                        bs.close();
                        return 2;
                    }
                }
                ds.close();
                bs.close();
                m = i;
            }
            this.dCompletionLength = i;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getData(TTaggedStructure[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(TTaggedStructure[] data, int length, int offset) {
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dFormat != 7) {
            return 2;
        }
        if (this.dTag.compareTo(data[0].getName()) != 0) {
            return 62;
        }
        if (this.hDataObject == null) {
            return 103;
        }
        this.getData(this.hDataObject);
        int dsiz = data[0].getSizeInBytes();
        byte[] hb = new byte[dsiz];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(this.hDataObject, i * dsiz, hb, 0, dsiz);
            data[i].toStruct(hb);
        }
        this.dCompletionLength /= dsiz;
        return 0;
    }

    public int getData(TCompoundDataObject[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(TCompoundDataObject[] data, int length, int offset) {
        int from_size;
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (data instanceof TBitfield[] && ((TBitfield[])data)[0] == null) {
            return 152;
        }
        if (data instanceof IMAGE[]) {
            return this.getData(((IMAGE[])data)[0]);
        }
        if (data instanceof HISTORY[] && this.dFormat != 56) {
            return 2;
        }
        if (data instanceof SPECTRUM[]) {
            return this.getData(((SPECTRUM[])data)[0]);
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        int len = this.dArrayLength;
        if (len > length) {
            len = length;
        }
        int to_size = 0;
        int cpy_size = from_size = TFormat.formatSizeOf(this.dFormat);
        try {
            int i = 0;
            int m = 0;
            int j = 0;
            for (int n = 0; n < this.numblks; ++n) {
                if (i + offset >= data.length) {
                    MsgLog.log("TDataType", "data overflow disgarded", 25, null, 1);
                    break;
                }
                if (data[i + offset] == null) {
                    this.makeNewCompoundDataObject(data, i + offset);
                }
                if (to_size == 0) {
                    to_size = data[i + offset].getSizeInBytes();
                    if (this.dFormat == 4) {
                        to_size = 1;
                    }
                    if (to_size < cpy_size) {
                        cpy_size = to_size;
                    }
                }
                if (this.dBuffers[n] == null) break;
                byte[] b = this.dBuffers[n].toByteArray();
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                while (i < len && i < m + b.length / from_size) {
                    if (data[i + offset] == null) {
                        this.makeNewCompoundDataObject(data, i + offset);
                    }
                    if (data[i + offset].getByteArray() == null) {
                        data[i + offset].toByteArray();
                    }
                    byte[] ba = data[i + offset].getByteArray();
                    for (j = 0; j < cpy_size; ++j) {
                        ba[j] = ds.readByte();
                    }
                    data[i + offset].toStruct();
                    ++i;
                }
                ds.close();
                bs.close();
                m = i;
            }
            this.dCompletionLength = i;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getData(SPECTRUM data) {
        if (this.dFormat != 28) {
            return 2;
        }
        if (this.dArrayLength > data.length) {
            return 23;
        }
        int dSize = this.dArrayLength + 24;
        try {
            int i = 0;
            int m = 0;
            for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
                byte[] b = this.dBuffers[n].toByteArray();
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                while (i < dSize * 4 && i < m + b.length) {
                    data.hByteArray[i] = ds.readByte();
                    ++i;
                }
                data.toStruct();
                ds.close();
                bs.close();
                m = i;
            }
            this.dCompletionLength = i - 24;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getData(IMAGE data) {
        if (this.dFormat != 55) {
            return 2;
        }
        if (this.dArrayLength > data.getImageFrameSize()) {
            return 23;
        }
        try {
            int len = 0;
            int off = 0;
            int i = 0;
            for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
                byte[] b = this.dBuffers[n].toByteArray();
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                len = b.length;
                if (n == 0) {
                    data.setHeaderBytes(ds);
                    off = 0;
                    len -= TFormat.getFormatHeaderSize((short)55);
                }
                data.setImageBytes(ds, off, len);
                off += len;
                data.toStruct();
                ds.close();
                bs.close();
            }
            this.dCompletionLength = i - 24;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int putData(float data) {
        float[] d = new float[]{data};
        return this.putData(d);
    }

    public int putData() {
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(float[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(float[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((double[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((float[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((short[])this.hDataObject)[i] = (short)data[i + offset];
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((long[])this.hDataObject)[i] = (long)data[i + offset];
                }
                break;
            }
            case 3: 
            case 33: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((int[])this.hDataObject)[i] = (int)data[i + offset];
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(FLTINT data) {
        FLTINT[] d = new FLTINT[]{data};
        return this.putData(d);
    }

    public int putData(FLTINT[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(FLTINT[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 15: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((INTINT[])this.hDataObject)[i] != null) {
                        ((INTINT[])this.hDataObject)[i].setValues((int)data[i + offset].fval, data[i + offset].ival);
                        continue;
                    }
                    ((INTINT[])this.hDataObject)[i] = new INTINT((int)data[i + offset].fval, data[i + offset].ival);
                }
                break;
            }
            case 14: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((FLTINT[])this.hDataObject)[i] != null) {
                        ((FLTINT[])this.hDataObject)[i].setValues(data[i + offset].fval, data[i + offset].ival);
                        continue;
                    }
                    ((FLTINT[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 40: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((DBLDBL[])this.hDataObject)[i] != null) {
                        ((DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].fval, data[i + offset].ival);
                        continue;
                    }
                    ((DBLDBL[])this.hDataObject)[i] = new DBLDBL(data[i + offset].fval, data[i + offset].ival);
                }
                break;
            }
            case 48: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((DBLDBLDBL[])this.hDataObject)[i] != null) {
                        ((DBLDBLDBL[])this.hDataObject)[i].setValues(data[i + offset].fval, 0.0, data[i + offset].ival);
                        continue;
                    }
                    ((DBLDBLDBL[])this.hDataObject)[i] = new DBLDBLDBL(data[i + offset].fval, 0.0, data[i + offset].ival);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((float[])this.hDataObject)[i] = data[i + offset].fval;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((double[])this.hDataObject)[i] = data[i + offset].fval;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((long[])this.hDataObject)[i] = data[i + offset].ival;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((int[])this.hDataObject)[i] = data[i + offset].ival;
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(NAME16FI[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(NAME16FI[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 10: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME16FI[])this.hDataObject)[i] != null) {
                        ((NAME16FI[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].fval, data[i + offset].ival);
                        continue;
                    }
                    ((NAME16FI[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 42: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME16II[])this.hDataObject)[i] != null) {
                        ((NAME16II[])this.hDataObject)[i].setValues(data[i + offset].name, (int)data[i + offset].fval, data[i + offset].ival);
                        continue;
                    }
                    ((NAME16II[])this.hDataObject)[i] = new NAME16II(data[i + offset].name, (int)data[i + offset].fval, data[i + offset].ival);
                }
                break;
            }
            case 41: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME16DBLDBL[])this.hDataObject)[i] != null) {
                        ((NAME16DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].fval, data[i + offset].ival);
                        continue;
                    }
                    ((NAME16DBLDBL[])this.hDataObject)[i] = new NAME16DBLDBL(data[i + offset].name, data[i + offset].fval, data[i + offset].ival);
                }
                break;
            }
            case 44: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME32DBLDBL[])this.hDataObject)[i] != null) {
                        ((NAME32DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].fval, data[i + offset].ival);
                        continue;
                    }
                    ((NAME32DBLDBL[])this.hDataObject)[i] = new NAME32DBLDBL(data[i + offset].name, data[i + offset].fval, data[i + offset].ival);
                }
                break;
            }
            case 54: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME64DBL[])this.hDataObject)[i] != null) {
                        ((NAME64DBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].fval);
                        continue;
                    }
                    ((NAME64DBL[])this.hDataObject)[i] = new NAME64DBL(data[i + offset].name, data[i + offset].fval);
                }
                break;
            }
            case 45: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME64DBLDBL[])this.hDataObject)[i] != null) {
                        ((NAME64DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].fval, data[i + offset].ival);
                        continue;
                    }
                    ((NAME64DBLDBL[])this.hDataObject)[i] = new NAME64DBLDBL(data[i + offset].name, data[i + offset].fval, data[i + offset].ival);
                }
                break;
            }
            case 49: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME64DBLDBLDBL[])this.hDataObject)[i] != null) {
                        ((NAME64DBLDBLDBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].fval, data[i + offset].ival, 0.0);
                        continue;
                    }
                    ((NAME64DBLDBLDBL[])this.hDataObject)[i] = new NAME64DBLDBLDBL(data[i + offset].name, data[i + offset].fval, data[i + offset].ival);
                }
                break;
            }
            case 24: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i] == null) continue;
                    if (((USTRING[])this.hDataObject)[i] != null) {
                        ((USTRING[])this.hDataObject)[i].setValues(data[i + offset].ival, data[i + offset].fval, 0.0f, 0, data[i + offset].name);
                        continue;
                    }
                    ((USTRING[])this.hDataObject)[i] = new USTRING(data[i + offset].ival, data[i + offset].fval, 0.0f, 0, data[i + offset].name);
                }
                break;
            }
            case 46: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((UNAME[])this.hDataObject)[i] != null) {
                        ((UNAME[])this.hDataObject)[i].setValues(data[i + offset].ival, data[i + offset].fval, 0.0f, 0.0f, data[i + offset].name);
                        continue;
                    }
                    ((UNAME[])this.hDataObject)[i] = new UNAME(data[i + offset].ival, data[i + offset].fval, 0.0f, 0.0f, data[i + offset].name);
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(NAME32DBLDBL[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(NAME32DBLDBL[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 42: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME16II[])this.hDataObject)[i] != null) {
                        ((NAME16II[])this.hDataObject)[i].setValues(data[i + offset].name, (int)data[i + offset].d1val, (int)data[i + offset].d2val);
                        continue;
                    }
                    ((NAME16II[])this.hDataObject)[i] = new NAME16II(data[i + offset].name, (int)data[i + offset].d1val, (int)data[i + offset].d2val);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME16FI[])this.hDataObject)[i] != null) {
                        ((NAME16FI[])this.hDataObject)[i].setValues(data[i + offset].name, (float)data[i + offset].d1val, (int)data[i + offset].d2val);
                        continue;
                    }
                    ((NAME16FI[])this.hDataObject)[i] = new NAME16FI(data[i].name, (float)data[i + offset].d1val, (int)data[i + offset].d2val);
                }
                break;
            }
            case 41: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME16DBLDBL[])this.hDataObject)[i] != null) {
                        ((NAME16DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].d1val, data[i + offset].d2val);
                        continue;
                    }
                    ((NAME16DBLDBL[])this.hDataObject)[i] = new NAME16DBLDBL(data[i + offset].name, data[i + offset].d1val, data[i + offset].d2val);
                }
                break;
            }
            case 44: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME32DBLDBL[])this.hDataObject)[i] != null) {
                        ((NAME32DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].d1val, data[i + offset].d2val);
                        continue;
                    }
                    ((NAME32DBLDBL[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 54: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME64DBL[])this.hDataObject)[i] != null) {
                        ((NAME64DBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].d1val);
                        continue;
                    }
                    ((NAME64DBL[])this.hDataObject)[i] = new NAME64DBL(data[i + offset].name, data[i + offset].d1val);
                }
                break;
            }
            case 45: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME64DBLDBL[])this.hDataObject)[i] != null) {
                        ((NAME64DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].d1val, data[i + offset].d2val);
                        continue;
                    }
                    ((NAME64DBLDBL[])this.hDataObject)[i] = new NAME64DBLDBL(data[i + offset].name, data[i + offset].d1val, data[i + offset].d2val);
                }
                break;
            }
            case 49: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((NAME64DBLDBLDBL[])this.hDataObject)[i] != null) {
                        ((NAME64DBLDBLDBL[])this.hDataObject)[i].setValues(data[i + offset].name, data[i + offset].d1val, data[i + offset].d2val, 0.0);
                        continue;
                    }
                    ((NAME64DBLDBLDBL[])this.hDataObject)[i] = new NAME64DBLDBLDBL(data[i + offset].name, data[i + offset].d1val, data[i + offset].d2val);
                }
                break;
            }
            case 24: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((USTRING[])this.hDataObject)[i] != null) {
                        ((USTRING[])this.hDataObject)[i].setValues((int)data[i + offset].d2val, (float)data[i + offset].d1val, 0.0f, 0, data[i + offset].name);
                        continue;
                    }
                    ((USTRING[])this.hDataObject)[i] = new USTRING((int)data[i].d2val, (float)data[i + offset].d1val, 0.0f, 0, data[i + offset].name);
                }
                break;
            }
            case 46: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((UNAME[])this.hDataObject)[i] != null) {
                        ((UNAME[])this.hDataObject)[i].setValues((int)data[i + offset].d2val, (float)data[i + offset].d1val, 0.0f, 0.0f, data[i + offset].name);
                        continue;
                    }
                    ((UNAME[])this.hDataObject)[i] = new UNAME((int)data[i + offset].d2val, (float)data[i + offset].d1val, 0.0f, 0.0f, data[i + offset].name);
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(INTINT data) {
        INTINT[] d = new INTINT[]{data};
        return this.putData(d);
    }

    public int putData(INTINT[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(INTINT[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 15: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((INTINT[])this.hDataObject)[i] != null) {
                        ((INTINT[])this.hDataObject)[i].setValues(data[i + offset].i1val, data[i + offset].i2val);
                        continue;
                    }
                    ((INTINT[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 14: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((FLTINT[])this.hDataObject)[i] != null) {
                        ((FLTINT[])this.hDataObject)[i].setValues(data[i + offset].i1val, data[i + offset].i2val);
                        continue;
                    }
                    ((FLTINT[])this.hDataObject)[i] = new FLTINT(data[i + offset].i1val, data[i + offset].i2val);
                }
                break;
            }
            case 40: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((DBLDBL[])this.hDataObject)[i] != null) {
                        ((DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].i1val, data[i + offset].i2val);
                        continue;
                    }
                    ((DBLDBL[])this.hDataObject)[i] = new DBLDBL(data[i + offset].i1val, data[i + offset].i2val);
                }
                break;
            }
            case 48: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((DBLDBLDBL[])this.hDataObject)[i] != null) {
                        ((DBLDBLDBL[])this.hDataObject)[i].setValues(data[i + offset].i1val, 0.0, data[i + offset].i2val);
                        continue;
                    }
                    ((DBLDBLDBL[])this.hDataObject)[i] = new DBLDBLDBL(data[i + offset].i1val, 0.0, data[i + offset].i2val);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((float[])this.hDataObject)[i] = data[i + offset].i1val;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((double[])this.hDataObject)[i] = data[i + offset].i1val;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((long[])this.hDataObject)[i] = data[i + offset].i1val;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((int[])this.hDataObject)[i] = data[i + offset].i1val;
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(DBLDBL data) {
        DBLDBL[] d = new DBLDBL[]{data};
        return this.putData(d);
    }

    public int putData(DBLDBL[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(DBLDBL[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 15: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((INTINT[])this.hDataObject)[i] != null) {
                        ((INTINT[])this.hDataObject)[i].setValues((int)data[i + offset].d1val, (int)data[i + offset].d2val);
                        continue;
                    }
                    ((INTINT[])this.hDataObject)[i] = new INTINT((int)data[i + offset].d1val, (int)data[i + offset].d2val);
                }
                break;
            }
            case 14: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((FLTINT[])this.hDataObject)[i] != null) {
                        ((FLTINT[])this.hDataObject)[i].setValues((float)data[i + offset].d1val, (int)data[i + offset].d2val);
                        continue;
                    }
                    ((FLTINT[])this.hDataObject)[i] = new FLTINT((float)data[i + offset].d1val, (int)data[i + offset].d2val);
                }
                break;
            }
            case 40: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((DBLDBL[])this.hDataObject)[i] != null) {
                        ((DBLDBL[])this.hDataObject)[i].setValues(data[i + offset].d1val, data[i + offset].d2val);
                        continue;
                    }
                    ((DBLDBL[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((float[])this.hDataObject)[i] = (float)data[i + offset].d1val;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((double[])this.hDataObject)[i] = data[i + offset].d1val;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((long[])this.hDataObject)[i] = (long)data[i + offset].d2val;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((int[])this.hDataObject)[i] = (int)data[i + offset].d2val;
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(DBLDBLDBL data) {
        DBLDBLDBL[] d = new DBLDBLDBL[]{data};
        return this.putData(d);
    }

    public int putData(DBLDBLDBL[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(DBLDBLDBL[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 26: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((FLTINTINT[])this.hDataObject)[i] != null) {
                        ((FLTINTINT[])this.hDataObject)[i].setValues((float)data[i + offset].d1val, (int)data[i + offset].d2val, (int)data[i + offset].d3val);
                        continue;
                    }
                    ((FLTINTINT[])this.hDataObject)[i] = new FLTINTINT((float)data[i + offset].d1val, (int)data[i + offset].d2val, (int)data[i + offset].d2val);
                }
                break;
            }
            case 48: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    if (((DBLDBLDBL[])this.hDataObject)[i] != null) {
                        ((DBLDBLDBL[])this.hDataObject)[i].setValues(data[i + offset].d1val, data[i + offset].d2val, data[i + offset].d3val);
                        continue;
                    }
                    ((DBLDBLDBL[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((float[])this.hDataObject)[i] = (float)data[i + offset].d1val;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((double[])this.hDataObject)[i] = data[i + offset].d1val;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((long[])this.hDataObject)[i] = (long)data[i + offset].d3val;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    if (data[i + offset] == null) continue;
                    ((int[])this.hDataObject)[i] = (int)data[i + offset].d3val;
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(String[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(String[] data, int length, int offset) {
        int i;
        int maxlen;
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if ((maxlen = this.dArrayLength) > length) {
            maxlen = length;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dFormat != TDataType.getObjectFormat(data)) {
            return 2;
        }
        for (i = 0; i < maxlen; ++i) {
            ((String[])this.hDataObject)[i] = data[i + offset];
        }
        if (this.dArrayLength > maxlen) {
            this.dArrayLength = maxlen;
        }
        this.dSizeInBytes = 0;
        for (i = 0; i < length; ++i) {
            this.dSizeInBytes += data[i] != null ? data[i].length() : 0;
            ++this.dSizeInBytes;
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(String data) {
        int len;
        if (this.isLocked) {
            return 72;
        }
        if (data == null || (len = data.length()) < 1) {
            return 0;
        }
        switch (this.dFormat) {
            case 8: {
                ((NAME8[])this.hDataObject)[0] = new NAME8(data);
                break;
            }
            case 9: {
                ((NAME16[])this.hDataObject)[0] = new NAME16(data);
                break;
            }
            case 13: {
                ((NAME32[])this.hDataObject)[0] = new NAME32(data);
                break;
            }
            case 19: {
                ((NAME48[])this.hDataObject)[0] = new NAME48(data);
                break;
            }
            case 36: {
                ((NAME64[])this.hDataObject)[0] = new NAME64(data);
                break;
            }
            case 4: 
            case 47: {
                if (len < this.dArrayLength) {
                    this.dArrayLength = len;
                }
                this.hDataObject = data.toCharArray();
                break;
            }
            case 2: {
                if (len < this.dArrayLength) {
                    this.dArrayLength = len;
                }
                this.hDataObject = data.getBytes();
                break;
            }
            case 33: {
                if (len < this.dArrayLength) {
                    this.dArrayLength = len;
                }
                ((int[])this.hDataObject)[0] = data.compareToIgnoreCase("true") == 0 || data.compareToIgnoreCase("yes") == 0 ? 1 : 0;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(TTaggedStructure data) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null) {
            return 20;
        }
        if (this.dFormat != 7) {
            return 2;
        }
        if (this.dTag.compareTo(data.getName()) != 0) {
            return 62;
        }
        if (this.hDataObject == null) {
            return 103;
        }
        data.toByteArray();
        System.arraycopy(data.getByteArray(), 0, (byte[])this.hDataObject, 0, data.getSizeInBytes());
        if (this.hStructObject != null && this.hStructObject instanceof TTaggedStructure) {
            TTaggedStructure tts = (TTaggedStructure)this.hStructObject;
            tts.toStruct(data.getByteArray());
        } else if (this.hStructObject instanceof TTaggedStructure[]) {
            TTaggedStructure[] tts = (TTaggedStructure[])this.hStructObject;
            tts[0].toStruct(data.getByteArray());
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(TTaggedStructure[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(TTaggedStructure[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dFormat != 7) {
            return 2;
        }
        if (this.dTag.compareTo(data[0].getName()) != 0) {
            return 62;
        }
        if (this.hDataObject == null) {
            return 103;
        }
        int tsiz = data[0].getSizeInBytes();
        int dsiz = this.getArrayLength();
        if (dsiz > length) {
            dsiz = length;
        }
        for (int i = 0; i < dsiz; ++i) {
            data[i + offset].toByteArray();
            System.arraycopy(data[i + offset].getByteArray(), 0, (byte[])this.hDataObject, i * tsiz, tsiz);
        }
        if (this.hStructObject != null && this.hStructObject instanceof TTaggedStructure) {
            TTaggedStructure tts = (TTaggedStructure)this.hStructObject;
            tts.toStruct(data[offset].getByteArray());
        } else if (this.hStructObject instanceof TTaggedStructure[]) {
            TTaggedStructure[] tts = (TTaggedStructure[])this.hStructObject;
            for (int i = 0; i < dsiz; ++i) {
                tts[i].toStruct(data[i + offset].getByteArray());
            }
        }
        this.setArrayLength(dsiz);
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(byte[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(byte[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 4: {
                if (this.hDataObject instanceof char[]) {
                    for (int i = 0; i < this.dArrayLength; ++i) {
                        ((char[])this.hDataObject)[i] = (char)data[i + offset];
                    }
                    break;
                }
                if (this.hDataObject instanceof StringBuffer) {
                    String s = new String(data);
                    ((StringBuffer)this.hDataObject).append(s, offset, this.dArrayLength);
                    break;
                }
                return 2;
            }
            case 2: 
            case 50: {
                System.arraycopy(data, offset, (byte[])this.hDataObject, 0, this.dArrayLength);
                break;
            }
            case 1: 
            case 51: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((short[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 3: 
            case 33: 
            case 52: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((int[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(byte[] data, String tag) {
        if (this.isLocked) {
            return 72;
        }
        if (this.hDataObject != null) {
            if (tag != null && TStructRegistry.getSizeInBytes(tag) < 1) {
                return 62;
            }
            if (data.length < this.dArrayLength) {
                this.dArrayLength = data.length;
            }
            System.arraycopy(data, 0, (byte[])this.hDataObject, 0, this.dArrayLength);
        } else if (this.hStructObject != null && this.hStructObject instanceof TTaggedStructure) {
            TTaggedStructure tts = (TTaggedStructure)this.hStructObject;
            if (data.length != tts.getSizeInBytes()) {
                return 62;
            }
            System.arraycopy(data, 0, tts.getByteArray(), 0, data.length);
        } else if (this.hStructObject instanceof TTaggedStructure[]) {
            TTaggedStructure[] tts = (TTaggedStructure[])this.hStructObject;
            int dsiz = tts[0].getSizeInBytes();
            for (int i = 0; i < tts.length; ++i) {
                System.arraycopy(data, i * dsiz, tts[i].getByteArray(), 0, dsiz);
            }
        } else {
            return 2;
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(Object data) {
        if (this.isLocked) {
            return 72;
        }
        if (data instanceof byte[]) {
            return this.putData((byte[])data);
        }
        if (data instanceof short[]) {
            return this.putData((short[])data);
        }
        if (data instanceof int[]) {
            return this.putData((int[])data);
        }
        if (data instanceof float[]) {
            return this.putData((float[])data);
        }
        if (data instanceof double[]) {
            return this.putData((double[])data);
        }
        if (data instanceof long[]) {
            return this.putData((long[])data);
        }
        if (data instanceof String[]) {
            return this.putData((String[])data);
        }
        if (data instanceof TCompoundDataObject[]) {
            int cc = this.putData((TCompoundDataObject[])data);
            if (this.dFormat == 56) {
                this.dArrayLength *= TFormat.getHistoryHeaderSize() + TFormat.getCarriedFormatSize(this.dTag);
            }
            return cc;
        }
        if (this.dFormat != TDataType.getObjectFormat(data)) {
            return 2;
        }
        int len = TDataType.getObjectSize(data);
        if (this.dFormat != 4 && this.dFormat != 47 && len < this.dArrayLength) {
            this.dArrayLength = len;
        }
        this.setObjectHandle(data);
        this.repackageDataForOutput();
        return 0;
    }

    public int putData(TCompoundDataObject data) {
        TCompoundDataObject[] d = new TCompoundDataObject[]{data};
        return this.putData(d);
    }

    public int putData(TCompoundDataObject[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(TCompoundDataObject[] data, int length, int offset) {
        boolean formatsEqual;
        int maxlen;
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if ((maxlen = this.dArrayLength) > length) {
            maxlen = length;
        }
        if (length <= 0) {
            return 20;
        }
        boolean bl = formatsEqual = this.dFormat == TDataType.getObjectFormat(data);
        if (data instanceof NAME[] && this.hDataObject instanceof NAME[] || data instanceof NAMEINT[] && this.hDataObject instanceof NAMEINT[]) {
            if (formatsEqual) {
                for (int i = 0; i < maxlen; ++i) {
                    ((TCompoundDataObject[])this.hDataObject)[i] = data[i + offset];
                }
            } else {
                try {
                    Class[] params = new Class[]{String.class};
                    Object[] objs = new Object[1];
                    for (int i = 0; i < maxlen; ++i) {
                        objs[0] = data[i + offset].toString();
                        ((TCompoundDataObject[])this.hDataObject)[i] = (TCompoundDataObject)this.hDataObject.getClass().getComponentType().getConstructor(params).newInstance(objs);
                    }
                }
                catch (Exception e) {
                    MsgLog.log("TDataType", "cannot convert " + TFormat.toString(TDataType.getObjectFormat(data)) + " to " + TFormat.toString(this.dFormat), 2, e, 0);
                }
            }
        } else if (data instanceof NAME[] && this.hDataObject instanceof char[]) {
            this.hDataObject = data[offset].toString().toCharArray();
            maxlen *= data[offset].getSizeInBytes();
        } else if (data instanceof NAME[] && this.hDataObject instanceof USTRING[]) {
            for (int i = 0; i < this.dArrayLength; ++i) {
                ((USTRING[])this.hDataObject)[i].setString(data[i + offset].toString());
            }
        } else {
            if (!formatsEqual) {
                return 2;
            }
            this.setObjectHandle(data);
        }
        if (this.dArrayLength > maxlen) {
            this.dArrayLength = maxlen;
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int getData(double[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(double[] data, int length, int offset) {
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        int len = this.dArrayLength;
        if (len > length) {
            len = length;
        }
        try {
            int fmtsiz = TFormat.formatSizeOf(this.dFormat);
            int i = 0;
            int m = 0;
            for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
                byte[] b = this.dBuffers[n].toByteArray();
                Swap.Bytes(b, fmtsiz);
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                switch (this.dFormat) {
                    case 0: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readDouble();
                            ++i;
                        }
                        break;
                    }
                    case 5: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readFloat();
                            ++i;
                        }
                        break;
                    }
                    case 6: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readLong();
                            ++i;
                        }
                        break;
                    }
                    case 3: 
                    case 33: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readInt();
                            ++i;
                        }
                        break;
                    }
                    case 1: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readShort();
                            ++i;
                        }
                        break;
                    }
                    default: {
                        ds.close();
                        bs.close();
                        return 2;
                    }
                }
                ds.close();
                bs.close();
                m = i;
            }
            this.dCompletionLength = i;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int putData(double data) {
        double[] d = new double[]{data};
        return this.putData(d);
    }

    public int putData(double[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(double[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((double[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((float[])this.hDataObject)[i] = (float)data[i + offset];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((short[])this.hDataObject)[i] = (short)data[i + offset];
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((long[])this.hDataObject)[i] = (long)data[i + offset];
                }
                break;
            }
            case 3: 
            case 33: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((int[])this.hDataObject)[i] = (int)data[i + offset];
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public int getData(long[] data) {
        return this.getData(data, data != null ? data.length : 0, 0);
    }

    public int getData(long[] data, int length, int offset) {
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        int len = this.dArrayLength;
        if (len > length) {
            len = length;
        }
        try {
            int fmtsiz = TFormat.formatSizeOf(this.dFormat);
            int i = 0;
            int m = 0;
            for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
                byte[] b = this.dBuffers[n].toByteArray();
                Swap.Bytes(b, fmtsiz);
                ByteArrayInputStream bs = new ByteArrayInputStream(b);
                DataInputStream ds = new DataInputStream(bs);
                switch (this.dFormat) {
                    case 0: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (long)ds.readDouble();
                            ++i;
                        }
                        break;
                    }
                    case 5: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = (long)ds.readFloat();
                            ++i;
                        }
                        break;
                    }
                    case 6: 
                    case 53: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readLong();
                            ++i;
                        }
                        break;
                    }
                    case 3: 
                    case 33: 
                    case 52: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readInt();
                            ++i;
                        }
                        break;
                    }
                    case 1: 
                    case 51: {
                        while (i < len && i < m + b.length / fmtsiz) {
                            data[i + offset] = ds.readShort();
                            ++i;
                        }
                        break;
                    }
                    default: {
                        ds.close();
                        bs.close();
                        return 2;
                    }
                }
                ds.close();
                bs.close();
                m = i;
            }
            this.dCompletionLength = i;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int putData(long data) {
        long[] d = new long[]{data};
        return this.putData(d);
    }

    public int putData(long[] data) {
        return this.putData(data, data != null ? data.length : 0, 0);
    }

    public int putData(long[] data, int length, int offset) {
        if (this.isLocked) {
            return 72;
        }
        if (data == null || length <= 0 || offset < 0) {
            return 20;
        }
        if (length > data.length - offset) {
            length = data.length - offset;
        }
        if (length <= 0) {
            return 20;
        }
        if (this.dArrayLength > length) {
            this.dArrayLength = length;
        }
        switch (this.dFormat) {
            case 0: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((double[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((float[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((short[])this.hDataObject)[i] = (short)data[i + offset];
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((long[])this.hDataObject)[i] = data[i + offset];
                }
                break;
            }
            case 3: 
            case 33: {
                for (int i = 0; i < this.dArrayLength; ++i) {
                    ((int[])this.hDataObject)[i] = (int)data[i + offset];
                }
                break;
            }
            default: {
                return 2;
            }
        }
        this.repackageDataForOutput();
        return 0;
    }

    public byte[] getDataBuffer() {
        try {
            if (this.dBuffers == null) {
                return null;
            }
            if (this.dBuffer == null) {
                this.dBuffer = new ByteArrayOutputStream(this.dSizeInBytes);
            } else {
                this.dBuffer.reset();
            }
            DataOutputStream dos = new DataOutputStream(this.dBuffer);
            for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
                dos.write(this.dBuffers[n].toByteArray());
            }
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.dBuffer.toByteArray();
    }

    public byte[] getDataBuffer(int n) {
        try {
            if (this.dBuffer == null) {
                this.dBuffer = new ByteArrayOutputStream();
            } else {
                this.dBuffer.reset();
            }
            DataOutputStream dos = new DataOutputStream(this.dBuffer);
            if (n < this.numblks && this.dBuffers[n] != null) {
                dos.write(this.dBuffers[n].toByteArray());
            }
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.dBuffer.toByteArray();
    }

    public int getArrayLength() {
        int dlen = this.dArrayLength;
        if (this.dFormat == 7) {
            int ssiz = TStructRegistry.getSizeInBytes(this.dTag);
            if (ssiz < 1) {
                ssiz = 1;
            }
            dlen /= ssiz;
        }
        return dlen;
    }

    public short getFormat() {
        return this.dFormat >= 0 ? this.dFormat : (short)(256 + this.dFormat);
    }

    public void removeTagFromLink() {
        this.removeTagAtLinkTime = true;
    }

    public String getTag() {
        return this.removeTagAtLinkTime ? "" : this.dTag;
    }

    public int getSizeInBytes() {
        return this.dSizeInBytes;
    }

    public int getDataSize() {
        int fmtsiz = 0;
        fmtsiz = TFormat.formatSizeOf(this.dFormat);
        if (fmtsiz > 0) {
            int datasize = fmtsiz * this.dArrayLength;
            if (this.dFormat == 28) {
                datasize += SPECTRUM.hdrSizeInBytes;
            }
            return datasize;
        }
        return 0;
    }

    private void makeNewCompoundDataObject(TCompoundDataObject[] Data, int index) {
        try {
            Data[index] = (TCompoundDataObject)Data.getClass().getComponentType().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] getStringArrayBytes(String[] data) {
        int sptr = 0;
        int slen = 0;
        byte[] bdata = new byte[this.dSizeInBytes];
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != null) {
                slen = data[i].length();
                if (slen + sptr >= this.dSizeInBytes) break;
                System.arraycopy(data[i].getBytes(), 0, bdata, sptr, slen);
                sptr += slen;
            }
            if (sptr >= this.dSizeInBytes) continue;
            bdata[sptr++] = 0;
        }
        return bdata;
    }

    private void setObjectContents(DataOutputStream ds, Object Data, int index) {
        try {
            if (Data instanceof byte[]) {
                ds.writeByte(((byte[])Data)[index]);
            } else if (Data instanceof short[]) {
                ds.writeShort(Swap.Short(((short[])Data)[index]));
            } else if (Data instanceof int[]) {
                ds.writeInt(Swap.Long(((int[])Data)[index]));
            } else if (Data instanceof long[]) {
                ds.writeLong(Swap.DLong(((long[])Data)[index]));
            } else if (Data instanceof float[]) {
                ds.write(Swap.Float(((float[])Data)[index]));
            } else if (Data instanceof double[]) {
                ds.write(Swap.Double(((double[])Data)[index]));
            } else if (Data instanceof char[]) {
                ds.writeBytes(new String((char[])Data));
            } else if (Data instanceof StringBuffer) {
                ds.writeBytes(((StringBuffer)Data).toString());
            } else if (Data instanceof String) {
                ds.write(((String)Data).getBytes());
            } else if (Data instanceof TCompoundDataObject[]) {
                if (((TCompoundDataObject[])Data)[index] == null) {
                    this.makeNewCompoundDataObject((TCompoundDataObject[])Data, index);
                }
                ds.write(((TCompoundDataObject[])Data)[index].toByteArray());
            } else if (Data instanceof String[]) {
                ds.write(this.getStringArrayBytes((String[])Data));
            } else if (Data instanceof SPECTRUM) {
                ds.write(((SPECTRUM)Data).toByteArray());
            } else if (Data instanceof IMAGE) {
                ds.write(((IMAGE)Data).toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDataObject(int dataSize, short dataFormat) {
        if (this.hDataObject == null) {
            this.makeDataObject(dataSize, dataFormat);
        }
    }

    private void setObjectHandle(TCompoundDataObject[] Data) {
        this.hDataObject = Data;
    }

    private void setObjectHandle(Object Data) {
        this.hDataObject = Data;
    }

    public static int getObjectSize(Object Data) {
        if (Data instanceof TCompoundDataObject[]) {
            return ((TCompoundDataObject[])Data).length;
        }
        if (Data instanceof byte[]) {
            return ((byte[])Data).length;
        }
        if (Data instanceof short[]) {
            return ((short[])Data).length;
        }
        if (Data instanceof int[]) {
            return ((int[])Data).length;
        }
        if (Data instanceof float[]) {
            return ((float[])Data).length;
        }
        if (Data instanceof double[]) {
            return ((double[])Data).length;
        }
        if (Data instanceof SPECTRUM) {
            return ((SPECTRUM)Data).hByteArray.length;
        }
        if (Data instanceof IMAGE) {
            return ((IMAGE)Data).getImageFrameSize();
        }
        if (Data instanceof char[]) {
            return ((char[])Data).length;
        }
        if (Data instanceof String) {
            return ((String)Data).length();
        }
        if (Data instanceof StringBuffer) {
            return ((StringBuffer)Data).toString().length();
        }
        return 0;
    }

    public static short getObjectFormat(Object Data) {
        if (Data instanceof TCompoundDataObject[]) {
            try {
                Object tdo = ((TCompoundDataObject[])Data)[0] != null ? ((TCompoundDataObject[])Data)[0] : Data.getClass().getComponentType().newInstance();
                return ((TCompoundDataObject)tdo).getFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Data instanceof byte[]) {
            return 2;
        }
        if (Data instanceof short[]) {
            return 1;
        }
        if (Data instanceof int[]) {
            return 3;
        }
        if (Data instanceof float[]) {
            return 5;
        }
        if (Data instanceof long[]) {
            return 6;
        }
        if (Data instanceof double[]) {
            return 0;
        }
        if (Data instanceof String) {
            return 4;
        }
        if (Data instanceof StringBuffer) {
            return 4;
        }
        if (Data instanceof char[]) {
            return 4;
        }
        if (Data instanceof String[]) {
            return 57;
        }
        return 255;
    }

    public int getData(Object Data) {
        if (Data instanceof byte[]) {
            this.getData((byte[])Data);
        } else if (Data instanceof short[]) {
            this.getData((short[])Data);
        } else if (Data instanceof int[]) {
            this.getData((int[])Data);
        } else if (Data instanceof float[]) {
            this.getData((float[])Data);
        } else if (Data instanceof double[]) {
            this.getData((double[])Data);
        } else if (Data instanceof long[]) {
            this.getData((long[])Data);
        } else if (Data instanceof char[]) {
            this.getData((char[])Data);
        } else if (Data instanceof StringBuffer) {
            this.getData((StringBuffer)Data);
        } else if (Data instanceof TCompoundDataObject[]) {
            this.getData((TCompoundDataObject[])Data);
        } else if (Data instanceof SPECTRUM) {
            this.getData((SPECTRUM)Data);
        } else if (Data instanceof IMAGE) {
            this.getData((IMAGE)Data);
        } else if (Data instanceof String[]) {
            this.getData((String[])Data);
        }
        return 0;
    }

    public int dataFill(String fromStr) {
        int n = 0;
        switch (this.dFormat) {
            case 255: {
                break;
            }
            case 10: {
                for (n = 0; n < this.dArrayLength && ((NAME16FI[])this.hDataObject)[n] != null; ++n) {
                    ((NAME16FI[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 42: {
                for (n = 0; n < this.dArrayLength && ((NAME16II[])this.hDataObject)[n] != null; ++n) {
                    ((NAME16II[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 41: {
                for (n = 0; n < this.dArrayLength && ((NAME16DBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME16DBLDBL[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 44: {
                for (n = 0; n < this.dArrayLength && ((NAME32DBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME32DBLDBL[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 54: {
                for (n = 0; n < this.dArrayLength && ((NAME64DBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME64DBL[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 45: {
                for (n = 0; n < this.dArrayLength && ((NAME64DBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME64DBLDBL[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 49: {
                for (n = 0; n < this.dArrayLength && ((NAME64DBLDBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME64DBLDBLDBL[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 36: {
                for (n = 0; n < this.dArrayLength && ((TCompoundDataObject[])this.hDataObject)[n] != null; ++n) {
                    ((NAME[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 37: {
                for (n = 0; n < this.dArrayLength && ((TCompoundDataObject[])this.hDataObject)[n] != null; ++n) {
                    ((NAMEINT[])this.hDataObject)[n].setName(fromStr);
                }
                break;
            }
            case 24: {
                for (n = 0; n < this.dArrayLength && ((USTRING[])this.hDataObject)[n] != null; ++n) {
                    ((USTRING[])this.hDataObject)[n].setString(fromStr);
                }
                break;
            }
            case 46: {
                for (n = 0; n < this.dArrayLength && ((UNAME[])this.hDataObject)[n] != null; ++n) {
                    ((UNAME[])this.hDataObject)[n].setString(fromStr);
                }
                break;
            }
            case 4: 
            case 47: {
                int size = this.dArrayLength < fromStr.length() ? this.dArrayLength : fromStr.length();
                char[] s = fromStr.toCharArray();
                for (n = 0; n < size && this.hDataObject != null; ++n) {
                    ((char[])this.hDataObject)[n] = s[n];
                }
                break;
            }
        }
        return n;
    }

    public int dataFill(double fromVal) {
        return this.dataFill(fromVal, 0);
    }

    public int dataFill(double fromVal, int offset) {
        int n = 0;
        if (offset >= this.dArrayLength) {
            return 0;
        }
        switch (this.dFormat) {
            case 255: {
                break;
            }
            case 10: {
                int len = ((NAME16FI[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((NAME16FI[])this.hDataObject)[n] != null; ++n) {
                    ((NAME16FI[])this.hDataObject)[n].fval = (float)fromVal;
                }
                break;
            }
            case 42: {
                int len = ((NAME16II[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((NAME16II[])this.hDataObject)[n] != null; ++n) {
                    ((NAME16II[])this.hDataObject)[n].i1val = (int)fromVal;
                }
                break;
            }
            case 41: {
                int len = ((NAME16DBLDBL[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((NAME16DBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME16DBLDBL[])this.hDataObject)[n].d1val = fromVal;
                }
                break;
            }
            case 44: {
                int len = ((NAME32DBLDBL[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((NAME32DBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME32DBLDBL[])this.hDataObject)[n].d1val = fromVal;
                }
                break;
            }
            case 54: {
                int len = ((NAME64DBL[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((NAME64DBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME64DBL[])this.hDataObject)[n].dval = fromVal;
                }
                break;
            }
            case 45: {
                int len = ((NAME64DBLDBL[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((NAME64DBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME64DBLDBL[])this.hDataObject)[n].d1val = fromVal;
                }
                break;
            }
            case 49: {
                int len = ((NAME64DBLDBLDBL[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((NAME64DBLDBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((NAME64DBLDBLDBL[])this.hDataObject)[n].d1val = fromVal;
                }
                break;
            }
            case 2: 
            case 7: {
                int len = ((byte[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && (byte[])this.hDataObject != null; ++n) {
                    ((byte[])this.hDataObject)[n] = (byte)fromVal;
                }
                break;
            }
            case 1: {
                int len = ((short[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && (short[])this.hDataObject != null; ++n) {
                    ((short[])this.hDataObject)[n] = (short)fromVal;
                }
                break;
            }
            case 3: {
                int len = ((int[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && (int[])this.hDataObject != null; ++n) {
                    ((int[])this.hDataObject)[n] = (int)fromVal;
                }
                break;
            }
            case 6: {
                int len = ((long[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && (long[])this.hDataObject != null; ++n) {
                    ((long[])this.hDataObject)[n] = (long)fromVal;
                }
                break;
            }
            case 5: {
                int len = ((float[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && (float[])this.hDataObject != null; ++n) {
                    ((float[])this.hDataObject)[n] = (float)fromVal;
                }
                break;
            }
            case 0: {
                int len = ((double[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && (double[])this.hDataObject != null; ++n) {
                    ((double[])this.hDataObject)[n] = fromVal;
                }
                break;
            }
            case 15: {
                int len = ((INTINT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((INTINT[])this.hDataObject)[n] != null; ++n) {
                    ((INTINT[])this.hDataObject)[n].i1val = (int)fromVal;
                }
                break;
            }
            case 14: {
                int len = ((FLTINT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((FLTINT[])this.hDataObject)[n] != null; ++n) {
                    ((FLTINT[])this.hDataObject)[n].fval = (float)fromVal;
                }
                break;
            }
            case 31: {
                int len = ((FLTFLT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((FLTFLT[])this.hDataObject)[n] != null; ++n) {
                    ((FLTFLT[])this.hDataObject)[n].f1val = (float)fromVal;
                }
                break;
            }
            case 40: {
                int len = ((DBLDBL[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((DBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((DBLDBL[])this.hDataObject)[n].d1val = fromVal;
                }
                break;
            }
            case 48: {
                int len = ((DBLDBLDBL[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((DBLDBLDBL[])this.hDataObject)[n] != null; ++n) {
                    ((DBLDBLDBL[])this.hDataObject)[n].d1val = fromVal;
                }
                break;
            }
            case 18: {
                int len = ((INTFLTINT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((INTFLTINT[])this.hDataObject)[n] != null; ++n) {
                    ((INTFLTINT[])this.hDataObject)[n].fval = (float)fromVal;
                }
                break;
            }
            case 25: {
                int len = ((FLTFLTINT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((FLTFLTINT[])this.hDataObject)[n] != null; ++n) {
                    ((FLTFLTINT[])this.hDataObject)[n].f1val = (float)fromVal;
                }
                break;
            }
            case 26: {
                int len = ((FLTINTINT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((FLTINTINT[])this.hDataObject)[n] != null; ++n) {
                    ((FLTINTINT[])this.hDataObject)[n].f1val = (float)fromVal;
                }
                break;
            }
            case 43: {
                int len = ((INTINTINT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((INTINTINT[])this.hDataObject)[n] != null; ++n) {
                    ((INTINTINT[])this.hDataObject)[n].i1val = (int)fromVal;
                }
                break;
            }
            case 29: {
                int len = ((INTINTINTINT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((INTINTINTINT[])this.hDataObject)[n] != null; ++n) {
                    ((INTINTINTINT[])this.hDataObject)[n].i1val = (int)fromVal;
                }
                break;
            }
            case 27: {
                int len = ((INTFLTFLTFLT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((INTFLTFLTFLT[])this.hDataObject)[n] != null; ++n) {
                    ((INTFLTFLTFLT[])this.hDataObject)[n].f1val = (float)fromVal;
                }
                break;
            }
            case 34: {
                int len = ((INTINTFLTFLT[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((INTINTFLTFLT[])this.hDataObject)[n] != null; ++n) {
                    ((INTINTFLTFLT[])this.hDataObject)[n].f1val = (float)fromVal;
                }
                break;
            }
            case 24: {
                int len = ((USTRING[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((USTRING[])this.hDataObject)[n] != null; ++n) {
                    ((USTRING[])this.hDataObject)[n].f1val = (float)fromVal;
                }
                break;
            }
            case 46: {
                int len = ((UNAME[])this.hDataObject).length;
                if (len > this.dArrayLength) {
                    len = this.dArrayLength;
                }
                for (n = offset; n < len && ((UNAME[])this.hDataObject)[n] != null; ++n) {
                    ((UNAME[])this.hDataObject)[n].f1val = (float)fromVal;
                }
                break;
            }
            case 28: {
                for (n = offset; n < this.dArrayLength && (SPECTRUM)this.hDataObject != null; ++n) {
                    ((SPECTRUM)this.hDataObject).d_spect_array[n] = (float)fromVal;
                }
                break;
            }
        }
        return n - offset;
    }

    public int dataCopy(TDataType fromData) {
        if (fromData == null) {
            return 0;
        }
        return this.dataCopy(fromData, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dataCopy(TDataType fromData, int offset) {
        int n = 0;
        TDataType tDataType = fromData;
        synchronized (tDataType) {
            block31: {
                if (this.dFormat != fromData.dFormat) {
                    if (this.dFormat == 254) {
                        TDataType tDataType2 = fromData;
                        synchronized (tDataType2) {
                            this.dFormat = fromData.dFormat;
                            this.dArrayLength = fromData.dArrayLength;
                            this.dCompletionLength = fromData.dCompletionLength;
                            if (this.hDataObject == null && this.hStructObject == null) {
                                this.setDataObject(this.dArrayLength, this.dFormat);
                            }
                            this.dBuffers = fromData.dBuffers;
                            this.numblks = fromData.numblks;
                        }
                    } else {
                        return 0;
                    }
                }
                int size = this.dArrayLength < fromData.dArrayLength ? this.dArrayLength : fromData.dArrayLength;
                this.copy(fromData);
                if (fromData.hDataObject == null || this.hDataObject == null) {
                    return 0;
                }
                if (this.hDataObject instanceof TCompoundDataObject[]) {
                    System.arraycopy((TCompoundDataObject[])fromData.hDataObject, offset, (TCompoundDataObject[])this.hDataObject, 0, size);
                    n = size;
                }
                try {
                    switch (this.dFormat) {
                        case 254: 
                        case 255: {
                            break;
                        }
                        case 4: {
                            if (this.hDataObject instanceof char[]) {
                                System.arraycopy((char[])fromData.hDataObject, offset, (char[])this.hDataObject, 0, size);
                                n = size;
                                break;
                            }
                            if (this.hDataObject instanceof StringBuffer) {
                                String s = ((StringBuffer)fromData.hDataObject).substring(0);
                                n = s.length();
                                ((StringBuffer)this.hDataObject).ensureCapacity(n);
                                ((StringBuffer)this.hDataObject).insert(0, s);
                                break;
                            }
                        }
                        case 2: 
                        case 7: {
                            System.arraycopy((byte[])fromData.hDataObject, offset, (byte[])this.hDataObject, 0, size);
                            n = size;
                            break;
                        }
                        case 1: {
                            System.arraycopy((short[])fromData.hDataObject, offset, (short[])this.hDataObject, 0, size);
                            n = size;
                            break;
                        }
                        case 3: {
                            System.arraycopy((int[])fromData.hDataObject, offset, (int[])this.hDataObject, 0, size);
                            n = size;
                            break;
                        }
                        case 6: {
                            System.arraycopy((long[])fromData.hDataObject, offset, (long[])this.hDataObject, 0, size);
                            n = size;
                            break;
                        }
                        case 5: {
                            System.arraycopy((float[])fromData.hDataObject, offset, (float[])this.hDataObject, 0, size);
                            n = size;
                            break;
                        }
                        case 0: {
                            System.arraycopy((double[])fromData.hDataObject, offset, (double[])this.hDataObject, 0, size);
                            n = size;
                            break;
                        }
                        case 28: {
                            System.arraycopy(((SPECTRUM)fromData.hDataObject).d_spect_array, offset, ((SPECTRUM)this.hDataObject).d_spect_array, 0, size);
                            n = size;
                        }
                    }
                }
                catch (NullPointerException e) {
                    if (fromData == null) {
                        System.out.println("TINE dataCopy Exception FROM: fromData==null");
                    } else if (fromData.hDataObject == null) {
                        System.out.println("TINE dataCopy Exception FROM: fromData.hDataObject==null " + fromData.dSizeInBytes);
                    } else {
                        System.out.println("TINE dataCopy Exception: fromData=" + fromData.hDataObject.toString().substring(0, 20));
                    }
                    if (this.hDataObject != null) break block31;
                    System.out.println("TINE dataCopy Exception: to==null");
                }
            }
        }
        return n;
    }

    public Object getStructObject() {
        return this.hStructObject;
    }

    public Object getDataObject() {
        return this.hDataObject;
    }

    public Vector<Object> getVector() {
        int i = 0;
        if (this.dVector == null) {
            this.dVector = new Vector();
        }
        Vector<Object> v = this.dVector;
        v.clear();
        switch (this.dFormat) {
            case 255: {
                break;
            }
            case 8: {
                TCompoundDataObject[] d = (NAME8[])this.hDataObject;
                if (d == null) {
                    d = new NAME8[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 9: {
                TCompoundDataObject[] d = (NAME16[])this.hDataObject;
                if (d == null) {
                    d = new NAME16[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 13: {
                TCompoundDataObject[] d = (NAME32[])this.hDataObject;
                if (d == null) {
                    d = new NAME32[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 19: {
                TCompoundDataObject[] d = (NAME48[])this.hDataObject;
                if (d == null) {
                    d = new NAME48[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 36: {
                TCompoundDataObject[] d = (NAME64[])this.hDataObject;
                if (d == null) {
                    d = new NAME64[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 21: {
                TCompoundDataObject[] d = (NAME16I[])this.hDataObject;
                if (d == null) {
                    d = new NAME16I[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 10: {
                TCompoundDataObject[] d = (NAME16FI[])this.hDataObject;
                if (d == null) {
                    d = new NAME16FI[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 42: {
                TCompoundDataObject[] d = (NAME16II[])this.hDataObject;
                if (d == null) {
                    d = new NAME16II[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 41: {
                TCompoundDataObject[] d = (NAME16DBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME16DBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 44: {
                TCompoundDataObject[] d = (NAME32DBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME32DBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 54: {
                TCompoundDataObject[] d = (NAME64DBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME64DBL[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 45: {
                TCompoundDataObject[] d = (NAME64DBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME64DBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 49: {
                TCompoundDataObject[] d = (NAME64DBLDBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME64DBLDBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 22: {
                TCompoundDataObject[] d = (NAME32I[])this.hDataObject;
                if (d == null) {
                    d = new NAME32I[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 23: {
                TCompoundDataObject[] d = (NAME48I[])this.hDataObject;
                if (d == null) {
                    d = new NAME48I[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 37: {
                TCompoundDataObject[] d = (NAME64I[])this.hDataObject;
                if (d == null) {
                    d = new NAME64I[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 2: {
                byte[] d = (byte[])this.hDataObject;
                if (d == null) {
                    d = new byte[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(new Byte(d[i]));
                }
                break;
            }
            case 7: 
            case 56: {
                break;
            }
            case 1: {
                short[] d = (short[])this.hDataObject;
                if (d == null) {
                    d = new short[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(new Short(d[i]));
                }
                break;
            }
            case 3: {
                int[] d = (int[])this.hDataObject;
                if (d == null) {
                    d = new int[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(new Integer(d[i]));
                }
                break;
            }
            case 6: {
                long[] d = (long[])this.hDataObject;
                if (d == null) {
                    d = new long[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(new Long(d[i]));
                }
                break;
            }
            case 5: {
                float[] d = (float[])this.hDataObject;
                if (d == null) {
                    d = new float[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(new Float(d[i]));
                }
                break;
            }
            case 0: {
                double[] d = (double[])this.hDataObject;
                if (d == null) {
                    d = new double[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(new Double(d[i]));
                }
                break;
            }
            case 15: {
                TCompoundDataObject[] d = (INTINT[])this.hDataObject;
                if (d == null) {
                    d = new INTINT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 14: {
                TCompoundDataObject[] d = (FLTINT[])this.hDataObject;
                if (d == null) {
                    d = new FLTINT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 31: {
                TCompoundDataObject[] d = (FLTFLT[])this.hDataObject;
                if (d == null) {
                    d = new FLTFLT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 16: {
                TCompoundDataObject[] d = (DBLINT[])this.hDataObject;
                if (d == null) {
                    d = new DBLINT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 40: {
                TCompoundDataObject[] d = (DBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new DBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 48: {
                TCompoundDataObject[] d = (DBLDBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new DBLDBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 18: {
                TCompoundDataObject[] d = (INTFLTINT[])this.hDataObject;
                if (d == null) {
                    d = new INTFLTINT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 25: {
                TCompoundDataObject[] d = (FLTFLTINT[])this.hDataObject;
                if (d == null) {
                    d = new FLTFLTINT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 26: {
                TCompoundDataObject[] d = (FLTINTINT[])this.hDataObject;
                if (d == null) {
                    d = new FLTINTINT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 43: {
                TCompoundDataObject[] d = (INTINTINT[])this.hDataObject;
                if (d == null) {
                    d = new INTINTINT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 29: {
                TCompoundDataObject[] d = (INTINTINTINT[])this.hDataObject;
                if (d == null) {
                    d = new INTINTINTINT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 27: {
                TCompoundDataObject[] d = (INTFLTFLTFLT[])this.hDataObject;
                if (d == null) {
                    d = new INTFLTFLTFLT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 34: {
                TCompoundDataObject[] d = (INTINTFLTFLT[])this.hDataObject;
                if (d == null) {
                    d = new INTINTFLTFLT[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 24: {
                TCompoundDataObject[] d = (USTRING[])this.hDataObject;
                if (d == null) {
                    d = new USTRING[this.dArrayLength];
                    this.getData(d);
                }
                for (i = 0; i < d.length; ++i) {
                    v.addElement(d[i]);
                }
                break;
            }
            case 46: {
                TCompoundDataObject[] undata = (UNAME[])this.hDataObject;
                if (undata == null) {
                    undata = new UNAME[this.dArrayLength];
                    this.getData(undata);
                }
                for (i = 0; i < undata.length; ++i) {
                    v.addElement(undata[i]);
                }
                break;
            }
        }
        this.dCompletionLength = i;
        return v;
    }

    private String pushToString(TCompoundDataObject[] cdo) {
        if (this.dCompletionLength == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(cdo[0].getSizeInBytes() * this.dCompletionLength);
        for (int i = 0; i < this.dCompletionLength && i < cdo.length && cdo[i] != null; ++i) {
            sb.append(cdo[i].toString());
            sb.append(this.arrayDelimiter);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.dFormat) {
            case 255: {
                return new String("");
            }
            case 4: 
            case 47: {
                if (this.hDataObject instanceof char[]) {
                    return new String((char[])this.hDataObject).trim();
                }
                if (this.hDataObject instanceof StringBuffer) {
                    return ((StringBuffer)this.hDataObject).toString().trim();
                }
                char[] t = new char[this.dArrayLength];
                this.getData(t);
                return new String(t).trim();
            }
            case 57: {
                String[] d = (String[])this.hDataObject;
                if (d == null) {
                    d = new String[this.dArrayLength];
                    this.getData(d);
                }
                String ds = new String();
                for (int i = 0; i < d.length; ++i) {
                    ds = ds + d[i] + "\n";
                }
                return ds;
            }
            case 24: {
                TCompoundDataObject[] d = (USTRING[])this.hDataObject;
                if (d == null) {
                    d = new USTRING[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 46: {
                TCompoundDataObject[] d = (UNAME[])this.hDataObject;
                if (d == null) {
                    d = new UNAME[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 43: {
                TCompoundDataObject[] d = (INTINTINT[])this.hDataObject;
                if (d == null) {
                    d = new INTINTINT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 29: {
                TCompoundDataObject[] d = (INTINTINTINT[])this.hDataObject;
                if (d == null) {
                    d = new INTINTINTINT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 27: {
                TCompoundDataObject[] d = (INTFLTFLTFLT[])this.hDataObject;
                if (d == null) {
                    d = new INTFLTFLTFLT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 34: {
                TCompoundDataObject[] d = (INTINTFLTFLT[])this.hDataObject;
                if (d == null) {
                    d = new INTINTFLTFLT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 18: {
                TCompoundDataObject[] d = (INTFLTINT[])this.hDataObject;
                if (d == null) {
                    d = new INTFLTINT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 25: {
                TCompoundDataObject[] d = (FLTFLTINT[])this.hDataObject;
                if (d == null) {
                    d = new FLTFLTINT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 26: {
                TCompoundDataObject[] d = (FLTINTINT[])this.hDataObject;
                if (d == null) {
                    d = new FLTINTINT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 8: {
                TCompoundDataObject[] d = (NAME8[])this.hDataObject;
                if (d == null) {
                    d = new NAME8[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 9: {
                TCompoundDataObject[] d = (NAME16[])this.hDataObject;
                if (d == null) {
                    d = new NAME16[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 13: {
                TCompoundDataObject[] d = (NAME32[])this.hDataObject;
                if (d == null) {
                    d = new NAME32[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 19: {
                TCompoundDataObject[] d = (NAME48[])this.hDataObject;
                if (d == null) {
                    d = new NAME48[this.dArrayLength];
                    this.getData(d);
                }
                this.getData(d);
                return this.pushToString(d);
            }
            case 36: {
                TCompoundDataObject[] d = (NAME64[])this.hDataObject;
                if (d == null) {
                    d = new NAME64[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 21: {
                TCompoundDataObject[] d = (NAME16I[])this.hDataObject;
                if (d == null) {
                    d = new NAME16I[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 10: {
                TCompoundDataObject[] d = (NAME16FI[])this.hDataObject;
                if (d == null) {
                    d = new NAME16FI[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 42: {
                TCompoundDataObject[] d = (NAME16II[])this.hDataObject;
                if (d == null) {
                    d = new NAME16II[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 41: {
                TCompoundDataObject[] d = (NAME16DBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME16DBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 44: {
                TCompoundDataObject[] d = (NAME32DBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME32DBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 54: {
                TCompoundDataObject[] d = (NAME64DBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME64DBL[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 45: {
                TCompoundDataObject[] d = (NAME64DBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME64DBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 49: {
                TCompoundDataObject[] d = (NAME64DBLDBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new NAME64DBLDBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 22: {
                TCompoundDataObject[] d = (NAME32I[])this.hDataObject;
                if (d == null) {
                    d = new NAME32I[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 23: {
                TCompoundDataObject[] d = (NAME48I[])this.hDataObject;
                if (d == null) {
                    d = new NAME48I[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 37: {
                TCompoundDataObject[] d = (NAME64I[])this.hDataObject;
                if (d == null) {
                    d = new NAME64I[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 2: 
            case 50: {
                byte[] d = (byte[])this.hDataObject;
                if (d == null) {
                    d = new byte[this.dArrayLength];
                    this.getData(d);
                }
                for (int i = 0; i < this.dCompletionLength && i < d.length; ++i) {
                    String ds = this.dFormat == 50 && this.dBitField == null ? TBitfieldRegistry.getBitfield(this.dTag).toString() : new String("" + d[i]);
                    sb.append(ds);
                    sb.append(this.arrayDelimiter);
                }
                return sb.toString();
            }
            case 56: {
                TCompoundDataObject[] d = (HISTORY[])this.hDataObject;
                if (d == null) {
                    d = new HISTORY[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 7: {
                if (this.hStructObject != null && this.hStructObject instanceof TTaggedStructure) {
                    return ((TTaggedStructure)this.hStructObject).toString();
                }
                if (this.hStructObject instanceof TTaggedStructure[]) {
                    for (int i = 0; i < ((TTaggedStructure[])this.hStructObject).length; ++i) {
                        sb.append(((TTaggedStructure[])this.hStructObject)[i].toString());
                        sb.append(this.arrayDelimiter);
                    }
                    return sb.toString();
                }
                if (this.hDataObject != null) {
                    int len = TStructRegistry.getSizeInBytes(this.dTag) * this.dCompletionLength;
                    return TStructRegistry.toString(this.dTag, (byte[])this.hDataObject, len);
                }
                return new String("user defined structure");
            }
            case 1: 
            case 51: {
                short[] d = (short[])this.hDataObject;
                if (d == null) {
                    d = new short[this.dArrayLength];
                    this.getData(d);
                }
                for (int i = 0; i < this.dCompletionLength && i < d.length; ++i) {
                    String ds = this.dFormat == 51 && this.dBitField == null ? TBitfieldRegistry.getBitfield(this.dTag).toString(d[i]) : new String("" + d[i]);
                    sb.append(ds);
                    sb.append(this.arrayDelimiter);
                }
                return sb.toString();
            }
            case 3: 
            case 52: {
                int[] d = (int[])this.hDataObject;
                if (d == null) {
                    d = new int[this.dArrayLength];
                    this.getData(d);
                }
                for (int i = 0; i < this.dCompletionLength && i < d.length; ++i) {
                    String ds = this.dFormat == 52 && this.dBitField == null ? TBitfieldRegistry.getBitfield(this.dTag).toString() : new String("" + d[i]);
                    sb.append(ds);
                    sb.append(this.arrayDelimiter);
                }
                return sb.toString();
            }
            case 6: 
            case 53: {
                long[] d = (long[])this.hDataObject;
                if (d == null) {
                    d = new long[this.dArrayLength];
                    this.getData(d);
                }
                for (int i = 0; i < this.dCompletionLength && i < d.length; ++i) {
                    String ds = this.dFormat == 53 && this.dBitField == null ? TBitfieldRegistry.getBitfield(this.dTag).toString() : new String("" + d[i]);
                    sb.append(ds);
                    sb.append(this.arrayDelimiter);
                }
                return sb.toString();
            }
            case 33: {
                int[] d = (int[])this.hDataObject;
                if (d == null) {
                    d = new int[this.dArrayLength];
                    this.getData(d);
                }
                for (int i = 0; i < this.dCompletionLength && i < d.length; ++i) {
                    sb.append(d[i] == 0 ? "false" : "true");
                    sb.append(this.arrayDelimiter);
                }
                return sb.toString();
            }
            case 15: {
                TCompoundDataObject[] d = (INTINT[])this.hDataObject;
                if (d == null) {
                    d = new INTINT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 5: {
                float[] d = (float[])this.hDataObject;
                if (d == null) {
                    d = new float[this.dArrayLength];
                    this.getData(d);
                }
                for (int i = 0; i < this.dCompletionLength && i < d.length; ++i) {
                    sb.append(d[i]);
                    sb.append(this.arrayDelimiter);
                }
                return sb.toString();
            }
            case 14: {
                TCompoundDataObject[] d = (FLTINT[])this.hDataObject;
                if (d == null) {
                    d = new FLTINT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 31: {
                TCompoundDataObject[] d = (FLTFLT[])this.hDataObject;
                if (d == null) {
                    d = new FLTFLT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 28: {
                SPECTRUM d = (SPECTRUM)this.hDataObject;
                if (d == null) {
                    d = new SPECTRUM();
                    this.getData(d);
                }
                return d.toString();
            }
            case 0: {
                double[] d = (double[])this.hDataObject;
                if (d == null) {
                    d = new double[this.dArrayLength];
                    this.getData(d);
                }
                for (int i = 0; i < this.dCompletionLength && i < d.length; ++i) {
                    sb.append(d[i]);
                    sb.append(this.arrayDelimiter);
                }
                return sb.toString();
            }
            case 16: {
                TCompoundDataObject[] d = (DBLINT[])this.hDataObject;
                if (d == null) {
                    d = new DBLINT[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 40: {
                TCompoundDataObject[] d = (DBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new DBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
            case 48: {
                TCompoundDataObject[] d = (DBLDBLDBL[])this.hDataObject;
                if (d == null) {
                    d = new DBLDBLDBL[this.dArrayLength];
                    this.getData(d);
                }
                return this.pushToString(d);
            }
        }
        return new String("");
    }

    public TDataType(char[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(char[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(char[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = (short)4;
            this.dArrayLength = length;
            this.dSizeInBytes = length;
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < this.dArrayLength && i < (n + 1) * this.mtu) {
                    byte bdata = (byte)data[i];
                    ds.writeByte(bdata);
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(StringBuffer data) {
        this.initTDataType(data, data.capacity());
    }

    public TDataType(StringBuffer data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(StringBuffer data, int length) {
        try {
            if (length > data.capacity()) {
                length = data.capacity();
            }
            this.dFormat = (short)4;
            this.dSizeInBytes = this.dArrayLength = length;
            byte[] bdata = data.toString().getBytes();
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < bdata.length && i < (n + 1) * this.mtu) {
                    ds.writeByte(bdata[i]);
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(String[] data) {
        this.initTDataType(data, data.length);
    }

    public TDataType(String[] data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(String[] data, int length) {
        try {
            if (length > data.length) {
                length = data.length;
            }
            this.dFormat = (short)57;
            this.dArrayLength = length;
            this.dSizeInBytes = 0;
            for (int i = 0; i < length; ++i) {
                this.dSizeInBytes += data[i] != null ? data[i].length() : 0;
                ++this.dSizeInBytes;
            }
            byte[] bdata = this.getStringArrayBytes(data);
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < bdata.length && i < (n + 1) * this.mtu) {
                    ds.writeByte(bdata[i]);
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = data;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TDataType(String data) {
        this.initTDataType(data, data.length());
    }

    public TDataType(String data, int length) {
        this.initTDataType(data, length);
    }

    private void initTDataType(String data, int length) {
        try {
            if (length > data.length()) {
                length = data.length();
            }
            this.dFormat = (short)4;
            this.dSizeInBytes = this.dArrayLength = length;
            byte[] bdata = data.getBytes();
            this.initCounters();
            this.dBuffers = new ByteArrayOutputStream[this.numblks];
            int i = 0;
            for (int n = 0; n < this.numblks; ++n) {
                this.dBuffers[n] = new ByteArrayOutputStream(dBufferSegSize);
                DataOutputStream ds = new DataOutputStream(this.dBuffers[n]);
                while (i < bdata.length && i < (n + 1) * this.mtu) {
                    ds.writeByte(bdata[i]);
                    ++i;
                }
                ds.close();
            }
            this.hDataObject = new char[this.dArrayLength];
            if (this.dArrayLength > 0) {
                data.getChars(0, this.dArrayLength - 1, (char[])this.hDataObject, 0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getData(char[] data) {
        if (this.dArrayLength > data.length) {
            return 26;
        }
        byte[] bdata = new byte[data.length];
        int i = 0;
        int m = 0;
        for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
            byte[] b = this.dBuffers[n].toByteArray();
            int cplen = b.length;
            if (cplen > data.length - m) {
                cplen = data.length - m;
            }
            if (cplen > 0) {
                System.arraycopy(b, 0, bdata, m, cplen);
                i += cplen;
            }
            m = i;
        }
        String sdata = new String(bdata, 0, i);
        sdata.getChars(0, sdata.length(), data, 0);
        if (this.hDataObject instanceof StringBuffer) {
            ((StringBuffer)this.hDataObject).replace(0, sdata.length(), sdata);
        } else if (this.hDataObject instanceof char[]) {
            System.arraycopy(data, 0, (char[])this.hDataObject, 0, sdata.length());
        }
        this.dCompletionLength = i;
        return 0;
    }

    public int getData(StringBuffer data) {
        if (this.dArrayLength > data.capacity()) {
            return 26;
        }
        byte[] bdata = new byte[data.capacity()];
        int i = 0;
        int m = 0;
        for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
            byte[] b = this.dBuffers[n].toByteArray();
            int cplen = b.length;
            if (cplen > data.capacity() - m) {
                cplen = data.capacity() - m;
            }
            if (cplen > 0) {
                System.arraycopy(b, 0, bdata, m, b.length);
                i += cplen;
            }
            m = i;
        }
        String sdata = new String(bdata, 0, i);
        data.replace(0, sdata.length(), sdata);
        if (this.hDataObject instanceof StringBuffer) {
            ((StringBuffer)this.hDataObject).replace(0, sdata.length(), sdata);
        } else if (this.hDataObject instanceof char[]) {
            System.arraycopy(data, 0, (char[])this.hDataObject, 0, sdata.length());
        }
        this.dCompletionLength = i;
        return 0;
    }

    public int getData(String[] data) {
        int dlen = this.dArrayLength;
        if (this.dArrayLength > data.length) {
            dlen = data.length;
        }
        this.dSizeInBytes = this.bytesin;
        byte[] bdata = new byte[this.dSizeInBytes];
        int i = 0;
        int m = 0;
        for (int n = 0; n < this.numblks && this.dBuffers[n] != null; ++n) {
            byte[] b = this.dBuffers[n].toByteArray();
            System.arraycopy(b, 0, bdata, m, b.length);
            m = i += b.length;
        }
        int off = 0;
        int len = 0;
        for (i = 0; i < dlen; ++i) {
            len = 0;
            while (len + off < this.dSizeInBytes && bdata[off + len] != 0) {
                ++len;
            }
            data[i] = new String(bdata, off, len);
            if (this.hDataObject instanceof StringBuffer) {
                data[0] = ((StringBuffer)this.hDataObject).toString().trim();
                break;
            }
            if (this.hDataObject instanceof char[]) {
                data[0] = new String((char[])this.hDataObject).trim();
                break;
            }
            if (this.hDataObject instanceof String[]) {
                data[i] = ((String[])this.hDataObject)[i];
            }
            off += len + 1;
        }
        this.dCompletionLength = i;
        return 0;
    }

    public void setTag(String tag) {
        this.dTag = tag;
    }

    public int getCompletionLength() {
        return this.dCompletionLength;
    }

    public void setArrayLength(int arrayLength) {
        int dlen = arrayLength;
        if (this.dFormat == 7) {
            int ssiz = TStructRegistry.getSizeInBytes(this.dTag);
            if (ssiz < 1) {
                ssiz = 1;
            }
            dlen *= ssiz;
        }
        this.dArrayLength = dlen;
    }

    public String getField() {
        return this.dField;
    }

    public void setField(String field) {
        this.dField = field;
    }

    public TBitfield getBitField() {
        return this.dBitField;
    }

    public void setBitField(TBitfield bitfield) {
        this.dBitField = bitfield;
    }
}

