/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.console;

import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataTime;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.MsgLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class TConsole {
    private PrintStream stdout;
    private PrintStream stderr;
    private PrintStream prevOut;
    private PrintStream prevErr;
    private JFrame consoleFrame;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private static TConsole instance = new TConsole();
    private static final int MAX_TEXT_WINDOW_SIZE = 65000;
    private static final int TEX_WINDOW_CHOP_SIZE = 5000;
    private JButton clientsButton = null;
    private JButton contractsButton = null;
    private JButton connectionsButton = null;
    private JButton messagesButton = null;
    private JButton filterButton = null;
    private JEditorPane filterPane = null;
    private ButtonGroup dbgGroup = null;
    private JRadioButton[] dbgButton = null;
    private JLabel dbgLabel;
    private JToolBar toolBar = null;

    public static TConsole getInstance() {
        return instance;
    }

    private TConsole() {
        this.storeDefaultStreamReferences();
        this.createOutputStreams();
        this.createOutputWindow();
    }

    public void show() {
        System.setOut(this.stdout);
        System.setErr(this.stderr);
        int dl = TLinkFactory.getOutputDebugLevel();
        if (dl >= 0 && dl < this.dbgButton.length) {
            this.dbgButton[dl].setSelected(true);
        }
        this.consoleFrame.setVisible(true);
    }

    public void hide() {
        this.restoreStreams();
        this.consoleFrame.setVisible(false);
    }

    private void createOutputStreams() {
        OutputStream out = new OutputStream(){

            public void write(int b) throws IOException {
                String str = new String(new int[]{b}, 0, 1);
                TConsole.this.textArea.append(str);
                if (b == 10) {
                    TConsole.this.textArea.setCaretPosition(TConsole.this.textArea.getDocument().getLength());
                    String txt = TConsole.this.textArea.getText();
                    int len = txt.length();
                    if (len > 65000) {
                        TConsole.this.textArea.setText(txt.substring(5000, len));
                    }
                }
            }
        };
        this.stdout = new PrintStream(out);
        OutputStream err = new OutputStream(){

            public void write(int b) throws IOException {
                String str = new String(new int[]{b}, 0, 1);
                TConsole.this.textArea.append(str);
                if (b == 10) {
                    TConsole.this.textArea.setCaretPosition(TConsole.this.textArea.getDocument().getLength());
                }
            }
        };
        this.stderr = new PrintStream(err);
    }

    JButton getClientsButton() {
        if (this.clientsButton == null) {
            this.clientsButton = new JButton("clients");
            this.clientsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TEquipmentModuleFactory.getInstance().dumpClientTable();
                }
            });
        }
        return this.clientsButton;
    }

    JButton getContractsButton() {
        if (this.contractsButton == null) {
            this.contractsButton = new JButton("contracts");
            this.contractsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TEquipmentModuleFactory.getInstance().dumpContractTable();
                }
            });
        }
        return this.contractsButton;
    }

    JButton getConnectionsButton() {
        if (this.connectionsButton == null) {
            this.connectionsButton = new JButton("connections");
            this.connectionsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TLinkFactory.dumpLinkTable();
                }
            });
        }
        return this.connectionsButton;
    }

    JButton getMessagesButton() {
        if (this.messagesButton == null) {
            this.messagesButton = new JButton("messages");
            this.messagesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MsgLog.MsgEntry[] msgs = MsgLog.getMessages(25);
                    System.out.println("\nLast 25 Messages:\n");
                    for (MsgLog.MsgEntry m : msgs) {
                        String msg = m.getMsg();
                        if (m.getCode() != 0) {
                            msg = msg + " (" + TErrorList.getErrorString(m.getCode()) + ")";
                        }
                        System.out.println(msg + " at " + TDataTime.toString(m.getTime()));
                    }
                }
            });
        }
        return this.messagesButton;
    }

    JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton("set debug filter: ");
            this.filterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String text = TConsole.this.getFilterPane().getText();
                    if (text == null || text.length() == 0) {
                        text = null;
                    }
                    DbgLog.setFilter(text);
                }
            });
        }
        return this.filterButton;
    }

    JEditorPane getFilterPane() {
        if (this.filterPane == null) {
            this.filterPane = new JEditorPane();
            this.filterPane.setBackground(SystemColor.control);
            this.filterPane.setSize(new Dimension(80, 25));
            this.filterPane.setMaximumSize(new Dimension(80, 25));
            this.filterPane.setToolTipText("enter text to filter on (empty = no filter)");
        }
        return this.filterPane;
    }

    private JRadioButton getDebugButton(final int index) {
        if (this.dbgButton == null) {
            this.dbgButton = new JRadioButton[5];
            this.dbgGroup = new ButtonGroup();
        }
        if (this.dbgButton[index] == null) {
            this.dbgButton[index] = new JRadioButton("" + (index > 0 ? new String("" + index) : "off"));
            this.dbgButton[index].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TLinkFactory.setOutputDebugLevel(index);
                }
            });
            this.dbgGroup.add(this.dbgButton[index]);
        }
        return this.dbgButton[index];
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getClientsButton());
            this.toolBar.add(this.getContractsButton());
            this.toolBar.add(this.getConnectionsButton());
            this.toolBar.add(this.getMessagesButton());
            this.dbgLabel = new JLabel();
            this.dbgLabel.setText("debug level:");
            this.toolBar.add(this.dbgLabel);
            this.toolBar.add(this.getDebugButton(0));
            this.toolBar.add(this.getDebugButton(1));
            this.toolBar.add(this.getDebugButton(2));
            this.toolBar.add(this.getDebugButton(3));
            this.toolBar.add(this.getDebugButton(4));
            this.toolBar.add(this.getFilterButton());
            this.toolBar.add(this.getFilterPane());
        }
        return this.toolBar;
    }

    public void addWindowListener(WindowListener l) {
        if (this.consoleFrame != null) {
            this.consoleFrame.addWindowListener(l);
        }
    }

    public void removeWindowListener(WindowListener l) {
        if (this.consoleFrame != null) {
            this.consoleFrame.removeWindowListener(l);
        }
    }

    private void createOutputWindow() {
        this.textArea = new JTextArea();
        this.textArea.setRows(10);
        String text = TEquipmentModuleFactory.getInstance().getFecName();
        if (text == null) {
            text = "";
        }
        this.consoleFrame = new JFrame(text + " Debugging console");
        this.consoleFrame.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.textArea);
        this.consoleFrame.add((Component)this.scrollPane, "Center");
        this.consoleFrame.addWindowListener(new ConsoleWindowListener());
        this.consoleFrame.setBounds(0, 0, 750, 750);
        this.consoleFrame.add((Component)this.getToolBar(), "North");
    }

    private void restoreStreams() {
        System.setOut(this.prevOut);
        System.setErr(this.prevErr);
        DbgLog.setFilter(null);
    }

    private void storeDefaultStreamReferences() {
        this.prevOut = System.out;
        this.prevErr = System.err;
    }

    private class ConsoleWindowListener
    implements WindowListener {
        private ConsoleWindowListener() {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            TConsole.this.restoreStreams();
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }
}

