/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.bitfieldUtils;

import de.desy.tine.bitfieldUtils.TBitfieldRegistry;
import de.desy.tine.bitfieldUtils.TField;
import de.desy.tine.client.TLink;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.NAME16I;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Hashtable;

public class TBitfield
implements TCompoundDataObject {
    private String srvName;
    private String bfName;
    private int bfFmt;
    private Hashtable<String, TField> fields = new Hashtable();
    private long bfValue;
    private byte[] bfBytes = new byte[8];

    public double getDoubleValue() {
        return this.bfValue;
    }

    public int getIntegerValue() {
        return (int)this.bfValue;
    }

    private int getBitShiftFromMask(long mask, int fmt) {
        int shf = 0;
        int b = 1;
        int mshf = TFormat.formatSizeOf((short)fmt) * 8 - 1;
        while ((mask & (long)b) == 0L && ++shf != mshf) {
            b *= 2;
        }
        return shf;
    }

    public TBitfield(String name, short format) {
        this(null, name, format);
    }

    public TBitfield(String server, String name, short format) {
        switch (format) {
            case 2: 
            case 50: {
                this.bfFmt = 50;
                break;
            }
            case 1: 
            case 51: {
                this.bfFmt = 51;
                break;
            }
            case 3: 
            case 52: {
                this.bfFmt = 52;
                break;
            }
            case 6: 
            case 53: {
                this.bfFmt = 53;
                break;
            }
            default: {
                return;
            }
        }
        this.srvName = server == null ? "this" : server;
        this.bfName = name.length() > 16 ? name.substring(0, 16) : name;
        TBitfieldRegistry.add(this);
    }

    public void addField(TField field) {
        if (field == null) {
            return;
        }
        String key = field.getName();
        if (this.fields.containsKey(key)) {
            return;
        }
        long mask = field.getBitmask();
        field.setBitshift(this.getBitShiftFromMask(mask, this.bfFmt));
        this.fields.put(key, field);
    }

    public int getField(String fieldName) {
        return this.getField(fieldName, (int)this.bfValue);
    }

    public int getField(String fieldName, int value) {
        TField fld = this.fields.get(fieldName);
        if (fld == null) {
            return 0;
        }
        return fld.getValue(value);
    }

    public String toString() {
        return this.toString((int)this.bfValue);
    }

    public String toString(int value) {
        String bfString = "";
        for (TField f : this.fields.values()) {
            if (bfString.length() > 0) {
                bfString = bfString + "\n";
            }
            bfString = bfString + f.getName() + " : " + f.getValue(value);
        }
        return bfString;
    }

    public String getSrvName() {
        return this.srvName;
    }

    public void setSrvName(String serverName) {
        this.srvName = serverName;
    }

    public short getFormat() {
        return (short)this.bfFmt;
    }

    public String getName() {
        return this.bfName;
    }

    public TField[] getFields() {
        return this.fields.values().toArray(new TField[0]);
    }

    public boolean isField(String fieldName) {
        return this.fields.keySet().contains(fieldName);
    }

    public byte[] toByteArray() {
        byte[] ba = null;
        switch (this.bfFmt) {
            case 50: {
                ba = new byte[]{(byte)this.bfValue};
                break;
            }
            case 51: {
                ba = Swap.ShortToBytes((int)this.bfValue);
                break;
            }
            case 52: {
                ba = Swap.LongToBytes((int)this.bfValue);
                break;
            }
            case 53: {
                ba = Swap.DLongToBytes(this.bfValue);
            }
        }
        System.arraycopy(ba, 0, this.bfBytes, 0, ba.length);
        return ba;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.bfBytes);
            DataInputStream ds = new DataInputStream(dis);
            switch (this.bfFmt) {
                case 50: {
                    this.bfValue = ds.readByte();
                    break;
                }
                case 51: {
                    this.bfValue = Swap.Short(ds.readShort());
                    break;
                }
                case 52: {
                    this.bfValue = Swap.Long(ds.readInt());
                    break;
                }
                case 53: {
                    this.bfValue = Swap.DLong(ds.readLong());
                }
            }
            ds.close();
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] getByteArray() {
        return this.bfBytes;
    }

    public int getSizeInBytes() {
        return TFormat.formatSizeOf((short)this.bfFmt);
    }

    public void setByteArray(byte[] byteArray) {
        int maxlen = byteArray.length;
        if (maxlen > 8) {
            maxlen = 8;
        }
        System.arraycopy(byteArray, 0, this.bfBytes, 0, maxlen);
    }

    public synchronized int acquireAndRegisterFields(String devName) {
        int nflds;
        String tgt;
        int cc = 62;
        if (devName == null) {
            return 20;
        }
        if (!devName.startsWith("/")) {
            return 16;
        }
        String[] dn = devName.split("/");
        switch (dn.length) {
            case 3: 
            case 4: {
                tgt = "/" + dn[1] + "/" + dn[2];
                break;
            }
            default: {
                return 141;
            }
        }
        tgt = tgt + "/" + this.bfName;
        TBitfield bf = TBitfieldRegistry.getBitfield(tgt);
        if (bf != null && bf.fields.size() > 0) {
            return 0;
        }
        TCompoundDataObject[] info = new NAME16I[32];
        TDataType dtInfo = new TDataType(info);
        TDataType dtTag = new TDataType(this.bfName.toCharArray());
        TLink tl = new TLink(devName, "BITFIELDFORMAT", dtInfo, dtTag, 1);
        cc = tl.execute(200, true);
        tl.close();
        if (cc == 0 && (nflds = dtInfo.getCompletionLength()) > 0) {
            short fmt = TFormat.getFormatDataType((short)((NAME16I)info[nflds - 1]).ival);
            if (fmt != this.bfFmt) {
                return 2;
            }
            for (int i = 0; i < nflds - 1; ++i) {
                this.addField(new TField(((NAME16I)info[i]).name, ((NAME16I)info[i]).ival));
            }
        }
        return cc;
    }
}

