/*
 * Decompiled with CFR 0.152.
 */
package tangoatk.jddd.addresses;

import DOOCSComponents.DOOCSParameter;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.ConnectionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import tangoatk.jddd.addresses.CompParam;
import ttf.doocs.clnt.EqAdr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TangoAdrList {
    private List<CompParam> paramList = new ArrayList<CompParam>();
    private List<String> fullAdrList = new ArrayList<String>();
    private boolean use_command_names = false;

    public TangoAdrList() {
        this.add("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "A full Tango attribute name", null);
    }

    public TangoAdrList(String name, DOOCSParameter.ParameterTypes type, DOOCSParameter.Levels level, String tooltip, String def) {
        this.add(name, type, level, tooltip, def);
    }

    public void use_command_names() {
        this.use_command_names = true;
    }

    public void add(String name, DOOCSParameter.ParameterTypes type, DOOCSParameter.Levels level, String tooltip, String def) {
        CompParam np = new CompParam(name, type, level, tooltip, def);
        this.paramList.add(np);
    }

    public void setAddress(String param_name, String address) {
        CompParam parList;
        int nu_par;
        int attr_index;
        String attr_name;
        if (address == null) {
            return;
        }
        CompParam adrList = this.paramList.get(0);
        int i = 0;
        int index = param_name.indexOf(".");
        if (param_name.substring(++index).length() > 0) {
            i = Integer.parseInt(param_name.substring(index));
        }
        if (!(attr_name = address.substring((attr_index = address.lastIndexOf("/")) + 1)).equals("*")) {
            address = address.replace('*', '#');
        }
        if (adrList.size() == i) {
            adrList.add(address);
            this.fullAdrList.add(address);
            for (nu_par = 1; nu_par < this.paramList.size(); ++nu_par) {
                parList = this.paramList.get(nu_par);
                parList.add();
            }
        } else {
            adrList.set(i, address);
            this.fullAdrList.set(i, address);
        }
        if (address.length() == 0 && adrList.size() > i) {
            adrList.remove(i);
            if (this.fullAdrList.size() > i) {
                this.fullAdrList.remove(i);
            }
            for (nu_par = 1; nu_par < this.paramList.size(); ++nu_par) {
                parList = this.paramList.get(nu_par);
                parList.remove(i);
            }
        }
    }

    public void setAddress(AEntityList list, String param_name, String address) {
        CompParam parList;
        int nu_par;
        int attr_index;
        String attr_name;
        if (address == null) {
            return;
        }
        CompParam adrList = this.paramList.get(0);
        int i = 0;
        int index = param_name.indexOf(".");
        if (param_name.substring(++index).length() > 0) {
            i = Integer.parseInt(param_name.substring(index));
        }
        if (!(attr_name = address.substring((attr_index = address.lastIndexOf("/")) + 1)).equals("*")) {
            address = address.replace('*', '#');
        }
        if (adrList.size() == i) {
            adrList.add(address);
            this.fullAdrList.add(address);
            for (nu_par = 1; nu_par < this.paramList.size(); ++nu_par) {
                parList = this.paramList.get(nu_par);
                parList.add();
            }
        } else {
            adrList.set(i, address);
            this.fullAdrList.set(i, address);
        }
        if (address.length() == 0 && adrList.size() > i) {
            adrList.remove(i);
            if (this.fullAdrList.size() > i) {
                this.fullAdrList.remove(i);
            }
            for (nu_par = 1; nu_par < this.paramList.size(); ++nu_par) {
                parList = this.paramList.get(nu_par);
                parList.remove(i);
            }
        }
        list.removeAllElements();
        for (i = 0; i < adrList.size(); ++i) {
            try {
                if (adrList.get(i) == null) continue;
                list.add(adrList.get(i));
                continue;
            }
            catch (ConnectionException ex) {
                // empty catch block
            }
        }
    }

    public String getAddress(String param_name) {
        CompParam adrList = this.paramList.get(0);
        int index = param_name.indexOf(".");
        if (param_name.substring(++index).length() == 0) {
            return null;
        }
        int i = Integer.parseInt(param_name.substring(index));
        if (i >= adrList.size()) {
            return null;
        }
        String adr = adrList.get(i);
        adr = adr.replace('#', '*');
        return adr;
    }

    public String getAddress(int i) {
        CompParam adrList = this.paramList.get(0);
        if (i >= adrList.size()) {
            return null;
        }
        String adr = adrList.get(i);
        adr = adr.replace('#', '*');
        return adr;
    }

    public void setFullAddress(String address) {
        CompParam adrList = this.paramList.get(0);
        for (int i = 0; i < adrList.size(); ++i) {
            String adr = adrList.get(i);
            adr = adr.replace('#', '*');
            EqAdr ea = new EqAdr(address);
            ea.merge(adr);
            adr = ea.show_adr();
            this.fullAdrList.set(i, adr);
        }
    }

    public void setFullAddress(AEntityList list, String address) {
        CompParam adrList = this.paramList.get(0);
        list.removeAllElements();
        for (int i = 0; i < adrList.size(); ++i) {
            String adr = adrList.get(i);
            adr = adr.replace('#', '*');
            EqAdr ea = new EqAdr(address);
            ea.merge(adr);
            adr = ea.show_adr();
            this.fullAdrList.set(i, adr);
            try {
                if (adr.indexOf("*") == -1) {
                    list.add(adr);
                    continue;
                }
                this.expandWildcard(list, adr);
                continue;
            }
            catch (ConnectionException ex) {
                Logger.getLogger(TangoAdrList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getFullAddress(int i) {
        if (i >= this.fullAdrList.size()) {
            return null;
        }
        return this.fullAdrList.get(i);
    }

    public String getFullAddress() {
        StringBuffer buf = new StringBuffer("<html>");
        for (int i = 0; i < this.fullAdrList.size(); ++i) {
            buf.append(this.fullAdrList.get(i));
            if (i + 1 >= this.fullAdrList.size()) continue;
            buf.append("<br>");
        }
        buf.append("</html>");
        return buf.toString();
    }

    public void setParameter(String param_name, String value) {
        int i;
        CompParam pList = null;
        int index = param_name.indexOf(".");
        for (i = 0; i < this.paramList.size(); ++i) {
            if (!this.paramList.get((int)i).name.equalsIgnoreCase(param_name.substring(0, index))) continue;
            pList = this.paramList.get(i);
            break;
        }
        if (pList == null) {
            return;
        }
        i = 0;
        if (param_name.substring(++index).length() > 0) {
            i = Integer.parseInt(param_name.substring(index));
        }
        if (value != null && value.length() == 0 && pList.size() > i) {
            pList.set(i, pList.default_val);
        } else if (value != null) {
            pList.set(i, value);
        }
    }

    public String getParameter(String param_name) {
        int i;
        CompParam pList = null;
        int index = param_name.indexOf(".");
        for (i = 0; i < this.paramList.size(); ++i) {
            if (!this.paramList.get((int)i).name.equalsIgnoreCase(param_name.substring(0, index))) continue;
            pList = this.paramList.get(i);
            break;
        }
        if (pList == null) {
            return null;
        }
        if (param_name.substring(++index).length() == 0) {
            return null;
        }
        i = Integer.parseInt(param_name.substring(index));
        if (i >= pList.size()) {
            return null;
        }
        return pList.get(i);
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        CompParam adrList = this.paramList.get(0);
        DOOCSParameter[] parameters = adrList.size() == 0 ? new DOOCSParameter[this.paramList.size()] : new DOOCSParameter[adrList.size() * this.paramList.size() + this.paramList.size()];
        for (int i = 0; i <= adrList.size(); ++i) {
            for (int k = 0; k < this.paramList.size(); ++k) {
                parameters[i * this.paramList.size() + k] = this.paramList.get(k).getDOOCSParameter(i);
            }
        }
        return parameters;
    }

    public List<String> getAdrRelation(String param) {
        int i;
        ArrayList<String> relationList = new ArrayList<String>();
        CompParam pList = null;
        for (i = 0; i < this.paramList.size(); ++i) {
            if (!this.paramList.get((int)i).name.equalsIgnoreCase(param)) continue;
            pList = this.paramList.get(i);
        }
        if (pList == null) {
            return relationList;
        }
        for (i = 0; i < this.fullAdrList.size(); ++i) {
            String adr = this.fullAdrList.get(i);
            if (adr.indexOf("*") != -1) {
                Vector<String> exp_adr = this.expandAdrWildcard(adr);
                if (exp_adr.isEmpty()) continue;
                for (int k = 0; k < exp_adr.size(); ++k) {
                    relationList.add(exp_adr.get(k));
                    relationList.add(pList.ValueList.get(i));
                }
                continue;
            }
            relationList.add(adr);
            relationList.add(pList.ValueList.get(i));
        }
        return relationList;
    }

    public List<String> getRelation(String param1, String param2) {
        int i;
        ArrayList<String> relationList = new ArrayList<String>();
        CompParam p1List = null;
        CompParam p2List = null;
        for (i = 0; i < this.paramList.size(); ++i) {
            if (this.paramList.get((int)i).name.equalsIgnoreCase(param1)) {
                p1List = this.paramList.get(i);
            }
            if (!this.paramList.get((int)i).name.equalsIgnoreCase(param2)) continue;
            p2List = this.paramList.get(i);
        }
        if (p1List == null || p2List == null) {
            return relationList;
        }
        for (i = 0; i < p1List.ValueList.size(); ++i) {
            relationList.add(p1List.ValueList.get(i));
            relationList.add(p2List.ValueList.get(i));
        }
        return relationList;
    }

    public void expandWildcard(AEntityList list, String address) {
        Vector<String> attr_names = this.expandAdrWildcard(address);
        for (int i = 0; i < attr_names.size(); ++i) {
            try {
                list.add(attr_names.get(i));
                continue;
            }
            catch (ConnectionException ex) {
                Logger.getLogger(TangoAdrList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Vector<String> expandAdrWildcard(String address) {
        int attr_index = address.lastIndexOf("/");
        String adr_name = address.substring(0, attr_index);
        int member_index = adr_name.lastIndexOf("/");
        adr_name = adr_name.substring(0, member_index);
        int family_index = adr_name.lastIndexOf("/");
        int domain_index = (adr_name = adr_name.substring(0, family_index)).lastIndexOf("/");
        domain_index = domain_index != -1 ? ++domain_index : ((domain_index = adr_name.indexOf(":")) != -1 ? ++domain_index : 0);
        String prefix = address.substring(0, domain_index);
        String dev_name = address.substring(domain_index, attr_index);
        String attr_name = address.substring(attr_index + 1, address.length());
        try {
            Database db = new Database();
            String[] device_names = db.get_device_exported(dev_name);
            Vector<String> attribute_names = new Vector<String>(0);
            for (int i = 0; i < device_names.length; ++i) {
                if (attr_name.indexOf("*") == -1) {
                    attribute_names.add(prefix + device_names[i] + "/" + attr_name);
                    continue;
                }
                if (this.use_command_names) {
                    if (!attr_name.equals("*")) continue;
                    attribute_names.add(prefix + device_names[i] + "/" + attr_name);
                    continue;
                }
                DeviceProxy dev_clnt = new DeviceProxy(device_names[i]);
                String[] dev_attr_names = dev_clnt.get_attribute_list();
                for (int k = 0; k < dev_attr_names.length; ++k) {
                    if (!this.wildcard_matches(attr_name, dev_attr_names[k])) continue;
                    attribute_names.add(prefix + device_names[i] + "/" + dev_attr_names[k]);
                }
            }
            return attribute_names;
        }
        catch (DevFailed ex) {
            Logger.getLogger(TangoAdrList.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private boolean wildcard_matches(String pattern, String text) {
        text = text + '\u0000';
        pattern = pattern + '\u0000';
        int N = pattern.length();
        boolean[] states = new boolean[N + 1];
        boolean[] old = new boolean[N + 1];
        old[0] = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            states = new boolean[N + 1];
            for (int j = 0; j < N; ++j) {
                char p = pattern.charAt(j);
                if (old[j] && p == '*') {
                    old[j + 1] = true;
                }
                if (old[j] && p == c) {
                    states[j + 1] = true;
                }
                if (old[j] && p == '*') {
                    states[j] = true;
                }
                if (!old[j] || p != '*') continue;
                states[j + 1] = true;
            }
            old = states;
        }
        return states[N];
    }
}

