/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import de.desy.tine.dataUtils.TDataType;
import java.util.ArrayList;
import java.util.List;
import ttf.doocs.clnt.EqNameString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqAdr {
    private EqNameString addr_ = new EqNameString();
    private String protocol = "";
    private String host = "";
    private String file = "";
    public int ens_;
    public TDataType tData = null;
    public long lastCallError = 0L;

    public EqAdr() {
        this.addr_.n_facility = new byte[64];
        this.addr_.n_object = new byte[64];
        this.addr_.n_location = new byte[64];
        this.addr_.n_property = new byte[64];
        this.ens_ = 0;
    }

    public void toByteArray(String str, byte[] arr, int len) {
        this.init();
        for (int i = 0; i < len; ++i) {
            arr[i] = (byte)str.charAt(i);
        }
    }

    public EqAdr(String adr) {
        this.addr_.n_facility = new byte[64];
        this.addr_.n_object = new byte[64];
        this.addr_.n_location = new byte[64];
        this.addr_.n_property = new byte[64];
        this.ens_ = 1;
        this.adr(adr);
    }

    public EqNameString EqName() {
        return this.addr_;
    }

    private void init() {
        this.tData = null;
        this.lastCallError = 0L;
    }

    public String facility() {
        if (this.addr_.n_facility.length > 0) {
            return new String(this.addr_.n_facility).trim();
        }
        return null;
    }

    public String device() {
        if (this.addr_.n_object.length > 0) {
            return new String(this.addr_.n_object).trim();
        }
        return null;
    }

    public String location() {
        if (this.addr_.n_location.length > 0) {
            return new String(this.addr_.n_location).trim();
        }
        return null;
    }

    public String property() {
        if (this.addr_.n_property.length > 0) {
            return new String(this.addr_.n_property).trim();
        }
        return null;
    }

    public String protocol() {
        return this.protocol;
    }

    public String host() {
        return this.host;
    }

    public String file() {
        return this.file;
    }

    public void set_facility(String str) {
        int ln = str.length();
        if (ln > 64) {
            ln = 64;
        }
        this.addr_.n_facility = new byte[64];
        this.toByteArray(str, this.addr_.n_facility, ln);
    }

    public void set_device(String str) {
        int ln = str.length();
        if (ln > 64) {
            ln = 64;
        }
        this.addr_.n_object = new byte[64];
        this.toByteArray(str, this.addr_.n_object, ln);
    }

    public void set_location(String str) {
        int ln = str.length();
        if (ln > 64) {
            ln = 64;
        }
        this.addr_.n_location = new byte[64];
        this.toByteArray(str, this.addr_.n_location, ln);
    }

    public void set_property(String str) {
        int ln = str.length();
        if (ln > 64) {
            ln = 64;
        }
        this.addr_.n_property = new byte[64];
        this.toByteArray(str, this.addr_.n_property, ln);
    }

    public void set_protocol(String str) {
        this.protocol = str;
    }

    public void set_host(String str) {
        this.host = str;
    }

    private String to_upper(String addr) {
        int len = addr.length();
        char[] a = new char[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Character.toUpperCase(addr.charAt(i));
        }
        return new String(a);
    }

    private String doProtocolHost(String adr) {
        String pro = this.getProtocol(adr);
        String ho = this.getHost(adr);
        int i = 0;
        int cnt = 0;
        this.protocol = pro;
        int j = pro.length();
        if (j > 0) {
            i = j + 1;
        }
        this.host = ho;
        j = ho.length();
        if (j > 0) {
            i += j + 2;
        }
        j = 0;
        while ((j = adr.indexOf("/", j)) >= 0) {
            ++j;
            ++cnt;
        }
        if (cnt > 3) {
            ++i;
        } else if (adr.startsWith("epics://")) {
            ++i;
        }
        return adr.substring(i);
    }

    private String getProtocol(String adr) {
        int firstSlash = adr.indexOf("/");
        int firstColon = adr.indexOf(":");
        if (adr.startsWith("epics:")) {
            return "epics";
        }
        if (firstSlash < 0 || firstColon < 0) {
            return "";
        }
        if (firstColon < firstSlash) {
            return adr.substring(0, firstColon);
        }
        return "";
    }

    private String getHost(String adr) {
        int j;
        int i = adr.indexOf("://");
        int k = adr.indexOf("//");
        if (i < 0 && k == 0 && (i = adr.indexOf("/", (j = adr.indexOf("/", k + 2)) + 1)) > 3) {
            return adr.substring(k + 2, j);
        }
        j = adr.indexOf("/", i + 3);
        if (i >= 0 && j > i) {
            return adr.substring(i + 3, j);
        }
        return "";
    }

    public void set_adr(String adr) {
        this.adr(adr);
    }

    public void adr(String adr) {
        if (adr == null) {
            return;
        }
        this.ens_ = 0;
        int n = 0;
        int k = 0;
        char dlm = "/".charAt(0);
        char wild = "*".charAt(0);
        int ln = adr.length();
        if (ln < 3) {
            return;
        }
        if (!EqAdr.isValidAdr(adr)) {
            return;
        }
        this.init();
        adr = this.doProtocolHost(adr);
        if (this.protocol.startsWith("file")) {
            this.file = adr;
            return;
        }
        if (this.protocol.startsWith("epics")) {
            this.file = adr;
            return;
        }
        ln = adr.length();
        if (ln < 3) {
            return;
        }
        try {
            int j;
            for (int i = 0; i < ln; ++i) {
                if (adr.charAt(i) == dlm) {
                    if (k == 0) {
                        for (j = n; j < 64; ++j) {
                            this.addr_.n_facility[j] = 0;
                        }
                    } else if (k == 1) {
                        for (j = n; j < 64; ++j) {
                            this.addr_.n_object[j] = 0;
                        }
                    } else if (k == 2 && n < 64) {
                        for (j = n; j < 64; ++j) {
                            this.addr_.n_location[j] = 0;
                        }
                    } else if (k == 3) {
                        for (j = n; j < 64; ++j) {
                            this.addr_.n_property[j] = 0;
                        }
                    }
                    n = 0;
                    if (++k <= 3) continue;
                    return;
                }
                if (k == 0) {
                    this.addr_.n_facility[n++] = (byte)adr.charAt(i);
                }
                if (k == 1) {
                    this.addr_.n_object[n++] = (byte)adr.charAt(i);
                    if (adr.charAt(i) != wild) {
                        this.ens_ = 1;
                    }
                }
                if (k == 2) {
                    this.addr_.n_location[n++] = (byte)adr.charAt(i);
                    this.ens_ = adr.charAt(i) != wild ? 2 : 1;
                }
                if (k != 3) continue;
                this.addr_.n_property[n++] = (byte)adr.charAt(i);
                this.ens_ = 2;
            }
            if (k == 3) {
                for (j = n; j < 64; ++j) {
                    this.addr_.n_property[j] = 0;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in call 'adr': " + exception.toString() + " ADR arg = " + adr);
        }
    }

    public void set(String fac, String loc, String dev, String prop) {
        int ln = fac.length();
        if (ln > 0) {
            this.addr_.n_facility = new byte[64];
            this.toByteArray(fac, this.addr_.n_facility, ln);
        }
        if ((ln = dev.length()) > 0) {
            this.addr_.n_object = new byte[64];
            this.toByteArray(dev, this.addr_.n_object, ln);
            this.ens_ = 1;
        }
        if ((ln = loc.length()) > 0) {
            this.addr_.n_location = new byte[64];
            this.toByteArray(loc, this.addr_.n_location, ln);
            this.ens_ = 2;
        }
        if ((ln = prop.length()) > 0) {
            this.addr_.n_property = new byte[64];
            this.toByteArray(prop, this.addr_.n_property, ln);
        }
    }

    public void merge(String mAdr) {
        String f_adr = "";
        String d_adr = "";
        String l_adr = "";
        String p_adr = "";
        String pro = this.getProtocol(mAdr);
        String ho = this.getHost(mAdr);
        int i = 0;
        int cnt = 0;
        int j = pro.length();
        if (j > 0) {
            i = j + 1;
            this.protocol = pro;
        }
        if ((j = ho.length()) > 0) {
            i += j + 3;
            this.host = ho;
        }
        j = 0;
        while ((j = mAdr.indexOf("/", j)) >= 0) {
            ++j;
            ++cnt;
        }
        String adr = mAdr.substring(i);
        if (adr != null && adr.indexOf("/") >= 0) {
            f_adr = adr.substring(0, adr.indexOf("/"));
            if ((adr = adr.substring(adr.indexOf("/") + 1)) != null && adr.indexOf("/") >= 0) {
                d_adr = adr.substring(0, adr.indexOf("/"));
                if ((adr = adr.substring(adr.indexOf("/") + 1)) != null && adr.indexOf("/") >= 0) {
                    l_adr = adr.substring(0, adr.indexOf("/"));
                    p_adr = adr.substring(adr.indexOf("/") + 1);
                }
            }
        }
        if (pro.startsWith("daq")) {
            l_adr = adr;
            d_adr = f_adr;
            f_adr = "";
        }
        this.init();
        String fac = this.facility();
        String dev = this.device();
        String loc = this.location();
        String prop = this.property();
        if (f_adr.length() > 0 && !f_adr.startsWith(".")) {
            this.set_facility(f_adr);
        }
        if (f_adr.startsWith(".")) {
            this.set_facility(this.facility() + f_adr);
        }
        if (f_adr.contains("$f")) {
            this.set_facility(this.facility().replace("$f", fac));
        }
        if (f_adr.contains("$d")) {
            this.set_facility(this.facility().replace("$d", dev));
        }
        if (f_adr.contains("$l")) {
            this.set_facility(this.facility().replace("$l", loc));
        }
        if (f_adr.contains("$p")) {
            this.set_facility(this.facility().replace("$p", prop));
        }
        if (d_adr.length() > 0 && !d_adr.startsWith(".")) {
            this.set_device(d_adr);
        }
        if (d_adr.startsWith(".")) {
            this.set_device(this.device() + d_adr);
        }
        if (d_adr.contains("$f")) {
            this.set_device(this.device().replace("$f", fac));
        }
        if (d_adr.contains("$d")) {
            this.set_device(this.device().replace("$d", dev));
        }
        if (d_adr.contains("$l")) {
            this.set_device(this.device().replace("$l", loc));
        }
        if (d_adr.contains("$p")) {
            this.set_device(this.device().replace("$p", prop));
        }
        if (l_adr.length() > 0 && !l_adr.startsWith(".")) {
            this.set_location(l_adr);
        }
        if (l_adr.startsWith(".")) {
            this.set_location(this.location() + l_adr);
        }
        if (l_adr.contains("$f")) {
            this.set_location(this.location().replace("$f", fac));
        }
        if (l_adr.contains("$d")) {
            this.set_location(this.location().replace("$d", dev));
        }
        if (l_adr.contains("$l")) {
            this.set_location(this.location().replace("$l", loc));
        }
        if (l_adr.contains("$p")) {
            this.set_location(this.location().replace("$p", prop));
        }
        if (p_adr.length() > 0 && !p_adr.startsWith(".")) {
            this.set_property(p_adr);
        }
        if (p_adr.startsWith(".")) {
            this.set_property(this.property() + p_adr);
        }
        if (p_adr.contains("$f")) {
            this.set_property(this.property().replace("$f", fac));
        }
        if (p_adr.contains("$d")) {
            this.set_property(this.property().replace("$d", dev));
        }
        if (p_adr.contains("$l")) {
            this.set_property(this.property().replace("$l", loc));
        }
        if (p_adr.contains("$p")) {
            this.set_property(this.property().replace("$p", prop));
        }
        if (this.protocol.startsWith("epics")) {
            this.file = adr;
        }
    }

    public static List<String> expandAdrString(String adr) {
        ArrayList<String> adrs = new ArrayList<String>();
        int idx = adr.indexOf("[");
        if (idx < 0) {
            adrs.add(adr);
            return adrs;
        }
        int idxEnd = adr.indexOf("]");
        int iT = adr.indexOf(";");
        int i = idx + 1;
        while (iT > 0 && i < idxEnd) {
            String tmp = adr.substring(0, idx) + adr.substring(i, iT) + adr.substring(idxEnd + 1);
            if (tmp.indexOf("[") >= 0) {
                List<String> tmpAdr = EqAdr.expandAdrString(tmp);
                for (int j = 0; j < tmpAdr.size(); ++j) {
                    adrs.add(tmpAdr.get(j));
                }
            } else {
                adrs.add(tmp);
            }
            if ((iT = adr.indexOf(";", i = iT + 1)) >= 0) continue;
            iT = idxEnd;
        }
        return adrs;
    }

    public String show_adr() {
        int flag = 0;
        if (!this.protocol.startsWith("daq")) {
            String tmp = new String(new String(this.addr_.n_facility).trim() + "/" + new String(this.addr_.n_object).trim() + "/" + new String(this.addr_.n_location).trim() + "/" + new String(this.addr_.n_property).trim());
            if (this.protocol.startsWith("file")) {
                tmp = this.file;
            }
            if (this.protocol.startsWith("epics")) {
                tmp = this.file;
            }
            if (this.protocol.length() > 0) {
                flag = 1;
            }
            if (this.host.length() > 0) {
                flag += 2;
            }
            switch (flag) {
                default: {
                    return tmp;
                }
                case 1: {
                    return this.protocol + ":" + tmp;
                }
                case 2: {
                    return "://" + this.host + "/" + tmp;
                }
                case 3: 
            }
            return this.protocol + "://" + this.host + "/" + tmp;
        }
        String tmp = new String(new String(this.protocol + ":" + new String(this.addr_.n_object).trim() + "/" + new String(this.addr_.n_location).trim()));
        return tmp;
    }

    public String toString() {
        return this.show_adr();
    }

    public static boolean isValidAdr(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 3) {
            return false;
        }
        if (str.contains("/") || str.startsWith("file:")) {
            return true;
        }
        return str.startsWith("epics:");
    }

    public boolean isValidAdr() {
        if (this.protocol.startsWith("file") && this.file.length() > 1) {
            return true;
        }
        if (this.protocol.startsWith("epics") && this.file.length() > 0) {
            return true;
        }
        if (this.addr_.n_facility[0] == 0) {
            return false;
        }
        return this.addr_.n_object[0] != 0;
    }

    public boolean isValidFullAdr() {
        if (this.protocol.startsWith("file") && this.file.length() > 1) {
            return true;
        }
        if (this.protocol.startsWith("epics") && this.file.length() > 0) {
            return true;
        }
        if (this.addr_.n_facility[0] == 0) {
            return false;
        }
        if (this.addr_.n_object[0] == 0) {
            return false;
        }
        if (this.addr_.n_location[0] == 0) {
            return false;
        }
        return this.addr_.n_property[0] != 0;
    }

    public int[] matlab_int(int len) {
        return new int[len];
    }

    public float[] matlab_float(int len) {
        return new float[len];
    }

    public byte[] matlab_byte(int len) {
        return new byte[len];
    }
}

