/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.jni;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.dbr.ACK;
import gov.aps.jca.dbr.CTRL;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.LABELS;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.STS;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.TIME;
import gov.aps.jca.dbr.TimeStamp;
import gov.aps.jca.jni.JNIAccessRightsCallback;
import gov.aps.jca.jni.JNIConnectionCallback;
import gov.aps.jca.jni.JNIContextExceptionCallback;
import gov.aps.jca.jni.JNIContextMessageCallback;
import gov.aps.jca.jni.JNIException;
import gov.aps.jca.jni.JNIGetCallback;
import gov.aps.jca.jni.JNIMonitorCallback;
import gov.aps.jca.jni.JNIPutCallback;
import gov.aps.jca.jni.JNITargetArch;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

class JNI {
    private static boolean _initialized = false;
    private static Object _lock = new Object();

    JNI() {
    }

    private static void loadLibrary(String path, String lib) {
        if (path.equals("")) {
            System.loadLibrary(lib);
        } else {
            try {
                String libname = System.mapLibraryName(lib);
                String targetArch = JNITargetArch.getTargetArch();
                if (targetArch.matches("darwin-(ppc|x86)")) {
                    libname = "lib" + lib + ".dylib";
                } else if (libname.endsWith(".jnilib")) {
                    libname = lib.replaceFirst(".jnilib$", ".so");
                }
                libname = new File(path, libname).getAbsolutePath();
                System.load(libname);
            }
            catch (UnsatisfiedLinkError linkError) {
                System.loadLibrary(lib);
            }
        }
    }

    public static void init() throws CAException {
        if (_initialized) {
            return;
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                try {
                    try {
                        String targetArch = JNITargetArch.getTargetArch();
                        JCALibrary jca = JCALibrary.getInstance();
                        String libPath = jca.getProperty("gov.aps.jca.jni.epics." + targetArch + ".library.path", "");
                        JNI.loadLibrary(libPath, "Com");
                        JNI.loadLibrary(libPath, "ca");
                        File caRepeaterPath = new File(jca.getProperty("gov.aps.jca.jni.epics." + targetArch + ".caRepeater.path", ""));
                        try {
                            String caRepeater = "caRepeater";
                            if (caRepeaterPath.exists()) {
                                caRepeater = new File(caRepeaterPath, "caRepeater").getAbsolutePath();
                            }
                            Runtime.getRuntime().exec(caRepeater);
                        }
                        catch (IOException ex) {
                            Runtime.getRuntime().exec("caRepeater");
                        }
                    }
                    catch (Throwable ex2) {
                        // empty catch block
                    }
                    System.loadLibrary("jca");
                    return null;
                }
                catch (Exception ex1) {
                    return ex1;
                }
            }
        };
        Object res = AccessController.doPrivileged(action);
        if (res != null) {
            throw new CAException("Unable to initialize gov.aps.jca.jni.JNI", (Exception)res);
        }
        _initialized = true;
    }

    public static Object lock() {
        return _lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setenv(String name, String value) {
        Object object = _lock;
        synchronized (object) {
            JNI._setenv(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long ctxt_contextCreate(boolean preemptive_callback) throws JNIException {
        Object object = _lock;
        synchronized (object) {
            return JNI._ctxt_contextCreate(preemptive_callback);
        }
    }

    public static void ctxt_contextDestroy() throws JNIException {
        JNI._ctxt_contextDestroy();
    }

    public static void ctxt_setMessageCallback(JNIContextMessageCallback callback) throws JNIException {
        JNI._ctxt_setMessageCallback(callback);
    }

    public static void ctxt_setExceptionCallback(JNIContextExceptionCallback callback) throws JNIException {
        JNI._ctxt_setExceptionCallback(callback);
    }

    public static void ctxt_pendIO(double timeout) throws JNIException {
        JNI._ctxt_pendIO(timeout);
    }

    public static boolean ctxt_testIO() throws JNIException {
        return JNI._ctxt_testIO();
    }

    public static void ctxt_pendEvent(double time) throws JNIException {
        block2: {
            try {
                JNI._ctxt_pendEvent(time);
            }
            catch (JNIException jex) {
                if (jex.getStatus() == CAStatus.TIMEOUT) break block2;
                throw jex;
            }
        }
    }

    public static void ctxt_poll() throws JNIException {
        block2: {
            try {
                JNI._ctxt_poll();
            }
            catch (JNIException jex) {
                if (jex.getStatus() == CAStatus.TIMEOUT) break block2;
                throw jex;
            }
        }
    }

    public static void ctxt_flushIO() throws JNIException {
        JNI._ctxt_flushIO();
    }

    public static void ctxt_attachThread(long ctxtID) throws JNIException {
        JNI._ctxt_attachThread(ctxtID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long ch_channelCreate(String name, JNIConnectionCallback callback, short priority) throws JNIException {
        Object object = _lock;
        synchronized (object) {
            return JNI._ch_channelCreate(name, callback, priority);
        }
    }

    public static void ch_channelDestroy(long channelID) throws JNIException {
        JNI._ch_channelDestroy(channelID);
    }

    public static void ch_setConnectionCallback(long channelID, JNIConnectionCallback callback) throws JNIException {
        JNI._ch_setConnectionCallback(channelID, callback);
    }

    public static void ch_setAccessRightsCallback(long channelID, JNIAccessRightsCallback callback) throws JNIException {
        JNI._ch_setAccessRightsCallback(channelID, callback);
    }

    public static int ch_getFieldType(long channelID) {
        return JNI._ch_getFieldType(channelID);
    }

    public static int ch_getElementCount(long channelID) {
        return JNI._ch_getElementCount(channelID);
    }

    public static int ch_getState(long channelID) {
        return JNI._ch_getState(channelID);
    }

    public static String ch_getHostName(long channelID) {
        return JNI._ch_getHostName(channelID);
    }

    public static boolean ch_getReadAccess(long channelID) {
        return JNI._ch_getReadAccess(channelID);
    }

    public static boolean ch_getWriteAccess(long channelID) {
        return JNI._ch_getWriteAccess(channelID);
    }

    public static void ch_arrayPut(int type, int count, long channelID, long dbrID) throws JNIException {
        JNI._ch_arrayPut(type, count, channelID, dbrID);
    }

    public static void ch_arrayPutCallback(int type, int count, long channelID, long dbrID, JNIPutCallback callback) throws JNIException {
        JNI._ch_arrayPutCallback(type, count, channelID, dbrID, callback);
    }

    public static void ch_arrayGet(int type, int count, long channelID, long dbrID) throws JNIException {
        JNI._ch_arrayGet(type, count, channelID, dbrID);
    }

    public static void ch_arrayGetCallback(int type, int count, long channelID, JNIGetCallback callback) throws JNIException {
        JNI._ch_arrayGetCallback(type, count, channelID, callback);
    }

    public static long ch_addMonitor(int type, int count, long channelID, JNIMonitorCallback callback, int mask) throws JNIException {
        return JNI._ch_addMonitor(type, count, channelID, callback, mask);
    }

    public static void ch_clearMonitor(long monitorID) throws JNIException {
        JNI._ch_clearMonitor(monitorID);
    }

    public static long dbr_create(int type, int count) {
        return JNI._dbr_create(type, count);
    }

    public static void dbr_destroy(long dbrid) {
        JNI._dbr_destroy(dbrid);
    }

    public static void dbr_setValue(long dbrid, int type, int count, Object value) {
        JNI._dbr_setValue(dbrid, type, count, value);
    }

    public static Object dbr_getValue(long dbrid, int type, int count, Object value) {
        return JNI._dbr_getValue(dbrid, type, count, value);
    }

    public static short dbr_getStatus(long dbrid, int type) {
        return JNI._dbr_getStatus(dbrid, type);
    }

    public static short dbr_getSeverity(long dbrid, int type) {
        return JNI._dbr_getSeverity(dbrid, type);
    }

    public static Number dbr_getUDL(long dbrid, int type) {
        return JNI._dbr_getUDL(dbrid, type);
    }

    public static Number dbr_getLDL(long dbrid, int type) {
        return JNI._dbr_getLDL(dbrid, type);
    }

    public static Number dbr_getUAL(long dbrid, int type) {
        return JNI._dbr_getUAL(dbrid, type);
    }

    public static Number dbr_getUWL(long dbrid, int type) {
        return JNI._dbr_getUWL(dbrid, type);
    }

    public static Number dbr_getLWL(long dbrid, int type) {
        return JNI._dbr_getLWL(dbrid, type);
    }

    public static Number dbr_getLAL(long dbrid, int type) {
        return JNI._dbr_getLAL(dbrid, type);
    }

    public static Number dbr_getUCL(long dbrid, int type) {
        return JNI._dbr_getUCL(dbrid, type);
    }

    public static Number dbr_getLCL(long dbrid, int type) {
        return JNI._dbr_getLCL(dbrid, type);
    }

    public static short dbr_getPrecision(long dbrid, int type) {
        return JNI._dbr_getPrecision(dbrid, type);
    }

    public static TimeStamp dbr_getTimeStamp(long dbrid, int type) {
        return JNI._dbr_getTimeStamp(dbrid, type);
    }

    public static String[] dbr_getLabels(long dbrid, int type) {
        return JNI._dbr_getLabels(dbrid, type);
    }

    public static String dbr_getUnits(long dbrid, int type) {
        return JNI._dbr_getUnits(dbrid, type);
    }

    public static int dbr_getAckT(long dbrid, int type) {
        return JNI._dbr_getAckT(dbrid, type);
    }

    public static int dbr_getAckS(long dbrid, int type) {
        return JNI._dbr_getAckS(dbrid, type);
    }

    public static void dbr_update(DBR dbr, long dbrid) {
        int type = dbr.getType().getValue();
        int count = dbr.getCount();
        JNI._dbr_getValue(dbrid, type, count, dbr.getValue());
        if (dbr instanceof STS) {
            ((STS)((Object)dbr)).setStatus(JNI._dbr_getStatus(dbrid, type));
            ((STS)((Object)dbr)).setSeverity(JNI._dbr_getSeverity(dbrid, type));
        }
        if (dbr instanceof TIME && !dbr.isGR()) {
            ((TIME)((Object)dbr)).setTimeStamp(JNI._dbr_getTimeStamp(dbrid, type));
        }
        if (dbr instanceof GR) {
            ((GR)((Object)dbr)).setUnits(JNI._dbr_getUnits(dbrid, type));
            ((GR)((Object)dbr)).setUpperDispLimit(JNI._dbr_getUDL(dbrid, type));
            ((GR)((Object)dbr)).setLowerDispLimit(JNI._dbr_getLDL(dbrid, type));
            ((GR)((Object)dbr)).setUpperAlarmLimit(JNI._dbr_getUAL(dbrid, type));
            ((GR)((Object)dbr)).setUpperWarningLimit(JNI._dbr_getUWL(dbrid, type));
            ((GR)((Object)dbr)).setLowerWarningLimit(JNI._dbr_getLWL(dbrid, type));
            ((GR)((Object)dbr)).setLowerAlarmLimit(JNI._dbr_getLAL(dbrid, type));
        }
        if (dbr instanceof CTRL) {
            ((CTRL)((Object)dbr)).setUpperCtrlLimit(JNI._dbr_getUCL(dbrid, type));
            ((CTRL)((Object)dbr)).setLowerCtrlLimit(JNI._dbr_getLCL(dbrid, type));
        }
        if (dbr instanceof PRECISION) {
            ((PRECISION)((Object)dbr)).setPrecision(JNI._dbr_getPrecision(dbrid, type));
        }
        if (dbr instanceof LABELS) {
            ((LABELS)((Object)dbr)).setLabels(JNI._dbr_getLabels(dbrid, type));
        }
        if (dbr instanceof ACK) {
            ((ACK)((Object)dbr)).setAckT(JNI._dbr_getAckT(dbrid, type) != 0);
            ((ACK)((Object)dbr)).setAckS(Severity.forValue(JNI._dbr_getAckS(dbrid, type)));
        }
    }

    private static native void _setenv(String var0, String var1);

    private static native int _ca_getVersion();

    private static native int _ca_getRevision();

    private static native int _ca_getModification();

    private static native String _ca_getVersionString();

    private static native String _ca_getReleaseString();

    private static native long _ctxt_contextCreate(boolean var0) throws JNIException;

    private static native void _ctxt_contextDestroy() throws JNIException;

    private static native void _ctxt_setMessageCallback(JNIContextMessageCallback var0) throws JNIException;

    private static native void _ctxt_setExceptionCallback(JNIContextExceptionCallback var0) throws JNIException;

    private static native void _ctxt_pendIO(double var0) throws JNIException;

    private static native boolean _ctxt_testIO() throws JNIException;

    private static native void _ctxt_pendEvent(double var0) throws JNIException;

    private static native void _ctxt_poll() throws JNIException;

    private static native void _ctxt_flushIO() throws JNIException;

    private static native void _ctxt_attachThread(long var0) throws JNIException;

    private static native long _ch_channelCreate(String var0, JNIConnectionCallback var1, short var2) throws JNIException;

    private static native void _ch_channelDestroy(long var0) throws JNIException;

    private static native void _ch_setConnectionCallback(long var0, JNIConnectionCallback var2) throws JNIException;

    private static native void _ch_setAccessRightsCallback(long var0, JNIAccessRightsCallback var2) throws JNIException;

    private static native int _ch_getFieldType(long var0);

    private static native int _ch_getElementCount(long var0);

    private static native int _ch_getState(long var0);

    private static native String _ch_getHostName(long var0);

    private static native boolean _ch_getReadAccess(long var0);

    private static native boolean _ch_getWriteAccess(long var0);

    private static native void _ch_arrayPut(int var0, int var1, long var2, long var4) throws JNIException;

    private static native void _ch_arrayPutCallback(int var0, int var1, long var2, long var4, JNIPutCallback var6) throws JNIException;

    private static native void _ch_arrayGet(int var0, int var1, long var2, long var4) throws JNIException;

    private static native void _ch_arrayGetCallback(int var0, int var1, long var2, JNIGetCallback var4) throws JNIException;

    private static native long _ch_addMonitor(int var0, int var1, long var2, JNIMonitorCallback var4, int var5) throws JNIException;

    private static native void _ch_clearMonitor(long var0) throws JNIException;

    private static native long _dbr_create(int var0, int var1);

    private static native void _dbr_destroy(long var0);

    private static native void _dbr_setValue(long var0, int var2, int var3, Object var4);

    private static native Object _dbr_getValue(long var0, int var2, int var3, Object var4);

    private static native short _dbr_getStatus(long var0, int var2);

    private static native short _dbr_getSeverity(long var0, int var2);

    private static native Number _dbr_getUDL(long var0, int var2);

    private static native Number _dbr_getLDL(long var0, int var2);

    private static native Number _dbr_getUAL(long var0, int var2);

    private static native Number _dbr_getUWL(long var0, int var2);

    private static native Number _dbr_getLWL(long var0, int var2);

    private static native Number _dbr_getLAL(long var0, int var2);

    private static native Number _dbr_getUCL(long var0, int var2);

    private static native Number _dbr_getLCL(long var0, int var2);

    private static native short _dbr_getPrecision(long var0, int var2);

    private static native TimeStamp _dbr_getTimeStamp(long var0, int var2);

    private static native String[] _dbr_getLabels(long var0, int var2);

    private static native String _dbr_getUnits(long var0, int var2);

    private static native int _dbr_getAckT(long var0, int var2);

    private static native int _dbr_getAckS(long var0, int var2);
}

