/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class TimeStamp {
    private long secPastEpoch;
    private long nsec;
    private static long TS_EPOCH_SEC_PAST_1970 = 631152000L;
    private static final BigDecimal nanoScale = new BigDecimal(1.0E-9);
    private static String[] monthText = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public TimeStamp() {
        long millis = System.currentTimeMillis();
        this.secPastEpoch = millis / 1000L - TS_EPOCH_SEC_PAST_1970;
        this.nsec = millis % 1000L * 1000000L;
    }

    public TimeStamp(long secPastEpoch, long nsec) {
        this.secPastEpoch = secPastEpoch;
        this.nsec = nsec;
    }

    public TimeStamp(double dbl) {
        this.secPastEpoch = (long)dbl;
        this.nsec = (long)((dbl - (double)this.secPastEpoch) * 1.0E9);
    }

    public TimeStamp(TimeStamp ts) {
        this.secPastEpoch = ts.secPastEpoch;
        this.nsec = ts.nsec;
    }

    public void add(double dbl) {
        if (dbl >= 0.0) {
            long secPastEpoch = (long)dbl;
            long nsec = (long)((dbl - (double)secPastEpoch) * 1.0E9);
            this.add(secPastEpoch, nsec);
        } else {
            long secPastEpoch = (long)(-dbl);
            long nsec = (long)((-dbl - (double)secPastEpoch) * 1.0E9);
            this.sub(secPastEpoch, nsec);
        }
    }

    public void add(TimeStamp ts) {
        this.add(ts.secPastEpoch, ts.nsec);
    }

    public void sub(double dbl) {
        this.add(-dbl);
    }

    public void sub(TimeStamp ts) {
        this.sub(ts.secPastEpoch, ts.nsec);
    }

    public int cmp(TimeStamp ts) {
        if (this.secPastEpoch < ts.secPastEpoch) {
            return -1;
        }
        if (this.secPastEpoch == ts.secPastEpoch) {
            if (this.nsec < ts.nsec) {
                return -1;
            }
            if (this.nsec == ts.nsec) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public boolean EQ(TimeStamp ts) {
        return this.secPastEpoch == ts.secPastEpoch && this.nsec == ts.nsec;
    }

    public boolean NE(TimeStamp ts) {
        return this.secPastEpoch != ts.secPastEpoch || this.nsec != ts.nsec;
    }

    public boolean GT(TimeStamp ts) {
        if (this.secPastEpoch > ts.secPastEpoch) {
            return true;
        }
        return this.secPastEpoch == ts.secPastEpoch && this.nsec > ts.nsec;
    }

    public boolean GE(TimeStamp ts) {
        if (this.secPastEpoch > ts.secPastEpoch) {
            return true;
        }
        return this.secPastEpoch == ts.secPastEpoch && this.nsec >= ts.nsec;
    }

    public boolean LT(TimeStamp ts) {
        if (this.secPastEpoch < ts.secPastEpoch) {
            return true;
        }
        return this.secPastEpoch == ts.secPastEpoch && this.nsec < ts.nsec;
    }

    public boolean LE(TimeStamp ts) {
        if (this.secPastEpoch < ts.secPastEpoch) {
            return true;
        }
        return this.secPastEpoch == ts.secPastEpoch && this.nsec <= ts.nsec;
    }

    public double asDouble() {
        return (double)this.secPastEpoch + (double)this.nsec / 1.0E9;
    }

    public BigDecimal asBigDecimal() {
        BigDecimal baseTime = BigDecimal.valueOf(this.secPastEpoch);
        BigDecimal nanoTime = BigDecimal.valueOf(this.nsec);
        BigDecimal fraction = nanoTime.multiply(nanoScale);
        return baseTime.add(fraction);
    }

    public String toMMDDYY() {
        int seconds;
        int minutes;
        int hours;
        Date date = new Date((this.secPastEpoch + TS_EPOCH_SEC_PAST_1970) * 1000L + this.nsec / 1000000L);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer buff = new StringBuffer(40);
        String fracPart = this.format(9, this.nsec);
        if (this.nsec % 1000000L == 0L) {
            fracPart = fracPart.substring(0, 3);
        } else if (this.nsec % 1000L == 0L) {
            fracPart = fracPart.substring(0, 6);
        }
        if (this.secPastEpoch <= 86400L) {
            hours = (int)(this.secPastEpoch / 3600L);
            minutes = (int)(this.secPastEpoch / 60L % 60L);
            seconds = (int)(this.secPastEpoch % 60L);
        } else {
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int year = cal.get(1) % 100;
            hours = cal.get(11);
            minutes = cal.get(12);
            seconds = cal.get(13);
            buff.append(this.format(2, month));
            buff.append(":");
            buff.append(this.format(2, day));
            buff.append(":");
            buff.append(this.format(2, year));
            buff.append(" ");
        }
        buff.append(this.format(2, hours));
        buff.append(":");
        buff.append(this.format(2, minutes));
        buff.append(":");
        buff.append(this.format(2, seconds));
        buff.append(".");
        buff.append(fracPart);
        return buff.toString();
    }

    public String toMONDDYYYY() {
        int seconds;
        int minutes;
        int hours;
        Date date = new Date((this.secPastEpoch + TS_EPOCH_SEC_PAST_1970) * 1000L + this.nsec / 1000000L);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer buff = new StringBuffer(40);
        String fracPart = this.format(9, this.nsec);
        if (this.nsec % 1000000L == 0L) {
            fracPart = fracPart.substring(0, 3);
        } else if (this.nsec % 1000L == 0L) {
            fracPart = fracPart.substring(0, 6);
        }
        if (this.secPastEpoch <= 86400L) {
            hours = (int)(this.secPastEpoch / 3600L);
            minutes = (int)(this.secPastEpoch / 60L % 60L);
            seconds = (int)(this.secPastEpoch % 60L);
        } else {
            int month = cal.get(2);
            int day = cal.get(5);
            int year = cal.get(1);
            hours = cal.get(11);
            minutes = cal.get(12);
            seconds = cal.get(13);
            buff.append(monthText[month]);
            buff.append(" ");
            buff.append(this.format(2, day));
            buff.append(",");
            buff.append(this.format(2, year));
            buff.append(" ");
        }
        buff.append(this.format(2, hours));
        buff.append(":");
        buff.append(this.format(2, minutes));
        buff.append(":");
        buff.append(this.format(2, seconds));
        buff.append(".");
        buff.append(fracPart);
        return buff.toString();
    }

    public static TimeStamp add(TimeStamp ts, double dbl) {
        TimeStamp res = new TimeStamp(ts);
        res.add(dbl);
        return res;
    }

    public static TimeStamp add(TimeStamp ts1, TimeStamp ts2) {
        TimeStamp res = new TimeStamp(ts1);
        res.add(ts2);
        return res;
    }

    public static TimeStamp sub(TimeStamp ts, double dbl) {
        TimeStamp res = new TimeStamp(ts);
        res.sub(dbl);
        return res;
    }

    public static TimeStamp sub(TimeStamp ts1, TimeStamp ts2) {
        TimeStamp res = new TimeStamp(ts1);
        res.sub(ts2);
        return res;
    }

    private void add(long secPastEpoch, long nsec) {
        this.secPastEpoch += secPastEpoch;
        if ((this.nsec += nsec) >= 1000000000L) {
            this.secPastEpoch += this.nsec / 1000000000L;
            this.nsec %= 1000000000L;
        }
    }

    private void sub(long secPastEpoch, long nsec) {
        this.secPastEpoch -= secPastEpoch;
        if (this.nsec >= nsec) {
            this.nsec -= nsec;
        } else {
            this.nsec += 1000000000L - nsec;
            --this.secPastEpoch;
        }
    }

    private String format(int width, int value) {
        StringBuffer buff = new StringBuffer();
        buff.append(value);
        while (buff.length() < width) {
            buff.insert(0, "0");
        }
        return buff.toString();
    }

    private String format(int width, long value) {
        StringBuffer buff = new StringBuffer();
        buff.append(value);
        while (buff.length() < width) {
            buff.insert(0, "0");
        }
        return buff.toString();
    }

    public long secPastEpoch() {
        return this.secPastEpoch;
    }

    public long nsec() {
        return this.nsec;
    }
}

